/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.traces.ATrace2D;
import info.monitorenter.util.collections.IRingBuffer;
import info.monitorenter.util.collections.RingBufferArrayFast;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace2DLtd
extends ATrace2D
implements ITrace2D {
    protected IRingBuffer<ITracePoint2D> m_buffer;

    public Trace2DLtd() {
        this(100);
    }

    public Trace2DLtd(int maxsize) {
        this(maxsize, Trace2DLtd.class.getName() + "-" + ATrace2D.getInstanceCount());
    }

    public Trace2DLtd(int maxsize, String name) {
        this.m_buffer = new RingBufferArrayFast<ITracePoint2D>(maxsize);
        this.setName(name);
    }

    public Trace2DLtd(String name) {
        this(100, name);
    }

    @Override
    protected boolean addPointInternal(ITracePoint2D p) {
        ITracePoint2D removed = this.m_buffer.add(p);
        if (removed != null) {
            double tmpx = removed.getX();
            double tmpy = removed.getY();
            if (tmpx >= this.m_maxX) {
                tmpx = this.m_maxX;
                this.maxXSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(tmpx), new Double(this.m_maxX));
            } else if (tmpx <= this.m_minX) {
                tmpx = this.m_minX;
                this.minXSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(tmpx), new Double(this.m_minX));
            }
            if (tmpy >= this.m_maxY) {
                tmpy = this.m_maxY;
                this.maxYSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(tmpy), new Double(this.m_maxY));
            } else if (tmpy <= this.m_minY) {
                tmpy = this.m_minY;
                this.minYSearch();
                this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(tmpy), new Double(this.m_minY));
            }
            this.firePointAdded(p);
            if (this.m_computingTraces.size() > 0) {
                for (ITrace2D trace : this.m_computingTraces) {
                    trace.removePoint(removed);
                }
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trace2DLtd other = (Trace2DLtd)obj;
        return !(this.m_buffer == null ? other.m_buffer != null : !this.m_buffer.equals(other.m_buffer));
    }

    @Override
    public int getMaxSize() {
        return this.m_buffer.getBufferSize();
    }

    @Override
    public int getSize() {
        return this.m_buffer.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_buffer == null ? 0 : this.m_buffer.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.m_buffer.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ITracePoint2D> iterator() {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            Trace2DLtd trace2DLtd = this;
            synchronized (trace2DLtd) {
                return this.m_buffer.iteratorL2F();
            }
        }
    }

    @Override
    public void removeAllPointsInternal() {
        this.m_buffer.clear();
    }

    @Override
    protected ITracePoint2D removePointInternal(ITracePoint2D point) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxSize(int amount) {
        this.ensureInitialized();
        Object object = this.m_renderer;
        synchronized (object) {
            Trace2DLtd trace2DLtd = this;
            synchronized (trace2DLtd) {
                this.m_buffer.setBufferSize(amount);
                double xmin = this.m_minX;
                this.minXSearch();
                if (this.m_minX != xmin) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_X", new Double(xmin), new Double(this.m_minX));
                }
                double xmax = this.m_maxX;
                this.maxXSearch();
                if (this.m_maxX != xmax) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MAX_X", new Double(xmax), new Double(this.m_maxX));
                }
                double ymax = this.m_maxY;
                this.maxYSearch();
                if (this.m_maxY != ymax) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MAX_Y", new Double(ymax), new Double(this.m_maxY));
                }
                double ymin = this.m_minY;
                this.minYSearch();
                if (this.m_minY != ymin) {
                    this.firePropertyChange("ITrace2D.PROPERTY_MIN_Y", new Double(ymin), new Double(this.m_minY));
                }
            }
        }
    }
}

