% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikicommons.R
\name{wt_wikicommons}
\alias{wt_wikicommons}
\alias{wt_wikicommons_parse}
\alias{wt_wikicommons_search}
\title{WikiCommons}
\usage{
wt_wikicommons(name, utf8 = TRUE, ...)

wt_wikicommons_parse(
  page,
  types = c("langlinks", "iwlinks", "externallinks", "common_names", "classification"),
  tidy = FALSE
)

wt_wikicommons_search(query, limit = 10, offset = 0, utf8 = TRUE, ...)
}
\arguments{
\item{name}{(character) Wiki name - as a page title, must be length 1}

\item{utf8}{(logical) If \code{TRUE}, encodes most (but not all) non-ASCII
characters as UTF-8 instead of replacing them with hexadecimal escape
sequences. Default: \code{TRUE}}

\item{...}{curl options, passed on to \code{\link[httr:GET]{httr::GET()}}}

\item{page}{(\code{\link[httr:response]{httr::response()}}) Result of \code{\link[=wt_wiki_page]{wt_wiki_page()}}}

\item{types}{(character) List of properties to parse}

\item{tidy}{(logical). tidy output to data.frame's if possible.
Default: \code{FALSE}}

\item{query}{(character) query terms}

\item{limit}{(integer) number of results to return. Default: 10}

\item{offset}{(integer) record to start at. Default: 0}
}
\value{
\code{wt_wikicommons} returns a list, with slots:
\itemize{
\item langlinks - language page links
\item externallinks - external links
\item common_names - a data.frame with \code{name} and \code{language} columns
\item classification - a data.frame with \code{rank} and \code{name} columns
}

\code{wt_wikicommons_parse} returns a list

\code{wt_wikicommons_search} returns a list with slots for \code{continue} and
\code{query}, where \code{query} holds the results, with \code{query$search} slot with
the search results
}
\description{
WikiCommons
}
\examples{
\dontrun{
# high level
wt_wikicommons(name = "Malus domestica")
wt_wikicommons(name = "Pinus contorta")
wt_wikicommons(name = "Ursus americanus")
wt_wikicommons(name = "Balaenoptera musculus")

wt_wikicommons(name = "Category:Poeae")
wt_wikicommons(name = "Category:Pinaceae")

# low level
pg <- wt_wiki_page("https://commons.wikimedia.org/wiki/Malus_domestica")
wt_wikicommons_parse(pg)

# search wikicommons
# FIXME: utf=FALSE for now until curl::curl_escape fix 
# https://github.com/jeroen/curl/issues/228
wt_wikicommons_search(query = "Pinus", utf8 = FALSE)

## use search results to dig into pages
res <- wt_wikicommons_search(query = "Pinus", utf8 = FALSE)
lapply(res$query$search$title[1:3], wt_wikicommons)
}
}
\references{
\url{https://www.mediawiki.org/wiki/API:Search} for help on search
}
\concept{Wikicommons functions}
