/*
 * SPDX-FileCopyrightText: 2018 Nicolas Fella <nicolas.fella@gmx.de>
 *
 * SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 */

import QtQuick 2.2
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.1
import org.kde.kirigami 2.0 as Kirigami
import org.kde.kdeconnect 1.0

Kirigami.Page
{
    id: root
    title: i18nd("kdeconnect-app", "Volume control")
    property QtObject pluginInterface

    ListView {
        id: sinkList
        anchors.fill: parent
        spacing: Kirigami.Units.largeSpacing

        model: RemoteSinksModel {
            deviceId: pluginInterface.deviceId
        }
        delegate: ColumnLayout {

            width: parent.width

            Label {
                text: description
                elide: Text.ElideRight
                Layout.fillWidth: true
            }

            RowLayout {

                Button {
                    icon.name: muted ? "player-volume-muted" : "player-volume"
                    onClicked: muted = !muted
                }

                Slider {
                    Layout.fillWidth: true
                    from: 0
                    value: volume
                    to: maxVolume
                    onMoved: volume = value
                }
            }
        }
    }
}

