/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.EloRating;
import friendless.games.filler.PlayerWrappers;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

class RankingsPanel
extends JPanel {
    JTextPane text;
    PlayerWrappers players;
    StyleContext styles;

    public RankingsPanel(PlayerWrappers playerWrappers) {
        super(true);
        this.players = playerWrappers;
        this.setLayout(new BorderLayout(4, 4));
        this.styles = new StyleContext();
        this.createStyles();
        this.text = new JTextPane();
        this.add("Center", this.text);
        this.text.setEditable(false);
    }

    public void refresh() {
        this.players.sortByRatings();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(this.styles);
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        try {
            int n3 = EloRating.TITLES.length - 1;
            while (n3 >= 0) {
                n2 = EloRating.RATINGS[n3];
                String string = Integer.toString(n2);
                string = n == Integer.MAX_VALUE ? string + "+" : string + "-" + Integer.toString(n - 1);
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), EloRating.TITLES[n3] + " (" + string + ")", this.styles.getStyle("heading"));
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), "\n", null);
                int n4 = 0;
                while (n4 < this.players.size()) {
                    int n5 = this.players.get(n4).getRating();
                    if (n5 < n && n5 >= n2) {
                        defaultStyledDocument.insertString(defaultStyledDocument.getLength(), Integer.toString(n5), this.styles.getStyle("number"));
                        defaultStyledDocument.insertString(defaultStyledDocument.getLength(), " " + this.players.get(n4).getName(), this.styles.getStyle("normal"));
                        defaultStyledDocument.insertString(defaultStyledDocument.getLength(), "\n", null);
                    }
                    ++n4;
                }
                defaultStyledDocument.insertString(defaultStyledDocument.getLength(), "\n", null);
                n = n2;
                --n3;
            }
            this.text.setDocument(defaultStyledDocument);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    void createStyles() {
        Style style = this.styles.getStyle("default");
        Style style2 = this.styles.addStyle("heading", style);
        StyleConstants.setFontFamily(style2, "SansSerif");
        StyleConstants.setBold(style2, true);
        StyleConstants.setAlignment(style2, 1);
        StyleConstants.setSpaceAbove(style2, 10.0f);
        StyleConstants.setSpaceBelow(style2, 16.0f);
        StyleConstants.setFontSize(style2, 18);
        Style style3 = this.styles.addStyle("normal", style);
        StyleConstants.setBold(style3, true);
        StyleConstants.setLeftIndent(style3, 10.0f);
        StyleConstants.setRightIndent(style3, 10.0f);
        StyleConstants.setFontFamily(style3, "SansSerif");
        StyleConstants.setFontSize(style3, 14);
        StyleConstants.setSpaceAbove(style3, 4.0f);
        StyleConstants.setSpaceBelow(style3, 4.0f);
        Style style4 = this.styles.addStyle("number", style3);
        StyleConstants.setFontFamily(style4, "monospaced");
    }
}

