/**

 * @file  twtable.h

 * @brief Tracy-Widom distribution

 */



#ifndef INCLUDE_TWTABLE_H_

#define INCLUDE_TWTABLE_H_

const double TWXVAL[] =

 {
-8.0, -7.9, -7.8, -7.7, -7.6, -7.5, -7.4, -7.3, -7.2, -7.1, -7.0, -6.9,
-6.8, -6.7, -6.6, -6.5, -6.4, -6.3, -6.2, -6.1, -6.0, -5.9, -5.8, -5.7,
-5.6, -5.5, -5.4, -5.3, -5.2, -5.1, -5.0, -4.9, -4.8, -4.7, -4.6, -4.5,
-4.4, -4.3, -4.2, -4.1, -4.0, -3.9, -3.8, -3.7, -3.6, -3.5, -3.4, -3.3,
-3.2, -3.1, -3.0, -2.9, -2.8, -2.7, -2.6, -2.5, -2.4, -2.3, -2.2, -2.1,
-2.0, -1.9, -1.8, -1.7, -1.6, -1.5, -1.4, -1.3, -1.2, -1.1, -1.0, -0.9,
-0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3, 0.4,
0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8,
1.9, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3.0, 3.1, 3.2,
3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 4.6,
4.7, 4.8, 4.9, 5.0, 5.1, 5.2, 5.3, 5.4, 5.5, 5.6, 5.7, 5.8, 5.9, 6.0,
6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4,
7.5, 7.6, 7.7, 7.8, 7.9, 8.0
};



const double TWXTAIL[] =
{
1.000000000, 1.000000000, 1.000000000, 1.000000000, 1.000000000,
1.000000000, 1.000000000, 0.999999999, 0.999999999, 0.999999997,
0.999999995, 0.999999989, 0.999999978, 0.999999958, 0.999999920,
0.999999849, 0.999999723, 0.999999498, 0.999999105, 0.999998431,
0.999997293, 0.999995401, 0.999992309, 0.999987331, 0.999979441,
0.999967125, 0.999948187, 0.999919496, 0.999876655, 0.999813597,
0.999722082, 0.999591101, 0.999406175, 0.999148569, 0.998794427,
0.998313849, 0.997669962, 0.996818016, 0.995704571, 0.994266851,
0.992432322, 0.990118582, 0.987233631, 0.983676579, 0.979338843,
0.974105853, 0.967859270, 0.960479677, 0.951849687, 0.941857369,
0.930399881, 0.917387157, 0.902745495, 0.886420892, 0.868381957,
0.848622271, 0.827162053, 0.804049066, 0.779358684, 0.753193114,
0.725679802, 0.696969061, 0.667231036, 0.636652122, 0.605430961,
0.573774198, 0.541892124, 0.509994383, 0.478285870, 0.446962951,
0.416210105, 0.386197065, 0.357076521, 0.328982392, 0.302028689,
0.276308949, 0.251896179, 0.228843301, 0.207183986, 0.186933854,
0.168091934, 0.150642330, 0.134556018, 0.119792709, 0.106302721,
0.094028817, 0.082907953, 0.072872924, 0.063853860, 0.055779577,
0.048578763, 0.042180992, 0.036517582, 0.031522284, 0.027131832,
0.023286351, 0.019929640, 0.017009350, 0.014477062, 0.012288293,
0.010402429, 0.008782605, 0.007395547, 0.006211384, 0.005203434,
0.004347977, 0.003624031, 0.003013114, 0.002499018, 0.002067590,
0.001706520, 0.001405143, 0.001154255, 0.000945945, 0.000773431,
0.000630927, 0.000513508, 0.000416999, 0.000337871, 0.000273152,
0.000220344, 0.000177359, 0.000142452, 0.000114170, 0.000091308,
0.000072871, 0.000058035, 0.000046124, 0.000036582, 0.000028955,
0.000022872, 0.000018030, 0.000014185, 0.000011138, 0.000008728,
0.000006826, 0.000005328, 0.000004151, 0.000003228, 0.000002505,
0.000001941, 0.000001501, 0.000001158, 0.000000892, 0.000000686,
0.000000527, 0.000000403, 0.000000308, 0.000000235, 0.000000179,
0.000000136, 0.000000104, 0.000000079, 0.000000059, 0.000000045,
0.000000034, 0.000000025, 0.000000019, 0.000000014, 0.000000011,
0.000000008

};



const double TWXPDF[] =

{
0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000,
0.000000001, 0.000000002, 0.000000005, 0.000000010, 0.000000019,
0.000000039, 0.000000076, 0.000000146, 0.000000276, 0.000000511,
0.000000932, 0.000001670, 0.000002942, 0.000005097, 0.000008683,
0.000014554, 0.000024005, 0.000038969, 0.000062279, 0.000098012,
0.000151923, 0.000231995, 0.000349097, 0.000517756, 0.000757035,
0.001091485, 0.001552137, 0.002177466, 0.003014256, 0.004118267,
0.005554591, 0.007397591, 0.009730295, 0.012643159, 0.016232112,
0.020595851, 0.025832397, 0.032034971, 0.039287325, 0.047658716,
0.057198759, 0.067932445, 0.079855636, 0.092931337, 0.107087044,
0.122213418, 0.138164458, 0.154759279, 0.171785501, 0.189004169,
0.206156009, 0.222968755, 0.239165233, 0.254471803, 0.268626779,
0.281388431, 0.292542221, 0.301906945, 0.309339558, 0.314738516,
0.318045543, 0.319245849, 0.318366852, 0.315475570, 0.310674866,
0.304098784, 0.295907232, 0.286280263, 0.275412215, 0.263505933,
0.250767272, 0.237400053, 0.223601597, 0.209558915, 0.195445624,
0.181419571, 0.167621190, 0.154172511, 0.141176787, 0.128718659,
0.116864772, 0.105664756, 0.095152500, 0.085347620, 0.076257058,
0.067876743, 0.060193257, 0.053185457, 0.046826015, 0.041082856,
0.035920459, 0.031301023, 0.027185487, 0.023534398, 0.020308645,
0.017470054, 0.014981856, 0.012809046, 0.010918644, 0.009279861,
0.007864200, 0.006645482, 0.005599836, 0.004705636, 0.003943413,
0.003295741, 0.002747112, 0.002283795, 0.001893694, 0.001566204,
0.001292071, 0.001063253, 0.000872795, 0.000714702, 0.000583831,
0.000475784, 0.000386816, 0.000313749, 0.000253894, 0.000204987,
0.000165125, 0.000132716, 0.000106431, 0.000085163, 0.000067996,
0.000054172, 0.000043066, 0.000034164, 0.000027045, 0.000021365,
0.000016843, 0.000013250, 0.000010403, 0.000008151, 0.000006374,
0.000004974, 0.000003874, 0.000003011, 0.000002336, 0.000001809,
0.000001398, 0.000001078, 0.000000830, 0.000000638, 0.000000489,
0.000000375, 0.000000286, 0.000000218, 0.000000166, 0.000000126,
0.000000096, 0.000000073, 0.000000055, 0.000000041, 0.000000031,
0.000000023

};



const int TWTABSIZE = 161;

#endif	/* INCLUDE_TWTABLE_H_ */

// g qlo qmed qhi qrat qrat/tau   :q
const double MPTABLE[] = 
{
0.00,  1,  1,  1,  1,  1.615891,  
0.000010,  0.997443897,  0.999996667,  1.002553788,  0.005109908,  1.615894833,  
0.000020,  0.996384450,  0.999993333,  1.003610921,  0.007226519,  1.615898879,  
0.000030,  0.995571240,  0.999990000,  1.004421815,  0.008850663,  1.615902629,  
0.000040,  0.994885493,  0.999986667,  1.005105247,  0.010219890,  1.615906485,  
0.000050,  0.994281202,  0.999983333,  1.005707224,  0.011426212,  1.615910459,  
0.000060,  0.993734771,  0.999980000,  1.006251340,  0.012516819,  1.615914377,  
0.000070,  0.993232185,  0.999976667,  1.006751611,  0.013519741,  1.615918178,  
0.000080,  0.992764310,  0.999973333,  1.007217171,  0.014453246,  1.615922063,  
0.000090,  0.992324803,  0.999970000,  1.007654363,  0.015330020,  1.615925950,  
0.000100,  0.991909046,  0.999966667,  1.008067806,  0.016159299,  1.615929874,  
0.000110,  0.991513551,  0.999963333,  1.008460986,  0.016948056,  1.615933758,  
0.000120,  0.991135610,  0.999960000,  1.008836612,  0.017701710,  1.615937634,  
0.000130,  0.990773069,  0.999956666,  1.009196838,  0.018424568,  1.615941468,  
0.000140,  0.990424180,  0.999953333,  1.009543412,  0.019120124,  1.615945396,  
0.000150,  0.990087506,  0.999950000,  1.009877772,  0.019791256,  1.615949283,  
0.000160,  0.989761841,  0.999946666,  1.010201121,  0.020440370,  1.615953124,  
0.000170,  0.989446170,  0.999943333,  1.010514478,  0.021069502,  1.615957041,  
0.000180,  0.989139622,  0.999940000,  1.010818712,  0.021680391,  1.615960959,  
0.000190,  0.988841446,  0.999936666,  1.011114573,  0.022274538,  1.615964839,  
0.000200,  0.988550989,  0.999933333,  1.011402714,  0.022853248,  1.615968681,  
0.000210,  0.988267680,  0.999930000,  1.011683708,  0.023417667,  1.615972551,  
0.000220,  0.987991014,  0.999926666,  1.011958060,  0.023968804,  1.615976451,  
0.000230,  0.987720541,  0.999923333,  1.012226218,  0.024507556,  1.615980370,  
0.000240,  0.987455863,  0.999919999,  1.012488581,  0.025034720,  1.615984253,  
0.000250,  0.987196622,  0.999916666,  1.012745508,  0.025551016,  1.615988127,  
0.000260,  0.986942492,  0.999913333,  1.012997322,  0.026057088,  1.615991997,  
0.000270,  0.986693184,  0.999909999,  1.013244316,  0.026553522,  1.615995895,  
0.000280,  0.986448430,  0.999906666,  1.013486755,  0.027040849,  1.615999796,  
0.000290,  0.986207990,  0.999903332,  1.013724880,  0.027519550,  1.616003646,  
0.000300,  0.985971641,  0.999899999,  1.013958914,  0.027990072,  1.616007545,  
0.000310,  0.985739182,  0.999896666,  1.014189059,  0.028452818,  1.616011444,  
0.000320,  0.985510424,  0.999893332,  1.014415501,  0.028908160,  1.616015292,  
0.000330,  0.985285197,  0.999889999,  1.014638414,  0.029356447,  1.616019195,  
0.000340,  0.985063340,  0.999886666,  1.014857956,  0.029797993,  1.616023079,  
0.000350,  0.984844706,  0.999883332,  1.015074275,  0.030233096,  1.616026969,  
0.000360,  0.984629158,  0.999879999,  1.015287508,  0.030662029,  1.616030842,  
0.000370,  0.984416568,  0.999876665,  1.015497783,  0.031085049,  1.616034729,  
0.000380,  0.984206817,  0.999873332,  1.015705219,  0.031502392,  1.616038609,  
0.000390,  0.983999794,  0.999869998,  1.015909928,  0.031914283,  1.616042528,  
0.000400,  0.983795394,  0.999866665,  1.016112013,  0.032320928,  1.616046410,  
0.000410,  0.983593520,  0.999863332,  1.016311572,  0.032722524,  1.616050278,  
0.000420,  0.983394080,  0.999859998,  1.016508698,  0.033119255,  1.616054177,  
0.000430,  0.983196986,  0.999856665,  1.016703476,  0.033511293,  1.616058048,  
0.000440,  0.983002159,  0.999853331,  1.016895988,  0.033898801,  1.616061913,  
0.000450,  0.982809521,  0.999849998,  1.017086312,  0.034281933,  1.616065831,  
0.000460,  0.982619000,  0.999846665,  1.017274518,  0.034660833,  1.616069682,  
0.000470,  0.982430526,  0.999843331,  1.017460677,  0.035035640,  1.616073574,  
0.000480,  0.982244035,  0.999839998,  1.017644853,  0.035406483,  1.616077457,  
0.000490,  0.982059465,  0.999836664,  1.017827108,  0.035773486,  1.616081352,  
0.000500,  0.981876758,  0.999833331,  1.018007500,  0.036136764,  1.616085237,  
0.000510,  0.981695859,  0.999829997,  1.018186085,  0.036496431,  1.616089123,  
0.000520,  0.981516713,  0.999826664,  1.018362916,  0.036852591,  1.616093019,  
0.000530,  0.981339271,  0.999823331,  1.018538043,  0.037205345,  1.616096904,  
0.000540,  0.981163485,  0.999819997,  1.018711514,  0.037554789,  1.616100785,  
0.000550,  0.980989310,  0.999816664,  1.018883375,  0.037901014,  1.616104673,  
0.000560,  0.980816700,  0.999813330,  1.019053670,  0.038244109,  1.616108573,  
0.000570,  0.980645615,  0.999809997,  1.019222440,  0.038584156,  1.616112454,  
0.000580,  0.980476015,  0.999806663,  1.019389725,  0.038921235,  1.616116319,  
0.000590,  0.980307861,  0.999803330,  1.019555564,  0.039255423,  1.616120204,  
0.000600,  0.980141117,  0.999799996,  1.019719993,  0.039586794,  1.616124081,  
0.000610,  0.979975748,  0.999796663,  1.019883048,  0.039915417,  1.616127986,  
0.000620,  0.979811719,  0.999793330,  1.020044761,  0.040241358,  1.616131849,  
0.000630,  0.979649000,  0.999789996,  1.020205166,  0.040564685,  1.616135745,  
0.000640,  0.979487558,  0.999786663,  1.020364293,  0.040885458,  1.616139623,  
0.000650,  0.979327364,  0.999783329,  1.020522173,  0.041203737,  1.616143537,  
0.000660,  0.979168388,  0.999779996,  1.020678833,  0.041519579,  1.616147421,  
0.000670,  0.979010605,  0.999776662,  1.020834301,  0.041833039,  1.616151282,  
0.000680,  0.978853987,  0.999773329,  1.020988605,  0.042144171,  1.616155186,  
0.000690,  0.978698508,  0.999769995,  1.021141769,  0.042453026,  1.616159064,  
0.000700,  0.978544144,  0.999766662,  1.021293818,  0.042759652,  1.616162932,  
0.000710,  0.978390870,  0.999763328,  1.021444777,  0.043064099,  1.616166835,  
0.000720,  0.978238665,  0.999759995,  1.021594668,  0.043366412,  1.616170736,  
0.000730,  0.978087505,  0.999756661,  1.021743512,  0.043666633,  1.616174592,  
0.000740,  0.977937370,  0.999753328,  1.021891333,  0.043964808,  1.616178496,  
0.000750,  0.977788238,  0.999749994,  1.022038150,  0.044260977,  1.616182386,  
0.000760,  0.977640090,  0.999746661,  1.022183983,  0.044555181,  1.616186266,  
0.000770,  0.977492906,  0.999743328,  1.022328852,  0.044847457,  1.616190158,  
0.000780,  0.977346668,  0.999739994,  1.022472775,  0.045137843,  1.616194035,  
0.000790,  0.977201358,  0.999736660,  1.022615771,  0.045426376,  1.616197927,  
0.000800,  0.977056957,  0.999733327,  1.022757857,  0.045713091,  1.616201819,  
0.000810,  0.976913449,  0.999729994,  1.022899050,  0.045998021,  1.616205705,  
0.000820,  0.976770818,  0.999726660,  1.023039366,  0.046281199,  1.616209571,  
0.000830,  0.976629047,  0.999723326,  1.023178822,  0.046562658,  1.616213452,  
0.000840,  0.976488121,  0.999719993,  1.023317434,  0.046842430,  1.616217367,  
0.000850,  0.976348024,  0.999716660,  1.023455215,  0.047120542,  1.616221245,  
0.000860,  0.976208744,  0.999713326,  1.023592181,  0.047397025,  1.616225132,  
0.000870,  0.976070264,  0.999709992,  1.023728346,  0.047671907,  1.616229021,  
0.000880,  0.975932572,  0.999706659,  1.023863723,  0.047945216,  1.616232888,  
0.000890,  0.975795653,  0.999703326,  1.023998327,  0.048216978,  1.616236790,  
0.000900,  0.975659496,  0.999699992,  1.024132169,  0.048487220,  1.616240658,  
0.000910,  0.975524087,  0.999696658,  1.024265264,  0.048755967,  1.616244569,  
0.000920,  0.975389414,  0.999693325,  1.024397622,  0.049023243,  1.616248446,  
0.000930,  0.975255465,  0.999689992,  1.024529256,  0.049289071,  1.616252323,  
0.000940,  0.975122228,  0.999686658,  1.024660178,  0.049553477,  1.616256218,  
0.000950,  0.974989692,  0.999683324,  1.024790399,  0.049816482,  1.616260113,  
0.000960,  0.974857847,  0.999679991,  1.024919929,  0.050078108,  1.616263974,  
0.000970,  0.974726680,  0.999676657,  1.025048781,  0.050338377,  1.616267879,  
0.000980,  0.974596183,  0.999673324,  1.025176964,  0.050597310,  1.616271775,  
0.000990,  0.974466344,  0.999669990,  1.025304488,  0.050854926,  1.616275660,  
0.001000,  0.974337154,  0.999666657,  1.025431363,  0.051111247,  1.616279536,  
0.001010,  0.974208603,  0.999663323,  1.025557600,  0.051366291,  1.616283438,  
0.001020,  0.974080681,  0.999659990,  1.025683207,  0.051620078,  1.616287324,  
0.001030,  0.973953379,  0.999656656,  1.025808193,  0.051872624,  1.616291186,  
0.001040,  0.973826689,  0.999653323,  1.025932569,  0.052123950,  1.616295088,  
0.001050,  0.973700601,  0.999649989,  1.026056342,  0.052374073,  1.616298970,  
0.001060,  0.973575107,  0.999646656,  1.026179521,  0.052623008,  1.616302850,  
0.001070,  0.973450198,  0.999643322,  1.026302115,  0.052870775,  1.616306743,  
0.001080,  0.973325867,  0.999639988,  1.026424131,  0.053117387,  1.616310616,  
0.001090,  0.973202105,  0.999636655,  1.026545579,  0.053362863,  1.616314525,  
0.001100,  0.973078904,  0.999633321,  1.026666464,  0.053607216,  1.616318390,  
0.001110,  0.972956257,  0.999629988,  1.026786796,  0.053850464,  1.616322281,  
0.001120,  0.972834157,  0.999626654,  1.026906582,  0.054092620,  1.616326181,  
0.001130,  0.972712596,  0.999623321,  1.027025828,  0.054333699,  1.616330054,  
0.001140,  0.972591566,  0.999619987,  1.027144543,  0.054573715,  1.616333954,  
0.001150,  0.972471062,  0.999616654,  1.027262733,  0.054812683,  1.616337851,  
0.001160,  0.972351076,  0.999613320,  1.027380404,  0.055050615,  1.616341726,  
0.001170,  0.972231601,  0.999609986,  1.027497564,  0.055287526,  1.616345610,  
0.001180,  0.972112631,  0.999606653,  1.027614219,  0.055523428,  1.616349491,  
0.001190,  0.971994159,  0.999603319,  1.027730376,  0.055758335,  1.616353386,  
0.001200,  0.971876180,  0.999599986,  1.027846040,  0.055992258,  1.616357259,  
0.001210,  0.971758686,  0.999596652,  1.027961219,  0.056225211,  1.616361165,  
0.001220,  0.971641673,  0.999593319,  1.028075917,  0.056457204,  1.616365040,  
0.001230,  0.971525134,  0.999589985,  1.028190141,  0.056688250,  1.616368925,  
0.001240,  0.971409064,  0.999586652,  1.028303897,  0.056918360,  1.616372816,  
0.001250,  0.971293456,  0.999583318,  1.028417190,  0.057147546,  1.616376704,  
0.001260,  0.971178305,  0.999579984,  1.028530026,  0.057375819,  1.616380597,  
0.001270,  0.971063606,  0.999576651,  1.028642410,  0.057603190,  1.616384486,  
0.001280,  0.970949354,  0.999573317,  1.028754348,  0.057829669,  1.616388385,  
0.001290,  0.970835543,  0.999569984,  1.028865844,  0.058055266,  1.616392262,  
0.001300,  0.970722168,  0.999566650,  1.028976904,  0.058279992,  1.616396145,  
0.001310,  0.970609224,  0.999563316,  1.029087533,  0.058503857,  1.616400028,  
0.001320,  0.970496706,  0.999559983,  1.029197736,  0.058726871,  1.616403917,  
0.001330,  0.970384610,  0.999556649,  1.029307518,  0.058949043,  1.616407815,  
0.001340,  0.970272930,  0.999553316,  1.029416883,  0.059170384,  1.616411703,  
0.001350,  0.970161662,  0.999549982,  1.029525836,  0.059390901,  1.616415589,  
0.001360,  0.970050801,  0.999546648,  1.029634382,  0.059610605,  1.616419484,  
0.001370,  0.969940344,  0.999543315,  1.029742524,  0.059829504,  1.616423351,  
0.001380,  0.969830285,  0.999539981,  1.029850269,  0.060047607,  1.616427255,  
0.001390,  0.969720620,  0.999536648,  1.029957619,  0.060264923,  1.616431139,  
0.001400,  0.969611344,  0.999533314,  1.030064579,  0.060481460,  1.616435021,  
0.001410,  0.969502455,  0.999529980,  1.030171154,  0.060697228,  1.616438921,  
0.001420,  0.969393948,  0.999526647,  1.030277346,  0.060912232,  1.616442788,  
0.001430,  0.969285818,  0.999523313,  1.030383162,  0.061126483,  1.616446696,  
0.001440,  0.969178061,  0.999519980,  1.030488603,  0.061339986,  1.616450571,  
0.001450,  0.969070674,  0.999516646,  1.030593675,  0.061552752,  1.616454467,  
0.001460,  0.968963654,  0.999513312,  1.030698381,  0.061764787,  1.616458358,  
0.001470,  0.968856996,  0.999509979,  1.030802724,  0.061976098,  1.616462233,  
0.001480,  0.968750696,  0.999506645,  1.030906709,  0.062186693,  1.616466121,  
0.001490,  0.968644751,  0.999503311,  1.031010339,  0.062396580,  1.616470008,  
0.001500,  0.968539157,  0.999499978,  1.031113618,  0.062605765,  1.616473901,  
0.001510,  0.968433912,  0.999496644,  1.031216549,  0.062814255,  1.616477793,  
0.001520,  0.968329010,  0.999493310,  1.031319135,  0.063022058,  1.616481668,  
0.001530,  0.968224450,  0.999489977,  1.031421381,  0.063229180,  1.616485566,  
0.001540,  0.968120227,  0.999486643,  1.031523289,  0.063435627,  1.616489457,  
0.001550,  0.968016339,  0.999483310,  1.031624862,  0.063641406,  1.616493334,  
0.001560,  0.967912782,  0.999479976,  1.031726105,  0.063846525,  1.616497239,  
0.001570,  0.967809552,  0.999476642,  1.031827019,  0.064050988,  1.616501116,  
0.001580,  0.967706648,  0.999473309,  1.031927609,  0.064254804,  1.616505016,  
0.001590,  0.967604065,  0.999469975,  1.032027876,  0.064457975,  1.616508884,  
0.001600,  0.967501801,  0.999466641,  1.032127825,  0.064660511,  1.616512771,  
0.001610,  0.967399853,  0.999463308,  1.032227459,  0.064862417,  1.616516676,  
0.001620,  0.967298218,  0.999459974,  1.032326779,  0.065063697,  1.616520552,  
0.001630,  0.967196892,  0.999456640,  1.032425790,  0.065264360,  1.616524452,  
0.001640,  0.967095874,  0.999453307,  1.032524493,  0.065464408,  1.616528327,  
0.001650,  0.966995160,  0.999449973,  1.032622892,  0.065663849,  1.616532211,  
0.001660,  0.966894748,  0.999446639,  1.032720990,  0.065862688,  1.616536107,  
0.001670,  0.966794634,  0.999443306,  1.032818789,  0.066060931,  1.616539995,  
0.001680,  0.966694816,  0.999439972,  1.032916292,  0.066258583,  1.616543889,  
0.001690,  0.966595292,  0.999436638,  1.033013501,  0.066455648,  1.616547769,  
0.001700,  0.966496059,  0.999433305,  1.033110420,  0.066652133,  1.616551670,  
0.001710,  0.966397114,  0.999429971,  1.033207050,  0.066848042,  1.616555555,  
0.001720,  0.966298454,  0.999426637,  1.033303394,  0.067043380,  1.616559433,  
0.001730,  0.966200078,  0.999423304,  1.033399455,  0.067238152,  1.616563320,  
0.001740,  0.966101983,  0.999419970,  1.033495236,  0.067432365,  1.616567227,  
0.001750,  0.966004167,  0.999416636,  1.033590737,  0.067626021,  1.616571094,  
0.001760,  0.965906626,  0.999413303,  1.033685963,  0.067819126,  1.616574989,  
0.001770,  0.965809359,  0.999409969,  1.033780915,  0.068011685,  1.616578876,  
0.001780,  0.965712364,  0.999406635,  1.033875596,  0.068203702,  1.616582774,  
0.001790,  0.965615637,  0.999403302,  1.033970008,  0.068395182,  1.616586672,  
0.001800,  0.965519178,  0.999399968,  1.034064152,  0.068586128,  1.616590543,  
0.001810,  0.965422983,  0.999396634,  1.034158032,  0.068776547,  1.616594429,  
0.001820,  0.965327050,  0.999393301,  1.034251650,  0.068966442,  1.616598326,  
0.001830,  0.965231378,  0.999389967,  1.034345007,  0.069155816,  1.616602207,  
0.001840,  0.965135964,  0.999386633,  1.034438107,  0.069344677,  1.616606111,  
0.001850,  0.965040806,  0.999383300,  1.034530950,  0.069533025,  1.616609998,  
0.001860,  0.964945902,  0.999379966,  1.034623539,  0.069720866,  1.616613880,  
0.001870,  0.964851250,  0.999376632,  1.034715876,  0.069908205,  1.616617764,  
0.001880,  0.964756848,  0.999373298,  1.034807964,  0.070095045,  1.616621668,  
0.001890,  0.964662693,  0.999369965,  1.034899803,  0.070281390,  1.616625547,  
0.001900,  0.964568785,  0.999366631,  1.034991397,  0.070467244,  1.616629447,  
0.001910,  0.964475121,  0.999363297,  1.035082746,  0.070652610,  1.616633325,  
0.001920,  0.964381698,  0.999359964,  1.035173854,  0.070837494,  1.616637228,  
0.001930,  0.964288516,  0.999356630,  1.035264721,  0.071021898,  1.616641115,  
0.001940,  0.964195573,  0.999353296,  1.035355349,  0.071205825,  1.616644985,  
0.001950,  0.964102866,  0.999349962,  1.035445742,  0.071389282,  1.616648890,  
0.001960,  0.964010393,  0.999346629,  1.035535899,  0.071572269,  1.616652766,  
0.001970,  0.963918154,  0.999343295,  1.035625824,  0.071754792,  1.616656662,  
0.001980,  0.963826145,  0.999339961,  1.035715518,  0.071936854,  1.616660563,  
0.001990,  0.963734366,  0.999336628,  1.035804982,  0.072118457,  1.616664449,  
0.002000,  0.963642815,  0.999333294,  1.035894218,  0.072299606,  1.616668326,  
0.002010,  0.963551490,  0.999329960,  1.035983229,  0.072480304,  1.616672227,  
0.002020,  0.963460389,  0.999326626,  1.036072015,  0.072660554,  1.616676110,  
0.002030,  0.963369510,  0.999323293,  1.036160579,  0.072840361,  1.616680007,  
0.002040,  0.963278853,  0.999319959,  1.036248921,  0.073019725,  1.616683880,  
0.002050,  0.963188414,  0.999316625,  1.036337045,  0.073198653,  1.616687785,  
0.002060,  0.963098194,  0.999313291,  1.036424950,  0.073377145,  1.616691663,  
0.002070,  0.963008190,  0.999309958,  1.036512640,  0.073555207,  1.616695565,  
0.002080,  0.962918400,  0.999306624,  1.036600115,  0.073732840,  1.616699456,  
0.002090,  0.962828823,  0.999303290,  1.036687376,  0.073910047,  1.616703330,  
0.002100,  0.962739458,  0.999299956,  1.036774427,  0.074086833,  1.616707235,  
0.002110,  0.962650303,  0.999296623,  1.036861267,  0.074263199,  1.616711119,  
0.002120,  0.962561357,  0.999293289,  1.036947899,  0.074439149,  1.616715013,  
0.002130,  0.962472617,  0.999289955,  1.037034323,  0.074614686,  1.616718890,  
0.002140,  0.962384083,  0.999286621,  1.037120542,  0.074789812,  1.616722777,  
0.002150,  0.962295753,  0.999283288,  1.037206557,  0.074964532,  1.616726669,  
0.002160,  0.962207626,  0.999279954,  1.037292369,  0.075138846,  1.616730554,  
0.002170,  0.962119701,  0.999276620,  1.037377980,  0.075312759,  1.616734447,  
0.002180,  0.962031975,  0.999273286,  1.037463391,  0.075486273,  1.616738339,  
0.002190,  0.961944448,  0.999269953,  1.037548604,  0.075659391,  1.616742243,  
0.002200,  0.961857118,  0.999266619,  1.037633619,  0.075832115,  1.616746130,  
0.002210,  0.961769984,  0.999263285,  1.037718438,  0.076004448,  1.616750012,  
0.002220,  0.961683044,  0.999259951,  1.037803063,  0.076176393,  1.616753908,  
0.002230,  0.961596298,  0.999256618,  1.037887494,  0.076347952,  1.616757785,  
0.002240,  0.961509743,  0.999253284,  1.037971734,  0.076519129,  1.616761686,  
0.002250,  0.961423379,  0.999249950,  1.038055783,  0.076689925,  1.616765577,  
0.002260,  0.961337205,  0.999246616,  1.038139642,  0.076860342,  1.616769455,  
0.002270,  0.961251219,  0.999243282,  1.038223314,  0.077030386,  1.616773356,  
0.002280,  0.961165419,  0.999239949,  1.038306798,  0.077200055,  1.616777234,  
0.002290,  0.961079806,  0.999236615,  1.038390097,  0.077369354,  1.616781125,  
0.002300,  0.960994376,  0.999233281,  1.038473212,  0.077538286,  1.616785027,  
0.002310,  0.960909130,  0.999229947,  1.038556143,  0.077706851,  1.616788912,  
0.002320,  0.960824066,  0.999226614,  1.038638892,  0.077875054,  1.616792798,  
0.002330,  0.960739183,  0.999223280,  1.038721461,  0.078042896,  1.616796702,  
0.002340,  0.960654479,  0.999219946,  1.038803849,  0.078210378,  1.616800578,  
0.002350,  0.960569954,  0.999216612,  1.038886059,  0.078377504,  1.616804468,  
0.002360,  0.960485607,  0.999213278,  1.038968092,  0.078544277,  1.616808365,  
0.002370,  0.960401436,  0.999209944,  1.039049948,  0.078710698,  1.616812249,  
0.002380,  0.960317440,  0.999206611,  1.039131629,  0.078876769,  1.616816137,  
0.002390,  0.960233618,  0.999203277,  1.039213136,  0.079042493,  1.616820025,  
0.002400,  0.960149969,  0.999199943,  1.039294471,  0.079207873,  1.616823933,  
0.002410,  0.960066492,  0.999196609,  1.039375633,  0.079372909,  1.616827821,  
0.002420,  0.959983186,  0.999193276,  1.039456624,  0.079537603,  1.616831703,  
0.002430,  0.959900049,  0.999189942,  1.039537446,  0.079701960,  1.616835603,  
0.002440,  0.959817082,  0.999186608,  1.039618098,  0.079865979,  1.616839477,  
0.002450,  0.959734282,  0.999183274,  1.039698584,  0.080029665,  1.616843386,  
0.002460,  0.959651648,  0.999179940,  1.039778902,  0.080193017,  1.616847269,  
0.002470,  0.959569181,  0.999176606,  1.039859055,  0.080356039,  1.616851163,  
0.002480,  0.959486878,  0.999173272,  1.039939043,  0.080518732,  1.616855050,  
0.002490,  0.959404739,  0.999169939,  1.040018867,  0.080681099,  1.616858931,  
0.002500,  0.959322762,  0.999166605,  1.040098529,  0.080843141,  1.616862828,  
0.002510,  0.959240947,  0.999163271,  1.040178029,  0.081004861,  1.616866716,  
0.002520,  0.959159293,  0.999159937,  1.040257369,  0.081166261,  1.616870620,  
0.002530,  0.959077798,  0.999156603,  1.040336548,  0.081327341,  1.616874499,  
0.002540,  0.958996463,  0.999153270,  1.040415569,  0.081488105,  1.616878397,  
0.002550,  0.958915285,  0.999149936,  1.040494432,  0.081648553,  1.616882289,  
0.002560,  0.958834264,  0.999146602,  1.040573138,  0.081808689,  1.616886183,  
0.002570,  0.958753400,  0.999143268,  1.040651687,  0.081968512,  1.616890059,  
0.002580,  0.958672690,  0.999139934,  1.040730082,  0.082128027,  1.616893956,  
0.002590,  0.958592135,  0.999136600,  1.040808322,  0.082287234,  1.616897838,  
0.002600,  0.958511733,  0.999133266,  1.040886409,  0.082446135,  1.616901728,  
0.002610,  0.958431484,  0.999129933,  1.040964344,  0.082604732,  1.616905629,  
0.002620,  0.958351386,  0.999126599,  1.041042127,  0.082763026,  1.616909518,  
0.002630,  0.958271439,  0.999123265,  1.041119759,  0.082921020,  1.616913404,  
0.002640,  0.958191642,  0.999119931,  1.041197242,  0.083078715,  1.616917307,  
0.002650,  0.958111993,  0.999116597,  1.041274575,  0.083236113,  1.616921189,  
0.002660,  0.958032493,  0.999113263,  1.041351760,  0.083393215,  1.616925078,  
0.002670,  0.957953140,  0.999109930,  1.041428798,  0.083550023,  1.616928971,  
0.002680,  0.957873934,  0.999106596,  1.041505690,  0.083706539,  1.616932875,  
0.002690,  0.957794874,  0.999103262,  1.041582435,  0.083862764,  1.616936753,  
0.002700,  0.957715958,  0.999099928,  1.041659036,  0.084018701,  1.616940649,  
0.002710,  0.957637187,  0.999096594,  1.041735493,  0.084174350,  1.616944547,  
0.002720,  0.957558558,  0.999093260,  1.041811806,  0.084329713,  1.616948429,  
0.002730,  0.957480073,  0.999089926,  1.041887977,  0.084484792,  1.616952323,  
0.002740,  0.957401729,  0.999086592,  1.041964006,  0.084639588,  1.616956210,  
0.002750,  0.957323526,  0.999083259,  1.042039894,  0.084794103,  1.616960095,  
0.002760,  0.957245462,  0.999079925,  1.042115643,  0.084948339,  1.616964005,  
0.002770,  0.957167539,  0.999076591,  1.042191251,  0.085102296,  1.616967883,  
0.002780,  0.957089754,  0.999073257,  1.042266721,  0.085255977,  1.616971774,  
0.002790,  0.957012107,  0.999069923,  1.042342053,  0.085409383,  1.616975662,  
0.002800,  0.956934597,  0.999066589,  1.042417248,  0.085562516,  1.616979556,  
0.002810,  0.956857224,  0.999063255,  1.042492307,  0.085715376,  1.616983457,  
0.002820,  0.956779986,  0.999059921,  1.042567230,  0.085867966,  1.616987351,  
0.002830,  0.956702884,  0.999056588,  1.042642017,  0.086020286,  1.616991228,  
0.002840,  0.956625915,  0.999053254,  1.042716671,  0.086172339,  1.616995128,  
0.002850,  0.956549080,  0.999049920,  1.042791191,  0.086324125,  1.616999019,  
0.002860,  0.956472378,  0.999046586,  1.042865578,  0.086475647,  1.617002910,  
0.002870,  0.956395809,  0.999043252,  1.042939833,  0.086626904,  1.617006803,  
0.002880,  0.956319370,  0.999039918,  1.043013957,  0.086777900,  1.617010703,  
0.002890,  0.956243063,  0.999036584,  1.043087949,  0.086928635,  1.617014582,  
0.002900,  0.956166886,  0.999033250,  1.043161812,  0.087079110,  1.617018482,  
0.002910,  0.956090838,  0.999029916,  1.043235545,  0.087229327,  1.617022372,  
0.002920,  0.956014918,  0.999026582,  1.043309149,  0.087379287,  1.617026257,  
0.002930,  0.955939127,  0.999023248,  1.043382626,  0.087528993,  1.617030164,  
0.002940,  0.955863464,  0.999019915,  1.043455974,  0.087678443,  1.617034041,  
0.002950,  0.955787927,  0.999016581,  1.043529196,  0.087827641,  1.617037934,  
0.002960,  0.955712516,  0.999013247,  1.043602292,  0.087976587,  1.617041829,  
0.002970,  0.955637231,  0.999009913,  1.043675262,  0.088125283,  1.617045715,  
0.002980,  0.955562071,  0.999006579,  1.043748108,  0.088273730,  1.617049621,  
0.002990,  0.955487035,  0.999003245,  1.043820829,  0.088421929,  1.617053511,  
0.003000,  0.955412123,  0.998999911,  1.043893426,  0.088569881,  1.617057394,  
0.003010,  0.955337333,  0.998996577,  1.043965901,  0.088717589,  1.617061298,  
0.003020,  0.955262666,  0.998993243,  1.044038253,  0.088865052,  1.617065188,  
0.003030,  0.955188121,  0.998989909,  1.044110483,  0.089012272,  1.617069078,  
0.003040,  0.955113698,  0.998986575,  1.044182592,  0.089159251,  1.617072969,  
0.003050,  0.955039394,  0.998983241,  1.044254580,  0.089305988,  1.617076855,  
0.003060,  0.954965211,  0.998979908,  1.044326449,  0.089452488,  1.617080759,  
0.003070,  0.954891147,  0.998976574,  1.044398197,  0.089598747,  1.617084633,  
0.003080,  0.954817202,  0.998973240,  1.044469828,  0.089744772,  1.617088543,  
0.003090,  0.954743376,  0.998969906,  1.044541339,  0.089890559,  1.617092420,  
0.003100,  0.954669667,  0.998966572,  1.044612734,  0.090036113,  1.617096328,  
0.003110,  0.954596075,  0.998963238,  1.044684011,  0.090181433,  1.617100222,  
0.003120,  0.954522600,  0.998959904,  1.044755171,  0.090326520,  1.617104104,  
0.003130,  0.954449240,  0.998956570,  1.044826215,  0.090471375,  1.617107989,  
0.003140,  0.954375997,  0.998953236,  1.044897144,  0.090616001,  1.617111882,  
0.003150,  0.954302868,  0.998949902,  1.044967958,  0.090760398,  1.617115774,  
0.003160,  0.954229853,  0.998946568,  1.045038658,  0.090904567,  1.617119672,  
0.003170,  0.954156952,  0.998943234,  1.045109244,  0.091048509,  1.617123564,  
0.003180,  0.954084165,  0.998939900,  1.045179717,  0.091192225,  1.617127463,  
0.003190,  0.954011490,  0.998936566,  1.045250077,  0.091335716,  1.617131358,  
0.003200,  0.953938928,  0.998933232,  1.045320324,  0.091478983,  1.617135236,  
0.003210,  0.953866477,  0.998929898,  1.045390460,  0.091622028,  1.617139129,  
0.003220,  0.953794137,  0.998926564,  1.045460485,  0.091764852,  1.617143024,  
0.003230,  0.953721908,  0.998923230,  1.045530399,  0.091907454,  1.617146913,  
0.003240,  0.953649789,  0.998919896,  1.045600204,  0.092049838,  1.617150821,  
0.003250,  0.953577780,  0.998916562,  1.045669898,  0.092192003,  1.617154708,  
0.003260,  0.953505879,  0.998913228,  1.045739483,  0.092333950,  1.617158594,  
0.003270,  0.953434088,  0.998909894,  1.045808960,  0.092475680,  1.617162490,  
0.003280,  0.953362404,  0.998906560,  1.045878329,  0.092617196,  1.617166390,  
0.003290,  0.953290828,  0.998903226,  1.045947590,  0.092758497,  1.617170283,  
0.003300,  0.953219360,  0.998899892,  1.046016744,  0.092899584,  1.617174178,  
0.003310,  0.953147998,  0.998896558,  1.046085791,  0.093040458,  1.617178067,  
0.003320,  0.953076742,  0.998893224,  1.046154732,  0.093181121,  1.617181960,  
0.003330,  0.953005592,  0.998889890,  1.046223567,  0.093321573,  1.617185847,  
0.003340,  0.952934547,  0.998886556,  1.046292297,  0.093461815,  1.617189737,  
0.003350,  0.952863606,  0.998883222,  1.046360923,  0.093601849,  1.617193641,  
0.003360,  0.952792770,  0.998879888,  1.046429444,  0.093741675,  1.617197530,  
0.003370,  0.952722038,  0.998876554,  1.046497861,  0.093881293,  1.617201418,  
0.003380,  0.952651409,  0.998873220,  1.046566175,  0.094020706,  1.617205310,  
0.003390,  0.952580883,  0.998869886,  1.046634386,  0.094159914,  1.617209203,  
0.003400,  0.952510460,  0.998866552,  1.046702495,  0.094298918,  1.617213102,  
0.003410,  0.952440138,  0.998863218,  1.046770502,  0.094437719,  1.617217001,  
0.003420,  0.952369918,  0.998859884,  1.046838407,  0.094576317,  1.617220891,  
0.003430,  0.952299799,  0.998856550,  1.046906211,  0.094714713,  1.617224783,  
0.003440,  0.952229781,  0.998853216,  1.046973914,  0.094852909,  1.617228668,  
0.003450,  0.952159863,  0.998849882,  1.047041517,  0.094990905,  1.617232558,  
0.003460,  0.952090045,  0.998846548,  1.047109021,  0.095128703,  1.617236461,  
0.003470,  0.952020326,  0.998843214,  1.047176425,  0.095266302,  1.617240352,  
0.003480,  0.951950706,  0.998839880,  1.047243730,  0.095403704,  1.617244244,  
0.003490,  0.951881184,  0.998836546,  1.047310937,  0.095540910,  1.617248141,  
0.003500,  0.951811761,  0.998833212,  1.047378046,  0.095677921,  1.617252041,  
0.003510,  0.951742435,  0.998829878,  1.047445057,  0.095814737,  1.617255936,  
0.003520,  0.951673206,  0.998826544,  1.047511970,  0.095951358,  1.617259816,  
0.003530,  0.951604074,  0.998823210,  1.047578787,  0.096087788,  1.617263710,  
0.003540,  0.951535039,  0.998819876,  1.047645508,  0.096224025,  1.617267611,  
0.003550,  0.951466100,  0.998816542,  1.047712132,  0.096360070,  1.617271495,  
0.003560,  0.951397256,  0.998813208,  1.047778661,  0.096495926,  1.617275389,  
0.003570,  0.951328507,  0.998809874,  1.047845095,  0.096631591,  1.617279286,  
0.003580,  0.951259853,  0.998806540,  1.047911434,  0.096767068,  1.617283181,  
0.003590,  0.951191294,  0.998803206,  1.047977679,  0.096902357,  1.617287081,  
0.003600,  0.951122828,  0.998799872,  1.048043829,  0.097037458,  1.617290965,  
0.003610,  0.951054457,  0.998796538,  1.048109886,  0.097172373,  1.617294858,  
0.003620,  0.950986178,  0.998793204,  1.048175850,  0.097307102,  1.617298755,  
0.003630,  0.950917992,  0.998789870,  1.048241721,  0.097441646,  1.617302650,  
0.003640,  0.950849899,  0.998786536,  1.048307499,  0.097576005,  1.617306536,  
0.003650,  0.950781898,  0.998783202,  1.048373186,  0.097710182,  1.617310440,  
0.003660,  0.950713988,  0.998779868,  1.048438781,  0.097844176,  1.617314337,  
0.003670,  0.950646170,  0.998776534,  1.048504284,  0.097977987,  1.617318224,  
0.003680,  0.950578442,  0.998773200,  1.048569697,  0.098111618,  1.617322126,  
0.003690,  0.950510806,  0.998769865,  1.048635018,  0.098245067,  1.617326006,  
0.003700,  0.950443259,  0.998766531,  1.048700250,  0.098378337,  1.617329904,  
0.003710,  0.950375802,  0.998763197,  1.048765392,  0.098511429,  1.617333800,  
0.003720,  0.950308435,  0.998759863,  1.048830444,  0.098644341,  1.617337689,  
0.003730,  0.950241157,  0.998756529,  1.048895408,  0.098777077,  1.617341595,  
0.003740,  0.950173968,  0.998753195,  1.048960282,  0.098909635,  1.617345481,  
0.003750,  0.950106867,  0.998749861,  1.049025068,  0.099042017,  1.617349373,  
0.003760,  0.950039854,  0.998746527,  1.049089766,  0.099174224,  1.617353267,  
0.003770,  0.949972929,  0.998743193,  1.049154377,  0.099306257,  1.617357171,  
0.003780,  0.949906091,  0.998739859,  1.049218900,  0.099438115,  1.617361066,  
0.003790,  0.949839340,  0.998736525,  1.049283336,  0.099569800,  1.617364959,  
0.003800,  0.949772676,  0.998733191,  1.049347685,  0.099701312,  1.617368849,  
0.003810,  0.949706098,  0.998729856,  1.049411948,  0.099832652,  1.617372743,  
0.003820,  0.949639606,  0.998726522,  1.049476125,  0.099963821,  1.617376635,  
0.003830,  0.949573200,  0.998723188,  1.049540216,  0.100094818,  1.617380524,  
0.003840,  0.949506879,  0.998719854,  1.049604222,  0.100225646,  1.617384416,  
0.003850,  0.949440643,  0.998716520,  1.049668144,  0.100356306,  1.617388327,  
0.003860,  0.949374492,  0.998713186,  1.049731980,  0.100486796,  1.617392212,  
0.003870,  0.949308425,  0.998709852,  1.049795732,  0.100617118,  1.617396104,  
0.003880,  0.949242442,  0.998706518,  1.049859400,  0.100747273,  1.617399996,  
0.003890,  0.949176542,  0.998703184,  1.049922985,  0.100877262,  1.617403900,  
0.003900,  0.949110726,  0.998699850,  1.049986486,  0.101007084,  1.617407791,  
0.003910,  0.949044993,  0.998696516,  1.050049904,  0.101136741,  1.617411685,  
0.003920,  0.948979343,  0.998693181,  1.050113240,  0.101266234,  1.617415586,  
0.003930,  0.948913775,  0.998689847,  1.050176493,  0.101395562,  1.617419481,  
0.003940,  0.948848289,  0.998686513,  1.050239664,  0.101524726,  1.617423376,  
0.003950,  0.948782885,  0.998683179,  1.050302753,  0.101653728,  1.617427270,  
0.003960,  0.948717563,  0.998679845,  1.050365760,  0.101782566,  1.617431152,  
0.003970,  0.948652321,  0.998676511,  1.050428687,  0.101911244,  1.617435051,  
0.003980,  0.948587161,  0.998673177,  1.050491533,  0.102039761,  1.617438949,  
0.003990,  0.948522080,  0.998669843,  1.050554298,  0.102168117,  1.617442842,  
0.004000,  0.948457081,  0.998666508,  1.050616983,  0.102296314,  1.617446738,  
0.004010,  0.948392161,  0.998663174,  1.050679588,  0.102424351,  1.617450631,  
0.004020,  0.948327320,  0.998659840,  1.050742114,  0.102552230,  1.617454535,  
0.004030,  0.948262560,  0.998656506,  1.050804560,  0.102679950,  1.617458428,  
0.004040,  0.948197878,  0.998653172,  1.050866927,  0.102807513,  1.617462320,  
0.004050,  0.948133274,  0.998649838,  1.050929215,  0.102934919,  1.617466210,  
0.004060,  0.948068750,  0.998646504,  1.050991425,  0.103062170,  1.617470110,  
0.004070,  0.948004303,  0.998643170,  1.051053556,  0.103189263,  1.617473993,  
0.004080,  0.947939935,  0.998639835,  1.051115610,  0.103316202,  1.617477890,  
0.004090,  0.947875644,  0.998636501,  1.051177586,  0.103442987,  1.617481784,  
0.004100,  0.947811430,  0.998633167,  1.051239485,  0.103569618,  1.617485682,  
0.004110,  0.947747293,  0.998629833,  1.051301307,  0.103696095,  1.617489578,  
0.004120,  0.947683233,  0.998626499,  1.051363052,  0.103822419,  1.617493471,  
0.004130,  0.947619250,  0.998623165,  1.051424721,  0.103948592,  1.617497372,  
0.004140,  0.947555342,  0.998619830,  1.051486313,  0.104074611,  1.617501259,  
0.004150,  0.947491511,  0.998616496,  1.051547830,  0.104200481,  1.617505161,  
0.004160,  0.947427755,  0.998613162,  1.051609271,  0.104326199,  1.617509056,  
0.004170,  0.947364075,  0.998609828,  1.051670636,  0.104451767,  1.617512943,  
0.004180,  0.947300469,  0.998606494,  1.051731927,  0.104577186,  1.617516847,  
0.004190,  0.947236939,  0.998603160,  1.051793143,  0.104702457,  1.617520749,  
0.004200,  0.947173483,  0.998599826,  1.051854284,  0.104827578,  1.617524644,  
0.004210,  0.947110101,  0.998596491,  1.051915350,  0.104952550,  1.617528527,  
0.004220,  0.947046794,  0.998593157,  1.051976343,  0.105077377,  1.617532428,  
0.004230,  0.946983560,  0.998589823,  1.052037262,  0.105202056,  1.617536322,  
0.004240,  0.946920400,  0.998586489,  1.052098107,  0.105326588,  1.617540211,  
0.004250,  0.946857313,  0.998583155,  1.052158880,  0.105450975,  1.617544119,  
0.004260,  0.946794298,  0.998579821,  1.052219579,  0.105575216,  1.617548010,  
0.004270,  0.946731357,  0.998576486,  1.052280205,  0.105699312,  1.617551898,  
0.004280,  0.946668488,  0.998573152,  1.052340759,  0.105823264,  1.617555795,  
0.004290,  0.946605692,  0.998569818,  1.052401241,  0.105947073,  1.617559693,  
0.004300,  0.946542967,  0.998566484,  1.052461651,  0.106070738,  1.617563591,  
0.004310,  0.946480314,  0.998563150,  1.052521989,  0.106194260,  1.617567486,  
0.004320,  0.946417733,  0.998559816,  1.052582256,  0.106317640,  1.617571386,  
0.004330,  0.946355222,  0.998556481,  1.052642451,  0.106440878,  1.617575277,  
0.004340,  0.946292783,  0.998553147,  1.052702576,  0.106563975,  1.617579181,  
0.004350,  0.946230414,  0.998549813,  1.052762629,  0.106686930,  1.617583065,  
0.004360,  0.946168116,  0.998546479,  1.052822612,  0.106809746,  1.617586959,  
0.004370,  0.946105889,  0.998543144,  1.052882525,  0.106932422,  1.617590855,  
0.004380,  0.946043731,  0.998539810,  1.052942368,  0.107054958,  1.617594751,  
0.004390,  0.945981643,  0.998536476,  1.053002142,  0.107177356,  1.617598660,  
0.004400,  0.945919624,  0.998533142,  1.053061845,  0.107299614,  1.617602546,  
0.004410,  0.945857675,  0.998529808,  1.053121480,  0.107421736,  1.617606451,  
0.004420,  0.945795795,  0.998526474,  1.053181045,  0.107543719,  1.617610342,  
0.004430,  0.945733984,  0.998523139,  1.053240541,  0.107665564,  1.617614230,  
0.004440,  0.945672241,  0.998519805,  1.053299969,  0.107787274,  1.617618129,  
0.004450,  0.945610566,  0.998516471,  1.053359329,  0.107908849,  1.617622030,  
0.004460,  0.945548960,  0.998513137,  1.053418620,  0.108030286,  1.617625921,  
0.004470,  0.945487422,  0.998509802,  1.053477844,  0.108151590,  1.617629823,  
0.004480,  0.945425951,  0.998506468,  1.053537000,  0.108272758,  1.617633721,  
0.004490,  0.945364548,  0.998503134,  1.053596088,  0.108393791,  1.617637613,  
0.004500,  0.945303212,  0.998499800,  1.053655109,  0.108514691,  1.617641505,  
0.004510,  0.945241943,  0.998496466,  1.053714063,  0.108635458,  1.617645400,  
0.004520,  0.945180740,  0.998493131,  1.053772951,  0.108756092,  1.617649304,  
0.004530,  0.945119605,  0.998489797,  1.053831772,  0.108876593,  1.617653202,  
0.004540,  0.945058535,  0.998486463,  1.053890526,  0.108996962,  1.617657092,  
0.004550,  0.944997532,  0.998483129,  1.053949215,  0.109117200,  1.617660996,  
0.004560,  0.944936595,  0.998479794,  1.054007837,  0.109237306,  1.617664885,  
0.004570,  0.944875723,  0.998476460,  1.054066394,  0.109357281,  1.617668783,  
0.004580,  0.944814917,  0.998473126,  1.054124885,  0.109477126,  1.617672673,  
0.004590,  0.944754176,  0.998469792,  1.054183311,  0.109596841,  1.617676567,  
0.004600,  0.944693500,  0.998466457,  1.054241673,  0.109716428,  1.617680478,  
0.004610,  0.944632889,  0.998463123,  1.054299969,  0.109835885,  1.617684370,  
0.004620,  0.944572342,  0.998459789,  1.054358200,  0.109955212,  1.617688257,  
0.004630,  0.944511860,  0.998456455,  1.054416368,  0.110074413,  1.617692164,  
0.004640,  0.944451442,  0.998453120,  1.054474471,  0.110193485,  1.617696062,  
0.004650,  0.944391088,  0.998449786,  1.054532510,  0.110312430,  1.617699956,  
0.004660,  0.944330798,  0.998446452,  1.054590485,  0.110431247,  1.617703850,  
0.004670,  0.944270572,  0.998443118,  1.054648397,  0.110549939,  1.617707749,  
0.004680,  0.944210408,  0.998439783,  1.054706245,  0.110668504,  1.617711641,  
0.004690,  0.944150308,  0.998436449,  1.054764030,  0.110786943,  1.617715536,  
0.004700,  0.944090271,  0.998433115,  1.054821752,  0.110905256,  1.617719430,  
0.004710,  0.944030297,  0.998429781,  1.054879412,  0.111023446,  1.617723336,  
0.004720,  0.943970385,  0.998426446,  1.054937009,  0.111141511,  1.617727234,  
0.004730,  0.943910536,  0.998423112,  1.054994543,  0.111259451,  1.617731125,  
0.004740,  0.943850749,  0.998419778,  1.055052015,  0.111377267,  1.617735017,  
0.004750,  0.943791024,  0.998416444,  1.055109426,  0.111494961,  1.617738923,  
0.004760,  0.943731360,  0.998413109,  1.055166774,  0.111612531,  1.617742813,  
0.004770,  0.943671758,  0.998409775,  1.055224061,  0.111729978,  1.617746710,  
0.004780,  0.943612218,  0.998406441,  1.055281287,  0.111847304,  1.617750613,  
0.004790,  0.943552739,  0.998403106,  1.055338451,  0.111964508,  1.617754504,  
0.004800,  0.943493321,  0.998399772,  1.055395555,  0.112081590,  1.617758411,  
0.004810,  0.943433963,  0.998396438,  1.055452597,  0.112198551,  1.617762300,  
0.004820,  0.943374666,  0.998393104,  1.055509579,  0.112315392,  1.617766200,  
0.004830,  0.943315430,  0.998389769,  1.055566500,  0.112432112,  1.617770090,  
0.004840,  0.943256254,  0.998386435,  1.055623362,  0.112548713,  1.617773999,  
0.004850,  0.943197138,  0.998383101,  1.055680163,  0.112665193,  1.617777893,  
0.004860,  0.943138082,  0.998379766,  1.055736904,  0.112781555,  1.617781788,  
0.004870,  0.943079086,  0.998376432,  1.055793586,  0.112897798,  1.617785690,  
0.004880,  0.943020149,  0.998373098,  1.055850208,  0.113013922,  1.617789588,  
0.004890,  0.942961271,  0.998369764,  1.055906770,  0.113129927,  1.617793473,  
0.004900,  0.942902453,  0.998366429,  1.055963274,  0.113245816,  1.617797379,  
0.004910,  0.942843693,  0.998363095,  1.056019718,  0.113361587,  1.617801267,  
0.004920,  0.942784992,  0.998359761,  1.056076104,  0.113477241,  1.617805166,  
0.004930,  0.942726350,  0.998356426,  1.056132431,  0.113592779,  1.617809060,  
0.004940,  0.942667767,  0.998353092,  1.056188700,  0.113708200,  1.617812960,  
0.004950,  0.942609242,  0.998349758,  1.056244911,  0.113823506,  1.617816867,  
0.004960,  0.942550774,  0.998346423,  1.056301063,  0.113938695,  1.617820758,  
0.004970,  0.942492365,  0.998343089,  1.056357158,  0.114053770,  1.617824661,  
0.004980,  0.942434013,  0.998339755,  1.056413194,  0.114168729,  1.617828547,  
0.004990,  0.942375719,  0.998336420,  1.056469174,  0.114283575,  1.617832455,  
0.005000,  0.942317482,  0.998333086,  1.056525096,  0.114398306,  1.617836355,  
0.005010,  0.942259303,  0.998329752,  1.056580960,  0.114512922,  1.617840244,  
0.005020,  0.942201180,  0.998326417,  1.056636768,  0.114627426,  1.617844147,  
0.005030,  0.942143115,  0.998323083,  1.056692519,  0.114741817,  1.617848048,  
0.005040,  0.942085106,  0.998319749,  1.056748213,  0.114856094,  1.617851945,  
0.005050,  0.942027154,  0.998316414,  1.056803850,  0.114970259,  1.617855836,  
0.005060,  0.941969258,  0.998313080,  1.056859431,  0.115084312,  1.617859731,  
0.005070,  0.941911418,  0.998309746,  1.056914956,  0.115198253,  1.617863629,  
0.005080,  0.941853634,  0.998306411,  1.056970425,  0.115312082,  1.617867528,  
0.005090,  0.941795906,  0.998303077,  1.057025838,  0.115425801,  1.617871426,  
0.005100,  0.941738234,  0.998299743,  1.057081195,  0.115539408,  1.617875318,  
0.005110,  0.941680617,  0.998296408,  1.057136497,  0.115652905,  1.617879219,  
0.005120,  0.941623056,  0.998293074,  1.057191744,  0.115766293,  1.617883125,  
0.005130,  0.941565550,  0.998289740,  1.057246935,  0.115879570,  1.617887019,  
0.005140,  0.941508099,  0.998286405,  1.057302071,  0.115992737,  1.617890914,  
0.005150,  0.941450703,  0.998283071,  1.057357152,  0.116105795,  1.617894807,  
0.005160,  0.941393361,  0.998279737,  1.057412179,  0.116218745,  1.617898713,  
0.005170,  0.941336074,  0.998276402,  1.057467151,  0.116331586,  1.617902612,  
0.005180,  0.941278842,  0.998273068,  1.057522068,  0.116444318,  1.617906500,  
0.005190,  0.941221664,  0.998269734,  1.057576932,  0.116556943,  1.617910409,  
0.005200,  0.941164540,  0.998266399,  1.057631741,  0.116669460,  1.617914305,  
0.005210,  0.941107470,  0.998263065,  1.057686496,  0.116781869,  1.617918198,  
0.005220,  0.941050453,  0.998259730,  1.057741198,  0.116894172,  1.617922103,  
0.005230,  0.940993490,  0.998256396,  1.057795846,  0.117006368,  1.617926004,  
0.005240,  0.940936581,  0.998253062,  1.057850440,  0.117118457,  1.617929896,  
0.005250,  0.940879725,  0.998249727,  1.057904981,  0.117230441,  1.617933795,  
0.005260,  0.940822923,  0.998246393,  1.057959469,  0.117342319,  1.617937696,  
0.005270,  0.940766173,  0.998243059,  1.058013904,  0.117454091,  1.617941596,  
0.005280,  0.940709476,  0.998239724,  1.058068286,  0.117565758,  1.617945494,  
0.005290,  0.940652832,  0.998236390,  1.058122615,  0.117677320,  1.617949389,  
0.005300,  0.940596241,  0.998233056,  1.058176891,  0.117788777,  1.617953278,  
0.005310,  0.940539701,  0.998229721,  1.058231116,  0.117900131,  1.617957189,  
0.005320,  0.940483215,  0.998226387,  1.058285288,  0.118011380,  1.617961089,  
0.005330,  0.940426780,  0.998223052,  1.058339407,  0.118122524,  1.617964973,  
0.005340,  0.940370397,  0.998219718,  1.058393475,  0.118233567,  1.617968875,  
0.005350,  0.940314066,  0.998216384,  1.058447491,  0.118344506,  1.617972775,  
0.005360,  0.940257787,  0.998213049,  1.058501456,  0.118455343,  1.617976682,  
0.005370,  0.940201560,  0.998209715,  1.058555368,  0.118566075,  1.617980570,  
0.005380,  0.940145383,  0.998206380,  1.058609230,  0.118676708,  1.617984479,  
0.005390,  0.940089258,  0.998203046,  1.058663040,  0.118787237,  1.617988374,  
0.005400,  0.940033185,  0.998199712,  1.058716799,  0.118897664,  1.617992275,  
0.005410,  0.939977162,  0.998196377,  1.058770507,  0.119007991,  1.617996172,  
0.005420,  0.939921190,  0.998193043,  1.058824164,  0.119118216,  1.618000069,  
0.005430,  0.939865268,  0.998189708,  1.058877770,  0.119228340,  1.618003963,  
0.005440,  0.939809398,  0.998186374,  1.058931326,  0.119338363,  1.618007863,  
0.005450,  0.939753577,  0.998183040,  1.058984832,  0.119448287,  1.618011769,  
0.005460,  0.939697807,  0.998179705,  1.059038287,  0.119558111,  1.618015664,  
0.005470,  0.939642088,  0.998176371,  1.059091692,  0.119667834,  1.618019563,  
0.005480,  0.939586418,  0.998173036,  1.059145047,  0.119777458,  1.618023461,  
0.005490,  0.939530798,  0.998169702,  1.059198352,  0.119886983,  1.618027358,  
0.005500,  0.939475227,  0.998166367,  1.059251608,  0.119996410,  1.618031264,  
0.005510,  0.939419706,  0.998163033,  1.059304813,  0.120105737,  1.618035151,  
0.005520,  0.939364235,  0.998159699,  1.059357970,  0.120214966,  1.618039058,  
0.005530,  0.939308813,  0.998156364,  1.059411077,  0.120324098,  1.618042956,  
0.005540,  0.939253441,  0.998153030,  1.059464135,  0.120433131,  1.618046857,  
0.005550,  0.939198117,  0.998149695,  1.059517143,  0.120542066,  1.618050745,  
0.005560,  0.939142842,  0.998146361,  1.059570103,  0.120650904,  1.618054645,  
0.005570,  0.939087616,  0.998143026,  1.059623014,  0.120759645,  1.618058544,  
0.005580,  0.939032439,  0.998139692,  1.059675877,  0.120868290,  1.618062450,  
0.005590,  0.938977310,  0.998136358,  1.059728691,  0.120976838,  1.618066352,  
0.005600,  0.938922230,  0.998133023,  1.059781456,  0.121085290,  1.618070244,  
0.005610,  0.938867198,  0.998129689,  1.059834173,  0.121193645,  1.618074139,  
0.005620,  0.938812214,  0.998126354,  1.059886842,  0.121301905,  1.618078039,  
0.005630,  0.938757278,  0.998123020,  1.059939464,  0.121410070,  1.618081951,  
0.005640,  0.938702390,  0.998119685,  1.059992037,  0.121518139,  1.618085847,  
0.005650,  0.938647550,  0.998116351,  1.060044562,  0.121626113,  1.618089741,  
0.005660,  0.938592757,  0.998113016,  1.060097040,  0.121733993,  1.618093644,  
0.005670,  0.938538012,  0.998109682,  1.060149470,  0.121841778,  1.618097540,  
0.005680,  0.938483314,  0.998106348,  1.060201853,  0.121949469,  1.618101441,  
0.005690,  0.938428664,  0.998103013,  1.060254189,  0.122057066,  1.618105347,  
0.005700,  0.938374060,  0.998099679,  1.060306477,  0.122164568,  1.618109239,  
0.005710,  0.938319504,  0.998096344,  1.060358718,  0.122271978,  1.618113133,  
0.005720,  0.938264995,  0.998093010,  1.060410913,  0.122379294,  1.618117038,  
0.005730,  0.938210532,  0.998089675,  1.060463061,  0.122486518,  1.618120939,  
0.005740,  0.938156116,  0.998086341,  1.060515162,  0.122593648,  1.618124837,  
0.005750,  0.938101746,  0.998083006,  1.060567217,  0.122700687,  1.618128741,  
0.005760,  0.938047423,  0.998079672,  1.060619225,  0.122807633,  1.618132638,  
0.005770,  0.937993146,  0.998076337,  1.060671187,  0.122914486,  1.618136538,  
0.005780,  0.937938916,  0.998073003,  1.060723103,  0.123021249,  1.618140440,  
0.005790,  0.937884731,  0.998069668,  1.060774972,  0.123127918,  1.618144330,  
0.005800,  0.937830592,  0.998066334,  1.060826796,  0.123234498,  1.618148232,  
0.005810,  0.937776500,  0.998062999,  1.060878574,  0.123340986,  1.618152132,  
0.005820,  0.937722452,  0.998059665,  1.060930307,  0.123447384,  1.618156040,  
0.005830,  0.937668451,  0.998056330,  1.060981993,  0.123553690,  1.618159929,  
0.005840,  0.937614494,  0.998052996,  1.061033635,  0.123659907,  1.618163837,  
0.005850,  0.937560584,  0.998049662,  1.061085231,  0.123766033,  1.618167737,  
0.005860,  0.937506718,  0.998046327,  1.061136782,  0.123872070,  1.618171640,  
0.005870,  0.937452897,  0.998042992,  1.061188287,  0.123978016,  1.618175531,  
0.005880,  0.937399122,  0.998039658,  1.061239748,  0.124083873,  1.618179433,  
0.005890,  0.937345391,  0.998036324,  1.061291164,  0.124189641,  1.618183336,  
0.005900,  0.937291705,  0.998032989,  1.061342535,  0.124295320,  1.618187237,  
0.005910,  0.937238064,  0.998029654,  1.061393861,  0.124400910,  1.618191131,  
0.005920,  0.937184467,  0.998026320,  1.061445143,  0.124506412,  1.618195030,  
0.005930,  0.937130915,  0.998022986,  1.061496381,  0.124611826,  1.618198938,  
0.005940,  0.937077407,  0.998019651,  1.061547574,  0.124717151,  1.618202836,  
0.005950,  0.937023943,  0.998016316,  1.061598723,  0.124822388,  1.618206736,  
0.005960,  0.936970523,  0.998012982,  1.061649828,  0.124927538,  1.618210637,  
0.005970,  0.936917147,  0.998009647,  1.061700889,  0.125032601,  1.618214539,  
0.005980,  0.936863816,  0.998006313,  1.061751906,  0.125137576,  1.618218438,  
0.005990,  0.936810527,  0.998002978,  1.061802879,  0.125242464,  1.618222334,  
0.006000,  0.936757283,  0.997999644,  1.061853809,  0.125347266,  1.618226239,  
0.006010,  0.936704082,  0.997996309,  1.061904695,  0.125451980,  1.618230137,  
0.006020,  0.936650924,  0.997992975,  1.061955537,  0.125556608,  1.618234028,  
0.006030,  0.936597810,  0.997989640,  1.062006337,  0.125661151,  1.618237936,  
0.006040,  0.936544739,  0.997986306,  1.062057093,  0.125765608,  1.618241834,  
0.006050,  0.936491711,  0.997982971,  1.062107806,  0.125869978,  1.618245733,  
0.006060,  0.936438726,  0.997979637,  1.062158476,  0.125974264,  1.618249632,  
0.006070,  0.936385784,  0.997976302,  1.062209103,  0.126078464,  1.618253530,  
0.006080,  0.936332885,  0.997972968,  1.062259688,  0.126182580,  1.618257439,  
0.006090,  0.936280028,  0.997969633,  1.062310230,  0.126286610,  1.618261342,  
0.006100,  0.936227214,  0.997966298,  1.062360729,  0.126390556,  1.618265241,  
0.006110,  0.936174442,  0.997962964,  1.062411185,  0.126494416,  1.618269132,  
0.006120,  0.936121713,  0.997959630,  1.062461600,  0.126598194,  1.618273041,  
0.006130,  0.936069026,  0.997956295,  1.062511972,  0.126701887,  1.618276940,  
0.006140,  0.936016382,  0.997952960,  1.062562302,  0.126805496,  1.618280843,  
0.006150,  0.935963779,  0.997949626,  1.062612590,  0.126909022,  1.618284746,  
0.006160,  0.935911218,  0.997946291,  1.062662835,  0.127012464,  1.618288634,  
0.006170,  0.935858699,  0.997942957,  1.062713040,  0.127115824,  1.618292547,  
0.006180,  0.935806222,  0.997939622,  1.062763202,  0.127219100,  1.618296443,  
0.006190,  0.935753786,  0.997936288,  1.062813323,  0.127322293,  1.618300349,  
0.006200,  0.935701392,  0.997932953,  1.062863402,  0.127425404,  1.618304248,  
0.006210,  0.935649040,  0.997929618,  1.062913439,  0.127528432,  1.618308140,  
0.006220,  0.935596729,  0.997926284,  1.062963436,  0.127631378,  1.618312049,  
0.006230,  0.935544459,  0.997922949,  1.063013391,  0.127734243,  1.618315950,  
0.006240,  0.935492230,  0.997919615,  1.063063305,  0.127837025,  1.618319852,  
0.006250,  0.935440042,  0.997916280,  1.063113177,  0.127939725,  1.618323741,  
0.006260,  0.935387895,  0.997912946,  1.063163009,  0.128042345,  1.618327643,  
0.006270,  0.935335790,  0.997909611,  1.063212800,  0.128144883,  1.618331542,  
0.006280,  0.935283724,  0.997906276,  1.063262551,  0.128247341,  1.618335453,  
0.006290,  0.935231700,  0.997902942,  1.063312260,  0.128349717,  1.618339346,  
0.006300,  0.935179716,  0.997899607,  1.063361930,  0.128452014,  1.618343258,  
0.006310,  0.935127772,  0.997896273,  1.063411558,  0.128554229,  1.618347150,  
0.006320,  0.935075869,  0.997892938,  1.063461146,  0.128656364,  1.618351049,  
0.006330,  0.935024006,  0.997889604,  1.063510694,  0.128758419,  1.618354949,  
0.006340,  0.934972184,  0.997886269,  1.063560202,  0.128860395,  1.618358853,  
0.006350,  0.934920401,  0.997882934,  1.063609670,  0.128962291,  1.618362757,  
0.006360,  0.934868658,  0.997879600,  1.063659098,  0.129064107,  1.618366662,  
0.006370,  0.934816956,  0.997876265,  1.063708486,  0.129165844,  1.618370565,  
0.006380,  0.934765293,  0.997872931,  1.063757834,  0.129267502,  1.618374465,  
0.006390,  0.934713670,  0.997869596,  1.063807142,  0.129369081,  1.618378364,  
0.006400,  0.934662086,  0.997866261,  1.063856411,  0.129470582,  1.618382269,  
0.006410,  0.934610542,  0.997862927,  1.063905640,  0.129572003,  1.618386168,  
0.006420,  0.934559037,  0.997859592,  1.063954830,  0.129673347,  1.618390070,  
0.006430,  0.934507572,  0.997856258,  1.064003980,  0.129774611,  1.618393966,  
0.006440,  0.934456146,  0.997852923,  1.064053091,  0.129875798,  1.618397866,  
0.006450,  0.934404759,  0.997849588,  1.064102163,  0.129976908,  1.618401767,  
0.006460,  0.934353411,  0.997846254,  1.064151196,  0.130077940,  1.618405668,  
0.006470,  0.934302102,  0.997842919,  1.064200190,  0.130178894,  1.618409570,  
0.006480,  0.934250832,  0.997839585,  1.064249145,  0.130279771,  1.618413469,  
0.006490,  0.934199601,  0.997836250,  1.064298062,  0.130380572,  1.618417380,  
0.006500,  0.934148408,  0.997832915,  1.064346939,  0.130481294,  1.618421273,  
0.006510,  0.934097255,  0.997829581,  1.064395778,  0.130581941,  1.618425175,  
0.006520,  0.934046139,  0.997826246,  1.064444579,  0.130682511,  1.618429082,  
0.006530,  0.933995062,  0.997822912,  1.064493341,  0.130783005,  1.618432984,  
0.006540,  0.933944024,  0.997819577,  1.064542065,  0.130883422,  1.618436888,  
0.006550,  0.933893023,  0.997816242,  1.064590750,  0.130983763,  1.618440786,  
0.006560,  0.933842061,  0.997812908,  1.064639397,  0.131084029,  1.618444684,  
0.006570,  0.933791137,  0.997809573,  1.064688007,  0.131184219,  1.618448596,  
0.006580,  0.933740251,  0.997806238,  1.064736578,  0.131284333,  1.618452494,  
0.006590,  0.933689403,  0.997802904,  1.064785111,  0.131384372,  1.618456394,  
0.006600,  0.933638593,  0.997799569,  1.064833606,  0.131484336,  1.618460290,  
0.006610,  0.933587820,  0.997796234,  1.064882064,  0.131584225,  1.618464196,  
0.006620,  0.933537085,  0.997792900,  1.064930484,  0.131684039,  1.618468096,  
0.006630,  0.933486388,  0.997789565,  1.064978867,  0.131783779,  1.618472006,  
0.006640,  0.933435728,  0.997786230,  1.065027212,  0.131883444,  1.618475907,  
0.006650,  0.933385106,  0.997782896,  1.065075519,  0.131983034,  1.618479801,  
0.006660,  0.933334520,  0.997779561,  1.065123790,  0.132082551,  1.618483711,  
0.006670,  0.933283972,  0.997776226,  1.065172023,  0.132181993,  1.618487613,  
0.006680,  0.933233462,  0.997772892,  1.065220219,  0.132281362,  1.618491516,  
0.006690,  0.933182988,  0.997769557,  1.065268377,  0.132380656,  1.618495408,  
0.006700,  0.933132551,  0.997766222,  1.065316499,  0.132479878,  1.618499313,  
0.006710,  0.933082151,  0.997762888,  1.065364584,  0.132579027,  1.618503215,  
0.006720,  0.933031788,  0.997759553,  1.065412632,  0.132678102,  1.618507115,  
0.006730,  0.932981462,  0.997756218,  1.065460644,  0.132777105,  1.618511026,  
0.006740,  0.932931172,  0.997752884,  1.065508618,  0.132876033,  1.618514919,  
0.006750,  0.932880920,  0.997749549,  1.065556557,  0.132974891,  1.618518830,  
0.006760,  0.932830703,  0.997746214,  1.065604458,  0.133073675,  1.618522724,  
0.006770,  0.932780523,  0.997742880,  1.065652324,  0.133172387,  1.618526637,  
0.006780,  0.932730379,  0.997739545,  1.065700153,  0.133271027,  1.618530539,  
0.006790,  0.932680271,  0.997736210,  1.065747945,  0.133369594,  1.618534434,  
0.006800,  0.932630200,  0.997732876,  1.065795702,  0.133468091,  1.618538341,  
0.006810,  0.932580165,  0.997729541,  1.065843422,  0.133566515,  1.618542237,  
0.006820,  0.932530165,  0.997726206,  1.065891107,  0.133664868,  1.618546147,  
0.006830,  0.932480202,  0.997722872,  1.065938755,  0.133763149,  1.618550045,  
0.006840,  0.932430274,  0.997719537,  1.065986368,  0.133861359,  1.618553951,  
0.006850,  0.932380383,  0.997716202,  1.066033945,  0.133959499,  1.618557856,  
0.006860,  0.932330527,  0.997712868,  1.066081486,  0.134057567,  1.618561755,  
0.006870,  0.932280706,  0.997709533,  1.066128991,  0.134155564,  1.618565651,  
0.006880,  0.932230921,  0.997706198,  1.066176461,  0.134253490,  1.618569553,  
0.006890,  0.932181172,  0.997702864,  1.066223896,  0.134351348,  1.618573463,  
0.006900,  0.932131458,  0.997699529,  1.066271295,  0.134449133,  1.618577362,  
0.006910,  0.932081779,  0.997696194,  1.066318659,  0.134546850,  1.618581267,  
0.006920,  0.932032136,  0.997692860,  1.066365988,  0.134644496,  1.618585175,  
0.006930,  0.931982527,  0.997689525,  1.066413281,  0.134742072,  1.618589072,  
0.006940,  0.931932954,  0.997686190,  1.066460539,  0.134839578,  1.618592969,  
0.006950,  0.931883416,  0.997682855,  1.066507763,  0.134937016,  1.618596880,  
0.006960,  0.931833912,  0.997679521,  1.066554951,  0.135034383,  1.618600777,  
0.006970,  0.931784444,  0.997676186,  1.066602105,  0.135131682,  1.618604685,  
0.006980,  0.931735010,  0.997672851,  1.066649224,  0.135228912,  1.618608590,  
0.006990,  0.931685611,  0.997669516,  1.066696308,  0.135326072,  1.618612492,  
0.007000,  0.931636247,  0.997666182,  1.066743357,  0.135423163,  1.618616388,  
0.007010,  0.931586917,  0.997662847,  1.066790372,  0.135520186,  1.618620292,  
0.007020,  0.931537622,  0.997659512,  1.066837353,  0.135617142,  1.618624204,  
0.007030,  0.931488361,  0.997656178,  1.066884299,  0.135714028,  1.618628105,  
0.007040,  0.931439134,  0.997652843,  1.066931210,  0.135810845,  1.618631998,  
0.007050,  0.931389942,  0.997649508,  1.066978088,  0.135907596,  1.618635908,  
0.007060,  0.931340784,  0.997646174,  1.067024931,  0.136004278,  1.618639810,  
0.007070,  0.931291660,  0.997642839,  1.067071740,  0.136100892,  1.618643712,  
0.007080,  0.931242570,  0.997639504,  1.067118515,  0.136197438,  1.618647612,  
0.007090,  0.931193514,  0.997636169,  1.067165256,  0.136293918,  1.618651514,  
0.007100,  0.931144492,  0.997632834,  1.067211964,  0.136390331,  1.618655427,  
0.007110,  0.931095504,  0.997629500,  1.067258637,  0.136486675,  1.618659326,  
0.007120,  0.931046549,  0.997626165,  1.067305277,  0.136582953,  1.618663234,  
0.007130,  0.930997628,  0.997622830,  1.067351883,  0.136679164,  1.618667138,  
0.007140,  0.930948741,  0.997619496,  1.067398455,  0.136775308,  1.618671037,  
0.007150,  0.930899888,  0.997616161,  1.067444994,  0.136871386,  1.618674943,  
0.007160,  0.930851067,  0.997612826,  1.067491499,  0.136967397,  1.618678843,  
0.007170,  0.930802280,  0.997609491,  1.067537971,  0.137063342,  1.618682747,  
0.007180,  0.930753527,  0.997606156,  1.067584409,  0.137159220,  1.618686644,  
0.007190,  0.930704807,  0.997602822,  1.067630815,  0.137255033,  1.618690556,  
0.007200,  0.930656120,  0.997599487,  1.067677187,  0.137350779,  1.618694458,  
0.007210,  0.930607466,  0.997596152,  1.067723526,  0.137446460,  1.618698362,  
0.007220,  0.930558845,  0.997592818,  1.067769832,  0.137542076,  1.618702267,  
0.007230,  0.930510258,  0.997589483,  1.067816105,  0.137637625,  1.618706172,  
0.007240,  0.930461703,  0.997586148,  1.067862345,  0.137733110,  1.618710076,  
0.007250,  0.930413181,  0.997582813,  1.067908552,  0.137828529,  1.618713978,  
0.007260,  0.930364691,  0.997579478,  1.067954726,  0.137923882,  1.618717876,  
0.007270,  0.930316235,  0.997576144,  1.068000868,  0.138019172,  1.618721786,  
0.007280,  0.930267811,  0.997572809,  1.068046977,  0.138114396,  1.618725689,  
0.007290,  0.930219420,  0.997569474,  1.068093053,  0.138209555,  1.618729587,  
0.007300,  0.930171061,  0.997566139,  1.068139097,  0.138304650,  1.618733494,  
0.007310,  0.930122735,  0.997562804,  1.068185108,  0.138399680,  1.618737392,  
0.007320,  0.930074441,  0.997559470,  1.068231087,  0.138494647,  1.618741295,  
0.007330,  0.930026179,  0.997556135,  1.068277034,  0.138589549,  1.618745203,  
0.007340,  0.929977950,  0.997552800,  1.068322949,  0.138684388,  1.618749112,  
0.007350,  0.929929753,  0.997549465,  1.068368831,  0.138779162,  1.618753013,  
0.007360,  0.929881588,  0.997546131,  1.068414681,  0.138873872,  1.618756913,  
0.007370,  0.929833455,  0.997542796,  1.068460499,  0.138968518,  1.618760817,  
0.007380,  0.929785354,  0.997539461,  1.068506285,  0.139063102,  1.618764719,  
0.007390,  0.929737284,  0.997536126,  1.068552040,  0.139157622,  1.618768633,  
0.007400,  0.929689247,  0.997532791,  1.068597762,  0.139252079,  1.618772533,  
0.007410,  0.929641242,  0.997529457,  1.068643452,  0.139346472,  1.618776431,  
0.007420,  0.929593268,  0.997526122,  1.068689111,  0.139440802,  1.618780337,  
0.007430,  0.929545326,  0.997522787,  1.068734738,  0.139535070,  1.618784239,  
0.007440,  0.929497416,  0.997519452,  1.068780334,  0.139629275,  1.618788149,  
0.007450,  0.929449537,  0.997516117,  1.068825898,  0.139723418,  1.618792053,  
0.007460,  0.929401690,  0.997512783,  1.068871430,  0.139817497,  1.618795951,  
0.007470,  0.929353874,  0.997509448,  1.068916932,  0.139911515,  1.618799865,  
0.007480,  0.929306089,  0.997506113,  1.068962401,  0.140005470,  1.618803761,  
0.007490,  0.929258336,  0.997502778,  1.069007840,  0.140099364,  1.618807672,  
0.007500,  0.929210613,  0.997499443,  1.069053247,  0.140193195,  1.618811573,  
0.007510,  0.929162922,  0.997496108,  1.069098623,  0.140286964,  1.618815476,  
0.007520,  0.929115263,  0.997492774,  1.069143968,  0.140380672,  1.618819381,  
0.007530,  0.929067634,  0.997489439,  1.069189282,  0.140474318,  1.618823288,  
0.007540,  0.929020036,  0.997486104,  1.069234565,  0.140567902,  1.618827191,  
0.007550,  0.928972469,  0.997482769,  1.069279817,  0.140661425,  1.618831096,  
0.007560,  0.928924933,  0.997479434,  1.069325038,  0.140754887,  1.618834998,  
0.007570,  0.928877428,  0.997476100,  1.069370229,  0.140848288,  1.618838910,  
0.007580,  0.928829953,  0.997472765,  1.069415388,  0.140941628,  1.618842806,  
0.007590,  0.928782509,  0.997469430,  1.069460517,  0.141034906,  1.618846710,  
0.007600,  0.928735096,  0.997466095,  1.069505616,  0.141128125,  1.618850622,  
0.007610,  0.928687713,  0.997462760,  1.069550683,  0.141221282,  1.618854518,  
0.007620,  0.928640361,  0.997459425,  1.069595721,  0.141314380,  1.618858429,  
0.007630,  0.928593039,  0.997456090,  1.069640728,  0.141407416,  1.618862335,  
0.007640,  0.928545748,  0.997452756,  1.069685704,  0.141500392,  1.618866234,  
0.007650,  0.928498487,  0.997449421,  1.069730650,  0.141593308,  1.618870135,  
0.007660,  0.928451256,  0.997446086,  1.069775566,  0.141686164,  1.618874040,  
0.007670,  0.928404055,  0.997442751,  1.069820452,  0.141778961,  1.618877947,  
0.007680,  0.928356885,  0.997439416,  1.069865308,  0.141871698,  1.618881858,  
0.007690,  0.928309744,  0.997436081,  1.069910133,  0.141964374,  1.618885755,  
0.007700,  0.928262634,  0.997432746,  1.069954929,  0.142056992,  1.618889665,  
0.007710,  0.928215553,  0.997429412,  1.069999695,  0.142149550,  1.618893574,  
0.007720,  0.928168503,  0.997426077,  1.070044430,  0.142242047,  1.618897471,  
0.007730,  0.928121482,  0.997422742,  1.070089136,  0.142334487,  1.618901378,  
0.007740,  0.928074491,  0.997419407,  1.070133812,  0.142426867,  1.618905283,  
0.007750,  0.928027530,  0.997416072,  1.070178459,  0.142519188,  1.618909194,  
0.007760,  0.927980598,  0.997412737,  1.070223075,  0.142611450,  1.618913091,  
0.007770,  0.927933696,  0.997409402,  1.070267662,  0.142703653,  1.618916996,  
0.007780,  0.927886824,  0.997406068,  1.070312220,  0.142795799,  1.618920906,  
0.007790,  0.927839981,  0.997402733,  1.070356748,  0.142887885,  1.618924812,  
0.007800,  0.927793168,  0.997399398,  1.070401246,  0.142979912,  1.618928711,  
0.007810,  0.927746384,  0.997396063,  1.070445716,  0.143071883,  1.618932626,  
0.007820,  0.927699629,  0.997392728,  1.070490155,  0.143163793,  1.618936519,  
0.007830,  0.927652903,  0.997389393,  1.070534566,  0.143255647,  1.618940431,  
0.007840,  0.927606207,  0.997386058,  1.070578947,  0.143347442,  1.618944332,  
0.007850,  0.927559540,  0.997382723,  1.070623300,  0.143439180,  1.618948246,  
0.007860,  0.927512902,  0.997379388,  1.070667623,  0.143530860,  1.618952150,  
0.007870,  0.927466293,  0.997376054,  1.070711917,  0.143622482,  1.618956055,  
0.007880,  0.927419713,  0.997372719,  1.070756182,  0.143714046,  1.618959958,  
0.007890,  0.927373162,  0.997369384,  1.070800418,  0.143805553,  1.618963863,  
0.007900,  0.927326640,  0.997366049,  1.070844625,  0.143897003,  1.618967766,  
0.007910,  0.927280147,  0.997362714,  1.070888804,  0.143988396,  1.618971679,  
0.007920,  0.927233682,  0.997359379,  1.070932953,  0.144079731,  1.618975576,  
0.007930,  0.927187246,  0.997356044,  1.070977074,  0.144171009,  1.618979483,  
0.007940,  0.927140839,  0.997352709,  1.071021166,  0.144262231,  1.618983385,  
0.007950,  0.927094461,  0.997349374,  1.071065230,  0.144353396,  1.618987296,  
0.007960,  0.927048111,  0.997346040,  1.071109265,  0.144444504,  1.618991201,  
0.007970,  0.927001790,  0.997342705,  1.071153272,  0.144535556,  1.618995111,  
0.007980,  0.926955496,  0.997339370,  1.071197250,  0.144626551,  1.618999015,  
0.007990,  0.926909232,  0.997336035,  1.071241199,  0.144717490,  1.619002914,  
0.008000,  0.926862996,  0.997332700,  1.071285121,  0.144808373,  1.619006826,  
0.008010,  0.926816788,  0.997329365,  1.071329014,  0.144899199,  1.619010731,  
0.008020,  0.926770608,  0.997326030,  1.071372879,  0.144989970,  1.619014637,  
0.008030,  0.926724456,  0.997322695,  1.071416715,  0.145080684,  1.619018537,  
0.008040,  0.926678333,  0.997319360,  1.071460524,  0.145171343,  1.619022448,  
0.008050,  0.926632238,  0.997316025,  1.071504304,  0.145261946,  1.619026349,  
0.008060,  0.926586170,  0.997312690,  1.071548057,  0.145352494,  1.619030262,  
0.008070,  0.926540131,  0.997309355,  1.071591781,  0.145442985,  1.619034163,  
0.008080,  0.926494120,  0.997306020,  1.071635478,  0.145533422,  1.619038074,  
0.008090,  0.926448136,  0.997302686,  1.071679146,  0.145623803,  1.619041973,  
0.008100,  0.926402180,  0.997299351,  1.071722787,  0.145714129,  1.619045881,  
0.008110,  0.926356253,  0.997296016,  1.071766400,  0.145804400,  1.619049786,  
0.008120,  0.926310352,  0.997292681,  1.071809985,  0.145894616,  1.619053688,  
0.008130,  0.926264480,  0.997289346,  1.071853543,  0.145984778,  1.619057600,  
0.008140,  0.926218635,  0.997286011,  1.071897073,  0.146074884,  1.619061505,  
0.008150,  0.926172818,  0.997282676,  1.071940576,  0.146164936,  1.619065416,  
0.008160,  0.926127028,  0.997279341,  1.071984051,  0.146254933,  1.619069323,  
0.008170,  0.926081265,  0.997276006,  1.072027498,  0.146344875,  1.619073225,  
0.008180,  0.926035530,  0.997272671,  1.072070918,  0.146434763,  1.619077129,  
0.008190,  0.925989823,  0.997269336,  1.072114311,  0.146524598,  1.619081038,  
0.008200,  0.925944142,  0.997266001,  1.072157676,  0.146614377,  1.619084939,  
0.008210,  0.925898490,  0.997262666,  1.072201014,  0.146704103,  1.619088844,  
0.008220,  0.925852864,  0.997259331,  1.072244325,  0.146793774,  1.619092752,  
0.008230,  0.925807265,  0.997255996,  1.072287609,  0.146883392,  1.619096661,  
0.008240,  0.925761694,  0.997252661,  1.072330866,  0.146972957,  1.619100572,  
0.008250,  0.925716149,  0.997249326,  1.072374095,  0.147062467,  1.619104471,  
0.008260,  0.925670632,  0.997245991,  1.072417298,  0.147151924,  1.619108384,  
0.008270,  0.925625141,  0.997242656,  1.072460473,  0.147241327,  1.619112282,  
0.008280,  0.925579678,  0.997239321,  1.072503622,  0.147330677,  1.619116192,  
0.008290,  0.925534241,  0.997235986,  1.072546744,  0.147419974,  1.619120102,  
0.008300,  0.925488831,  0.997232651,  1.072589839,  0.147509217,  1.619124008,  
0.008310,  0.925443448,  0.997229316,  1.072632907,  0.147598408,  1.619127913,  
0.008320,  0.925398092,  0.997225981,  1.072675948,  0.147687544,  1.619131814,  
0.008330,  0.925352762,  0.997222646,  1.072718963,  0.147776629,  1.619135722,  
0.008340,  0.925307459,  0.997219312,  1.072761951,  0.147865660,  1.619139627,  
0.008350,  0.925262182,  0.997215976,  1.072804913,  0.147954640,  1.619143539,  
0.008360,  0.925216932,  0.997212642,  1.072847848,  0.148043566,  1.619147445,  
0.008370,  0.925171709,  0.997209306,  1.072890757,  0.148132440,  1.619151355,  
0.008380,  0.925126512,  0.997205972,  1.072933639,  0.148221261,  1.619155261,  
0.008390,  0.925081341,  0.997202636,  1.072976495,  0.148310031,  1.619159172,  
0.008400,  0.925036197,  0.997199302,  1.073019324,  0.148398747,  1.619163073,  
0.008410,  0.924991079,  0.997195966,  1.073062127,  0.148487412,  1.619166980,  
0.008420,  0.924945988,  0.997192632,  1.073104904,  0.148576024,  1.619170889,  
0.008430,  0.924900922,  0.997189296,  1.073147654,  0.148664584,  1.619174789,  
0.008440,  0.924855883,  0.997185962,  1.073190379,  0.148753093,  1.619178701,  
0.008450,  0.924810869,  0.997182626,  1.073233077,  0.148841550,  1.619182605,  
0.008460,  0.924765882,  0.997179292,  1.073275750,  0.148929956,  1.619186518,  
0.008470,  0.924720921,  0.997175956,  1.073318396,  0.149018309,  1.619190422,  
0.008480,  0.924675986,  0.997172622,  1.073361016,  0.149106611,  1.619194326,  
0.008490,  0.924631076,  0.997169286,  1.073403611,  0.149194862,  1.619198240,  
0.008500,  0.924586193,  0.997165951,  1.073446179,  0.149283061,  1.619202140,  
0.008510,  0.924541336,  0.997162616,  1.073488722,  0.149371210,  1.619206052,  
0.008520,  0.924496504,  0.997159281,  1.073531239,  0.149459307,  1.619209960,  
0.008530,  0.924451698,  0.997155946,  1.073573730,  0.149547353,  1.619213867,  
0.008540,  0.924406918,  0.997152611,  1.073616195,  0.149635348,  1.619217770,  
0.008550,  0.924362163,  0.997149276,  1.073658635,  0.149723292,  1.619221678,  
0.008560,  0.924317434,  0.997145941,  1.073701049,  0.149811185,  1.619225584,  
0.008570,  0.924272730,  0.997142606,  1.073743438,  0.149899028,  1.619229494,  
0.008580,  0.924228052,  0.997139271,  1.073785801,  0.149986820,  1.619233402,  
0.008590,  0.924183400,  0.997135936,  1.073828138,  0.150074561,  1.619237303,  
0.008600,  0.924138773,  0.997132601,  1.073870450,  0.150162252,  1.619241208,  
0.008610,  0.924094171,  0.997129266,  1.073912737,  0.150249893,  1.619245119,  
0.008620,  0.924049595,  0.997125931,  1.073954999,  0.150337484,  1.619249032,  
0.008630,  0.924005044,  0.997122596,  1.073997235,  0.150425025,  1.619252939,  
0.008640,  0.923960518,  0.997119261,  1.074039446,  0.150512515,  1.619256846,  
0.008650,  0.923916018,  0.997115926,  1.074081631,  0.150599955,  1.619260747,  
0.008660,  0.923871542,  0.997112591,  1.074123792,  0.150687346,  1.619264660,  
0.008670,  0.923827092,  0.997109256,  1.074165927,  0.150774686,  1.619268562,  
0.008680,  0.923782667,  0.997105921,  1.074208038,  0.150861978,  1.619272478,  
0.008690,  0.923738266,  0.997102586,  1.074250123,  0.150949219,  1.619276384,  
0.008700,  0.923693891,  0.997099251,  1.074292183,  0.151036410,  1.619280288,  
0.008710,  0.923649541,  0.997095916,  1.074334218,  0.151123552,  1.619284193,  
0.008720,  0.923605216,  0.997092581,  1.074376229,  0.151210646,  1.619288107,  
0.008730,  0.923560916,  0.997089246,  1.074418214,  0.151297689,  1.619292007,  
0.008740,  0.923516640,  0.997085910,  1.074460175,  0.151384684,  1.619295918,  
0.008750,  0.923472389,  0.997082575,  1.074502111,  0.151471629,  1.619299827,  
0.008760,  0.923428163,  0.997079240,  1.074544022,  0.151558525,  1.619303733,  
0.008770,  0.923383962,  0.997075905,  1.074585909,  0.151645373,  1.619307645,  
0.008780,  0.923339785,  0.997072570,  1.074627771,  0.151732171,  1.619311555,  
0.008790,  0.923295633,  0.997069235,  1.074669608,  0.151818921,  1.619315461,  
0.008800,  0.923251505,  0.997065900,  1.074711420,  0.151905621,  1.619319362,  
0.008810,  0.923207402,  0.997062565,  1.074753209,  0.151992274,  1.619323278,  
0.008820,  0.923163324,  0.997059230,  1.074794972,  0.152078877,  1.619327179,  
0.008830,  0.923119270,  0.997055895,  1.074836711,  0.152165432,  1.619331085,  
0.008840,  0.923075240,  0.997052560,  1.074878426,  0.152251940,  1.619334995,  
0.008850,  0.923031235,  0.997049225,  1.074920117,  0.152338399,  1.619338909,  
0.008860,  0.922987254,  0.997045890,  1.074961783,  0.152424809,  1.619342817,  
0.008870,  0.922943297,  0.997042554,  1.075003425,  0.152511172,  1.619346727,  
0.008880,  0.922899364,  0.997039219,  1.075045042,  0.152597485,  1.619350629,  
0.008890,  0.922855456,  0.997035884,  1.075086636,  0.152683752,  1.619354542,  
0.008900,  0.922811572,  0.997032549,  1.075128205,  0.152769970,  1.619358448,  
0.008910,  0.922767712,  0.997029214,  1.075169750,  0.152856141,  1.619362356,  
0.008920,  0.922723876,  0.997025879,  1.075211271,  0.152942264,  1.619366262,  
0.008930,  0.922680064,  0.997022544,  1.075252768,  0.153028339,  1.619370171,  
0.008940,  0.922636276,  0.997019209,  1.075294241,  0.153114367,  1.619374079,  
0.008950,  0.922592512,  0.997015874,  1.075335690,  0.153200347,  1.619377987,  
0.008960,  0.922548772,  0.997012538,  1.075377115,  0.153286280,  1.619381894,  
0.008970,  0.922505056,  0.997009203,  1.075418516,  0.153372165,  1.619385798,  
0.008980,  0.922461364,  0.997005868,  1.075459894,  0.153458004,  1.619389713,  
0.008990,  0.922417695,  0.997002533,  1.075501248,  0.153543795,  1.619393625,  
0.009000,  0.922374050,  0.996999198,  1.075542577,  0.153629538,  1.619397524,  
0.009010,  0.922330429,  0.996995863,  1.075583884,  0.153715236,  1.619401441,  
0.009020,  0.922286832,  0.996992528,  1.075625166,  0.153800886,  1.619405345,  
0.009030,  0.922243258,  0.996989193,  1.075666425,  0.153886489,  1.619409256,  
0.009040,  0.922199708,  0.996985858,  1.075707660,  0.153972046,  1.619413161,  
0.009050,  0.922156182,  0.996982522,  1.075748872,  0.154057556,  1.619417072,  
0.009060,  0.922112678,  0.996979187,  1.075790060,  0.154143019,  1.619420980,  
0.009070,  0.922069199,  0.996975852,  1.075831225,  0.154228436,  1.619424890,  
0.009080,  0.922025743,  0.996972517,  1.075872366,  0.154313806,  1.619428797,  
0.009090,  0.921982310,  0.996969182,  1.075913484,  0.154399130,  1.619432707,  
0.009100,  0.921938901,  0.996965847,  1.075954578,  0.154484407,  1.619436612,  
0.009110,  0.921895515,  0.996962512,  1.075995649,  0.154569638,  1.619440518,  
0.009120,  0.921852152,  0.996959176,  1.076036697,  0.154654823,  1.619444428,  
0.009130,  0.921808812,  0.996955841,  1.076077722,  0.154739963,  1.619448341,  
0.009140,  0.921765496,  0.996952506,  1.076118723,  0.154825055,  1.619452246,  
0.009150,  0.921722203,  0.996949171,  1.076159702,  0.154910103,  1.619456163,  
0.009160,  0.921678933,  0.996945836,  1.076200657,  0.154995105,  1.619460072,  
0.009170,  0.921635686,  0.996942501,  1.076241589,  0.155080060,  1.619463980,  
0.009180,  0.921592462,  0.996939166,  1.076282498,  0.155164970,  1.619467889,  
0.009190,  0.921549261,  0.996935830,  1.076323383,  0.155249833,  1.619471789,  
0.009200,  0.921506084,  0.996932495,  1.076364246,  0.155334652,  1.619475699,  
0.009210,  0.921462929,  0.996929160,  1.076405086,  0.155419425,  1.619479608,  
0.009220,  0.921419797,  0.996925825,  1.076445903,  0.155504153,  1.619483517,  
0.009230,  0.921376688,  0.996922490,  1.076486698,  0.155588836,  1.619487434,  
0.009240,  0.921333602,  0.996919155,  1.076527469,  0.155673473,  1.619491339,  
0.009250,  0.921290538,  0.996915820,  1.076568218,  0.155758066,  1.619495253,  
0.009260,  0.921247497,  0.996912484,  1.076608943,  0.155842612,  1.619499154,  
0.009270,  0.921204480,  0.996909149,  1.076649646,  0.155927114,  1.619503062,  
0.009280,  0.921161484,  0.996905814,  1.076690327,  0.156011572,  1.619506978,  
0.009290,  0.921118512,  0.996902479,  1.076730984,  0.156095983,  1.619510880,  
0.009300,  0.921075562,  0.996899144,  1.076771620,  0.156180351,  1.619514799,  
0.009310,  0.921032634,  0.996895808,  1.076812232,  0.156264673,  1.619518703,  
0.009320,  0.920989729,  0.996892473,  1.076852822,  0.156348951,  1.619522612,  
0.009330,  0.920946847,  0.996889138,  1.076893390,  0.156433185,  1.619526527,  
0.009340,  0.920903987,  0.996885803,  1.076933934,  0.156517373,  1.619530426,  
0.009350,  0.920861150,  0.996882468,  1.076974457,  0.156601518,  1.619534341,  
0.009360,  0.920818335,  0.996879132,  1.077014957,  0.156685618,  1.619538248,  
0.009370,  0.920775542,  0.996875797,  1.077055435,  0.156769673,  1.619542159,  
0.009380,  0.920732772,  0.996872462,  1.077095890,  0.156853684,  1.619546063,  
0.009390,  0.920690024,  0.996869127,  1.077136324,  0.156937652,  1.619549983,  
0.009400,  0.920647298,  0.996865792,  1.077176735,  0.157021576,  1.619553892,  
0.009410,  0.920604594,  0.996862457,  1.077217123,  0.157105454,  1.619557795,  
0.009420,  0.920561913,  0.996859121,  1.077257490,  0.157189290,  1.619561709,  
0.009430,  0.920519253,  0.996855786,  1.077297834,  0.157273081,  1.619565615,  
0.009440,  0.920476616,  0.996852451,  1.077338156,  0.157356828,  1.619569522,  
0.009450,  0.920434001,  0.996849116,  1.077378457,  0.157440533,  1.619573441,  
0.009460,  0.920391408,  0.996845780,  1.077418735,  0.157524193,  1.619577350,  
0.009470,  0.920348837,  0.996842445,  1.077458991,  0.157607809,  1.619581258,  
0.009480,  0.920306288,  0.996839110,  1.077499225,  0.157691382,  1.619585166,  
0.009490,  0.920263761,  0.996835775,  1.077539437,  0.157774911,  1.619589074,  
0.009500,  0.920221256,  0.996832440,  1.077579627,  0.157858397,  1.619592981,  
0.009510,  0.920178773,  0.996829104,  1.077619796,  0.157941840,  1.619596898,  
0.009520,  0.920136311,  0.996825769,  1.077659942,  0.158025239,  1.619600801,  
0.009530,  0.920093872,  0.996822434,  1.077700067,  0.158108596,  1.619604713,  
0.009540,  0.920051454,  0.996819099,  1.077740170,  0.158191909,  1.619608623,  
0.009550,  0.920009058,  0.996815764,  1.077780251,  0.158275179,  1.619612530,  
0.009560,  0.919966683,  0.996812428,  1.077820311,  0.158358407,  1.619616445,  
0.009570,  0.919924330,  0.996809093,  1.077860349,  0.158441591,  1.619620356,  
0.009580,  0.919881999,  0.996805758,  1.077900365,  0.158524732,  1.619624262,  
0.009590,  0.919839690,  0.996802423,  1.077940360,  0.158607831,  1.619628176,  
0.009600,  0.919797402,  0.996799087,  1.077980333,  0.158690887,  1.619632085,  
0.009610,  0.919755135,  0.996795752,  1.078020284,  0.158773900,  1.619635989,  
0.009620,  0.919712890,  0.996792417,  1.078060215,  0.158856872,  1.619639908,  
0.009630,  0.919670667,  0.996789082,  1.078100123,  0.158939799,  1.619643812,  
0.009640,  0.919628464,  0.996785746,  1.078140010,  0.159022685,  1.619647721,  
0.009650,  0.919586284,  0.996782411,  1.078179876,  0.159105528,  1.619651634,  
0.009660,  0.919544124,  0.996779076,  1.078219721,  0.159188330,  1.619655550,  
0.009670,  0.919501987,  0.996775741,  1.078259544,  0.159271089,  1.619659459,  
0.009680,  0.919459870,  0.996772406,  1.078299345,  0.159353805,  1.619663361,  
0.009690,  0.919417774,  0.996769070,  1.078339126,  0.159436480,  1.619667276,  
0.009700,  0.919375700,  0.996765735,  1.078378885,  0.159519112,  1.619671185,  
0.009710,  0.919333647,  0.996762400,  1.078418623,  0.159601702,  1.619675094,  
0.009720,  0.919291616,  0.996759064,  1.078458340,  0.159684251,  1.619679005,  
0.009730,  0.919249605,  0.996755729,  1.078498036,  0.159766758,  1.619682918,  
0.009740,  0.919207615,  0.996752394,  1.078537711,  0.159849223,  1.619686831,  
0.009750,  0.919165647,  0.996749059,  1.078577364,  0.159931646,  1.619690736,  
0.009760,  0.919123699,  0.996745723,  1.078616997,  0.160014028,  1.619694651,  
0.009770,  0.919081773,  0.996742388,  1.078656608,  0.160096367,  1.619698556,  
0.009780,  0.919039867,  0.996739053,  1.078696199,  0.160178666,  1.619702470,  
0.009790,  0.918997983,  0.996735718,  1.078735769,  0.160260923,  1.619706385,  
0.009800,  0.918956119,  0.996732382,  1.078775317,  0.160343138,  1.619710287,  
0.009810,  0.918914276,  0.996729047,  1.078814845,  0.160425312,  1.619714200,  
0.009820,  0.918872454,  0.996725712,  1.078854352,  0.160507445,  1.619718110,  
0.009830,  0.918830653,  0.996722376,  1.078893838,  0.160589537,  1.619722019,  
0.009840,  0.918788873,  0.996719041,  1.078933304,  0.160671588,  1.619725936,  
0.009850,  0.918747114,  0.996715706,  1.078972749,  0.160753598,  1.619729849,  
0.009860,  0.918705375,  0.996712371,  1.079012172,  0.160835565,  1.619733750,  
0.009870,  0.918663656,  0.996709035,  1.079051576,  0.160917493,  1.619737669,  
0.009880,  0.918621959,  0.996705700,  1.079090958,  0.160999379,  1.619741574,  
0.009890,  0.918580282,  0.996702365,  1.079130320,  0.161081225,  1.619745484,  
0.009900,  0.918538626,  0.996699029,  1.079169662,  0.161163030,  1.619749401,  
0.010000,  0.918123189,  0.996665676,  1.079561950,  0.161978851,  1.619788511,  
0.011000,  0.914075513,  0.996332135,  1.083378135,  0.169925887,  1.620179761,  
0.012000,  0.910203910,  0.995998573,  1.087018248,  0.177524690,  1.620571290,  
0.013000,  0.906486813,  0.995664992,  1.090503854,  0.184818229,  1.620963101,  
0.014000,  0.902906738,  0.995331390,  1.093852437,  0.191841332,  1.621355175,  
0.015000,  0.899449271,  0.994997769,  1.097078411,  0.198622697,  1.621747529,  
0.016000,  0.896102366,  0.994664127,  1.100193823,  0.205186305,  1.622140168,  
0.017000,  0.892855834,  0.994330466,  1.103208861,  0.211552430,  1.622533074,  
0.018000,  0.889700962,  0.993996784,  1.106132238,  0.217738406,  1.622926258,  
0.019000,  0.886630233,  0.993663083,  1.108971472,  0.223759182,  1.623319722,  
0.020000,  0.883637107,  0.993329361,  1.111733103,  0.229627760,  1.623713463,  
0.021000,  0.880715849,  0.992995620,  1.114422863,  0.235355533,  1.624107478,  
0.022000,  0.877861404,  0.992661858,  1.117045811,  0.240952552,  1.624501772,  
0.023000,  0.875069280,  0.992328076,  1.119606437,  0.246427732,  1.624896346,  
0.024000,  0.872335471,  0.991994274,  1.122108747,  0.251789030,  1.625291199,  
0.025000,  0.869656384,  0.991660452,  1.124556335,  0.257043578,  1.625686331,  
0.026000,  0.867028780,  0.991326610,  1.126952439,  0.262197803,  1.626081744,  
0.027000,  0.864449730,  0.990992747,  1.129299988,  0.267257514,  1.626477433,  
0.028000,  0.861916573,  0.990658864,  1.131601644,  0.272227990,  1.626873407,  
0.029000,  0.859426883,  0.990324962,  1.133859832,  0.277114038,  1.627269661,  
0.030000,  0.856978443,  0.989991038,  1.136076770,  0.281920054,  1.627666193,  
0.031000,  0.854569216,  0.989657095,  1.138254493,  0.286650072,  1.628063004,  
0.032000,  0.852197331,  0.989323132,  1.140394874,  0.291307798,  1.628460098,  
0.033000,  0.849861060,  0.988989148,  1.142499640,  0.295896654,  1.628857473,  
0.034000,  0.847558806,  0.988655144,  1.144570389,  0.300419803,  1.629255134,  
0.035000,  0.845289087,  0.988321119,  1.146608601,  0.304880173,  1.629653073,  
0.036000,  0.843050529,  0.987987074,  1.148615653,  0.309280488,  1.630051296,  
0.037000,  0.840841848,  0.987653009,  1.150592826,  0.313623281,  1.630449802,  
0.038000,  0.838661851,  0.987318924,  1.152541315,  0.317910916,  1.630848590,  
0.039000,  0.836509420,  0.986984818,  1.154462238,  0.322145602,  1.631247666,  
0.040000,  0.834383508,  0.986650691,  1.156356641,  0.326329405,  1.631647025,  
0.041000,  0.832283134,  0.986316545,  1.158225504,  0.330464263,  1.632046664,  
0.042000,  0.830207377,  0.985982378,  1.160069751,  0.334551997,  1.632446594,  
0.043000,  0.828155369,  0.985648190,  1.161890247,  0.338594319,  1.632846800,  
0.044000,  0.826126293,  0.985313982,  1.163687812,  0.342592844,  1.633247300,  
0.045000,  0.824119377,  0.984979754,  1.165463215,  0.346549091,  1.633648080,  
0.046000,  0.822133893,  0.984645505,  1.167217186,  0.350464499,  1.634049150,  
0.047000,  0.820169151,  0.984311235,  1.168950413,  0.354340425,  1.634450504,  
0.048000,  0.818224499,  0.983976945,  1.170663551,  0.358178160,  1.634852149,  
0.049000,  0.816299318,  0.983642634,  1.172357217,  0.361978920,  1.635254077,  
0.050000,  0.814393019,  0.983308303,  1.174031999,  0.365743865,  1.635656290,  
0.051000,  0.812505045,  0.982973952,  1.175688457,  0.369474096,  1.636058795,  
0.052000,  0.810634864,  0.982639579,  1.177327121,  0.373170657,  1.636461586,  
0.053000,  0.808781969,  0.982305186,  1.178948498,  0.376834546,  1.636864668,  
0.054000,  0.806945880,  0.981970773,  1.180553069,  0.380466710,  1.637268036,  
0.055000,  0.805126134,  0.981636339,  1.182141295,  0.384068056,  1.637671695,  
0.056000,  0.803322295,  0.981301884,  1.183713615,  0.387639448,  1.638075643,  
0.057000,  0.801533941,  0.980967408,  1.185270448,  0.391181709,  1.638479877,  
0.058000,  0.799760671,  0.980632912,  1.186812197,  0.394695631,  1.638884406,  
0.059000,  0.798002100,  0.980298395,  1.188339245,  0.398181968,  1.639289221,  
0.060000,  0.796257862,  0.979963858,  1.189851961,  0.401641444,  1.639694330,  
0.061000,  0.794527602,  0.979629299,  1.191350698,  0.405074752,  1.640099732,  
0.062000,  0.792810983,  0.979294720,  1.192835793,  0.408482556,  1.640505421,  
0.063000,  0.791107679,  0.978960120,  1.194307573,  0.411865494,  1.640911407,  
0.064000,  0.789417379,  0.978625499,  1.195766348,  0.415224179,  1.641317680,  
0.065000,  0.787739782,  0.978290857,  1.197212420,  0.418559199,  1.641724250,  
0.066000,  0.786074600,  0.977956195,  1.198646075,  0.421871120,  1.642131107,  
0.067000,  0.784421555,  0.977621512,  1.200067594,  0.425160488,  1.642538265,  
0.068000,  0.782780380,  0.977286808,  1.201477241,  0.428427825,  1.642945711,  
0.069000,  0.781150817,  0.976952082,  1.202875276,  0.431673638,  1.643353453,  
0.070000,  0.779532618,  0.976617336,  1.204261946,  0.434898412,  1.643761489,  
0.071000,  0.777925543,  0.976282570,  1.205637490,  0.438102615,  1.644169816,  
0.072000,  0.776329362,  0.975947782,  1.207002141,  0.441286703,  1.644578441,  
0.073000,  0.774743852,  0.975612973,  1.208356121,  0.444451111,  1.644987362,  
0.074000,  0.773168796,  0.975278143,  1.209699646,  0.447596261,  1.645396580,  
0.075000,  0.771603986,  0.974943292,  1.211032923,  0.450722561,  1.645806091,  
0.076000,  0.770049221,  0.974608420,  1.212356155,  0.453830404,  1.646215900,  
0.077000,  0.768504307,  0.974273528,  1.213669536,  0.456920173,  1.646626006,  
0.078000,  0.766969054,  0.973938614,  1.214973255,  0.459992236,  1.647036409,  
0.079000,  0.765443281,  0.973603679,  1.216267493,  0.463046948,  1.647447108,  
0.080000,  0.763926810,  0.973268723,  1.217552429,  0.466084657,  1.647858107,  
0.081000,  0.762419471,  0.972933746,  1.218828233,  0.469105696,  1.648269404,  
0.082000,  0.760921096,  0.972598748,  1.220095070,  0.472110390,  1.648680995,  
0.083000,  0.759431526,  0.972263728,  1.221353103,  0.475099054,  1.649092889,  
0.084000,  0.757950604,  0.971928688,  1.222602488,  0.478071992,  1.649505085,  
0.085000,  0.756478178,  0.971593626,  1.223843375,  0.481029501,  1.649917576,  
0.086000,  0.755014102,  0.971258543,  1.225075912,  0.483971867,  1.650330368,  
0.087000,  0.753558232,  0.970923439,  1.226300242,  0.486899369,  1.650743461,  
0.088000,  0.752110430,  0.970588314,  1.227516504,  0.489812279,  1.651156855,  
0.089000,  0.750670561,  0.970253167,  1.228724832,  0.492710858,  1.651570550,  
0.090000,  0.749238494,  0.969917999,  1.229925357,  0.495595363,  1.651984544,  
0.091000,  0.747814101,  0.969582810,  1.231118208,  0.498466043,  1.652398843,  
0.092000,  0.746397259,  0.969247600,  1.232303507,  0.501323138,  1.652813441,  
0.093000,  0.744987846,  0.968912368,  1.233481376,  0.504166884,  1.653228342,  
0.094000,  0.743585746,  0.968577115,  1.234651932,  0.506997511,  1.653643547,  
0.095000,  0.742190843,  0.968241840,  1.235815290,  0.509815240,  1.654059057,  
0.096000,  0.740803028,  0.967906545,  1.236971560,  0.512620289,  1.654474867,  
0.097000,  0.739422190,  0.967571227,  1.238120852,  0.515412868,  1.654890985,  
0.098000,  0.738048226,  0.967235889,  1.239263270,  0.518193184,  1.655307405,  
0.099000,  0.736681030,  0.966900529,  1.240398917,  0.520961434,  1.655724128,  
0.100000,  0.735320504,  0.966565147,  1.241527895,  0.523717819,  1.656141158,  
0.101000,  0.733966550,  0.966229744,  1.242650301,  0.526462525,  1.656558494,  
0.102000,  0.732619071,  0.965894320,  1.243766231,  0.529195740,  1.656976136,  
0.103000,  0.731277975,  0.965558874,  1.244875777,  0.531917644,  1.657394083,  
0.104000,  0.729943171,  0.965223407,  1.245979031,  0.534628415,  1.657812338,  
0.105000,  0.728614570,  0.964887918,  1.247076081,  0.537328224,  1.658230898,  
0.106000,  0.727292085,  0.964552407,  1.248167014,  0.540017240,  1.658649768,  
0.107000,  0.725975632,  0.964216875,  1.249251914,  0.542695627,  1.659068942,  
0.108000,  0.724665129,  0.963881322,  1.250330865,  0.545363547,  1.659488426,  
0.109000,  0.723360493,  0.963545746,  1.251403947,  0.548021156,  1.659908219,  
0.110000,  0.722061648,  0.963210150,  1.252471238,  0.550668606,  1.660328318,  
0.111000,  0.720768514,  0.962874531,  1.253532817,  0.553306050,  1.660748731,  
0.112000,  0.719481018,  0.962538891,  1.254588758,  0.555933631,  1.661169449,  
0.113000,  0.718199085,  0.962203229,  1.255639135,  0.558551493,  1.661590481,  
0.114000,  0.716922643,  0.961867545,  1.256684020,  0.561159777,  1.662011821,  
0.115000,  0.715651622,  0.961531840,  1.257723484,  0.563758619,  1.662433471,  
0.116000,  0.714385952,  0.961196113,  1.258757595,  0.566348152,  1.662855432,  
0.117000,  0.713125567,  0.960860364,  1.259786422,  0.568928510,  1.663277707,  
0.118000,  0.711870400,  0.960524594,  1.260810030,  0.571499818,  1.663700291,  
0.119000,  0.710620386,  0.960188801,  1.261828484,  0.574062202,  1.664123188,  
0.120000,  0.709375462,  0.959852987,  1.262841847,  0.576615786,  1.664546397,  
0.121000,  0.708135566,  0.959517151,  1.263850182,  0.579160690,  1.664969921,  
0.122000,  0.706900638,  0.959181293,  1.264853549,  0.581697032,  1.665393757,  
0.123000,  0.705670617,  0.958845414,  1.265852007,  0.584224925,  1.665817905,  
0.124000,  0.704445446,  0.958509512,  1.266845616,  0.586744486,  1.666242371,  
0.125000,  0.703225066,  0.958173588,  1.267834432,  0.589255822,  1.666667150,  
0.126000,  0.702009424,  0.957837643,  1.268818510,  0.591759042,  1.667092242,  
0.127000,  0.700798462,  0.957501676,  1.269797907,  0.594254255,  1.667517651,  
0.128000,  0.699592128,  0.957165686,  1.270772676,  0.596741563,  1.667943375,  
0.129000,  0.698390368,  0.956829675,  1.271742869,  0.599221069,  1.668369415,  
0.130000,  0.697193132,  0.956493642,  1.272708539,  0.601692873,  1.668795773,  
0.131000,  0.696000368,  0.956157586,  1.273669736,  0.604157072,  1.669222446,  
0.132000,  0.694812026,  0.955821509,  1.274626510,  0.606613765,  1.669649436,  
0.133000,  0.693628057,  0.955485409,  1.275578910,  0.609063045,  1.670076745,  
0.134000,  0.692448414,  0.955149288,  1.276526984,  0.611505005,  1.670504372,  
0.135000,  0.691273050,  0.954813144,  1.277470779,  0.613939736,  1.670932317,  
0.136000,  0.690101917,  0.954476978,  1.278410341,  0.616367327,  1.671360580,  
0.137000,  0.688934972,  0.954140791,  1.279345716,  0.618787867,  1.671789164,  
0.138000,  0.687772168,  0.953804581,  1.280276948,  0.621201441,  1.672218066,  
0.139000,  0.686613463,  0.953468348,  1.281204081,  0.623608134,  1.672647289,  
0.140000,  0.685458814,  0.953132094,  1.282127157,  0.626008028,  1.673076831,  
0.141000,  0.684308178,  0.952795818,  1.283046220,  0.628401207,  1.673506696,  
0.142000,  0.683161514,  0.952459519,  1.283961310,  0.630787749,  1.673936880,  
0.143000,  0.682018781,  0.952123198,  1.284872468,  0.633167733,  1.674367385,  
0.144000,  0.680879940,  0.951786854,  1.285779734,  0.635541237,  1.674798212,  
0.145000,  0.679744950,  0.951450489,  1.286683148,  0.637908336,  1.675229362,  
0.146000,  0.678613773,  0.951114101,  1.287582749,  0.640269107,  1.675660838,  
0.147000,  0.677486372,  0.950777690,  1.288478573,  0.642623620,  1.676092633,  
0.148000,  0.676362708,  0.950441258,  1.289370659,  0.644971950,  1.676524752,  
0.149000,  0.675242745,  0.950104803,  1.290259044,  0.647314167,  1.676957197,  
0.150000,  0.674126447,  0.949768325,  1.291143763,  0.649650340,  1.677389966,  
0.151000,  0.673013779,  0.949431826,  1.292024851,  0.651980538,  1.677823057,  
0.152000,  0.671904705,  0.949095304,  1.292902345,  0.654304829,  1.678256475,  
0.153000,  0.670799191,  0.948758759,  1.293776278,  0.656623278,  1.678690219,  
0.154000,  0.669697204,  0.948422192,  1.294646684,  0.658935952,  1.679124287,  
0.155000,  0.668598709,  0.948085602,  1.295513597,  0.661242915,  1.679558685,  
0.156000,  0.667503675,  0.947748990,  1.296377048,  0.663544229,  1.679993406,  
0.157000,  0.666412069,  0.947412355,  1.297237071,  0.665839957,  1.680428456,  
0.158000,  0.665323860,  0.947075698,  1.298093697,  0.668130159,  1.680863833,  
0.159000,  0.664239015,  0.946739018,  1.298946957,  0.670414897,  1.681299539,  
0.160000,  0.663157505,  0.946402316,  1.299796882,  0.672694229,  1.681735573,  
0.161000,  0.662079300,  0.946065591,  1.300643502,  0.674968214,  1.682171935,  
0.162000,  0.661004369,  0.945728844,  1.301486847,  0.677236908,  1.682608626,  
0.163000,  0.659932682,  0.945392074,  1.302326946,  0.679500370,  1.683045648,  
0.164000,  0.658864213,  0.945055281,  1.303163828,  0.681758653,  1.683482998,  
0.165000,  0.657798931,  0.944718465,  1.303997522,  0.684011814,  1.683920681,  
0.166000,  0.656736809,  0.944381627,  1.304828056,  0.686259906,  1.684358695,  
0.167000,  0.655677819,  0.944044766,  1.305655456,  0.688502982,  1.684797037,  
0.168000,  0.654621934,  0.943707882,  1.306479751,  0.690741096,  1.685235714,  
0.169000,  0.653569128,  0.943370976,  1.307300967,  0.692974297,  1.685674722,  
0.170000,  0.652519374,  0.943034047,  1.308119130,  0.695202637,  1.686114062,  
0.171000,  0.651472645,  0.942697095,  1.308934267,  0.697426167,  1.686553734,  
0.172000,  0.650428917,  0.942360120,  1.309746403,  0.699644936,  1.686993742,  
0.173000,  0.649388164,  0.942023122,  1.310555563,  0.701858992,  1.687434083,  
0.174000,  0.648350361,  0.941686102,  1.311361772,  0.704068383,  1.687874756,  
0.175000,  0.647315484,  0.941349058,  1.312165055,  0.706273156,  1.688315765,  
0.176000,  0.646283508,  0.941011992,  1.312965436,  0.708473360,  1.688757109,  
0.177000,  0.645254410,  0.940674903,  1.313762939,  0.710669038,  1.689198790,  
0.178000,  0.644228167,  0.940337791,  1.314557587,  0.712860237,  1.689640807,  
0.179000,  0.643204754,  0.940000655,  1.315349403,  0.715047001,  1.690083157,  
0.180000,  0.642184149,  0.939663497,  1.316138410,  0.717229373,  1.690525843,  
0.181000,  0.641166330,  0.939326316,  1.316924632,  0.719407399,  1.690968871,  
0.182000,  0.640151274,  0.938989112,  1.317708089,  0.721581120,  1.691412234,  
0.183000,  0.639138960,  0.938651885,  1.318488805,  0.723750579,  1.691855936,  
0.184000,  0.638129365,  0.938314634,  1.319266800,  0.725915818,  1.692299975,  
0.185000,  0.637122469,  0.937977361,  1.320042096,  0.728076877,  1.692744354,  
0.186000,  0.636118250,  0.937640065,  1.320814714,  0.730233797,  1.693189072,  
0.187000,  0.635116688,  0.937302745,  1.321584675,  0.732386618,  1.693634131,  
0.188000,  0.634117761,  0.936965402,  1.322351999,  0.734535380,  1.694079528,  
0.189000,  0.633121451,  0.936628036,  1.323116706,  0.736680121,  1.694525266,  
0.190000,  0.632127737,  0.936290647,  1.323878817,  0.738820880,  1.694971344,  
0.191000,  0.631136599,  0.935953235,  1.324638352,  0.740957697,  1.695417767,  
0.192000,  0.630148018,  0.935615800,  1.325395328,  0.743090605,  1.695864528,  
0.193000,  0.629161974,  0.935278341,  1.326149767,  0.745219645,  1.696311633,  
0.194000,  0.628178449,  0.934940859,  1.326901686,  0.747344851,  1.696759080,  
0.195000,  0.627197424,  0.934603353,  1.327651105,  0.749466262,  1.697206872,  
0.196000,  0.626218880,  0.934265825,  1.328398042,  0.751583910,  1.697655007,  
0.197000,  0.625242800,  0.933928273,  1.329142514,  0.753697832,  1.698103483,  
0.198000,  0.624269165,  0.933590697,  1.329884541,  0.755808063,  1.698552306,  
0.199000,  0.623297957,  0.933253099,  1.330624140,  0.757914636,  1.699001475,  
0.200000,  0.622329159,  0.932915477,  1.331361329,  0.760017587,  1.699450989,  
0.201000,  0.621362754,  0.932577831,  1.332096124,  0.762116947,  1.699900847,  
0.202000,  0.620398725,  0.932240162,  1.332828543,  0.764212750,  1.700351052,  
0.203000,  0.619437053,  0.931902470,  1.333558603,  0.766305030,  1.700801605,  
0.204000,  0.618477724,  0.931564754,  1.334286320,  0.768393816,  1.701252503,  
0.205000,  0.617520720,  0.931227014,  1.335011712,  0.770479143,  1.701703751,  
0.206000,  0.616566025,  0.930889252,  1.335734794,  0.772561040,  1.702155346,  
0.207000,  0.615613624,  0.930551465,  1.336455582,  0.774639540,  1.702607289,  
0.208000,  0.614663498,  0.930213655,  1.337174093,  0.776714673,  1.703059581,  
0.209000,  0.613715635,  0.929875821,  1.337890341,  0.778786467,  1.703512220,  
0.210000,  0.612770017,  0.929537964,  1.338604344,  0.780854957,  1.703965213,  
0.211000,  0.611826630,  0.929200083,  1.339316115,  0.782920168,  1.704418553,  
0.212000,  0.610885457,  0.928862179,  1.340025671,  0.784982132,  1.704872247,  
0.213000,  0.609946486,  0.928524251,  1.340733025,  0.787040876,  1.705326288,  
0.214000,  0.609009699,  0.928186299,  1.341438194,  0.789096430,  1.705780683,  
0.215000,  0.608075083,  0.927848323,  1.342141191,  0.791148822,  1.706235429,  
0.216000,  0.607142624,  0.927510324,  1.342842031,  0.793198079,  1.706690528,  
0.217000,  0.606212306,  0.927172301,  1.343540729,  0.795244230,  1.707145981,  
0.218000,  0.605284117,  0.926834254,  1.344237298,  0.797287302,  1.707601786,  
0.219000,  0.604358041,  0.926496183,  1.344931753,  0.799327321,  1.708057946,  
0.220000,  0.603434065,  0.926158089,  1.345624107,  0.801364315,  1.708514459,  
0.221000,  0.602512176,  0.925819971,  1.346314374,  0.803398309,  1.708971327,  
0.222000,  0.601592359,  0.925481828,  1.347002568,  0.805429330,  1.709428551,  
0.223000,  0.600674602,  0.925143662,  1.347688702,  0.807457404,  1.709886131,  
0.224000,  0.599758891,  0.924805472,  1.348372789,  0.809482557,  1.710344067,  
0.225000,  0.598845213,  0.924467258,  1.349054842,  0.811504812,  1.710802359,  
0.226000,  0.597933556,  0.924129021,  1.349734874,  0.813524196,  1.711261008,  
0.227000,  0.597023906,  0.923790759,  1.350412898,  0.815540733,  1.711720014,  
0.228000,  0.596116250,  0.923452473,  1.351088927,  0.817554448,  1.712179379,  
0.229000,  0.595210577,  0.923114163,  1.351762973,  0.819565365,  1.712639102,  
0.230000,  0.594306874,  0.922775829,  1.352435048,  0.821573507,  1.713099183,  
0.231000,  0.593405129,  0.922437472,  1.353105165,  0.823578898,  1.713559625,  
0.232000,  0.592505329,  0.922099090,  1.353773336,  0.825581563,  1.714020427,  
0.233000,  0.591607462,  0.921760683,  1.354439573,  0.827581523,  1.714481588,  
0.234000,  0.590711518,  0.921422253,  1.355103887,  0.829578802,  1.714943109,  
0.235000,  0.589817483,  0.921083799,  1.355766291,  0.831573423,  1.715404993,  
0.236000,  0.588925347,  0.920745320,  1.356426796,  0.833565408,  1.715867239,  
0.237000,  0.588035098,  0.920406818,  1.357085413,  0.835554779,  1.716329846,  
0.238000,  0.587146724,  0.920068291,  1.357742154,  0.837541558,  1.716792816,  
0.239000,  0.586260214,  0.919729739,  1.358397030,  0.839525768,  1.717256148,  
0.240000,  0.585375558,  0.919391164,  1.359050052,  0.841507428,  1.717719845,  
0.241000,  0.584492744,  0.919052564,  1.359701232,  0.843486562,  1.718183906,  
0.242000,  0.583611761,  0.918713940,  1.360350579,  0.845463189,  1.718648329,  
0.243000,  0.582732599,  0.918375292,  1.360998106,  0.847437332,  1.719113121,  
0.244000,  0.581855246,  0.918036619,  1.361643822,  0.849409010,  1.719578276,  
0.245000,  0.580979693,  0.917697922,  1.362287738,  0.851378243,  1.720043797,  
0.246000,  0.580105929,  0.917359201,  1.362929865,  0.853345054,  1.720509686,  
0.247000,  0.579233943,  0.917020455,  1.363570212,  0.855309459,  1.720975939,  
0.248000,  0.578363725,  0.916681685,  1.364208791,  0.857271482,  1.721442562,  
0.249000,  0.577495265,  0.916342890,  1.364845612,  0.859231142,  1.721909553,  
0.250000,  0.576628553,  0.916004071,  1.365480683,  0.861188455,  1.722376910,  
0.251000,  0.575763579,  0.915665227,  1.366114016,  0.863143444,  1.722844637,  
0.252000,  0.574900333,  0.915326359,  1.366745621,  0.865096127,  1.723312735,  
0.253000,  0.574038806,  0.914987466,  1.367375506,  0.867046522,  1.723781201,  
0.254000,  0.573178987,  0.914648548,  1.368003682,  0.868994650,  1.724250038,  
0.255000,  0.572320868,  0.914309607,  1.368630158,  0.870940526,  1.724719246,  
0.256000,  0.571464438,  0.913970640,  1.369254943,  0.872884172,  1.725188822,  
0.257000,  0.570609689,  0.913631649,  1.369878048,  0.874825604,  1.725658773,  
0.258000,  0.569756611,  0.913292633,  1.370499481,  0.876764841,  1.726129096,  
0.259000,  0.568905194,  0.912953592,  1.371119251,  0.878701901,  1.726599790,  
0.260000,  0.568055430,  0.912614527,  1.371737368,  0.880636801,  1.727070859,  
0.261000,  0.567207311,  0.912275437,  1.372353841,  0.882569559,  1.727542301,  
0.262000,  0.566360826,  0.911936322,  1.372968678,  0.884500192,  1.728014117,  
0.263000,  0.565515966,  0.911597183,  1.373581889,  0.886428719,  1.728486308,  
0.264000,  0.564672724,  0.911258018,  1.374193482,  0.888355155,  1.728958874,  
0.265000,  0.563831091,  0.910918829,  1.374803466,  0.890279517,  1.729431817,  
0.266000,  0.562991057,  0.910579615,  1.375411849,  0.892201822,  1.729905134,  
0.267000,  0.562152615,  0.910240376,  1.376018640,  0.894122087,  1.730378828,  
0.268000,  0.561315755,  0.909901113,  1.376623848,  0.896040329,  1.730852900,  
0.269000,  0.560480470,  0.909561824,  1.377227481,  0.897956564,  1.731327350,  
0.270000,  0.559646752,  0.909222510,  1.377829546,  0.899870807,  1.731802176,  
0.271000,  0.558814591,  0.908883172,  1.378430054,  0.901783077,  1.732277384,  
0.272000,  0.557983980,  0.908543808,  1.379029010,  0.903693385,  1.732752968,  
0.273000,  0.557154911,  0.908204420,  1.379626424,  0.905601751,  1.733228933,  
0.274000,  0.556327376,  0.907865006,  1.380222304,  0.907508189,  1.733705278,  
0.275000,  0.555501367,  0.907525568,  1.380816657,  0.909412715,  1.734182004,  
0.276000,  0.554676875,  0.907186104,  1.381409491,  0.911315343,  1.734659110,  
0.277000,  0.553853894,  0.906846615,  1.382000815,  0.913216091,  1.735136599,  
0.278000,  0.553032416,  0.906507101,  1.382590635,  0.915114970,  1.735614469,  
0.279000,  0.552212432,  0.906167562,  1.383178960,  0.917011999,  1.736092723,  
0.280000,  0.551393936,  0.905827998,  1.383765797,  0.918907191,  1.736571360,  
0.281000,  0.550576920,  0.905488408,  1.384351153,  0.920800559,  1.737050380,  
0.282000,  0.549761376,  0.905148794,  1.384935036,  0.922692121,  1.737529784,  
0.283000,  0.548947297,  0.904809154,  1.385517453,  0.924581888,  1.738009572,  
0.284000,  0.548134676,  0.904469489,  1.386098413,  0.926469878,  1.738489748,  
0.285000,  0.547323505,  0.904129798,  1.386677921,  0.928356103,  1.738970307,  
0.286000,  0.546513778,  0.903790082,  1.387255985,  0.930240576,  1.739451254,  
0.287000,  0.545705486,  0.903450341,  1.387832612,  0.932123313,  1.739932586,  
0.288000,  0.544898624,  0.903110575,  1.388407810,  0.934004328,  1.740414307,  
0.289000,  0.544093184,  0.902770783,  1.388981584,  0.935883632,  1.740896414,  
0.290000,  0.543289159,  0.902430966,  1.389553943,  0.937761242,  1.741378910,  
0.291000,  0.542486543,  0.902091123,  1.390124893,  0.939637170,  1.741861796,  
0.292000,  0.541685328,  0.901751255,  1.390694441,  0.941511430,  1.742345071,  
0.293000,  0.540885507,  0.901411361,  1.391262593,  0.943384034,  1.742828734,  
0.294000,  0.540087074,  0.901071442,  1.391829357,  0.945254996,  1.743312789,  
0.295000,  0.539290023,  0.900731498,  1.392394739,  0.947124329,  1.743797236,  
0.296000,  0.538494347,  0.900391527,  1.392958745,  0.948992046,  1.744282072,  
0.297000,  0.537700039,  0.900051532,  1.393521383,  0.950858161,  1.744767301,  
0.298000,  0.536907092,  0.899711510,  1.394082658,  0.952722685,  1.745252923,  
0.299000,  0.536115501,  0.899371463,  1.394642577,  0.954585631,  1.745738937,  
0.300000,  0.535325259,  0.899031391,  1.395201146,  0.956447012,  1.746225344,  
0.301000,  0.534536360,  0.898691292,  1.395758373,  0.958306841,  1.746712148,  
0.302000,  0.533748796,  0.898351168,  1.396314262,  0.960165129,  1.747199344,  
0.303000,  0.532962563,  0.898011019,  1.396868820,  0.962021890,  1.747686935,  
0.304000,  0.532177654,  0.897670843,  1.397422054,  0.963877135,  1.748174922,  
0.305000,  0.531394062,  0.897330642,  1.397973969,  0.965730876,  1.748663307,  
0.306000,  0.530611783,  0.896990415,  1.398524572,  0.967583126,  1.749152087,  
0.307000,  0.529830809,  0.896650162,  1.399073869,  0.969433896,  1.749641266,  
0.308000,  0.529051135,  0.896309883,  1.399621865,  0.971283198,  1.750130841,  
0.309000,  0.528272754,  0.895969579,  1.400168566,  0.973131044,  1.750620814,  
0.310000,  0.527495662,  0.895629248,  1.400713979,  0.974977446,  1.751111186,  
0.311000,  0.526719852,  0.895288892,  1.401258109,  0.976822415,  1.751601958,  
0.312000,  0.525945318,  0.894948510,  1.401800962,  0.978665962,  1.752093129,  
0.313000,  0.525172054,  0.894608101,  1.402342544,  0.980508100,  1.752584703,  
0.314000,  0.524400056,  0.894267667,  1.402882860,  0.982348838,  1.753076677,  
0.315000,  0.523629317,  0.893927207,  1.403421916,  0.984188189,  1.753569052,  
0.316000,  0.522859831,  0.893586721,  1.403959718,  0.986026164,  1.754061830,  
0.317000,  0.522091594,  0.893246208,  1.404496271,  0.987862774,  1.754555009,  
0.318000,  0.521324599,  0.892905670,  1.405031581,  0.989698029,  1.755048593,  
0.319000,  0.520558842,  0.892565105,  1.405565652,  0.991531940,  1.755542578,  
0.320000,  0.519794316,  0.892224514,  1.406098492,  0.993364520,  1.756036970,  
0.321000,  0.519031016,  0.891883898,  1.406630105,  0.995195777,  1.756531767,  
0.322000,  0.518268938,  0.891543255,  1.407160495,  0.997025722,  1.757026967,  
0.323000,  0.517508074,  0.891202585,  1.407689670,  0.998854368,  1.757522575,  
0.324000,  0.516748422,  0.890861890,  1.408217633,  1.000681723,  1.758018588,  
0.325000,  0.515989974,  0.890521168,  1.408744390,  1.002507798,  1.758515007,  
0.326000,  0.515232727,  0.890180420,  1.409269947,  1.004332605,  1.759011837,  
0.327000,  0.514476674,  0.889839646,  1.409794308,  1.006156152,  1.759509073,  
0.328000,  0.513721811,  0.889498845,  1.410317479,  1.007978451,  1.760006720,  
0.329000,  0.512968133,  0.889158018,  1.410839465,  1.009799511,  1.760504774,  
0.330000,  0.512215634,  0.888817164,  1.411360270,  1.011619343,  1.761003240,  
0.331000,  0.511464310,  0.888476284,  1.411879900,  1.013437956,  1.761502115,  
0.332000,  0.510714156,  0.888135378,  1.412398359,  1.015255360,  1.762001400,  
0.333000,  0.509965167,  0.887794445,  1.412915653,  1.017071566,  1.762501098,  
0.334000,  0.509217337,  0.887453486,  1.413431785,  1.018886581,  1.763001204,  
0.335000,  0.508470663,  0.887112500,  1.413946763,  1.020700419,  1.763501727,  
0.336000,  0.507725138,  0.886771488,  1.414460590,  1.022513087,  1.764002664,  
0.337000,  0.506980759,  0.886430449,  1.414973270,  1.024324595,  1.764504012,  
0.338000,  0.506237521,  0.886089383,  1.415484808,  1.026134952,  1.765005774,  
0.339000,  0.505495419,  0.885748291,  1.415995210,  1.027944169,  1.765507953,  
0.340000,  0.504754448,  0.885407172,  1.416504480,  1.029752254,  1.766010546,  
0.341000,  0.504014604,  0.885066027,  1.417012623,  1.031559218,  1.766513557,  
0.342000,  0.503275882,  0.884724855,  1.417519642,  1.033365068,  1.767016983,  
0.343000,  0.502538278,  0.884383656,  1.418025544,  1.035169816,  1.767520828,  
0.344000,  0.501801787,  0.884042430,  1.418530331,  1.036973468,  1.768025088,  
0.345000,  0.501066404,  0.883701178,  1.419034009,  1.038776034,  1.768529765,  
0.346000,  0.500332125,  0.883359899,  1.419536583,  1.040577526,  1.769034866,  
0.347000,  0.499598946,  0.883018593,  1.420038056,  1.042377950,  1.769540384,  
0.348000,  0.498866862,  0.882677260,  1.420538433,  1.044177315,  1.770046322,  
0.349000,  0.498135869,  0.882335900,  1.421037719,  1.045975632,  1.770552682,  
0.350000,  0.497405962,  0.881994513,  1.421535917,  1.047772907,  1.771059461,  
0.351000,  0.496677137,  0.881653100,  1.422033033,  1.049569151,  1.771566663,  
0.352000,  0.495949391,  0.881311659,  1.422529070,  1.051364372,  1.772074288,  
0.353000,  0.495222718,  0.880970192,  1.423024032,  1.053158578,  1.772582334,  
0.354000,  0.494497114,  0.880628697,  1.423517924,  1.054951778,  1.773090804,  
0.355000,  0.493772576,  0.880287176,  1.424010751,  1.056743982,  1.773599701,  
0.356000,  0.493049098,  0.879945627,  1.424502515,  1.058535196,  1.774109019,  
0.357000,  0.492326678,  0.879604051,  1.424993222,  1.060325431,  1.774618766,  
0.358000,  0.491605310,  0.879262448,  1.425482875,  1.062114692,  1.775128934,  
0.359000,  0.490884991,  0.878920818,  1.425971479,  1.063902991,  1.775639533,  
0.360000,  0.490165717,  0.878579161,  1.426459037,  1.065690334,  1.776150557,  
0.361000,  0.489447483,  0.878237477,  1.426945554,  1.067476731,  1.776662010,  
0.362000,  0.488730286,  0.877895765,  1.427431033,  1.069262188,  1.777173890,  
0.363000,  0.488014122,  0.877554026,  1.427915479,  1.071046715,  1.777686200,  
0.364000,  0.487298987,  0.877212260,  1.428398896,  1.072830319,  1.778198939,  
0.365000,  0.486584876,  0.876870467,  1.428881286,  1.074613008,  1.778712107,  
0.366000,  0.485871786,  0.876528646,  1.429362655,  1.076394791,  1.779225706,  
0.367000,  0.485159714,  0.876186798,  1.429843006,  1.078175675,  1.779739737,  
0.368000,  0.484448654,  0.875844923,  1.430322344,  1.079955669,  1.780254200,  
0.369000,  0.483738604,  0.875503020,  1.430800671,  1.081734780,  1.780769096,  
0.370000,  0.483029560,  0.875161089,  1.431277991,  1.083513015,  1.781284424,  
0.371000,  0.482321518,  0.874819132,  1.431754309,  1.085290384,  1.781800187,  
0.372000,  0.481614474,  0.874477146,  1.432229627,  1.087066892,  1.782316382,  
0.373000,  0.480908424,  0.874135134,  1.432703951,  1.088842549,  1.782833014,  
0.374000,  0.480203365,  0.873793093,  1.433177283,  1.090617362,  1.783350081,  
0.375000,  0.479499293,  0.873451025,  1.433649626,  1.092391336,  1.783867582,  
0.376000,  0.478796205,  0.873108930,  1.434120986,  1.094164483,  1.784385522,  
0.377000,  0.478094096,  0.872766807,  1.434591365,  1.095936808,  1.784903899,  
0.378000,  0.477392964,  0.872424656,  1.435060767,  1.097708319,  1.785422715,  
0.379000,  0.476692805,  0.872082478,  1.435529195,  1.099479023,  1.785941968,  
0.380000,  0.475993614,  0.871740271,  1.435996653,  1.101248927,  1.786461660,  
0.381000,  0.475295390,  0.871398038,  1.436463145,  1.103018040,  1.786981793,  
0.382000,  0.474598127,  0.871055776,  1.436928674,  1.104786368,  1.787502366,  
0.383000,  0.473901823,  0.870713486,  1.437393243,  1.106553918,  1.788023380,  
0.384000,  0.473206475,  0.870371169,  1.437856856,  1.108320697,  1.788544834,  
0.385000,  0.472512078,  0.870028824,  1.438319517,  1.110086715,  1.789066734,  
0.386000,  0.471818630,  0.869686451,  1.438781228,  1.111851975,  1.789589073,  
0.387000,  0.471126126,  0.869344050,  1.439241993,  1.113616486,  1.790111856,  
0.388000,  0.470434565,  0.869001621,  1.439701816,  1.115380256,  1.790635085,  
0.389000,  0.469743942,  0.868659165,  1.440160700,  1.117143292,  1.791158760,  
0.390000,  0.469054253,  0.868316680,  1.440618648,  1.118905599,  1.791682878,  
0.391000,  0.468365497,  0.867974167,  1.441075663,  1.120667185,  1.792207442,  
0.392000,  0.467677669,  0.867631626,  1.441531749,  1.122428057,  1.792732453,  
0.393000,  0.466990766,  0.867289057,  1.441986909,  1.124188222,  1.793257912,  
0.394000,  0.466304784,  0.866946460,  1.442441146,  1.125947687,  1.793783819,  
0.395000,  0.465619722,  0.866603835,  1.442894464,  1.127706458,  1.794310174,  
0.396000,  0.464935575,  0.866261182,  1.443346865,  1.129464542,  1.794836977,  
0.397000,  0.464252341,  0.865918501,  1.443798353,  1.131221947,  1.795364233,  
0.398000,  0.463570016,  0.865575791,  1.444248931,  1.132978678,  1.795891937,  
0.399000,  0.462888596,  0.865233053,  1.444698601,  1.134734741,  1.796420091,  
0.400000,  0.462208080,  0.864890287,  1.445147369,  1.136490147,  1.796948701,  
0.401000,  0.461528464,  0.864547493,  1.445595235,  1.138244897,  1.797477760,  
0.402000,  0.460849744,  0.864204670,  1.446042204,  1.139999001,  1.798007273,  
0.403000,  0.460171918,  0.863861819,  1.446488278,  1.141752464,  1.798537239,  
0.404000,  0.459494982,  0.863518939,  1.446933461,  1.143505294,  1.799067661,  
0.405000,  0.458818935,  0.863176031,  1.447377755,  1.145257496,  1.799598537,  
0.406000,  0.458143772,  0.862833095,  1.447821163,  1.147009076,  1.800129867,  
0.407000,  0.457469490,  0.862490130,  1.448263689,  1.148760043,  1.800661656,  
0.408000,  0.456796087,  0.862147137,  1.448705336,  1.150510401,  1.801193899,  
0.409000,  0.456123560,  0.861804115,  1.449146105,  1.152260157,  1.801726603,  
0.410000,  0.455451906,  0.861461065,  1.449586002,  1.154009318,  1.802259764,  
0.411000,  0.454781121,  0.861117986,  1.450025027,  1.155757889,  1.802793384,  
0.412000,  0.454111204,  0.860774879,  1.450463184,  1.157505876,  1.803327462,  
0.413000,  0.453442151,  0.860431742,  1.450900477,  1.159253288,  1.803862003,  
0.414000,  0.452773959,  0.860088578,  1.451336907,  1.161000128,  1.804397002,  
0.415000,  0.452106625,  0.859745384,  1.451772478,  1.162746403,  1.804932465,  
0.416000,  0.451440147,  0.859402162,  1.452207192,  1.164492120,  1.805468388,  
0.417000,  0.450774521,  0.859058911,  1.452641052,  1.166237284,  1.806004774,  
0.418000,  0.450109746,  0.858715631,  1.453074062,  1.167981902,  1.806541624,  
0.419000,  0.449445818,  0.858372322,  1.453506224,  1.169725980,  1.807078939,  
0.420000,  0.448782734,  0.858028985,  1.453937540,  1.171469523,  1.807616718,  
0.421000,  0.448120492,  0.857685619,  1.454368014,  1.173212538,  1.808154963,  
0.422000,  0.447459089,  0.857342224,  1.454797647,  1.174955030,  1.808693673,  
0.423000,  0.446798522,  0.856998800,  1.455226444,  1.176697007,  1.809232853,  
0.424000,  0.446138788,  0.856655346,  1.455654406,  1.178438473,  1.809772498,  
0.425000,  0.445479886,  0.856311864,  1.456081536,  1.180179432,  1.810312610,  
0.426000,  0.444821811,  0.855968353,  1.456507837,  1.181919895,  1.810853194,  
0.427000,  0.444164562,  0.855624813,  1.456933311,  1.183659863,  1.811394246,  
0.428000,  0.443508136,  0.855281244,  1.457357962,  1.185399345,  1.811935769,  
0.429000,  0.442852531,  0.854937646,  1.457781791,  1.187138343,  1.812477760,  
0.430000,  0.442197743,  0.854594018,  1.458204802,  1.188876867,  1.813020225,  
0.431000,  0.441543770,  0.854250362,  1.458626997,  1.190614921,  1.813563163,  
0.432000,  0.440890609,  0.853906676,  1.459048378,  1.192352511,  1.814106574,  
0.433000,  0.440238259,  0.853562961,  1.459468948,  1.194089640,  1.814650456,  
0.434000,  0.439586716,  0.853219217,  1.459888709,  1.195826316,  1.815194812,  
0.435000,  0.438935978,  0.852875443,  1.460307665,  1.197562547,  1.815739649,  
0.436000,  0.438286042,  0.852531640,  1.460725818,  1.199298334,  1.816284956,  
0.437000,  0.437636906,  0.852187808,  1.461143169,  1.201033684,  1.816830739,  
0.438000,  0.436988567,  0.851843947,  1.461559723,  1.202768606,  1.817377005,  
0.439000,  0.436341023,  0.851500056,  1.461975480,  1.204503100,  1.817923744,  
0.440000,  0.435694272,  0.851156135,  1.462390444,  1.206237175,  1.818470962,  
0.441000,  0.435048310,  0.850812185,  1.462804617,  1.207970836,  1.819018661,  
0.442000,  0.434403137,  0.850468206,  1.463218001,  1.209704086,  1.819566837,  
0.443000,  0.433758748,  0.850124197,  1.463630599,  1.211436934,  1.820115496,  
0.444000,  0.433115142,  0.849780159,  1.464042413,  1.213169383,  1.820664634,  
0.445000,  0.432472316,  0.849436091,  1.464453446,  1.214901440,  1.821214256,  
0.446000,  0.431830268,  0.849091993,  1.464863700,  1.216633110,  1.821764362,  
0.447000,  0.431188996,  0.848747866,  1.465273177,  1.218364396,  1.822314948,  
0.448000,  0.430548497,  0.848403709,  1.465681880,  1.220095306,  1.822866019,  
0.449000,  0.429908769,  0.848059522,  1.466089811,  1.221825844,  1.823417575,  
0.450000,  0.429269810,  0.847715306,  1.466496973,  1.223556017,  1.823969619,  
0.451000,  0.428631616,  0.847371060,  1.466903367,  1.225285827,  1.824522146,  
0.452000,  0.427994187,  0.847026784,  1.467308996,  1.227015283,  1.825075162,  
0.453000,  0.427357520,  0.846682478,  1.467713862,  1.228744386,  1.825628662,  
0.454000,  0.426721611,  0.846338142,  1.468117968,  1.230473146,  1.826182655,  
0.455000,  0.426086460,  0.845993777,  1.468521316,  1.232201565,  1.826737136,  
0.456000,  0.425452064,  0.845649382,  1.468923907,  1.233929648,  1.827292106,  
0.457000,  0.424818420,  0.845304956,  1.469325745,  1.235657401,  1.827847565,  
0.458000,  0.424185526,  0.844960501,  1.469726832,  1.237384831,  1.828403520,  
0.459000,  0.423553381,  0.844616015,  1.470127169,  1.239111938,  1.828959962,  
0.460000,  0.422921982,  0.844271500,  1.470526759,  1.240838732,  1.829516899,  
0.461000,  0.422291326,  0.843926954,  1.470925604,  1.242565215,  1.830074328,  
0.462000,  0.421661413,  0.843582379,  1.471323706,  1.244291393,  1.830632251,  
0.463000,  0.421032238,  0.843237773,  1.471721068,  1.246017272,  1.831190670,  
0.464000,  0.420403801,  0.842893137,  1.472117692,  1.247742857,  1.831749586,  
0.465000,  0.419776099,  0.842548471,  1.472513579,  1.249468151,  1.832308997,  
0.466000,  0.419149130,  0.842203775,  1.472908732,  1.251193160,  1.832868904,  
0.467000,  0.418522892,  0.841859048,  1.473303153,  1.252917890,  1.833429311,  
0.468000,  0.417897382,  0.841514291,  1.473696844,  1.254642343,  1.833990214,  
0.469000,  0.417272599,  0.841169504,  1.474089807,  1.256366527,  1.834551618,  
0.470000,  0.416648541,  0.840824686,  1.474482045,  1.258090445,  1.835113521,  
0.471000,  0.416025205,  0.840479838,  1.474873559,  1.259814104,  1.835675927,  
0.472000,  0.415402590,  0.840134960,  1.475264351,  1.261537505,  1.836238830,  
0.473000,  0.414780692,  0.839790051,  1.475654424,  1.263260658,  1.836802242,  
0.474000,  0.414159512,  0.839445112,  1.476043779,  1.264983562,  1.837366151,  
0.475000,  0.413539045,  0.839100142,  1.476432419,  1.266706226,  1.837930566,  
0.476000,  0.412919291,  0.838755141,  1.476820345,  1.268428653,  1.838495484,  
0.477000,  0.412300247,  0.838410110,  1.477207560,  1.270150849,  1.839060910,  
0.478000,  0.411681911,  0.838065049,  1.477594065,  1.271872817,  1.839626839,  
0.479000,  0.411064282,  0.837719956,  1.477979863,  1.273594563,  1.840193277,  
0.480000,  0.410447356,  0.837374833,  1.478364956,  1.275316092,  1.840760223,  
0.481000,  0.409831133,  0.837029680,  1.478749345,  1.277037407,  1.841327675,  
0.482000,  0.409215610,  0.836684495,  1.479133032,  1.278758514,  1.841895637,  
0.483000,  0.408600786,  0.836339280,  1.479516020,  1.280479417,  1.842464108,  
0.484000,  0.407986658,  0.835994034,  1.479898310,  1.282200122,  1.843033092,  
0.485000,  0.407373224,  0.835648757,  1.480279905,  1.283920633,  1.843602588,  
0.486000,  0.406760483,  0.835303450,  1.480660805,  1.285640952,  1.844172591,  
0.487000,  0.406148433,  0.834958111,  1.481041014,  1.287361087,  1.844743110,  
0.488000,  0.405537071,  0.834612741,  1.481420533,  1.289081042,  1.845314144,  
0.489000,  0.404926396,  0.834267341,  1.481799363,  1.290800819,  1.845885689,  
0.490000,  0.404316406,  0.833921909,  1.482177507,  1.292520425,  1.846457750,  
0.491000,  0.403707100,  0.833576447,  1.482554967,  1.294239864,  1.847030327,  
0.492000,  0.403098474,  0.833230953,  1.482931745,  1.295959142,  1.847603423,  
0.493000,  0.402490528,  0.832885428,  1.483307841,  1.297678260,  1.848177034,  
0.494000,  0.401883259,  0.832539872,  1.483683259,  1.299397225,  1.848751164,  
0.495000,  0.401276666,  0.832194286,  1.484058000,  1.301116041,  1.849325814,  
0.496000,  0.400670747,  0.831848667,  1.484432066,  1.302834712,  1.849900982,  
0.497000,  0.400065499,  0.831503018,  1.484805458,  1.304553244,  1.850476673,  
0.498000,  0.399460922,  0.831157337,  1.485178179,  1.306271639,  1.851052883,  
0.499000,  0.398857014,  0.830811625,  1.485550230,  1.307989902,  1.851629615,  
0.500000,  0.398253772,  0.830465882,  1.485921614,  1.309708040,  1.852206872,  
0.501000,  0.397651194,  0.830120107,  1.486292331,  1.311426055,  1.852784654,  
0.502000,  0.397049280,  0.829774301,  1.486662383,  1.313143950,  1.853362957,  
0.503000,  0.396448027,  0.829428463,  1.487031773,  1.314861732,  1.853941787,  
0.504000,  0.395847434,  0.829082594,  1.487400502,  1.316579405,  1.854521143,  
0.505000,  0.395247498,  0.828736694,  1.487768572,  1.318296972,  1.855101025,  
0.506000,  0.394648219,  0.828390761,  1.488135984,  1.320014438,  1.855681436,  
0.507000,  0.394049593,  0.828044798,  1.488502741,  1.321731808,  1.856262374,  
0.508000,  0.393451620,  0.827698803,  1.488868844,  1.323449086,  1.856843844,  
0.509000,  0.392854298,  0.827352776,  1.489234294,  1.325166275,  1.857425842,  
0.510000,  0.392257626,  0.827006717,  1.489599094,  1.326883380,  1.858008371,  
0.511000,  0.391661600,  0.826660627,  1.489963245,  1.328600407,  1.858591433,  
0.512000,  0.391066221,  0.826314505,  1.490326749,  1.330317357,  1.859175026,  
0.513000,  0.390471485,  0.825968351,  1.490689607,  1.332034237,  1.859759153,  
0.514000,  0.389877392,  0.825622165,  1.491051822,  1.333751050,  1.860343816,  
0.515000,  0.389283940,  0.825275948,  1.491413394,  1.335467799,  1.860929010,  
0.516000,  0.388691126,  0.824929699,  1.491774326,  1.337184492,  1.861514744,  
0.517000,  0.388098950,  0.824583418,  1.492134618,  1.338901128,  1.862101011,  
0.518000,  0.387507410,  0.824237104,  1.492494274,  1.340617716,  1.862687818,  
0.519000,  0.386916504,  0.823890759,  1.492853294,  1.342334257,  1.863275163,  
0.520000,  0.386326230,  0.823544382,  1.493211680,  1.344050757,  1.863863046,  
0.521000,  0.385736588,  0.823197973,  1.493569433,  1.345767218,  1.864451469,  
0.522000,  0.385147574,  0.822851532,  1.493926556,  1.347483646,  1.865040433,  
0.523000,  0.384559188,  0.822505058,  1.494283050,  1.349200046,  1.865629941,  
0.524000,  0.383971428,  0.822158553,  1.494638916,  1.350916419,  1.866219988,  
0.525000,  0.383384293,  0.821812015,  1.494994156,  1.352632771,  1.866810580,  
0.526000,  0.382797781,  0.821465445,  1.495348771,  1.354349105,  1.867401714,  
0.527000,  0.382211890,  0.821118843,  1.495702764,  1.356065427,  1.867993394,  
0.528000,  0.381626618,  0.820772208,  1.496056136,  1.357781741,  1.868585622,  
0.529000,  0.381041965,  0.820425541,  1.496408887,  1.359498048,  1.869178394,  
0.530000,  0.380457929,  0.820078842,  1.496761021,  1.361214355,  1.869771715,  
0.531000,  0.379874507,  0.819732111,  1.497112537,  1.362930664,  1.870365582,  
0.532000,  0.379291699,  0.819385347,  1.497463439,  1.364646981,  1.870960000,  
0.533000,  0.378709503,  0.819038550,  1.497813727,  1.366363309,  1.871554968,  
0.534000,  0.378127918,  0.818691721,  1.498163403,  1.368079652,  1.872150486,  
0.535000,  0.377546942,  0.818344860,  1.498512468,  1.369796013,  1.872746555,  
0.536000,  0.376966572,  0.817997966,  1.498860924,  1.371512398,  1.873343178,  
0.537000,  0.376386809,  0.817651039,  1.499208773,  1.373228811,  1.873940355,  
0.538000,  0.375807651,  0.817304080,  1.499556015,  1.374945252,  1.874538082,  
0.539000,  0.375229095,  0.816957088,  1.499902653,  1.376661730,  1.875136367,  
0.540000,  0.374651141,  0.816610063,  1.500248688,  1.378378247,  1.875735210,  
0.541000,  0.374073787,  0.816263005,  1.500594121,  1.380094806,  1.876334607,  
0.542000,  0.373497031,  0.815915915,  1.500938954,  1.381811412,  1.876934563,  
0.543000,  0.372920872,  0.815568792,  1.501283188,  1.383528069,  1.877535078,  
0.544000,  0.372345310,  0.815221636,  1.501626825,  1.385244780,  1.878136151,  
0.545000,  0.371770341,  0.814874448,  1.501969866,  1.386961548,  1.878737784,  
0.546000,  0.371195964,  0.814527226,  1.502312312,  1.388678380,  1.879339980,  
0.547000,  0.370622180,  0.814179971,  1.502654166,  1.390395277,  1.879942736,  
0.548000,  0.370048984,  0.813832683,  1.502995427,  1.392112243,  1.880546054,  
0.549000,  0.369476378,  0.813485362,  1.503336099,  1.393829285,  1.881149939,  
0.550000,  0.368904358,  0.813138009,  1.503676182,  1.395546404,  1.881754387,  
0.551000,  0.368332924,  0.812790622,  1.504015678,  1.397263605,  1.882359402,  
0.552000,  0.367762074,  0.812443202,  1.504354588,  1.398980891,  1.882964983,  
0.553000,  0.367191807,  0.812095748,  1.504692913,  1.400698265,  1.883571129,  
0.554000,  0.366622122,  0.811748262,  1.505030655,  1.402415733,  1.884177845,  
0.555000,  0.366053016,  0.811400742,  1.505367815,  1.404133297,  1.884785129,  
0.556000,  0.365484489,  0.811053189,  1.505704394,  1.405850961,  1.885392982,  
0.557000,  0.364916539,  0.810705603,  1.506040395,  1.407568730,  1.886001408,  
0.558000,  0.364349165,  0.810357983,  1.506375818,  1.409286608,  1.886610406,  
0.559000,  0.363782365,  0.810010330,  1.506710664,  1.411004597,  1.887219975,  
0.560000,  0.363216139,  0.809662643,  1.507044936,  1.412722702,  1.887830119,  
0.561000,  0.362650484,  0.809314923,  1.507378634,  1.414440927,  1.888440838,  
0.562000,  0.362085400,  0.808967170,  1.507711760,  1.416159274,  1.889052131,  
0.563000,  0.361520885,  0.808619382,  1.508044314,  1.417877748,  1.889664000,  
0.564000,  0.360956938,  0.808271562,  1.508376299,  1.419596353,  1.890276447,  
0.565000,  0.360393557,  0.807923707,  1.508707716,  1.421315093,  1.890889472,  
0.566000,  0.359830741,  0.807575820,  1.509038565,  1.423033969,  1.891503075,  
0.567000,  0.359268489,  0.807227898,  1.509368849,  1.424752989,  1.892117260,  
0.568000,  0.358706800,  0.806879942,  1.509698568,  1.426472152,  1.892732023,  
0.569000,  0.358145672,  0.806531953,  1.510027724,  1.428191465,  1.893347368,  
0.570000,  0.357585104,  0.806183930,  1.510356319,  1.429910934,  1.893963300,  
0.571000,  0.357025094,  0.805835873,  1.510684352,  1.431630555,  1.894579810,  
0.572000,  0.356465641,  0.805487782,  1.511011827,  1.433350339,  1.895196908,  
0.573000,  0.355906745,  0.805139658,  1.511338743,  1.435070285,  1.895814588,  
0.574000,  0.355348403,  0.804791499,  1.511665103,  1.436790400,  1.896432858,  
0.575000,  0.354790615,  0.804443306,  1.511990907,  1.438510686,  1.897051714,  
0.576000,  0.354233379,  0.804095080,  1.512316157,  1.440231146,  1.897671157,  
0.577000,  0.353676694,  0.803746819,  1.512640854,  1.441951785,  1.898291191,  
0.578000,  0.353120559,  0.803398524,  1.512965000,  1.443672606,  1.898911814,  
0.579000,  0.352564972,  0.803050195,  1.513288595,  1.445393613,  1.899533029,  
0.580000,  0.352009932,  0.802701832,  1.513611640,  1.447114809,  1.900154835,  
0.581000,  0.351455438,  0.802353434,  1.513934138,  1.448836199,  1.900777235,  
0.582000,  0.350901489,  0.802005002,  1.514256088,  1.450557784,  1.901400228,  
0.583000,  0.350348084,  0.801656536,  1.514577493,  1.452279570,  1.902023816,  
0.584000,  0.349795220,  0.801308036,  1.514898354,  1.454001560,  1.902648000,  
0.585000,  0.349242898,  0.800959501,  1.515218672,  1.455723757,  1.903272781,  
0.586000,  0.348691115,  0.800610932,  1.515538447,  1.457446165,  1.903898158,  
0.587000,  0.348139871,  0.800262328,  1.515857682,  1.459168787,  1.904524135,  
0.588000,  0.347589165,  0.799913690,  1.516176377,  1.460891627,  1.905150710,  
0.589000,  0.347038994,  0.799565017,  1.516494534,  1.462614690,  1.905777888,  
0.590000,  0.346489359,  0.799216310,  1.516812154,  1.464337977,  1.906405666,  
0.591000,  0.345940258,  0.798867568,  1.517129238,  1.466061493,  1.907034046,  
0.592000,  0.345391689,  0.798518792,  1.517445786,  1.467785241,  1.907663029,  
0.593000,  0.344843652,  0.798169980,  1.517761802,  1.469509226,  1.908292618,  
0.594000,  0.344296144,  0.797821134,  1.518077284,  1.471233450,  1.908922813,  
0.595000,  0.343749166,  0.797472254,  1.518392235,  1.472957917,  1.909553613,  
0.596000,  0.343202716,  0.797123338,  1.518706657,  1.474682631,  1.910185021,  
0.597000,  0.342656793,  0.796774388,  1.519020549,  1.476407593,  1.910817035,  
0.598000,  0.342111395,  0.796425402,  1.519333913,  1.478132811,  1.911449662,  
0.599000,  0.341566522,  0.796076382,  1.519646750,  1.479858283,  1.912082895,  
0.600000,  0.341022172,  0.795727326,  1.519959062,  1.481584018,  1.912716742,  
0.601000,  0.340478344,  0.795378236,  1.520270849,  1.483310017,  1.913351202,  
0.602000,  0.339935037,  0.795029111,  1.520582112,  1.485036282,  1.913986273,  
0.603000,  0.339392251,  0.794679951,  1.520892854,  1.486762818,  1.914621958,  
0.604000,  0.338849983,  0.794330755,  1.521203074,  1.488489629,  1.915258259,  
0.605000,  0.338308232,  0.793981524,  1.521512775,  1.490216720,  1.915895177,  
0.606000,  0.337766998,  0.793632258,  1.521821956,  1.491944091,  1.916532713,  
0.607000,  0.337226280,  0.793282957,  1.522130620,  1.493671746,  1.917170865,  
0.608000,  0.336686076,  0.792933621,  1.522438767,  1.495399691,  1.917809639,  
0.609000,  0.336146385,  0.792584249,  1.522746398,  1.497127926,  1.918449029,  
0.610000,  0.335607206,  0.792234842,  1.523053515,  1.498856459,  1.919089045,  
0.611000,  0.335068538,  0.791885399,  1.523360118,  1.500585288,  1.919729679,  
0.612000,  0.334530380,  0.791535921,  1.523666209,  1.502314421,  1.920370938,  
0.613000,  0.333992731,  0.791186407,  1.523971788,  1.504043859,  1.921012821,  
0.614000,  0.333455589,  0.790836858,  1.524276857,  1.505773606,  1.921655330,  
0.615000,  0.332918954,  0.790487274,  1.524581417,  1.507503665,  1.922298464,  
0.616000,  0.332382825,  0.790137654,  1.524885469,  1.509234041,  1.922942225,  
0.617000,  0.331847200,  0.789787997,  1.525189014,  1.510964737,  1.923586617,  
0.618000,  0.331312079,  0.789438306,  1.525492053,  1.512695755,  1.924231636,  
0.619000,  0.330777460,  0.789088578,  1.525794587,  1.514427099,  1.924877286,  
0.620000,  0.330243342,  0.788738815,  1.526096617,  1.516158772,  1.925523566,  
0.621000,  0.329709725,  0.788389016,  1.526398145,  1.517890781,  1.926170482,  
0.622000,  0.329176607,  0.788039182,  1.526699170,  1.519623124,  1.926818029,  
0.623000,  0.328643987,  0.787689311,  1.526999695,  1.521355809,  1.927466212,  
0.624000,  0.328111864,  0.787339404,  1.527299720,  1.523088836,  1.928115030,  
0.625000,  0.327580237,  0.786989461,  1.527599246,  1.524822209,  1.928764483,  
0.626000,  0.327049105,  0.786639483,  1.527898274,  1.526555933,  1.929414575,  
0.627000,  0.326518467,  0.786289468,  1.528196806,  1.528290010,  1.930065305,  
0.628000,  0.325988322,  0.785939417,  1.528494842,  1.530024445,  1.930716676,  
0.629000,  0.325458669,  0.785589330,  1.528792383,  1.531759239,  1.931368686,  
0.630000,  0.324929507,  0.785239206,  1.529089431,  1.533494398,  1.932021340,  
0.631000,  0.324400834,  0.784889047,  1.529385986,  1.535229924,  1.932674637,  
0.632000,  0.323872651,  0.784538851,  1.529682049,  1.536965819,  1.933328575,  
0.633000,  0.323344956,  0.784188619,  1.529977622,  1.538702089,  1.933983161,  
0.634000,  0.322817747,  0.783838350,  1.530272705,  1.540438736,  1.934638392,  
0.635000,  0.322291024,  0.783488046,  1.530567299,  1.542175763,  1.935294269,  
0.636000,  0.321764787,  0.783137704,  1.530861405,  1.543913173,  1.935950795,  
0.637000,  0.321239033,  0.782787326,  1.531155025,  1.545650972,  1.936607972,  
0.638000,  0.320713762,  0.782436912,  1.531448159,  1.547389161,  1.937265798,  
0.639000,  0.320188972,  0.782086461,  1.531740808,  1.549127745,  1.937924276,  
0.640000,  0.319664664,  0.781735974,  1.532032973,  1.550866725,  1.938583406,  
0.641000,  0.319140836,  0.781385449,  1.532324656,  1.552606106,  1.939243190,  
0.642000,  0.318617487,  0.781034888,  1.532615856,  1.554345890,  1.939903627,  
0.643000,  0.318094615,  0.780684291,  1.532906576,  1.556086084,  1.940564724,  
0.644000,  0.317572221,  0.780333656,  1.533196815,  1.557826686,  1.941226474,  
0.645000,  0.317050303,  0.779982985,  1.533486576,  1.559567704,  1.941888883,  
0.646000,  0.316528860,  0.779632277,  1.533775858,  1.561309138,  1.942551952,  
0.647000,  0.316007891,  0.779281532,  1.534064663,  1.563050993,  1.943215681,  
0.648000,  0.315487395,  0.778930750,  1.534352992,  1.564793273,  1.943880072,  
0.649000,  0.314967372,  0.778579930,  1.534640845,  1.566535978,  1.944545122,  
0.650000,  0.314447819,  0.778229074,  1.534928224,  1.568279117,  1.945210840,  
0.651000,  0.313928738,  0.777878181,  1.535215130,  1.570022687,  1.945877220,  
0.652000,  0.313410125,  0.777527251,  1.535501563,  1.571766696,  1.946544266,  
0.653000,  0.312891981,  0.777176283,  1.535787524,  1.573511145,  1.947211979,  
0.654000,  0.312374305,  0.776825278,  1.536073015,  1.575256038,  1.947880360,  
0.655000,  0.311857095,  0.776474236,  1.536358036,  1.577001379,  1.948549412,  
0.656000,  0.311340351,  0.776123157,  1.536642588,  1.578747170,  1.949219132,  
0.657000,  0.310824071,  0.775772040,  1.536926672,  1.580493416,  1.949889525,  
0.658000,  0.310308256,  0.775420886,  1.537210289,  1.582240117,  1.950560588,  
0.659000,  0.309792903,  0.775069694,  1.537493440,  1.583987280,  1.951232327,  
0.660000,  0.309278012,  0.774718465,  1.537776125,  1.585734905,  1.951904738,  
0.661000,  0.308763583,  0.774367199,  1.538058346,  1.587482999,  1.952577827,  
0.662000,  0.308249614,  0.774015894,  1.538340104,  1.589231564,  1.953251594,  
0.663000,  0.307736104,  0.773664552,  1.538621398,  1.590980600,  1.953926036,  
0.664000,  0.307223052,  0.773313173,  1.538902231,  1.592730115,  1.954601160,  
0.665000,  0.306710458,  0.772961756,  1.539182604,  1.594480111,  1.955276964,  
0.666000,  0.306198320,  0.772610301,  1.539462516,  1.596230590,  1.955953451,  
0.667000,  0.305686639,  0.772258808,  1.539741969,  1.597981554,  1.956630617,  
0.668000,  0.305175412,  0.771907277,  1.540020964,  1.599733010,  1.957308468,  
0.669000,  0.304664638,  0.771555709,  1.540299501,  1.601484958,  1.957987005,  
0.670000,  0.304154318,  0.771204102,  1.540577582,  1.603237405,  1.958666229,  
0.671000,  0.303644451,  0.770852458,  1.540855207,  1.604990350,  1.959346139,  
0.672000,  0.303135034,  0.770500775,  1.541132377,  1.606743799,  1.960026739,  
0.673000,  0.302626068,  0.770149055,  1.541409094,  1.608497756,  1.960708029,  
0.674000,  0.302117551,  0.769797296,  1.541685357,  1.610252222,  1.961390009,  
0.675000,  0.301609484,  0.769445499,  1.541961168,  1.612007199,  1.962072679,  
0.676000,  0.301101864,  0.769093664,  1.542236527,  1.613762695,  1.962756046,  
0.677000,  0.300594690,  0.768741791,  1.542511436,  1.615518710,  1.963440106,  
0.678000,  0.300087964,  0.768389879,  1.542785895,  1.617275248,  1.964124861,  
0.679000,  0.299581682,  0.768037929,  1.543059905,  1.619032311,  1.964810312,  
0.680000,  0.299075844,  0.767685941,  1.543333467,  1.620789905,  1.965496463,  
0.681000,  0.298570451,  0.767333914,  1.543606582,  1.622548031,  1.966183313,  
0.682000,  0.298065500,  0.766981848,  1.543879251,  1.624306694,  1.966870863,  
0.683000,  0.297560990,  0.766629745,  1.544151473,  1.626065897,  1.967559116,  
0.684000,  0.297056922,  0.766277602,  1.544423251,  1.627825641,  1.968248070,  
0.685000,  0.296553294,  0.765925421,  1.544694585,  1.629585932,  1.968937729,  
0.686000,  0.296050106,  0.765573201,  1.544965475,  1.631346770,  1.969628091,  
0.687000,  0.295547356,  0.765220943,  1.545235923,  1.633108161,  1.970319160,  
0.688000,  0.295045043,  0.764868646,  1.545505930,  1.634870110,  1.971010939,  
0.689000,  0.294543168,  0.764516310,  1.545775496,  1.636632616,  1.971703425,  
0.690000,  0.294041728,  0.764163935,  1.546044622,  1.638395686,  1.972396623,  
0.691000,  0.293540724,  0.763811521,  1.546313309,  1.640159320,  1.973090531,  
0.692000,  0.293040154,  0.763459068,  1.546581557,  1.641923524,  1.973785153,  
0.693000,  0.292540018,  0.763106576,  1.546849368,  1.643688299,  1.974480487,  
0.694000,  0.292040314,  0.762754045,  1.547116742,  1.645453650,  1.975176537,  
0.695000,  0.291541043,  0.762401475,  1.547383680,  1.647219579,  1.975873304,  
0.696000,  0.291042202,  0.762048866,  1.547650182,  1.648986089,  1.976570785,  
0.697000,  0.290543792,  0.761696218,  1.547916250,  1.650753185,  1.977268988,  
0.698000,  0.290045812,  0.761343530,  1.548181885,  1.652520870,  1.977967911,  
0.699000,  0.289548260,  0.760990804,  1.548447086,  1.654289145,  1.978667553,  
0.700000,  0.289051136,  0.760638038,  1.548711856,  1.656058017,  1.979367920,  
0.701000,  0.288554440,  0.760285232,  1.548976194,  1.657827485,  1.980069010,  
0.702000,  0.288058169,  0.759932387,  1.549240101,  1.659597556,  1.980770825,  
0.703000,  0.287562325,  0.759579502,  1.549503579,  1.661368230,  1.981473364,  
0.704000,  0.287066905,  0.759226578,  1.549766627,  1.663139513,  1.982176633,  
0.705000,  0.286571909,  0.758873615,  1.550029248,  1.664911408,  1.982880631,  
0.706000,  0.286077336,  0.758520612,  1.550291440,  1.666683916,  1.983585358,  
0.707000,  0.285583186,  0.758167569,  1.550553206,  1.668457043,  1.984290818,  
0.708000,  0.285089458,  0.757814486,  1.550814546,  1.670230790,  1.984997009,  
0.709000,  0.284596150,  0.757461364,  1.551075460,  1.672005161,  1.985703933,  
0.710000,  0.284103263,  0.757108202,  1.551335950,  1.673780160,  1.986411594,  
0.711000,  0.283610794,  0.756755000,  1.551596016,  1.675555791,  1.987119992,  
0.712000,  0.283118745,  0.756401758,  1.551855659,  1.677332054,  1.987829126,  
0.713000,  0.282627113,  0.756048476,  1.552114879,  1.679108955,  1.988539000,  
0.714000,  0.282135899,  0.755695154,  1.552373678,  1.680886496,  1.989249613,  
0.715000,  0.281645100,  0.755341792,  1.552632056,  1.682664682,  1.989960970,  
0.716000,  0.281154718,  0.754988389,  1.552890014,  1.684443514,  1.990673067,  
0.717000,  0.280664750,  0.754634947,  1.553147553,  1.686222998,  1.991385912,  
0.718000,  0.280175196,  0.754281465,  1.553404672,  1.688003134,  1.992099500,  
0.719000,  0.279686055,  0.753927942,  1.553661374,  1.689783928,  1.992813836,  
0.720000,  0.279197327,  0.753574379,  1.553917658,  1.691565381,  1.993528920,  
0.721000,  0.278709011,  0.753220775,  1.554173526,  1.693347498,  1.994244753,  
0.722000,  0.278221105,  0.752867131,  1.554428978,  1.695130283,  1.994961338,  
0.723000,  0.277733611,  0.752513447,  1.554684015,  1.696913735,  1.995678674,  
0.724000,  0.277246525,  0.752159722,  1.554938637,  1.698697862,  1.996396763,  
0.725000,  0.276759849,  0.751805957,  1.555192846,  1.700482665,  1.997115609,  
0.726000,  0.276273580,  0.751452150,  1.555446642,  1.702268150,  1.997835211,  
0.727000,  0.275787719,  0.751098304,  1.555700025,  1.704054316,  1.998555569,  
0.728000,  0.275302265,  0.750744416,  1.555952997,  1.705841168,  1.999276686,  
0.729000,  0.274817216,  0.750390488,  1.556205558,  1.707628711,  1.999998564,  
0.730000,  0.274332573,  0.750036519,  1.556457708,  1.709416945,  2.000721203,  
0.731000,  0.273848334,  0.749682509,  1.556709449,  1.711205875,  2.001444604,  
0.732000,  0.273364500,  0.749328458,  1.556960782,  1.712995507,  2.002168772,  
0.733000,  0.272881068,  0.748974366,  1.557211706,  1.714785840,  2.002893703,  
0.734000,  0.272398038,  0.748620234,  1.557462223,  1.716576880,  2.003619404,  
0.735000,  0.271915410,  0.748266060,  1.557712332,  1.718368627,  2.004345870,  
0.736000,  0.271433183,  0.747911845,  1.557962036,  1.720161089,  2.005073107,  
0.737000,  0.270951356,  0.747557588,  1.558211334,  1.721954265,  2.005801116,  
0.738000,  0.270469928,  0.747203291,  1.558460228,  1.723748163,  2.006529899,  
0.739000,  0.269988899,  0.746848952,  1.558708717,  1.725542781,  2.007259454,  
0.740000,  0.269508269,  0.746494572,  1.558956803,  1.727338124,  2.007989782,  
0.741000,  0.269028035,  0.746140151,  1.559204486,  1.729134197,  2.008720889,  
0.742000,  0.268548199,  0.745785688,  1.559451767,  1.730931001,  2.009452772,  
0.743000,  0.268068758,  0.745431184,  1.559698647,  1.732728543,  2.010185438,  
0.744000,  0.267589712,  0.745076638,  1.559945126,  1.734526824,  2.010918885,  
0.745000,  0.267111062,  0.744722050,  1.560191205,  1.736325846,  2.011653113,  
0.746000,  0.266632804,  0.744367421,  1.560436884,  1.738125613,  2.012388123,  
0.747000,  0.266154941,  0.744012750,  1.560682165,  1.739926128,  2.013123919,  
0.748000,  0.265677469,  0.743658038,  1.560927048,  1.741727398,  2.013860504,  
0.749000,  0.265200390,  0.743303283,  1.561171533,  1.743529421,  2.014597874,  
0.750000,  0.264723702,  0.742948487,  1.561415621,  1.745332204,  2.015336037,  
0.751000,  0.264247404,  0.742593649,  1.561659313,  1.747135747,  2.016074985,  
0.752000,  0.263771495,  0.742238769,  1.561902610,  1.748940058,  2.016814731,  
0.753000,  0.263295976,  0.741883846,  1.562145511,  1.750745135,  2.017555267,  
0.754000,  0.262820846,  0.741528882,  1.562388019,  1.752550985,  2.018296599,  
0.755000,  0.262346103,  0.741173876,  1.562630132,  1.754357609,  2.019038726,  
0.756000,  0.261871747,  0.740818827,  1.562871853,  1.756165013,  2.019781653,  
0.757000,  0.261397778,  0.740463737,  1.563113181,  1.757973198,  2.020525379,  
0.758000,  0.260924194,  0.740108604,  1.563354118,  1.759782169,  2.021269906,  
0.759000,  0.260450995,  0.739753428,  1.563594663,  1.761591928,  2.022015236,  
0.760000,  0.259978181,  0.739398211,  1.563834818,  1.763402478,  2.022761368,  
0.761000,  0.259505750,  0.739042950,  1.564074584,  1.765213826,  2.023508309,  
0.762000,  0.259033703,  0.738687648,  1.564313960,  1.767025969,  2.024256053,  
0.763000,  0.258562038,  0.738332302,  1.564552947,  1.768838915,  2.025004606,  
0.764000,  0.258090755,  0.737976914,  1.564791546,  1.770652666,  2.025753969,  
0.765000,  0.257619853,  0.737621484,  1.565029758,  1.772467225,  2.026504142,  
0.766000,  0.257149331,  0.737266011,  1.565267584,  1.774282598,  2.027255131,  
0.767000,  0.256679189,  0.736910495,  1.565505023,  1.776098784,  2.028006931,  
0.768000,  0.256209426,  0.736554936,  1.565742077,  1.777915790,  2.028759549,  
0.769000,  0.255740042,  0.736199334,  1.565978746,  1.779733617,  2.029512983,  
0.770000,  0.255271035,  0.735843690,  1.566215030,  1.781552269,  2.030267235,  
0.771000,  0.254802406,  0.735488002,  1.566450931,  1.783371750,  2.031022309,  
0.772000,  0.254334153,  0.735132271,  1.566686448,  1.785192062,  2.031778203,  
0.773000,  0.253866276,  0.734776497,  1.566921583,  1.787013208,  2.032534918,  
0.774000,  0.253398775,  0.734420680,  1.567156337,  1.788835197,  2.033292464,  
0.775000,  0.252931648,  0.734064820,  1.567390709,  1.790658025,  2.034050833,  
0.776000,  0.252464895,  0.733708917,  1.567624700,  1.792481698,  2.034810029,  
0.777000,  0.251998516,  0.733352970,  1.567858311,  1.794306219,  2.035570053,  
0.778000,  0.251532509,  0.732996980,  1.568091542,  1.796131593,  2.036330909,  
0.779000,  0.251066874,  0.732640946,  1.568324395,  1.797957823,  2.037092599,  
0.780000,  0.250601611,  0.732284869,  1.568556869,  1.799784912,  2.037855122,  
0.781000,  0.250136718,  0.731928748,  1.568788966,  1.801612863,  2.038618481,  
0.782000,  0.249672196,  0.731572584,  1.569020685,  1.803441678,  2.039382675,  
0.783000,  0.249208043,  0.731216376,  1.569252028,  1.805271364,  2.040147710,  
0.784000,  0.248744260,  0.730860125,  1.569482995,  1.807101921,  2.040913584,  
0.785000,  0.248280844,  0.730503829,  1.569713586,  1.808933354,  2.041680300,  
0.786000,  0.247817796,  0.730147490,  1.569943802,  1.810765666,  2.042447858,  
0.787000,  0.247355116,  0.729791107,  1.570173644,  1.812598860,  2.043216262,  
0.788000,  0.246892802,  0.729434680,  1.570403113,  1.814432941,  2.043985512,  
0.789000,  0.246430854,  0.729078208,  1.570632208,  1.816267910,  2.044755609,  
0.790000,  0.245969270,  0.728721693,  1.570860931,  1.818103775,  2.045526560,  
0.791000,  0.245508052,  0.728365134,  1.571089281,  1.819940531,  2.046298356,  
0.792000,  0.245047198,  0.728008531,  1.571317260,  1.821778188,  2.047071006,  
0.793000,  0.244586706,  0.727651883,  1.571544869,  1.823616750,  2.047844513,  
0.794000,  0.244126578,  0.727295191,  1.571772107,  1.825456219,  2.048618877,  
0.795000,  0.243666812,  0.726938454,  1.571998975,  1.827296596,  2.049394096,  
0.796000,  0.243207408,  0.726581674,  1.572225474,  1.829137885,  2.050170174,  
0.797000,  0.242748364,  0.726224848,  1.572451604,  1.830980092,  2.050947114,  
0.798000,  0.242289681,  0.725867979,  1.572677366,  1.832823219,  2.051724915,  
0.799000,  0.241831358,  0.725511064,  1.572902761,  1.834667269,  2.052503581,  
0.800000,  0.241373393,  0.725154105,  1.573127789,  1.836512248,  2.053283114,  
0.801000,  0.240915788,  0.724797102,  1.573352450,  1.838358154,  2.054063511,  
0.802000,  0.240458540,  0.724440053,  1.573576745,  1.840204996,  2.054844779,  
0.803000,  0.240001650,  0.724082960,  1.573800675,  1.842052774,  2.055626917,  
0.804000,  0.239545116,  0.723725822,  1.574024240,  1.843901494,  2.056409928,  
0.805000,  0.239088939,  0.723368639,  1.574247441,  1.845751157,  2.057193811,  
0.806000,  0.238633117,  0.723011411,  1.574470278,  1.847601769,  2.057978572,  
0.807000,  0.238177650,  0.722654137,  1.574692752,  1.849453332,  2.058764209,  
0.808000,  0.237722538,  0.722296819,  1.574914864,  1.851305850,  2.059550726,  
0.809000,  0.237267779,  0.721939456,  1.575136613,  1.853159324,  2.060338122,  
0.810000,  0.236813374,  0.721582047,  1.575358001,  1.855013763,  2.061126403,  
0.811000,  0.236359321,  0.721224593,  1.575579027,  1.856869163,  2.061915564,  
0.812000,  0.235905620,  0.720867093,  1.575799693,  1.858725534,  2.062705613,  
0.813000,  0.235452271,  0.720509549,  1.576020000,  1.860582877,  2.063496549,  
0.814000,  0.234999272,  0.720151958,  1.576239946,  1.862441195,  2.064288374,  
0.815000,  0.234546624,  0.719794323,  1.576459534,  1.864300492,  2.065081090,  
0.816000,  0.234094326,  0.719436641,  1.576678763,  1.866160770,  2.065874696,  
0.817000,  0.233642377,  0.719078914,  1.576897635,  1.868022036,  2.066669199,  
0.818000,  0.233190776,  0.718721141,  1.577116149,  1.869884293,  2.067464598,  
0.819000,  0.232739524,  0.718363323,  1.577334306,  1.871747539,  2.068260891,  
0.820000,  0.232288618,  0.718005458,  1.577552107,  1.873611785,  2.069058087,  
0.821000,  0.231838060,  0.717647548,  1.577769552,  1.875477030,  2.069856183,  
0.822000,  0.231387848,  0.717289592,  1.577986641,  1.877343277,  2.070655179,  
0.823000,  0.230937981,  0.716931590,  1.578203376,  1.879210534,  2.071455083,  
0.824000,  0.230488460,  0.716573541,  1.578419757,  1.881078800,  2.072255892,  
0.825000,  0.230039283,  0.716215447,  1.578635783,  1.882948080,  2.073057608,  
0.826000,  0.229590450,  0.715857306,  1.578851457,  1.884818378,  2.073860234,  
0.827000,  0.229141961,  0.715499119,  1.579066778,  1.886689699,  2.074663773,  
0.828000,  0.228693815,  0.715140885,  1.579281746,  1.888562042,  2.075468223,  
0.829000,  0.228246010,  0.714782606,  1.579496363,  1.890435417,  2.076273590,  
0.830000,  0.227798548,  0.714424280,  1.579710629,  1.892309822,  2.077079873,  
0.831000,  0.227351427,  0.714065907,  1.579924543,  1.894185261,  2.077887072,  
0.832000,  0.226904646,  0.713707487,  1.580138108,  1.896061743,  2.078695197,  
0.833000,  0.226458205,  0.713349021,  1.580351323,  1.897939266,  2.079504240,  
0.834000,  0.226012104,  0.712990509,  1.580564188,  1.899817834,  2.080314206,  
0.835000,  0.225566342,  0.712631949,  1.580776705,  1.901697454,  2.081125100,  
0.836000,  0.225120918,  0.712273343,  1.580988874,  1.903578128,  2.081936923,  
0.837000,  0.224675832,  0.711914690,  1.581200694,  1.905459856,  2.082749671,  
0.838000,  0.224231083,  0.711555989,  1.581412168,  1.907342648,  2.083563354,  
0.839000,  0.223786670,  0.711197242,  1.581623294,  1.909226504,  2.084377969,  
0.840000,  0.223342594,  0.710838448,  1.581834074,  1.911111427,  2.085193518,  
0.841000,  0.222898854,  0.710479606,  1.582044509,  1.912997422,  2.086010004,  
0.842000,  0.222455448,  0.710120717,  1.582254598,  1.914884493,  2.086827429,  
0.843000,  0.222012378,  0.709761781,  1.582464342,  1.916772641,  2.087645793,  
0.844000,  0.221569640,  0.709402798,  1.582673742,  1.918661874,  2.088465100,  
0.845000,  0.221127237,  0.709043767,  1.582882798,  1.920552192,  2.089285351,  
0.846000,  0.220685166,  0.708684689,  1.583091511,  1.922443600,  2.090106549,  
0.847000,  0.220243428,  0.708325563,  1.583299880,  1.924336100,  2.090928692,  
0.848000,  0.219802021,  0.707966390,  1.583507908,  1.926229701,  2.091751788,  
0.849000,  0.219360945,  0.707607169,  1.583715593,  1.928124401,  2.092575835,  
0.850000,  0.218920200,  0.707247900,  1.583922936,  1.930020204,  2.093400832,  
0.851000,  0.218479785,  0.706888583,  1.584129939,  1.931917118,  2.094226789,  
0.852000,  0.218039700,  0.706529219,  1.584336600,  1.933815140,  2.095053698,  
0.853000,  0.217599944,  0.706169806,  1.584542922,  1.935714280,  2.095881568,  
0.854000,  0.217160516,  0.705810346,  1.584748904,  1.937614540,  2.096710401,  
0.855000,  0.216721416,  0.705450837,  1.584954547,  1.939515923,  2.097540195,  
0.856000,  0.216282644,  0.705091280,  1.585159851,  1.941418430,  2.098370952,  
0.857000,  0.215844198,  0.704731676,  1.585364817,  1.943322069,  2.099202678,  
0.858000,  0.215406079,  0.704372022,  1.585569445,  1.945226844,  2.100035374,  
0.859000,  0.214968286,  0.704012321,  1.585773736,  1.947132755,  2.100869039,  
0.860000,  0.214530818,  0.703652571,  1.585977690,  1.949039808,  2.101703676,  
0.861000,  0.214093674,  0.703292772,  1.586181307,  1.950948007,  2.102539289,  
0.862000,  0.213656855,  0.702932926,  1.586384589,  1.952857355,  2.103375877,  
0.863000,  0.213220360,  0.702573030,  1.586587535,  1.954767857,  2.104213445,  
0.864000,  0.212784187,  0.702213086,  1.586790145,  1.956679511,  2.105051989,  
0.865000,  0.212348337,  0.701853093,  1.586992422,  1.958592331,  2.105891520,  
0.866000,  0.211912809,  0.701493051,  1.587194364,  1.960506312,  2.106732033,  
0.867000,  0.211477603,  0.701132961,  1.587395972,  1.962421461,  2.107573532,  
0.868000,  0.211042718,  0.700772821,  1.587597247,  1.964337782,  2.108416020,  
0.869000,  0.210608153,  0.700412633,  1.587798189,  1.966255279,  2.109259498,  
0.870000,  0.210173908,  0.700052395,  1.587998799,  1.968173956,  2.110103969,  
0.871000,  0.209739982,  0.699692108,  1.588199077,  1.970093815,  2.110949433,  
0.872000,  0.209306376,  0.699331772,  1.588399023,  1.972014861,  2.111795893,  
0.873000,  0.208873087,  0.698971387,  1.588598639,  1.973937100,  2.112643354,  
0.874000,  0.208440117,  0.698610952,  1.588797923,  1.975860530,  2.113491811,  
0.875000,  0.208007464,  0.698250468,  1.588996878,  1.977785161,  2.114341274,  
0.876000,  0.207575128,  0.697889934,  1.589195503,  1.979710994,  2.115191740,  
0.877000,  0.207143107,  0.697529351,  1.589393798,  1.981638032,  2.116043211,  
0.878000,  0.206711403,  0.697168719,  1.589591765,  1.983566280,  2.116895691,  
0.879000,  0.206280014,  0.696808036,  1.589789403,  1.985495743,  2.117749182,  
0.880000,  0.205848939,  0.696447304,  1.589986713,  1.987426423,  2.118603685,  
0.881000,  0.205418179,  0.696086522,  1.590183696,  1.989358325,  2.119459203,  
0.882000,  0.204987732,  0.695725690,  1.590380351,  1.991291452,  2.120315738,  
0.883000,  0.204557598,  0.695364808,  1.590576680,  1.993225809,  2.121173292,  
0.884000,  0.204127777,  0.695003876,  1.590772683,  1.995161400,  2.122031867,  
0.885000,  0.203698268,  0.694642894,  1.590968359,  1.997098226,  2.122891462,  
0.886000,  0.203269071,  0.694281861,  1.591163710,  1.999036294,  2.123752085,  
0.887000,  0.202840185,  0.693920779,  1.591358736,  2.000975607,  2.124613734,  
0.888000,  0.202411609,  0.693559646,  1.591553438,  2.002916169,  2.125476412,  
0.889000,  0.201983343,  0.693198462,  1.591747816,  2.004857986,  2.126340123,  
0.890000,  0.201555386,  0.692837229,  1.591941869,  2.006801056,  2.127204865,  
0.891000,  0.201127739,  0.692475944,  1.592135600,  2.008745390,  2.128070644,  
0.892000,  0.200700400,  0.692114609,  1.592329007,  2.010690987,  2.128937462,  
0.893000,  0.200273369,  0.691753224,  1.592522092,  2.012637853,  2.129805317,  
0.894000,  0.199846645,  0.691391787,  1.592714855,  2.014585993,  2.130674216,  
0.895000,  0.199420229,  0.691030300,  1.592907296,  2.016535407,  2.131544158,  
0.896000,  0.198994118,  0.690668762,  1.593099416,  2.018486104,  2.132415148,  
0.897000,  0.198568314,  0.690307172,  1.593291214,  2.020438083,  2.133287184,  
0.898000,  0.198142815,  0.689945532,  1.593482693,  2.022391352,  2.134160272,  
0.899000,  0.197717620,  0.689583841,  1.593673852,  2.024345916,  2.135034415,  
0.900000,  0.197292730,  0.689222098,  1.593864690,  2.026301773,  2.135909610,  
0.901000,  0.196868144,  0.688860304,  1.594055210,  2.028258933,  2.136785863,  
0.902000,  0.196443861,  0.688498459,  1.594245411,  2.030217397,  2.137663175,  
0.903000,  0.196019881,  0.688136563,  1.594435293,  2.032177169,  2.138541550,  
0.904000,  0.195596203,  0.687774615,  1.594624858,  2.034138255,  2.139420990,  
0.905000,  0.195172827,  0.687412615,  1.594814104,  2.036100657,  2.140301493,  
0.906000,  0.194749752,  0.687050564,  1.595003034,  2.038064381,  2.141183065,  
0.907000,  0.194326978,  0.686688461,  1.595191647,  2.040029430,  2.142065711,  
0.908000,  0.193904505,  0.686326306,  1.595379943,  2.041995806,  2.142949425,  
0.909000,  0.193482330,  0.685964099,  1.595567924,  2.043963519,  2.143834218,  
0.910000,  0.193060456,  0.685601841,  1.595755588,  2.045932565,  2.144720085,  
0.911000,  0.192638879,  0.685239530,  1.595942938,  2.047902956,  2.145607034,  
0.912000,  0.192217601,  0.684877167,  1.596129973,  2.049874692,  2.146495065,  
0.913000,  0.191796621,  0.684514752,  1.596316693,  2.051847776,  2.147384179,  
0.914000,  0.191375937,  0.684152285,  1.596503099,  2.053822216,  2.148274381,  
0.915000,  0.190955551,  0.683789766,  1.596689192,  2.055798012,  2.149165671,  
0.916000,  0.190535460,  0.683427194,  1.596874971,  2.057775172,  2.150058052,  
0.917000,  0.190115666,  0.683064569,  1.597060438,  2.059753697,  2.150951526,  
0.918000,  0.189696166,  0.682701893,  1.597245592,  2.061733592,  2.151846094,  
0.919000,  0.189276961,  0.682339163,  1.597430434,  2.063714864,  2.152741765,  
0.920000,  0.188858050,  0.681976381,  1.597614964,  2.065697513,  2.153638531,  
0.921000,  0.188439432,  0.681613546,  1.597799183,  2.067681546,  2.154536405,  
0.922000,  0.188021108,  0.681250658,  1.597983091,  2.069666966,  2.155435381,  
0.923000,  0.187603076,  0.680887718,  1.598166688,  2.071653777,  2.156335465,  
0.924000,  0.187185336,  0.680524724,  1.598349975,  2.073641985,  2.157236658,  
0.925000,  0.186767888,  0.680161677,  1.598532953,  2.075631593,  2.158138965,  
0.926000,  0.186350731,  0.679798577,  1.598715621,  2.077622605,  2.159042385,  
0.927000,  0.185933864,  0.679435424,  1.598897980,  2.079615025,  2.159946924,  
0.928000,  0.185517287,  0.679072217,  1.599080030,  2.081608859,  2.160852583,  
0.929000,  0.185101000,  0.678708957,  1.599261772,  2.083604109,  2.161759360,  
0.930000,  0.184685002,  0.678345644,  1.599443206,  2.085600781,  2.162667264,  
0.931000,  0.184269292,  0.677982277,  1.599624333,  2.087598879,  2.163576294,  
0.932000,  0.183853871,  0.677618856,  1.599805152,  2.089598405,  2.164486451,  
0.933000,  0.183438736,  0.677255382,  1.599985665,  2.091599367,  2.165397744,  
0.934000,  0.183023889,  0.676891854,  1.600165871,  2.093601768,  2.166310169,  
0.935000,  0.182609328,  0.676528272,  1.600345771,  2.095605612,  2.167223730,  
0.936000,  0.182195054,  0.676164636,  1.600525365,  2.097610900,  2.168138427,  
0.937000,  0.181781064,  0.675800946,  1.600704654,  2.099617644,  2.169054270,  
0.938000,  0.181367360,  0.675437202,  1.600883638,  2.101625841,  2.169971252,  
0.939000,  0.180953939,  0.675073404,  1.601062318,  2.103635502,  2.170889386,  
0.940000,  0.180540803,  0.674709551,  1.601240693,  2.105646626,  2.171808667,  
0.941000,  0.180127950,  0.674345644,  1.601418765,  2.107659220,  2.172729099,  
0.942000,  0.179715380,  0.673981683,  1.601596533,  2.109673287,  2.173650686,  
0.943000,  0.179303093,  0.673617668,  1.601773997,  2.111688830,  2.174573425,  
0.944000,  0.178891087,  0.673253597,  1.601951159,  2.113705858,  2.175497326,  
0.945000,  0.178479362,  0.672889472,  1.602128019,  2.115724373,  2.176422389,  
0.946000,  0.178067918,  0.672525292,  1.602304577,  2.117744379,  2.177348616,  
0.947000,  0.177656755,  0.672161058,  1.602480832,  2.119765882,  2.178276010,  
0.948000,  0.177245872,  0.671796768,  1.602656787,  2.121788885,  2.179204571,  
0.949000,  0.176835267,  0.671432424,  1.602832440,  2.123813392,  2.180134305,  
0.950000,  0.176424942,  0.671068024,  1.603007793,  2.125839408,  2.181065213,  
0.951000,  0.176014894,  0.670703569,  1.603182846,  2.127866941,  2.181997300,  
0.952000,  0.175605125,  0.670339059,  1.603357598,  2.129895989,  2.182930564,  
0.953000,  0.175195632,  0.669974494,  1.603532052,  2.131926563,  2.183865011,  
0.954000,  0.174786417,  0.669609873,  1.603706205,  2.133958661,  2.184800641,  
0.955000,  0.174377477,  0.669245197,  1.603880060,  2.135992293,  2.185737461,  
0.956000,  0.173968813,  0.668880465,  1.604053617,  2.138027464,  2.186675472,  
0.957000,  0.173560424,  0.668515678,  1.604226875,  2.140064172,  2.187614671,  
0.958000,  0.173152310,  0.668150834,  1.604399835,  2.142102429,  2.188555069,  
0.959000,  0.172744470,  0.667785935,  1.604572498,  2.144142235,  2.189496665,  
0.960000,  0.172336904,  0.667420980,  1.604744864,  2.146183597,  2.190439461,  
0.961000,  0.171929611,  0.667055969,  1.604916933,  2.148226518,  2.191383460,  
0.962000,  0.171522590,  0.666690902,  1.605088706,  2.150271004,  2.192328666,  
0.963000,  0.171115841,  0.666325779,  1.605260182,  2.152317059,  2.193275081,  
0.964000,  0.170709364,  0.665960600,  1.605431363,  2.154364687,  2.194222707,  
0.965000,  0.170303158,  0.665595364,  1.605602248,  2.156413894,  2.195171545,  
0.966000,  0.169897222,  0.665230072,  1.605772838,  2.158464684,  2.196121603,  
0.967000,  0.169491556,  0.664864723,  1.605943133,  2.160517061,  2.197072879,  
0.968000,  0.169086159,  0.664499317,  1.606113134,  2.162571033,  2.198025380,  
0.969000,  0.168681032,  0.664133856,  1.606282841,  2.164626600,  2.198979104,  
0.970000,  0.168276172,  0.663768337,  1.606452254,  2.166683769,  2.199934056,  
0.971000,  0.167871581,  0.663402761,  1.606621374,  2.168742546,  2.200890240,  
0.972000,  0.167467257,  0.663037129,  1.606790201,  2.170802934,  2.201847657,  
0.973000,  0.167063199,  0.662671439,  1.606958735,  2.172864939,  2.202806311,  
0.974000,  0.166659408,  0.662305692,  1.607126976,  2.174928563,  2.203766204,  
0.975000,  0.166255883,  0.661939888,  1.607294926,  2.176993815,  2.204727339,  
0.976000,  0.165852622,  0.661574027,  1.607462583,  2.179060697,  2.205689718,  
0.977000,  0.165449627,  0.661208109,  1.607629949,  2.181129213,  2.206653344,  
0.978000,  0.165046895,  0.660842133,  1.607797025,  2.183199373,  2.207618223,  
0.979000,  0.164644427,  0.660476099,  1.607963809,  2.185271176,  2.208584355,  
0.980000,  0.164242222,  0.660110008,  1.608130303,  2.187344630,  2.209551744,  
0.981000,  0.163840280,  0.659743859,  1.608296507,  2.189419738,  2.210520391,  
0.982000,  0.163438600,  0.659377652,  1.608462421,  2.191496506,  2.211490299,  
0.983000,  0.163037181,  0.659011388,  1.608628045,  2.193574939,  2.212461474,  
0.984000,  0.162636022,  0.658645065,  1.608793381,  2.195655042,  2.213433916,  
0.985000,  0.162235125,  0.658278684,  1.608958427,  2.197736820,  2.214407629,  
0.986000,  0.161834487,  0.657912245,  1.609123186,  2.199820279,  2.215382618,  
0.987000,  0.161434108,  0.657545748,  1.609287656,  2.201905422,  2.216358882,  
0.988000,  0.161033988,  0.657179193,  1.609451838,  2.203992254,  2.217336426,  
0.989000,  0.160634126,  0.656812579,  1.609615732,  2.206080780,  2.218315251,  
0.990000,  0.160234522,  0.656445906,  1.609779340,  2.208171008,  2.219295365,  
0.991000,  0.159835175,  0.656079175,  1.609942660,  2.210262938,  2.220276766,  
0.992000,  0.159436085,  0.655712385,  1.610105695,  2.212356580,  2.221259459,  
0.993000,  0.159037250,  0.655345536,  1.610268442,  2.214451936,  2.222243448,  
0.994000,  0.158638671,  0.654978629,  1.610430903,  2.216549010,  2.223228731,  
0.995000,  0.158240347,  0.654611662,  1.610593079,  2.218647811,  2.224215316,  
0.996000,  0.157842277,  0.654244637,  1.610754970,  2.220748343,  2.225203210,  
0.997000,  0.157444460,  0.653877552,  1.610916576,  2.222850611,  2.226192408,  
0.998000,  0.157046898,  0.653510408,  1.611077897,  2.224954618,  2.227182916,  
0.999000,  0.156649587,  0.653143204,  1.611238934,  2.227060371,  2.228174737,  
1.000000,  0.156253,  0.652776,  1.161140,  2,229160,  2.229160  
};

const int MPTABSIZE = 11090  ;
