SUBROUTINE TRANS_INQ4PY(KRETURNCODE, KSIZEJ, KTRUNC, KSLOEN, KLOEN, KNUMMAXRESOL, &
                      &KGPTOT, KSPEC, KNMENG)
! ** PURPOSE
!    Simplified wrapper to TRANS_INQ
!
! ** DUMMY ARGUMENTS
!    KSIZEJ: number of latitudes in grid-point space
!    KTRUNC: troncature
!    KSLOEN: Size of KLOEN
!    KLOEN: number of points on each latitude row
!    KNUMMAXRESOL: maximum number of troncatures handled
!    KGPTOT: number of gridpoints
!    KSPEC: number of spectral coefficients
!    KNMENG: cut-off zonal wavenumber
!
! ** AUTHOR
!    9 April 2014, S. Riette
!
! ** MODIFICATIONS
!    6 Jan., S. Riette: w_spec_setup interfaced modified
!
! I. Dummy arguments declaration
IMPLICIT NONE
INTEGER(KIND=8), INTENT(OUT) :: KRETURNCODE
INTEGER(KIND=8), INTENT(IN) :: KSIZEJ
INTEGER(KIND=8), INTENT(IN) :: KTRUNC
INTEGER(KIND=8), INTENT(IN) :: KSLOEN
INTEGER(KIND=8), DIMENSION(KSLOEN), INTENT(IN) :: KLOEN
INTEGER(KIND=8), INTENT(IN) :: KNUMMAXRESOL
INTEGER(KIND=8), INTENT(OUT) :: KGPTOT
INTEGER(KIND=8), INTENT(OUT) :: KSPEC
INTEGER(KIND=8), DIMENSION(KSLOEN), INTENT(OUT) :: KNMENG
!
! II. Local variables declaration
INTEGER, DIMENSION(SIZE(KLOEN)) :: ILOEN
INTEGER :: ISIZEI, ISIZEJ, &
         & IPHYSICALSIZEI, IPHYSICALSIZEJ, &
         & ITRUNCX, ITRUNCY, &
         & INUMMAXRESOL
LOGICAL :: LLSTOP
INTEGER :: IIDENTRESOL
INTEGER :: IGPTOT, ISPEC
INTEGER, DIMENSION(SIZE(KLOEN)) :: INMENG
REAL(KIND=8) :: ZDELTAX, ZDELTAY
#include "trans_inq.h"

ILOEN(:)=KLOEN(:)
ISIZEI=0
ISIZEJ=KSIZEJ
IPHYSICALSIZEI=0
IPHYSICALSIZEJ=0
ITRUNCX=KTRUNC
ITRUNCY=0
INUMMAXRESOL=KNUMMAXRESOL
INMENG(:)=KNMENG(:)
!
! III. Setup
ZDELTAX=0.
ZDELTAY=0.
CALL SPEC_SETUP4PY(KRETURNCODE, ISIZEI, ISIZEJ, IPHYSICALSIZEI, IPHYSICALSIZEJ, &
                  &ITRUNCX, ITRUNCY, INUMMAXRESOL, ILOEN, .FALSE., SIZE(ILOEN), &
                  &ZDELTAX, ZDELTAY, IIDENTRESOL, LLSTOP)
IF (.NOT. LLSTOP) THEN
  CALL TRANS_INQ(KRESOL=IIDENTRESOL, KGPTOT=IGPTOT, KSPEC=ISPEC, KNMENG=INMENG)
  KGPTOT=IGPTOT
  KSPEC=ISPEC
  KNMENG=INMENG
ENDIF
!
END SUBROUTINE TRANS_INQ4PY
