#include "authors_note.h"
#include "console.h"
#include "font.h"
#include "viewwin.h"
#include "random.h"

using namespace std;

extern viewport view;

extern console cons;

extern void load_instrument ();

void authors_note::enter () {
  cons ("show-authors-note");
  cons.home ();
}

void authors_note::leave () {
  cons.clear ();
  cons << "Press F1 for help" << eol;
  cons << "Press TAB to enter command mode" << eol;
}

void authors_note::setup_widgets (vector<widget*>& widgets) {

  donate_now.add_screen (this);

  im_a_donor.add_screen (this);

  ticker.add_screen (this);

  donate_now.set_listener (this);
  im_a_donor.set_listener (this);

  widgets.push_back (&donate_now);
  widgets.push_back (&im_a_donor);
  widgets.push_back (&ticker);

}

void authors_note::update_widgets () {

  int lh = get_line_height ();
  ticker.toggle.set_label (">>>");
  ticker.toggle.set_pos (20, lh);
  const box<int>& e = ticker.toggle.get_extents ();
  ticker.xstart = e.right;
  ticker.dy = get_line_height ();
  ticker.twin (ticker.xstart, e.bottom - ticker.dy, view.xmax, e.bottom + lh);
  ticker.startx = view.xmax;
  int msgw = get_char_width (ticker_tape::message);
  ticker.leftxt = -msgw;
  ticker.rightxt = view.xmax;

  donate_now.set_label ("Donate Now!");
  donate_now.set_pos (20, 5 * lh);

  im_a_donor.set_label ("I'm a Donor!");
  im_a_donor.set_pos (20, 3 * lh);

  seed_rand_gen (clock());
  rnd<float> rd (0.5, 1);
  donate_now.set_color (rd(), rd(), rd());
  im_a_donor.set_color (rd(), rd(), rd());
  ticker.set_color (rd(), rd(), rd());

}

void authors_note::clicked (button& b) {
  if (&b == &donate_now) {
    cons ("source ~/.din/donate.tcl");
  } else {
    load_instrument ();
  }
}

