# Custom Aqsis specific version of FindPNG
SET(AQSIS_PNG_FOUND 0)

SET(AQSIS_PNG_INCLUDE_SEARCHPATH)

IF(WIN32)
	IF(AQSIS_WIN32LIBS)
		SET(AQSIS_PNG_INCLUDE_SEARCHPATH ${AQSIS_PNG_INCLUDE_SEARCHPATH} ${AQSIS_WIN32LIBS}/libpng/include)
		IF(MSVC AND MSVC80)
			SET(AQSIS_PNG_LIBRARY_NAMES libpng)
			SET(AQSIS_PNG_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/libpng/lib/vc8_sp1 CACHE PATH "Semi-colon separated list of paths to search for the png libraries")
			SET(AQSIS_PNG_LIBRARY_NAMES ${AQSIS_PNG_LIBRARY_NAMES} libpng)
		ELSEIF(MSVC AND MSVC90)
			SET(AQSIS_PNG_LIBRARY_NAMES libpng)
			SET(AQSIS_PNG_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/libpng/lib/vc9_sp1 CACHE PATH "Semi-colon separated list of paths to search for the png libraries")
			SET(AQSIS_PNG_LIBRARY_NAMES ${AQSIS_PNG_LIBRARY_NAMES} libpng)
		ELSE(MSVC AND MSVC80)
			IF(MINGW)
				SET(AQSIS_PNG_LIBRARY_NAMES png)
				SET(AQSIS_PNG_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/libpng/lib/mingw CACHE PATH "Semi-colon separated list of paths to search for the png libraries")
			ENDIF(MINGW)
		ENDIF(MSVC AND MSVC80)
	ENDIF(AQSIS_WIN32LIBS)
	if(MINGW)
		LIST(APPEND AQSIS_PNG_INCLUDE_SEARCHPATH ${AQSIS_DEPENDENCIES}/include)
		LIST(APPEND AQSIS_PNG_LIBRARIES_DIR ${AQSIS_DEPENDENCIES}/lib)
		SET(AQSIS_PNG_LIBRARY_NAMES png)
	endif()
ELSE(WIN32)
	SET(AQSIS_PNG_LIBRARY_NAMES png)
	SET(AQSIS_PNG_LIBRARIES_DIR CACHE PATH "Semi-colon separated list of paths to search for the png libraries")
ENDIF(WIN32)

FIND_PATH(AQSIS_PNG_INCLUDE_DIR
			png.h
			PATHS ${AQSIS_PNG_INCLUDE_SEARCHPATH}
			DOC "Location of the libpng headers"
			)

FIND_LIBRARY(AQSIS_PNG_LIBRARIES
			NAMES ${AQSIS_PNG_LIBRARY_NAMES}
			PATHS ${AQSIS_PNG_LIBRARIES_DIR}
			DOC "Location of the libpng library"
			)
MARK_AS_ADVANCED(AQSIS_PNG_LIBRARIES)

STRING(COMPARE EQUAL "${AQSIS_PNG_INCLUDE_DIR}" "AQSIS_PNG_INCLUDE_DIR-NOTFOUND" AQSIS_PNG_INCLUDE_DIR_NOTFOUND)
STRING(COMPARE EQUAL "${AQSIS_PNG_LIBRARIES}" "AQSIS_PNG_LIBRARIES-NOTFOUND" AQSIS_PNG_LIBRARIES_NOTFOUND)

IF(NOT AQSIS_PNG_LIBRARIES_NOTFOUND AND NOT AQSIS_PNG_INCLUDE_DIR_NOTFOUND)
	SET(AQSIS_PNG_FOUND 1)
	GET_FILENAME_COMPONENT(AQSIS_PNG_LIBRARIES_DIR ${AQSIS_PNG_LIBRARIES} PATH)
ENDIF(NOT AQSIS_PNG_LIBRARIES_NOTFOUND AND NOT AQSIS_PNG_INCLUDE_DIR_NOTFOUND)

