#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Criminal Expert
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241105.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='criminal-expert'
GAME_NAME='Criminal Expert'

ARCHIVE_BASE_0_NAME='setup_criminal_expert_1.4_(61646).exe'
ARCHIVE_BASE_0_MD5='b5b13afbd5abeedb00720d641fc0ea06'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_criminal_expert_1.4_(61646)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='008e6369c386939f499565c0c3e8a40c'
ARCHIVE_BASE_0_PART2_NAME='setup_criminal_expert_1.4_(61646)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='2e340cb1cf05726420b686561d4a305f'
ARCHIVE_BASE_0_SIZE='5400000'
ARCHIVE_BASE_0_VERSION='1.4-gog61646'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/criminal_expert'

UNITY3D_NAME='criminalexpert'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Forever Entertainment S_ A_/CriminalExpert'

## TODO: Check if all these fonts are required
WINE_WINETRICKS_VERBS='corefonts'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
