/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.ErrorCode;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class DetectorFactory {
    public HashMap<String, double[]> wordLangProbMap = new HashMap();
    public ArrayList<String> langlist = new ArrayList();
    public Long seed = null;
    private static DetectorFactory instance_ = new DetectorFactory();

    private DetectorFactory() {
    }

    public static void loadProfile(String profileDirectory) throws LangDetectException {
        DetectorFactory.loadProfile(new File(profileDirectory));
    }

    private static LangProfile makeProfile(JsonObject profileData) {
        JsonObject freqData = profileData.getJsonObject("freq");
        Object[] n_wordsData = profileData.getJsonArray("n_words").toArray();
        HashMap freq = new HashMap();
        for (Map.Entry entry : freqData.entrySet()) {
            freq.put(entry.getKey(), ((JsonNumber)entry.getValue()).intValue());
        }
        int[] n_words = new int[n_wordsData.length];
        for (int i = 0; i < n_wordsData.length; ++i) {
            n_words[i] = ((JsonNumber)n_wordsData[i]).intValue();
        }
        return new LangProfile(profileData.getString("name"), freq, n_words);
    }

    public static void loadProfile(File profileDirectory) throws LangDetectException {
        File[] listFiles = profileDirectory.listFiles();
        if (listFiles == null) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Not found profile: " + profileDirectory);
        }
        int langsize = listFiles.length;
        int index = 0;
        for (File file : listFiles) {
            if (file.getName().startsWith(".") || !file.isFile()) continue;
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                JsonReader reader = Json.createReader(is);
                JsonObject profileData = reader.readObject();
                LangProfile profile = DetectorFactory.makeProfile(profileData);
                DetectorFactory.addProfile(profile, index, langsize);
                ++index;
            }
            catch (IOException e) {
                throw new LangDetectException(ErrorCode.FileLoadError, "can't open '" + file.getName() + "'");
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void loadProfile(List<String> json_profiles) throws LangDetectException {
        int index = 0;
        int langsize = json_profiles.size();
        if (langsize < 2) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Need more than 2 profiles");
        }
        for (String json : json_profiles) {
            JsonReader reader = Json.createReader(new StringReader(json));
            JsonObject profileData = reader.readObject();
            LangProfile profile = DetectorFactory.makeProfile(profileData);
            DetectorFactory.addProfile(profile, index, langsize);
            ++index;
        }
    }

    static void addProfile(LangProfile profile, int index, int langsize) throws LangDetectException {
        String lang = profile.name;
        if (DetectorFactory.instance_.langlist.contains(lang)) {
            throw new LangDetectException(ErrorCode.DuplicateLangError, "duplicate the same language profile");
        }
        DetectorFactory.instance_.langlist.add(lang);
        for (String word : profile.freq.keySet()) {
            double prob;
            int length;
            if (!DetectorFactory.instance_.wordLangProbMap.containsKey(word)) {
                DetectorFactory.instance_.wordLangProbMap.put(word, new double[langsize]);
            }
            if ((length = word.length()) < 1 || length > 3) continue;
            DetectorFactory.instance_.wordLangProbMap.get((Object)word)[index] = prob = profile.freq.get(word).doubleValue() / (double)profile.n_words[length - 1];
        }
    }

    public static void clear() {
        DetectorFactory.instance_.langlist.clear();
        DetectorFactory.instance_.wordLangProbMap.clear();
    }

    public static Detector create() throws LangDetectException {
        return DetectorFactory.createDetector();
    }

    public static Detector create(double alpha) throws LangDetectException {
        Detector detector = DetectorFactory.createDetector();
        detector.setAlpha(alpha);
        return detector;
    }

    private static Detector createDetector() throws LangDetectException {
        if (DetectorFactory.instance_.langlist.size() == 0) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "need to load profiles");
        }
        Detector detector = new Detector(instance_);
        return detector;
    }

    public static void setSeed(long seed) {
        DetectorFactory.instance_.seed = seed;
    }

    public static final List<String> getLangList() {
        return Collections.unmodifiableList(DetectorFactory.instance_.langlist);
    }
}

