/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.event.ProfileChangeEvent;
import ca.sqlpower.architect.profile.event.ProfileChangeListener;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.ProfileResultsViewer;
import ca.sqlpower.architect.swingui.ProfileRowComponent;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.Search;
import ca.sqlpower.swingui.SearchTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class ProfileManagerView
extends JPanel
implements ProfileChangeListener,
Search {
    private static Logger logger = Logger.getLogger(ProfileManagerView.class);
    private static final int VISIBLE_ROWS = 8;
    private final ProfileManager pm;
    private final ResultListPanel resultListPanel;
    private final JScrollPane scrollPane;
    private final JLabel statusText;
    private final SearchTextField searchText;
    private final PageListener pageListener;
    private Comparator<ProfileRowComponent> comparator;
    List<ProfileRowComponent> list = new ArrayList<ProfileRowComponent>();
    final List<ProfileRowComponent> showingRows = new ArrayList<ProfileRowComponent>();
    private Pattern lastSearchPattern;
    private boolean lastMatchExactValue;
    private boolean hasProfileSelected = false;
    private final Action viewSelectedAction = new AbstractAction(Messages.getString("ProfileManagerView.viewSelectedActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfileResultsViewer profileResultsViewer = new ProfileResultsViewer(ProfileManagerView.this.pm);
            profileResultsViewer.clearScanList();
            for (ProfileRowComponent rowComp : ProfileManagerView.this.showingRows) {
                if (!rowComp.isSelected()) continue;
                TableProfileResult result = rowComp.getResult();
                profileResultsViewer.addTableProfileResultToScan(result);
                profileResultsViewer.addTableProfileResult(result);
            }
            profileResultsViewer.getDialog().setVisible(true);
        }
    };
    private Action viewAllAction = new AbstractAction(Messages.getString("ProfileManagerView.viewAllActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfileResultsViewer profileResultsViewer = new ProfileResultsViewer(ProfileManagerView.this.pm);
            profileResultsViewer.clearScanList();
            for (ProfileRowComponent rowComp : ProfileManagerView.this.showingRows) {
                TableProfileResult result = rowComp.getResult();
                profileResultsViewer.addTableProfileResultToScan(result);
                profileResultsViewer.addTableProfileResult(result);
            }
            profileResultsViewer.getDialog().setVisible(true);
        }
    };
    private Action deleteAllAction = new AbstractAction(Messages.getString("ProfileManagerView.deleteAllActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int confirm = JOptionPane.showConfirmDialog(ProfileManagerView.this.scrollPane, Messages.getString("ProfileManagerView.confirmDeleteProfileData"), Messages.getString("ProfileManagerView.deleteAllButton"), 0);
            if (confirm == 0) {
                ProfileManagerView.this.resultListPanel.removeAll();
                ProfileManagerView.this.list.clear();
                ProfileManagerView.this.showingRows.clear();
                ProfileManagerView.this.pm.clear();
                ProfileManagerView.this.resultListPanel.revalidate();
            }
        }
    };

    public ProfileManagerView(ProfileManager pm) {
        this.pm = pm;
        this.pageListener = new PageListener();
        this.addKeyListener(this.pageListener);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        this.add((Component)topPanel, "North");
        this.searchText = new SearchTextField((Search)this, 10);
        this.searchText.getTextField().addKeyListener(this.pageListener);
        topPanel.add(this.searchText.getPanel());
        JButton clearSearchButton = new JButton(Messages.getString("ProfileManagerView.clearSearch"));
        clearSearchButton.addKeyListener(this.pageListener);
        clearSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileManagerView.this.searchText.clear();
            }
        });
        topPanel.add(clearSearchButton);
        this.comparator = new TableProfileNameComparator();
        JLabel orderByLabel = new JLabel(Messages.getString("ProfileManagerView.orderBy"));
        topPanel.add(orderByLabel);
        final JRadioButton nameRadioButton = new JRadioButton(Messages.getString("ProfileManagerView.nameOption"));
        topPanel.add(nameRadioButton);
        nameRadioButton.addKeyListener(this.pageListener);
        JRadioButton dateRadioButton = new JRadioButton(Messages.getString("ProfileManagerView.dateOption"));
        topPanel.add(dateRadioButton);
        dateRadioButton.addKeyListener(this.pageListener);
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (nameRadioButton.isSelected()) {
                    ProfileManagerView.this.setComparator(new TableProfileNameComparator());
                } else {
                    ProfileManagerView.this.setComparator(new TableProfileDateComparator());
                }
            }
        };
        nameRadioButton.addActionListener(radioListener);
        dateRadioButton.addActionListener(radioListener);
        ButtonGroup group = new ButtonGroup();
        group.add(nameRadioButton);
        group.add(dateRadioButton);
        nameRadioButton.setSelected(true);
        this.scrollPane = new JScrollPane();
        this.resultListPanel = new ResultListPanel(this.scrollPane);
        this.scrollPane.setViewportView(this.resultListPanel);
        this.resultListPanel.setFocusable(true);
        this.resultListPanel.addKeyListener(this.pageListener);
        this.resultListPanel.setBackground(UIManager.getColor("List.background"));
        this.resultListPanel.setLayout(new GridLayout(0, 1));
        logger.debug((Object)("Populating profile manager view from profile manager " + System.identityHashCode(pm)));
        for (TableProfileResult result : pm.getResults()) {
            ProfileRowComponent myRowComponent = new ProfileRowComponent(result, pm);
            myRowComponent.addProfileChangeListener(this);
            this.list.add(myRowComponent);
            myRowComponent.addSelectionListener(this.resultListPanel);
            this.resultListPanel.add(myRowComponent);
            this.showingRows.add(myRowComponent);
        }
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.scrollPane.getViewport().setFocusable(true);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        this.add((Component)bottomPanel, "South");
        bottomPanel.add(new JButton(this.viewAllAction));
        bottomPanel.add(new JButton(this.viewSelectedAction));
        this.statusText = new JLabel();
        this.updateStatus();
        bottomPanel.add(this.statusText);
        bottomPanel.add(new JButton(this.deleteAllAction));
        JButton closeButton = new JButton(Messages.getString("ProfileManagerView.closeButton"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Container c;
                for (c = ProfileManagerView.this.getParent(); c != null && !(c instanceof Window); c = c.getParent()) {
                }
                if (c != null) {
                    c.setVisible(false);
                }
            }
        });
        bottomPanel.add(closeButton);
    }

    private void updateStatus() {
        int totalNumber = this.list.size();
        int numberShowing = this.showingRows.size();
        this.viewAllAction.setEnabled(numberShowing != 0);
        this.deleteAllAction.setEnabled(totalNumber != 0);
        this.updateSelection();
        this.statusText.setText(String.format(Messages.getString("ProfileManagerView.profileDisplayStatus"), numberShowing, totalNumber));
    }

    private void updateSelection() {
        this.viewSelectedAction.setEnabled(this.hasProfileSelected);
    }

    private void updateResultListPanel() {
        this.resultListPanel.removeAll();
        ArrayList<TableProfileResult> tableProfileResults = new ArrayList<TableProfileResult>();
        this.hasProfileSelected = false;
        for (ProfileRowComponent r : this.showingRows) {
            this.resultListPanel.add(r);
            tableProfileResults.add(r.getResult());
            if (this.hasProfileSelected || !r.isSelected()) continue;
            this.hasProfileSelected = true;
        }
        this.pm.setProcessingOrder(tableProfileResults);
        this.resultListPanel.revalidate();
        this.updateSelection();
        logger.debug((Object)("Showing rows has contents " + this.showingRows));
    }

    public void doSearch(Pattern p, boolean matchExactly) {
        this.lastSearchPattern = p;
        this.lastMatchExactValue = matchExactly;
        this.showingRows.clear();
        if (p == null || p.pattern() == null || p.pattern().length() == 0) {
            for (ProfileRowComponent r : this.list) {
                this.showingRows.add(r);
            }
        } else {
            for (ProfileRowComponent r : this.list) {
                if (matchExactly && p.matcher(((SQLTable)r.getResult().getProfiledObject()).getName()).matches()) {
                    this.showingRows.add(r);
                    continue;
                }
                if (matchExactly || !p.matcher(((SQLTable)r.getResult().getProfiledObject()).getName()).find()) continue;
                this.showingRows.add(r);
            }
        }
        Collections.sort(this.showingRows, this.comparator);
        this.updateResultListPanel();
        this.updateStatus();
    }

    private void setComparator(Comparator<ProfileRowComponent> comparator) {
        this.comparator = comparator;
        this.doSearch(this.lastSearchPattern, this.lastMatchExactValue);
    }

    @Override
    public void profilesAdded(ProfileChangeEvent e) {
        logger.debug((Object)"ProfileManagerView.profileAdded(): table profile added");
        ArrayList<ProfileResult> profileResult = new ArrayList<ProfileResult>(e.getProfileResults());
        ArrayList<TableProfileResult> tpr = new ArrayList<TableProfileResult>();
        for (ProfileResult pr : profileResult) {
            if (pr instanceof TableProfileResult) {
                ProfileRowComponent myRowComponent = new ProfileRowComponent((TableProfileResult)pr, this.pm);
                myRowComponent.addSelectionListener(this.resultListPanel);
                myRowComponent.addProfileChangeListener(this);
                this.list.add(myRowComponent);
                tpr.add((TableProfileResult)pr);
                this.pm.setProcessingOrder(tpr);
                continue;
            }
            logger.debug((Object)("Cannot create a component based on the profile result " + pr));
        }
        this.doSearch(this.lastSearchPattern, this.lastMatchExactValue);
    }

    @Override
    public void profilesRemoved(ProfileChangeEvent e) {
        List<ProfileResult> profileResults = e.getProfileResults();
        logger.debug((Object)("ProfileManagerView.profileRemoved(): " + profileResults + ": profiles deleted"));
        block0: for (ProfileResult profileResult : profileResults) {
            for (ProfileRowComponent view : this.list) {
                if (!view.getResult().equals(profileResult)) continue;
                this.list.remove(view);
                view.removeSelectionListener(this.resultListPanel);
                continue block0;
            }
        }
        this.doSearch(this.lastSearchPattern, this.lastMatchExactValue);
    }

    @Override
    public void profileListChanged(ProfileChangeEvent e) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProfileManagerView.this.sort();
            }
        };
        try {
            SwingUtilities.invokeLater(runner);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sort() {
        Collections.sort(this.showingRows, this.comparator);
        this.updateStatus();
        this.updateResultListPanel();
    }

    private class PageListener
    implements KeyListener {
        private PageListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (ProfileManagerView.this.scrollPane != null && ProfileManagerView.this.resultListPanel != null) {
                if (e.getKeyCode() == 34) {
                    JScrollBar sb = ProfileManagerView.this.scrollPane.getVerticalScrollBar();
                    sb.setValue(sb.getValue() + ((ProfileManagerView)ProfileManagerView.this).resultListPanel.getPreferredScrollableViewportSize().height);
                } else if (e.getKeyCode() == 33) {
                    JScrollBar sb = ProfileManagerView.this.scrollPane.getVerticalScrollBar();
                    sb.setValue(sb.getValue() - ((ProfileManagerView)ProfileManagerView.this).resultListPanel.getPreferredScrollableViewportSize().height);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class TableProfileDateComparator
    implements Comparator<ProfileRowComponent> {
        private TableProfileDateComparator() {
        }

        @Override
        public int compare(ProfileRowComponent o1, ProfileRowComponent o2) {
            TableProfileResult tpr1 = o1.getResult();
            TableProfileResult tpr2 = o2.getResult();
            if (tpr1.getCreateStartTime() < tpr2.getCreateStartTime()) {
                return -1;
            }
            if (tpr1.getCreateStartTime() > tpr2.getCreateStartTime()) {
                return 1;
            }
            int result = ((SQLTable)tpr1.getProfiledObject()).getName().compareTo(((SQLTable)tpr2.getProfiledObject()).getName());
            return result;
        }
    }

    private class TableProfileNameComparator
    implements Comparator<ProfileRowComponent> {
        private TableProfileNameComparator() {
        }

        @Override
        public int compare(ProfileRowComponent o1, ProfileRowComponent o2) {
            TableProfileResult tpr1 = o1.getResult();
            TableProfileResult tpr2 = o2.getResult();
            int result = ((SQLTable)tpr1.getProfiledObject()).getName().compareTo(((SQLTable)tpr2.getProfiledObject()).getName());
            if (result != 0) {
                return result;
            }
            if (tpr1.getCreateStartTime() < tpr2.getCreateStartTime()) {
                return -1;
            }
            if (tpr1.getCreateStartTime() > tpr2.getCreateStartTime()) {
                return 1;
            }
            return 0;
        }
    }

    private class ResultListPanel
    extends JPanel
    implements Scrollable,
    SelectionListener {
        private static final String SELECT_ABOVE_ACTION = "selectAboveAction";
        private static final String SELECT_BELOW_ACTION = "selectBelowAction";
        private static final String DELETE_ACTION = "deleteAction";
        private static final String SHOW_PROFILE_ACTION = "showProfileAction";
        private ProfileRowComponent lastSelectedRow;
        private boolean ignoreSelectionEvents = false;
        private final JScrollPane parentScrollPane;

        public ResultListPanel(JScrollPane parent) {
            this.parentScrollPane = parent;
            this.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), SELECT_ABOVE_ACTION);
            this.getActionMap().put(SELECT_ABOVE_ACTION, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfileRowComponent focusedRow = null;
                    for (ProfileRowComponent prc : ProfileManagerView.this.showingRows) {
                        if (!prc.hasFocus()) continue;
                        focusedRow = prc;
                        break;
                    }
                    if (focusedRow == null) {
                        return;
                    }
                    if (ProfileManagerView.this.showingRows.indexOf(focusedRow) != 0) {
                        ProfileRowComponent abovePRC = ProfileManagerView.this.showingRows.get(ProfileManagerView.this.showingRows.indexOf(focusedRow) - 1);
                        abovePRC.setSelected(true, 4);
                        if (ResultListPanel.this.parentScrollPane != null) {
                            Rectangle viewRect = ResultListPanel.this.parentScrollPane.getViewport().getViewRect();
                            ResultListPanel.this.parentScrollPane.getViewport().scrollRectToVisible(new Rectangle((int)((double)abovePRC.getX() - viewRect.getX()), (int)((double)abovePRC.getY() - viewRect.getY()), abovePRC.getWidth(), abovePRC.getHeight()));
                        }
                    }
                }
            });
            this.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0), SELECT_BELOW_ACTION);
            this.getActionMap().put(SELECT_BELOW_ACTION, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfileRowComponent focusedRow = null;
                    for (ProfileRowComponent prc : ProfileManagerView.this.showingRows) {
                        if (!prc.hasFocus()) continue;
                        focusedRow = prc;
                        break;
                    }
                    if (focusedRow == null) {
                        return;
                    }
                    if (ProfileManagerView.this.showingRows.indexOf(focusedRow) != ProfileManagerView.this.showingRows.size() - 1) {
                        ProfileRowComponent belowPRC = ProfileManagerView.this.showingRows.get(ProfileManagerView.this.showingRows.indexOf(focusedRow) + 1);
                        belowPRC.setSelected(true, 4);
                        if (ResultListPanel.this.parentScrollPane != null) {
                            Rectangle viewRect = ResultListPanel.this.parentScrollPane.getViewport().getViewRect();
                            ResultListPanel.this.parentScrollPane.getViewport().scrollRectToVisible(new Rectangle((int)((double)belowPRC.getX() - viewRect.getX()), (int)((double)belowPRC.getY() - viewRect.getY()), belowPRC.getWidth(), belowPRC.getHeight()));
                        }
                    }
                }
            });
            this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), DELETE_ACTION);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(8, 0), DELETE_ACTION);
            this.getActionMap().put(DELETE_ACTION, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = ProfileManagerView.this.showingRows.size() - 1; i >= 0; --i) {
                        ProfileRowComponent rowComp = ProfileManagerView.this.showingRows.get(i);
                        if (!rowComp.isSelected()) continue;
                        ProfileManagerView.this.pm.removeProfile(rowComp.getResult());
                    }
                    ProfileManagerView.this.updateResultListPanel();
                }
            });
            this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), SHOW_PROFILE_ACTION);
            this.getActionMap().put(SHOW_PROFILE_ACTION, ProfileManagerView.this.viewSelectedAction);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return d;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            if (ProfileManagerView.this.list.size() == 0) {
                return super.getPreferredSize();
            }
            Dimension d = super.getPreferredSize();
            d.height = ProfileManagerView.this.list.get((int)0).getPreferredSize().height * 8;
            d.width = Math.max(((ProfileManagerView)ProfileManagerView.this).resultListPanel.getPreferredSize().width, d.width);
            return d;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return ((ProfileManagerView)ProfileManagerView.this).resultListPanel.getPreferredScrollableViewportSize().height;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 15;
        }

        @Override
        public void itemDeselected(SelectionEvent e) {
            if (this.ignoreSelectionEvents) {
                return;
            }
            this.ignoreSelectionEvents = true;
            ProfileManagerView.this.hasProfileSelected = false;
            for (ProfileRowComponent row : ProfileManagerView.this.showingRows) {
                if (!row.isSelected()) continue;
                ProfileManagerView.this.hasProfileSelected = true;
                break;
            }
            ProfileManagerView.this.updateSelection();
            this.ignoreSelectionEvents = false;
        }

        @Override
        public void itemSelected(SelectionEvent e) {
            if (this.ignoreSelectionEvents) {
                return;
            }
            this.ignoreSelectionEvents = true;
            ProfileManagerView.this.hasProfileSelected = true;
            ProfileRowComponent selectedRow = (ProfileRowComponent)e.getSource();
            if (e.getMultiselectType() == 4) {
                this.lastSelectedRow = selectedRow;
                for (ProfileRowComponent row : ProfileManagerView.this.list) {
                    if (row == selectedRow) continue;
                    row.setSelected(false, 4);
                }
            } else if (e.getMultiselectType() == 8) {
                this.lastSelectedRow = selectedRow;
            } else if (e.getMultiselectType() == 16) {
                int lastSelectedRowIndex = ProfileManagerView.this.showingRows.indexOf(this.lastSelectedRow);
                int selectedRowIndex = ProfileManagerView.this.showingRows.indexOf(selectedRow);
                int start = Math.min(lastSelectedRowIndex, selectedRowIndex);
                int end = Math.max(lastSelectedRowIndex, selectedRowIndex);
                for (int i = 0; i < ProfileManagerView.this.showingRows.size(); ++i) {
                    if (i < start || i > end) {
                        ProfileManagerView.this.showingRows.get(i).setSelected(false, 4);
                        continue;
                    }
                    ProfileManagerView.this.showingRows.get(i).setSelected(true, 4);
                }
                ProfileManagerView.this.showingRows.get(selectedRowIndex).setSelected(true, 4);
            }
            ProfileManagerView.this.updateSelection();
            this.ignoreSelectionEvents = false;
        }
    }
}

