/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.beaninfo.editors.FileEditor;
import org.netbeans.core.execution.beaninfo.editors.NbClassPathEditor;
import org.openide.awt.Mnemonics;
import org.openide.execution.NbClassPath;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

class NbClassPathCustomEditor
extends JPanel {
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private PropertyEditor editor;
    private DefaultListModel<Object> listModel = new DefaultListModel();
    private boolean editable = true;
    private JButton addDirButton;
    private JButton addJarButton;
    private JButton downButton;
    private JPanel innerPanel;
    private JList pathList;
    private JScrollPane pathScrollPane;
    private JButton removeButton;
    private JButton upButton;

    public NbClassPathCustomEditor() {
        this.initComponents();
        this.pathList.setModel(this.listModel);
        this.pathScrollPane.setViewportView(this.pathList);
        this.setMinimumSize(new Dimension(400, 200));
        this.setPreferredSize(new Dimension(400, 200));
        this.pathList.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_PathList"));
        this.addDirButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_AddDirectory"));
        this.addJarButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_AddJAR"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_MoveDown"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_Remove"));
        this.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_CustomNbClassPathEditor"));
    }

    NbClassPathCustomEditor(PropertyEditor propertyEditor) {
        this();
        this.editor = propertyEditor;
        Object object = propertyEditor.getValue();
        if (object instanceof NbClassPath) {
            this.setClassPath(((NbClassPath)object).getClassPath());
        }
        if (this.editor instanceof NbClassPathEditor && !((NbClassPathEditor)((Object)this.editor)).isEditable()) {
            this.editable = false;
            this.addDirButton.setEnabled(false);
            this.addJarButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.addDirButton = new JButton();
        this.addJarButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.pathScrollPane = new JScrollPane();
        this.pathList = new JList();
        this.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addDirButton, (String)NbClassPathCustomEditor.getString("CTL_AddDirectory"));
        this.addDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.addDirButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addDirButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addJarButton, (String)NbClassPathCustomEditor.getString("CTL_AddJAR"));
        this.addJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.addJarButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addJarButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbClassPathCustomEditor.getString("CTL_MoveUp"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.upButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbClassPathCustomEditor.getString("CTL_MoveDown"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.innerPanel.add((Component)this.downButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbClassPathCustomEditor.getString("CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NbClassPathCustomEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.innerPanel.add((Component)this.removeButton, gridBagConstraints);
        this.pathList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NbClassPathCustomEditor.this.pathListMouseClicked(mouseEvent);
            }
        });
        this.pathList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                NbClassPathCustomEditor.this.pathListValueChanged(listSelectionEvent);
            }
        });
        this.pathScrollPane.setViewportView(this.pathList);
        this.pathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbClassPathCustomEditor.class, (String)"NbClassPathCustomEditor.pathList.AccessibleContext.accessibleName"));
        this.pathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbClassPathCustomEditor.class, (String)"NbClassPathCustomEditor.pathList.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.innerPanel.add((Component)this.pathScrollPane, gridBagConstraints);
        this.add((Component)this.innerPanel, "Center");
    }

    private void pathListMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        this.triggerEdit(this.pathList.getSelectedIndex());
    }

    private void pathListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = this.pathList.getSelectedIndex();
        Object[] objectArray = this.pathList.getSelectedValues();
        for (n = 0; n < objectArray.length; ++n) {
            this.listModel.removeElement(objectArray[n]);
            this.fireValueChanged();
        }
        n = this.listModel.getSize();
        if (n2 >= 0 && n > 0) {
            if (n == n2) {
                this.pathList.setSelectedIndex(n2 - 1);
            } else if (n > n2) {
                this.pathList.setSelectedIndex(n2);
            } else {
                this.pathList.setSelectedIndex(0);
            }
        }
        this.enableButtons();
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.pathList.getSelectedIndex();
        this.swap(n);
        this.pathList.setSelectedIndex(n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.pathList.getSelectedIndex();
        this.swap(n - 1);
        this.pathList.setSelectedIndex(n - 1);
    }

    private void addJarButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        this.setHelpToChooser(jFileChooser);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return NbClassPathCustomEditor.getString("CTL_JarArchivesMask");
            }
        });
        if (lastJarFolder != null) {
            jFileChooser.setCurrentDirectory(lastJarFolder);
        }
        jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_FileSystemPanel.Jar_Dialog_Title"));
        jFileChooser.setMultiSelectionEnabled(true);
        if (jFileChooser.showDialog(this, NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            boolean bl = false;
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] == null || !fileArray[i].isFile()) continue;
                bl = true;
                String string = fileArray[i].getAbsolutePath();
                if (this.listModel.contains(string)) continue;
                this.listModel.addElement(string);
            }
            if (bl) {
                lastJarFolder = jFileChooser.getCurrentDirectory();
                this.fireValueChanged();
            }
            this.pathList.setSelectedIndex(this.listModel.size() - 1);
        }
    }

    private void addDirButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
        jFileChooser.setFileHidingEnabled(false);
        this.setHelpToChooser(jFileChooser);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_FileSystemPanel.Local_Dialog_Title"));
        if (lastDirFolder != null) {
            jFileChooser.setCurrentDirectory(lastDirFolder);
        }
        if (jFileChooser.showDialog(this, NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file = jFileChooser.getSelectedFile()) != null && file.isDirectory()) {
            lastDirFolder = file.getParentFile();
            String string = file.getAbsolutePath();
            if (!this.listModel.contains(string)) {
                this.listModel.addElement(string);
            }
            this.fireValueChanged();
            this.pathList.setSelectedIndex(this.listModel.size() - 1);
        }
    }

    private void fireValueChanged() {
        if (this.editor != null) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void triggerEdit(int n) {
        if (n < 0) {
            return;
        }
        String string = (String)this.listModel.elementAt(n);
        File file = new File(string);
        if (file.isDirectory()) {
            File file2;
            JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
            this.setHelpToChooser(jFileChooser);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_Edit_Local_Dialog_Title"));
            if (file.getParentFile() != null) {
                jFileChooser.setCurrentDirectory(file.getParentFile());
                jFileChooser.setSelectedFile(file);
            }
            if (jFileChooser.showDialog(this, NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file2 = jFileChooser.getSelectedFile()) != null && file2.isDirectory()) {
                lastDirFolder = jFileChooser.getCurrentDirectory();
                try {
                    file2 = file2.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.listModel.set(n, file2.getAbsolutePath());
                this.fireValueChanged();
            }
        } else if (file.isFile()) {
            File file3;
            JFileChooser jFileChooser = FileEditor.createHackedFileChooser();
            this.setHelpToChooser(jFileChooser);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
                }

                @Override
                public String getDescription() {
                    return NbClassPathCustomEditor.getString("CTL_JarArchivesMask");
                }
            });
            jFileChooser.setCurrentDirectory(file.getParentFile());
            jFileChooser.setSelectedFile(file);
            jFileChooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_Edit_Jar_Dialog_Title"));
            if (jFileChooser.showDialog(this, NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (file3 = jFileChooser.getSelectedFile()) != null && file3.isFile()) {
                lastJarFolder = jFileChooser.getCurrentDirectory();
                this.listModel.set(n, file3.getAbsolutePath());
                this.fireValueChanged();
            }
        }
    }

    private void swap(int n) {
        if (n < 0 || n >= this.listModel.size() - 1) {
            return;
        }
        Object object = this.listModel.elementAt(n);
        this.listModel.removeElement(object);
        this.listModel.add(n + 1, object);
        this.fireValueChanged();
        this.enableButtons();
    }

    private void enableButtons() {
        if (!this.editable) {
            return;
        }
        this.removeButton.setEnabled(this.pathList.getSelectedIndices().length > 0);
        if (this.pathList.getSelectedIndices().length == 1) {
            this.downButton.setEnabled(this.pathList.getSelectedIndices()[0] < this.pathList.getModel().getSize() - 1);
            this.upButton.setEnabled(this.pathList.getSelectedIndices()[0] > 0);
        } else {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.enableButtons();
        }
    }

    private void setClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (this.listModel.contains(string2)) continue;
            this.listModel.addElement(string2);
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        ArrayList<String> arrayList = Collections.list(NbCollections.checkedEnumerationByFilter(this.listModel.elements(), String.class, (boolean)true));
        String[] stringArray = arrayList.toArray(new String[0]);
        return new NbClassPath(stringArray);
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(NbClassPathCustomEditor.class, (String)string);
    }

    private void setHelpToChooser(JFileChooser jFileChooser) {
        HelpCtx helpCtx = HelpCtx.findHelp((Component)this);
        if (helpCtx != null) {
            HelpCtx.setHelpIDString((JComponent)jFileChooser, (String)helpCtx.getHelpID());
        }
    }
}

