/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * max(uvec4(0u, 1u, 2u, 5u), 0u) => uvec4(0u, 1u, 2u, 5u)
 * max(uvec4(34u, 0u, 1u, 2u), 0u) => uvec4(34u, 0u, 1u, 2u)
 * max(uvec4(0u, 1u, 2u, 5u), 1u) => uvec4(1u, 1u, 2u, 5u)
 * max(uvec4(34u, 0u, 1u, 2u), 1u) => uvec4(34u, 1u, 1u, 2u)
 * max(uvec4(0u, 1u, 2u, 5u), 2u) => uvec4(2u, 2u, 2u, 5u)
 * max(uvec4(34u, 0u, 1u, 2u), 2u) => uvec4(34u, 2u, 2u, 2u)
 * max(uvec4(0u, 1u, 2u, 5u), 5u) => uvec4(5u, 5u, 5u, 5u)
 * max(uvec4(34u, 0u, 1u, 2u), 5u) => uvec4(34u, 5u, 5u, 5u)
 * max(uvec4(0u, 1u, 2u, 5u), 34u) => uvec4(34u, 34u, 34u, 34u)
 * max(uvec4(34u, 0u, 1u, 2u), 34u) => uvec4(34u, 34u, 34u, 34u)
 */
#version 130

void main()
{
  float[all(equal(max(uvec4(0u, 1u, 2u, 5u), 0u), uvec4(0u, 1u, 2u, 5u))) ? 1 : -1] array0;
  float[all(equal(max(uvec4(34u, 0u, 1u, 2u), 0u), uvec4(34u, 0u, 1u, 2u))) ? 1 : -1] array1;
  float[all(equal(max(uvec4(0u, 1u, 2u, 5u), 1u), uvec4(1u, 1u, 2u, 5u))) ? 1 : -1] array2;
  float[all(equal(max(uvec4(34u, 0u, 1u, 2u), 1u), uvec4(34u, 1u, 1u, 2u))) ? 1 : -1] array3;
  float[all(equal(max(uvec4(0u, 1u, 2u, 5u), 2u), uvec4(2u, 2u, 2u, 5u))) ? 1 : -1] array4;
  float[all(equal(max(uvec4(34u, 0u, 1u, 2u), 2u), uvec4(34u, 2u, 2u, 2u))) ? 1 : -1] array5;
  float[all(equal(max(uvec4(0u, 1u, 2u, 5u), 5u), uvec4(5u, 5u, 5u, 5u))) ? 1 : -1] array6;
  float[all(equal(max(uvec4(34u, 0u, 1u, 2u), 5u), uvec4(34u, 5u, 5u, 5u))) ? 1 : -1] array7;
  float[all(equal(max(uvec4(0u, 1u, 2u, 5u), 34u), uvec4(34u, 34u, 34u, 34u))) ? 1 : -1] array8;
  float[all(equal(max(uvec4(34u, 0u, 1u, 2u), 34u), uvec4(34u, 34u, 34u, 34u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
