# SPDX-FileCopyrightText: 2018 Volker Krause <vkrause@kde.org>
# SPDX-License-Identifier: BSD-3-Clause


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KPublicTransportConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(Qt6Gui)
find_dependency(ZLIB)

# Breeze icons used by the QML UI components or returned by C++ icon API
# For use in Kirigami icon bundling in consuming apps
set(KPUBLICTRANSPORT_ICONS
    channel-insecure-symbolic
    channel-secure-symbolic
    documentinfo
    edit-clear-history-symbolic
    edit-delete-symbolic
    emblem-error
    emblem-important
    emblem-information
    emblem-question
    emblem-warning
    go-down
    go-up
    map-symbolic
    question
    sort-name-symbolic
    system-software-update-symbolic
)

include("${CMAKE_CURRENT_LIST_DIR}/KPublicTransportTargets.cmake")

