/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Utils;

public final class OpenBrowser {
    private OpenBrowser() {
    }

    public static String displayUrl(URI uri) {
        CheckParameterUtil.ensureParameterNotNull(uri, "uri");
        Logging.info(I18n.tr("Opening URL: {0}", uri));
        try {
            if (PlatformManager.getPlatform() != null) {
                PlatformManager.getPlatform().openUrl(uri.toString());
            } else if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(uri);
            } else {
                Logging.warn("Neither Platform nor Desktop class is not supported. Cannot open " + String.valueOf(uri));
            }
        }
        catch (IOException e) {
            Logging.warn(e);
            return e.getMessage();
        }
        return null;
    }

    public static String displayUrl(String url) {
        try {
            return OpenBrowser.displayUrl(Utils.urlToURI(url));
        }
        catch (MalformedURLException | URISyntaxException e) {
            Logging.debug(e);
            return e.getMessage();
        }
    }
}

