/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CalculatedMemberEditPanel
implements DataEntryPanel {
    private MondrianModel.CalculatedMember calculatedMember;
    private JPanel panel;
    private JTextField nameField;
    private JTextField captionField;
    private JTextField dimensionField;
    private JTextArea formulaTextArea;
    private JTextField formatField;
    private JCheckBox visibleCheckBox;

    public CalculatedMemberEditPanel(MondrianModel.CalculatedMember model) {
        this.calculatedMember = model;
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 150dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.nameField = new JTextField(model.getName());
        builder.append("Name", (Component)this.nameField);
        this.captionField = new JTextField(model.getCaption());
        builder.append("Caption", (Component)this.captionField);
        this.dimensionField = new JTextField(model.getDimension());
        builder.append("Dimension", (Component)this.dimensionField);
        this.visibleCheckBox = new JCheckBox("", model.getVisible() == null ? true : model.getVisible());
        builder.append("Visible", (Component)this.visibleCheckBox);
        String formula = null;
        if (model.getFormula() != null) {
            formula = model.getFormula();
        } else if (model.getFormulaElement() != null) {
            formula = model.getFormulaElement().getText();
        }
        this.formulaTextArea = new JTextArea(formula, 4, 50);
        builder.append("Formula", (Component)this.formulaTextArea);
        this.formulaTextArea.setLineWrap(true);
        this.formatField = new JTextField(model.getFormatString());
        builder.append("Format", (Component)this.formatField);
        this.panel = builder.getPanel();
    }

    public boolean applyChanges() {
        this.calculatedMember.begin("Modifying Calculated Measure Properties");
        this.calculatedMember.setName(this.nameField.getText());
        this.calculatedMember.setCaption(this.captionField.getText());
        this.calculatedMember.setDimension(this.dimensionField.getText());
        this.calculatedMember.setVisible(this.visibleCheckBox.isSelected());
        if (this.calculatedMember.getFormulaElement() == null || this.calculatedMember.getFormula() != null) {
            this.calculatedMember.setFormula(this.formulaTextArea.getText());
        }
        if (this.calculatedMember.getFormulaElement() != null) {
            this.calculatedMember.getFormulaElement().setText(this.formulaTextArea.getText());
        }
        this.calculatedMember.setFormatString(this.formatField.getText());
        this.calculatedMember.commit();
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

