/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowsfromresult;

import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowsfromresult.Messages;
import org.pentaho.di.trans.steps.rowsfromresult.RowsFromResultData;
import org.pentaho.di.trans.steps.rowsfromresult.RowsFromResultMeta;

public class RowsFromResult
extends BaseStep
implements StepInterface {
    private RowsFromResultMeta meta = (RowsFromResultMeta)this.getStepMeta().getStepMetaInterface();
    private RowsFromResultData data;

    public RowsFromResult(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (RowsFromResultData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Result previousResult = this.getTransMeta().getPreviousResult();
        if (previousResult == null || this.getLinesRead() >= (long)previousResult.getRows().size()) {
            this.setOutputDone();
            return false;
        }
        RowMetaAndData row = (RowMetaAndData)previousResult.getRows().get((int)this.getLinesRead());
        this.incrementLinesRead();
        this.data = (RowsFromResultData)sdi;
        this.data.outputRowMeta = row.getRowMeta();
        this.putRow(this.data.outputRowMeta, row.getData());
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("RowsFromResult.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RowsFromResultMeta)smi;
        this.data = (RowsFromResultData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

