/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.impl.adt.Barcode;

class BarcodeListDeltas {
    private final Barcode updates = new Barcode();
    private final Barcode deletes = new Barcode();
    private final Barcode inserts = new Barcode();

    BarcodeListDeltas() {
    }

    public void reset(int length) {
        this.deletes.clear();
        this.deletes.addBlack(0, length);
        this.updates.clear();
        this.updates.addBlack(0, length);
        this.inserts.clear();
        this.inserts.addBlack(0, length);
    }

    private void ensureCapacity(int size) {
        int delta = size - this.deletes.blackSize();
        if (delta <= 0) {
            return;
        }
        this.updates.addBlack(this.updates.size(), delta);
        this.deletes.addBlack(this.deletes.size(), delta);
        this.inserts.addBlack(this.inserts.size(), delta);
    }

    public int currentToSnapshot(int currentIndex) {
        if (currentIndex < 0 || currentIndex >= this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.inserts.get(currentIndex) == Barcode.WHITE) {
            return -1;
        }
        int insertAdjusted = this.inserts.getBlackIndex(currentIndex);
        return this.deletes.getIndex(insertAdjusted, Barcode.BLACK);
    }

    public int snapshotToCurrent(int snapshotIndex) {
        if (snapshotIndex < 0 || snapshotIndex >= this.inserts.whiteSize() + this.snapshotSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (snapshotIndex >= this.snapshotSize()) {
            return this.inserts.getIndex(snapshotIndex - this.snapshotSize(), Barcode.WHITE);
        }
        if (this.deletes.get(snapshotIndex) == Barcode.WHITE) {
            return -1;
        }
        int deleteAdjusted = this.deletes.getBlackIndex(snapshotIndex);
        return this.inserts.getIndex(deleteAdjusted, Barcode.BLACK);
    }

    public boolean currentUpdated(int currentIndex) {
        if (currentIndex < 0 || currentIndex >= this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.inserts.get(currentIndex) == Barcode.WHITE) {
            return true;
        }
        int insertAdjusted = this.inserts.getBlackIndex(currentIndex);
        return this.updates.get(insertAdjusted) == Barcode.WHITE;
    }

    public void add(int currentIndex) {
        this.ensureCapacity(currentIndex + 1);
        if (currentIndex < 0 || currentIndex > this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        this.inserts.addWhite(currentIndex, 1);
    }

    public void remove(int currentIndex) {
        this.ensureCapacity(currentIndex + 1);
        if (currentIndex < 0 || currentIndex >= this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.inserts.get(currentIndex) == Barcode.BLACK) {
            int insertAdjusted = this.inserts.getBlackIndex(currentIndex);
            int deleteAdjusted = this.deletes.getIndex(insertAdjusted, Barcode.BLACK);
            this.deletes.set(deleteAdjusted, Barcode.WHITE, 1);
            this.updates.remove(deleteAdjusted, 1);
            this.inserts.remove(currentIndex, 1);
        } else {
            this.inserts.remove(currentIndex, 1);
        }
    }

    public void update(int currentIndex) {
        this.ensureCapacity(currentIndex + 1);
        if (currentIndex < 0 || currentIndex >= this.currentSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.inserts.get(currentIndex) == Barcode.BLACK) {
            int insertAdjusted = this.inserts.getBlackIndex(currentIndex);
            this.updates.set(insertAdjusted, Barcode.WHITE, 1);
        }
    }

    public int currentSize() {
        return this.inserts.size();
    }

    public int snapshotSize() {
        return this.deletes.size();
    }

    public String toString() {
        return "INSERTS: " + this.inserts + ", UPDATES: " + this.updates + ", DELETES: " + this.deletes;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public boolean isEmpty() {
        if (this.inserts.whiteSize() > 0) {
            return false;
        }
        if (this.deletes.whiteSize() > 0) {
            return false;
        }
        return this.updates.whiteSize() <= 0;
    }

    public class Iterator {
        int snapshotIndex = 0;
        int currentIndex = 0;
        int index = -1;
        int type = -1;

        private Iterator() {
        }

        public int getIndex() {
            return this.index;
        }

        public int getType() {
            return this.type;
        }

        public boolean next() {
            while (this.snapshotIndex < BarcodeListDeltas.this.deletes.size() || this.currentIndex < BarcodeListDeltas.this.inserts.size()) {
                if (this.snapshotIndex < BarcodeListDeltas.this.deletes.size() && BarcodeListDeltas.this.deletes.get(this.snapshotIndex) == Barcode.WHITE) {
                    this.index = this.currentIndex;
                    this.type = 0;
                    ++this.snapshotIndex;
                    return true;
                }
                if (this.currentIndex < BarcodeListDeltas.this.inserts.size() && BarcodeListDeltas.this.inserts.get(this.currentIndex) == Barcode.WHITE) {
                    this.index = this.currentIndex++;
                    this.type = 2;
                    return true;
                }
                if (this.snapshotIndex < BarcodeListDeltas.this.deletes.size()) {
                    int deleteAdjusted = BarcodeListDeltas.this.deletes.getBlackIndex(this.snapshotIndex);
                    if (BarcodeListDeltas.this.updates.get(deleteAdjusted) == Barcode.WHITE) {
                        this.index = this.currentIndex++;
                        this.type = 1;
                        ++this.snapshotIndex;
                        return true;
                    }
                }
                ++this.currentIndex;
                ++this.snapshotIndex;
            }
            return false;
        }

        public boolean hasNext() {
            return true;
        }
    }
}

