/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb;

import dotty.tools.dotc.semanticdb.ApplyTree;
import dotty.tools.dotc.semanticdb.FunctionTree;
import dotty.tools.dotc.semanticdb.IdTree;
import dotty.tools.dotc.semanticdb.LiteralTree;
import dotty.tools.dotc.semanticdb.MacroExpansionTree;
import dotty.tools.dotc.semanticdb.OriginalTree;
import dotty.tools.dotc.semanticdb.PPrint$package$;
import dotty.tools.dotc.semanticdb.PrinterSymtab;
import dotty.tools.dotc.semanticdb.Range;
import dotty.tools.dotc.semanticdb.SelectTree;
import dotty.tools.dotc.semanticdb.SymbolInformationPrinter;
import dotty.tools.dotc.semanticdb.Synthetic;
import dotty.tools.dotc.semanticdb.Tree;
import dotty.tools.dotc.semanticdb.Type;
import dotty.tools.dotc.semanticdb.TypeApplyTree;
import dotty.tools.dotc.util.SourceFile;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class SyntheticPrinter
extends SymbolInformationPrinter {
    private final SourceFile source;

    public SyntheticPrinter(PrinterSymtab symtab, SourceFile source) {
        this.source = source;
        super(symtab);
    }

    public String pprint(Synthetic synth) {
        StringBuilder stringBuilder;
        StringBuilder sb = new StringBuilder();
        SymbolInformationPrinter.InfoNotes notes = new SymbolInformationPrinter.InfoNotes();
        TreePrinter treePrinter = new TreePrinter(this, this.source, synth.range(), notes);
        Option<Range> option = synth.range();
        if (option instanceof Some) {
            Range range = (Range)((Some)option).value();
            PPrint$package$.MODULE$.processRange(sb, range);
            stringBuilder = sb.append(this.substring(this.source, range));
        } else if (None$.MODULE$.equals(option)) {
            stringBuilder = sb.append("[):");
        } else {
            throw new MatchError(option);
        }
        sb.append(" => ");
        sb.append(treePrinter.pprint(synth.tree()));
        return sb.toString();
    }

    public String dotty$tools$dotc$semanticdb$SyntheticPrinter$$substring(SourceFile source, Option<Range> range) {
        Option<Range> option = range;
        if (option instanceof Some) {
            Range range2 = (Range)((Some)option).value();
            return this.substring(source, range2);
        }
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        throw new MatchError(option);
    }

    private String substring(SourceFile source, Range range) {
        int start = source.lineToOffset(range.startLine()) + package$.MODULE$.min(range.startCharacter(), SyntheticPrinter.lineLength$1(source, range.startLine()));
        int end = source.lineToOffset(range.endLine()) + package$.MODULE$.min(range.endCharacter(), SyntheticPrinter.lineLength$1(source, range.endLine()));
        return new String(source.content(), start, end - start);
    }

    private static final int lineLength$1(SourceFile source$1, int line) {
        boolean isLastLine;
        boolean bl = isLastLine = source$1.lineToOffsetOpt(line).nonEmpty() && source$1.lineToOffsetOpt(line + 1).isEmpty();
        if (isLastLine) {
            return source$1.content().length - source$1.lineToOffset(line) - 1;
        }
        return source$1.lineToOffset(line + 1) - source$1.lineToOffset(line) - 1;
    }

    public static final /* synthetic */ void dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$rep$$anonfun$1(StringBuilder sb$2, String seq$1, Function1 f$1, Tuple2 x$1) {
        Object object = x$1._1();
        int n = BoxesRunTime.unboxToInt((Object)x$1._2());
        if (n != 0) {
            sb$2.append(seq$1);
        }
        f$1.apply(object);
    }

    public class TreePrinter
    extends SymbolInformationPrinter.InfoPrinter {
        private final SourceFile source;
        private final Option<Range> originalRange;
        private final /* synthetic */ SyntheticPrinter $outer;

        public TreePrinter(SyntheticPrinter $outer, SourceFile source, Option<Range> originalRange, SymbolInformationPrinter.InfoNotes notes) {
            this.source = source;
            this.originalRange = originalRange;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, notes);
        }

        public String pprint(Tree tree) {
            StringBuilder sb = new StringBuilder();
            this.processTree(tree, sb);
            return sb.toString();
        }

        private <T> void rep(Seq<T> xs, String seq, Function1<T, BoxedUnit> f, StringBuilder sb) {
            ((IterableOnceOps)xs.zipWithIndex()).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SyntheticPrinter.dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$_$rep$$anonfun$1(sb, seq, f, arg_0)));
        }

        private void processTree(Tree tree2, StringBuilder sb) {
            Tree tree3;
            block10: {
                Option<IdTree> option;
                while (true) {
                    if ((tree3 = tree2) instanceof ApplyTree) {
                        ApplyTree tree4 = (ApplyTree)tree3;
                        this.processTree(tree4.function(), sb);
                        sb.append("(");
                        this.rep((Seq)tree4.arguments(), ", ", (Function1)(JProcedure1 & Serializable)tree -> this.processTree((Tree)tree, sb), sb);
                        sb.append(")");
                        return;
                    }
                    if (tree3 instanceof FunctionTree) {
                        FunctionTree tree5 = (FunctionTree)tree3;
                        sb.append("{");
                        sb.append("(");
                        this.rep((Seq)tree5.parameters(), ", ", (Function1)(JProcedure1 & Serializable)tree -> this.processTree((Tree)tree, sb), sb);
                        sb.append(") =>");
                        this.processTree(tree5.body(), sb);
                        sb.append("}");
                        return;
                    }
                    if (tree3 instanceof IdTree) {
                        IdTree tree6 = (IdTree)tree3;
                        sb.append(this.pprintRef(tree6.symbol()));
                        return;
                    }
                    if (tree3 instanceof LiteralTree) {
                        LiteralTree tree7 = (LiteralTree)tree3;
                        sb.append(this.pprint(tree7.constant()));
                        return;
                    }
                    if (tree3 instanceof MacroExpansionTree) {
                        MacroExpansionTree tree8 = (MacroExpansionTree)tree3;
                        sb.append("(`macro-expandee` : `");
                        sb.append(this.pprint(tree8.tpe()));
                        sb.append(")");
                        return;
                    }
                    if (tree3 instanceof OriginalTree) {
                        OriginalTree tree9 = (OriginalTree)tree3;
                        Option<Range> option2 = tree9.range();
                        Option<Range> option3 = this.originalRange;
                        if (!(option2 != null ? !option2.equals(option3) : option3 != null) && this.originalRange.nonEmpty()) {
                            sb.append("*");
                            return;
                        }
                        sb.append("orig(");
                        sb.append(this.$outer.dotty$tools$dotc$semanticdb$SyntheticPrinter$$substring(this.source, tree9.range()));
                        sb.append(")");
                        return;
                    }
                    if (!(tree3 instanceof SelectTree)) break block10;
                    SelectTree tree10 = (SelectTree)tree3;
                    this.processTree(tree10.qualifier(), sb);
                    sb.append(".");
                    option = tree10.id();
                    if (!(option instanceof Some)) break;
                    IdTree tree11 = (IdTree)((Some)option).value();
                    tree2 = tree11;
                }
                if (None$.MODULE$.equals(option)) {
                    return;
                }
                throw new MatchError(option);
            }
            if (tree3 instanceof TypeApplyTree) {
                TypeApplyTree tree12 = (TypeApplyTree)tree3;
                this.processTree(tree12.function(), sb);
                sb.append("[");
                this.rep((Seq)tree12.typeArguments(), ", ", (Function1)(JProcedure1 & Serializable)t -> sb.append(this.pprint((Type)t)), sb);
                sb.append("]");
                return;
            }
            sb.append("<?>");
        }

        public final /* synthetic */ SyntheticPrinter dotty$tools$dotc$semanticdb$SyntheticPrinter$TreePrinter$$$outer() {
            return this.$outer;
        }
    }
}

