/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.typehandling;

import java.math.BigDecimal;
import org.codehaus.groovy.runtime.typehandling.NumberMath;

public class BigDecimalMath
extends NumberMath {
    public static final int MAX_DIVISION_SCALE = 10;
    protected static BigDecimalMath instance = new BigDecimalMath();

    private BigDecimalMath() {
    }

    protected Number absImpl(Number number) {
        return BigDecimalMath.toBigDecimal(number).abs();
    }

    protected Number addImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).add(BigDecimalMath.toBigDecimal(right));
    }

    protected Number subtractImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).subtract(BigDecimalMath.toBigDecimal(right));
    }

    protected Number multiplyImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).multiply(BigDecimalMath.toBigDecimal(right));
    }

    protected Number divideImpl(Number left, Number right) {
        BigDecimal bigLeft = BigDecimalMath.toBigDecimal(left);
        BigDecimal bigRight = BigDecimalMath.toBigDecimal(right);
        int scale = Math.max(bigLeft.scale(), bigRight.scale());
        return this.normalize(bigLeft.divide(bigRight, Math.max(scale, 10), 4));
    }

    protected int compareToImpl(Number left, Number right) {
        return BigDecimalMath.toBigDecimal(left).compareTo(BigDecimalMath.toBigDecimal(right));
    }

    private BigDecimal normalize(BigDecimal number) {
        if (number.signum() == 0) {
            return number.setScale(0);
        }
        try {
            while (true) {
                number = number.setScale(number.scale() - 1);
            }
        }
        catch (ArithmeticException e) {
            return number;
        }
    }

    protected Number negateImpl(Number left) {
        return BigDecimalMath.toBigDecimal(left).negate();
    }
}

