/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LogEntry {
    public final Severity severity;
    public final String source;
    public final int pid;
    public final String message;
    private static final Pattern PARSER = Pattern.compile("^([VDIWEF])/([^\\(\\s]+)\\s*\\(\\s*(\\d+)\\): (.+)$");

    public LogEntry(String string) {
        Matcher matcher = PARSER.matcher(string);
        if (!matcher.matches()) {
            throw new RuntimeException("I can't understand log entry\n" + string);
        }
        this.severity = Severity.fromChar(matcher.group(1).charAt(0));
        this.source = matcher.group(2);
        this.pid = Integer.parseInt(matcher.group(3));
        this.message = matcher.group(4);
    }

    public String toString() {
        return (Object)((Object)this.severity) + "/" + this.source + "(" + this.pid + "): " + this.message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        Verbose(false),
        Debug(false),
        Info(false),
        Warning(true),
        Error(true),
        Fatal(true);

        public final boolean useErrorStream;

        private Severity(boolean bl) {
            this.useErrorStream = bl;
        }

        private static Severity fromChar(char c) {
            if (c == 'V') {
                return Verbose;
            }
            if (c == 'D') {
                return Debug;
            }
            if (c == 'I') {
                return Info;
            }
            if (c == 'W') {
                return Warning;
            }
            if (c == 'E') {
                return Error;
            }
            if (c == 'F') {
                return Fatal;
            }
            throw new IllegalArgumentException("I don't know how to interpret '" + c + "' as a log severity");
        }
    }
}

