/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.table.AbstractTableModel;
import org.jfree.report.modules.misc.tablemodel.CloseableTableModel;
import org.jfree.report.modules.misc.tablemodel.TypeMapper;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class ScrollableResultSetTableModel
extends AbstractTableModel
implements CloseableTableModel {
    private ResultSet resultset;
    private ResultSetMetaData dbmd;
    private int rowCount;
    private final boolean labelMapMode;
    private Class[] types;

    public ScrollableResultSetTableModel(ResultSet resultSet, boolean bl) throws SQLException {
        this.labelMapMode = bl;
        if (resultSet != null) {
            this.updateResultSet(resultSet);
        } else {
            this.close();
        }
    }

    protected ScrollableResultSetTableModel(boolean bl) {
        this.labelMapMode = bl;
    }

    public boolean isLabelMapMode() {
        return this.labelMapMode;
    }

    public void updateResultSet(ResultSet resultSet) throws SQLException {
        if (this.resultset != null) {
            this.close();
        }
        this.resultset = resultSet;
        this.dbmd = resultSet.getMetaData();
        this.rowCount = resultSet.last() ? resultSet.getRow() : 0;
        this.fireTableStructureChanged();
    }

    @Override
    public void close() {
        if (this.resultset != null) {
            try {
                this.resultset.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.resultset = null;
        this.dbmd = null;
        this.rowCount = 0;
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        if (this.resultset == null) {
            return 0;
        }
        try {
            if (this.resultset.last()) {
                this.rowCount = this.resultset.getRow();
                if (this.rowCount == -1) {
                    this.rowCount = 0;
                }
            } else {
                this.rowCount = 0;
            }
        }
        catch (SQLException sQLException) {
            return 0;
        }
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        if (this.resultset == null) {
            return 0;
        }
        if (this.dbmd != null) {
            try {
                return this.dbmd.getColumnCount();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public String getColumnName(int n) {
        if (this.dbmd != null) {
            try {
                if (this.isLabelMapMode()) {
                    return this.dbmd.getColumnLabel(n + 1);
                }
                return this.dbmd.getColumnName(n + 1);
            }
            catch (SQLException sQLException) {
                DebugLog.log((Object)"ScrollableResultSetTableModel.getColumnName: SQLException.");
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.resultset != null) {
            try {
                this.resultset.absolute(n + 1);
                return this.resultset.getObject(n2 + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public Class getColumnClass(int n) {
        if (this.types != null) {
            return this.types[n];
        }
        if (this.dbmd != null) {
            try {
                this.types = TypeMapper.mapTypes(this.dbmd);
                return this.types[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Object.class;
    }

    public String getColumnClassName(int n) {
        if (this.dbmd != null) {
            return this.mckoiDBFixClassName(this.getColumnClass(n).getName());
        }
        return Object.class.getName();
    }

    private String mckoiDBFixClassName(String string) {
        if (string.startsWith("class ")) {
            return string.substring(6).trim();
        }
        return string;
    }
}

