/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.afm;

import org.pentaho.reporting.libraries.fonts.afm.AfmFont;
import org.pentaho.reporting.libraries.fonts.afm.AfmHeader;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class AfmFontRecord
implements FontSource,
FontIdentifier {
    private DefaultFontFamily fontFamily;
    private boolean bold;
    private boolean italic;
    private String fontFile;
    private boolean embeddable;

    public AfmFontRecord(AfmFont font, DefaultFontFamily fontFamily) {
        if (font == null) {
            throw new NullPointerException();
        }
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.embeddable = font.isEmbeddable();
        this.fontFile = font.getFilename();
        this.fontFamily = fontFamily;
        AfmHeader header = font.getHeader();
        this.bold = header.getWeight() > 400;
        this.italic = font.getDirectionSection(0).getItalicAngle() != 0.0;
    }

    @Override
    public FontFamily getFamily() {
        return this.fontFamily;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italic;
    }

    @Override
    public boolean isOblique() {
        return false;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public String getFontSource() {
        return this.fontFile;
    }

    @Override
    public boolean isEmbeddable() {
        return this.embeddable;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public FontType getFontType() {
        return FontType.AFM;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AfmFontRecord that = (AfmFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.embeddable != that.embeddable) {
            return false;
        }
        if (this.italic != that.italic) {
            return false;
        }
        if (!this.fontFamily.equals(that.fontFamily)) {
            return false;
        }
        return this.fontFile.equals(that.fontFile);
    }

    @Override
    public int hashCode() {
        int result = this.fontFamily.hashCode();
        result = 31 * result + (this.bold ? 1 : 0);
        result = 31 * result + (this.italic ? 1 : 0);
        result = 31 * result + this.fontFile.hashCode();
        result = 31 * result + (this.embeddable ? 1 : 0);
        return result;
    }
}

