% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutationProfiling.R
\name{plotSlideWindowTune}
\alias{plotSlideWindowTune}
\title{Visualize parameter tuning for sliding window approach}
\usage{
plotSlideWindowTune(
  tuneList,
  plotFiltered = c("filtered", "remaining", "per_mutation"),
  percentage = FALSE,
  jitter.x = FALSE,
  jitter.x.amt = 0.1,
  jitter.y = FALSE,
  jitter.y.amt = 0.1,
  pchs = 1:length(tuneList),
  ltys = 1:length(tuneList),
  cols = 1,
  plotLegend = TRUE,
  legendPos = "topright",
  legendHoriz = FALSE,
  legendCex = 1,
  title = NULL,
  returnRaw = FALSE
)
}
\arguments{
\item{tuneList}{a list of logical matrices returned by \link{slideWindowTune}.}

\item{plotFiltered}{whether to plot the number of filtered ('filtered'), 
or remaining ('remaining') sequences for each mutation threshold. 
Use 'per_mutation' to plot the number of sequences at each mutation
value. Default is \code{'filtered'}.}

\item{percentage}{whether to plot on the y-axis the percentage of filtered sequences
(as opposed to the absolute number). Default is \code{FALSE}.}

\item{jitter.x}{whether to jitter x-axis values. Default is \code{FALSE}.}

\item{jitter.x.amt}{amount of jittering to be applied on x-axis values if 
\code{jitter.x=TRUE}. Default is 0.1.}

\item{jitter.y}{whether to jitter y-axis values. Default is \code{FALSE}.}

\item{jitter.y.amt}{amount of jittering to be applied on y-axis values if 
\code{jitter.y=TRUE}. Default is 0.1.}

\item{pchs}{point types to pass on to \link{plot}. Default is
\code{1:length(tuneList)}.}

\item{ltys}{line types to pass on to \link{plot}. Default is
\code{1:length(tuneList)}.}

\item{cols}{colors to pass on to \link{plot}.}

\item{plotLegend}{whether to plot legend. Default is \code{TRUE}.}

\item{legendPos}{position of legend to pass on to \link{legend}. Can be either a
numeric vector specifying x-y coordinates, or one of 
\code{"topright"}, \code{"center"}, etc. Default is \code{"topright"}.}

\item{legendHoriz}{whether to make legend horizontal. Default is \code{FALSE}.}

\item{legendCex}{numeric values by which legend should be magnified relative to 1.}

\item{title}{plot main title. Default is NULL (no title)}

\item{returnRaw}{Return a data.frame with sequence counts (TRUE) or a
plot. Default is \code{FALSE}.}
}
\description{
Visualize results from \link{slideWindowTune}
}
\details{
For each \code{windowSize}, if \code{plotFiltered='filtered'}, the x-axis 
          represents a mutation threshold range, and the y-axis the number of
          sequences that have at least that number of mutations. If 
          \code{plotFiltered='remaining'}, the y-axis represents the number of sequences
          that have less mutations than the mutation threshold range. For the same
          window size, a sequence can be included in the counts for different
          mutation thresholds. For example, sequence "CCACCAAAA" with germline
          "AAAAAAAAA" has 4 mutations. This sequence has at least 2 mutations 
          and at least 3 mutations, in a window of size 4. the sequence will
          be included in the sequence count for mutation thresholds 2 and 3.
          If \code{plotFiltered='per_mutation'}, the sequences are counted only once 
          for each window size, at their largest mutation threshold. The above 
          example sequence would be included in the sequence count for 
          mutation threshold 3. 
          
          When plotting, a user-defined \code{amount} of jittering can be applied on values plotted
          on either axis or both axes via adjusting \code{jitter.x}, \code{jitter.y}, 
          \code{jitter.x.amt} and \code{jitter.y.amt}. This may be help with visually distinguishing
          lines for different window sizes in case they are very close or identical to each other. 
          If plotting percentages (\code{percentage=TRUE}) and using jittering on the y-axis values 
          (\code{jitter.y=TRUE}), it is strongly recommended that \code{jitter.y.amt} be set very
          small (e.g. 0.01). 
          
          \code{NA} for a combination of \code{mutThresh} and \code{windowSize} where 
          \code{mutThresh} is greater than \code{windowSize} will not be plotted.
}
\examples{
# Use an entry in the example data for input and germline sequence
data(ExampleDb, package="alakazam")

# Try out thresholds of 2-4 mutations in window sizes of 3-5 nucleotides 
# on a subset of ExampleDb
tuneList <- slideWindowTune(db = ExampleDb[1:10, ], 
                           mutThreshRange = 2:4, windowSizeRange = 3:5,
                           verbose = FALSE)

# Visualize
# Plot numbers of sequences filtered without jittering y-axis values
plotSlideWindowTune(tuneList, pchs=1:3, ltys=1:3, cols=1:3, 
                    plotFiltered='filtered', jitter.y=FALSE)
                    
# Notice that some of the lines overlap
# Jittering could help
plotSlideWindowTune(tuneList, pchs=1:3, ltys=1:3, cols=1:3,
                    plotFiltered='filtered', jitter.y=TRUE)
                    
# Plot numbers of sequences remaining instead of filtered
plotSlideWindowTune(tuneList, pchs=1:3, ltys=1:3, cols=1:3, 
                    plotFiltered='remaining', jitter.y=TRUE, 
                    legendPos="bottomright")
                    
# Plot percentages of sequences filtered with a tiny amount of jittering
plotSlideWindowTune(tuneList, pchs=1:3, ltys=1:3, cols=1:3,
                    plotFiltered='filtered', percentage=TRUE, 
                    jitter.y=TRUE, jitter.y.amt=0.01)
}
\seealso{
See \link{slideWindowTune} for how to get \code{tuneList}. See \link{jitter} for 
          use of \code{amount} of jittering.
}
