
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Standard_GUID.hxx>
#include <Quantity_Color.hxx>
#include <Quantity_ColorRGBA.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_HAsciiString.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <XCAFDimTolObjects_DatumObject.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_HAsciiString.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <XCAFDimTolObjects_DimensionObject.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <XCAFDoc_ColorTool.hxx>
#include <XCAFDoc_ClippingPlaneTool.hxx>
#include <XCAFDoc_LayerTool.hxx>
#include <XCAFDoc_DimTolTool.hxx>
#include <XCAFDoc_MaterialTool.hxx>
#include <XCAFDoc_NotesTool.hxx>
#include <XCAFDoc_ViewTool.hxx>
#include <XCAFDoc_VisMaterialTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDoc_VisMaterial.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <XCAFDimTolObjects_GeomToleranceObject.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <TDF_DataSet.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDoc_GraphNode.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Standard_GUID.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_HAsciiString.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <OSD_File.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <OSD_File.hxx>
#include <Standard_GUID.hxx>
#include <XCAFDoc_Note.hxx>
#include <XCAFDoc_AssemblyItemId.hxx>
#include <XCAFDoc_AssemblyItemRef.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <TDF_RelocationTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <XCAFDoc_GraphNode.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <TDF_Label.hxx>
#include <XCAFView_Object.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_Aspects.hxx>
#include <Graphic3d_MaterialAspect.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Graphic3d_Aspects.hxx>
#include <Graphic3d_MaterialAspect.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <XCAFDoc_VisMaterial.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>

// module includes
#include <XCAFDoc.hxx>
#include <XCAFDoc_Area.hxx>
#include <XCAFDoc_AssemblyGraph.hxx>
#include <XCAFDoc_AssemblyItemId.hxx>
#include <XCAFDoc_AssemblyItemRef.hxx>
#include <XCAFDoc_AssemblyIterator.hxx>
#include <XCAFDoc_AssemblyTool.hxx>
#include <XCAFDoc_Centroid.hxx>
#include <XCAFDoc_ClippingPlaneTool.hxx>
#include <XCAFDoc_Color.hxx>
#include <XCAFDoc_ColorTool.hxx>
#include <XCAFDoc_ColorType.hxx>
#include <XCAFDoc_DataMapIteratorOfDataMapOfShapeLabel.hxx>
#include <XCAFDoc_DataMapOfShapeLabel.hxx>
#include <XCAFDoc_Datum.hxx>
#include <XCAFDoc_Dimension.hxx>
#include <XCAFDoc_DimTol.hxx>
#include <XCAFDoc_DimTolTool.hxx>
#include <XCAFDoc_DocumentTool.hxx>
#include <XCAFDoc_Editor.hxx>
#include <XCAFDoc_GeomTolerance.hxx>
#include <XCAFDoc_GraphNode.hxx>
#include <XCAFDoc_GraphNodeSequence.hxx>
#include <XCAFDoc_LayerTool.hxx>
#include <XCAFDoc_LengthUnit.hxx>
#include <XCAFDoc_Location.hxx>
#include <XCAFDoc_Material.hxx>
#include <XCAFDoc_MaterialTool.hxx>
#include <XCAFDoc_Note.hxx>
#include <XCAFDoc_NoteBalloon.hxx>
#include <XCAFDoc_NoteBinData.hxx>
#include <XCAFDoc_NoteComment.hxx>
#include <XCAFDoc_NotesTool.hxx>
#include <XCAFDoc_PartId.hxx>
#include <XCAFDoc_ShapeMapTool.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <XCAFDoc_View.hxx>
#include <XCAFDoc_ViewTool.hxx>
#include <XCAFDoc_VisMaterial.hxx>
#include <XCAFDoc_VisMaterialCommon.hxx>
#include <XCAFDoc_VisMaterialPBR.hxx>
#include <XCAFDoc_VisMaterialTool.hxx>
#include <XCAFDoc_Volume.hxx>

// template related includes

// ./opencascade/XCAFDoc_DataMapOfShapeLabel.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFDoc_DataMapOfShapeLabel.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFDoc_GraphNodeSequence.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XCAFDoc(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XCAFDoc"));
py::object klass;

//Python trampoline classes
    class Py_XCAFDoc_Note : public XCAFDoc_Note{
    public:
        using XCAFDoc_Note::XCAFDoc_Note;


        // public pure virtual

        const Standard_GUID & ID() const  override { PYBIND11_OVERLOAD_PURE(const Standard_GUID &,TDF_Attribute,ID,) };
        opencascade::handle<TDF_Attribute> NewEmpty() const  override { PYBIND11_OVERLOAD_PURE(opencascade::handle<TDF_Attribute>,TDF_Attribute,NewEmpty,) };

        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class XCAFDoc from ./opencascade/XCAFDoc.hxx
    klass = m.attr("XCAFDoc");

    // default constructor
    register_default_constructor<XCAFDoc , shared_ptr<XCAFDoc>>(m,"XCAFDoc");

    // nested enums

    static_cast<py::class_<XCAFDoc , shared_ptr<XCAFDoc>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AssemblyGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::AssemblyGUID),
                    R"#(class for containing GraphNodes. Returns GUID for UAttribute identifying assembly)#" 
          )
        .def_static("ShapeRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ShapeRefGUID),
                    R"#(Returns GUID for TreeNode representing assembly link)#" 
          )
        .def_static("ColorRefGUID_s",
                    (const Standard_GUID & (*)( const XCAFDoc_ColorType  ) ) static_cast<const Standard_GUID & (*)( const XCAFDoc_ColorType  ) >(&XCAFDoc::ColorRefGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of colors)#"  , py::arg("type")
          )
        .def_static("DimTolRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::DimTolRefGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of DGT)#" 
          )
        .def_static("DimensionRefFirstGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::DimensionRefFirstGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of Dimension)#" 
          )
        .def_static("DimensionRefSecondGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::DimensionRefSecondGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of Dimension)#" 
          )
        .def_static("GeomToleranceRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::GeomToleranceRefGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of GeomTolerance)#" 
          )
        .def_static("DatumRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::DatumRefGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of datum)#" 
          )
        .def_static("DatumTolRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::DatumTolRefGUID),
                    R"#(Return GUIDs for TreeNode representing connections Datum-Toler)#" 
          )
        .def_static("LayerRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::LayerRefGUID),
                    R"#(None)#" 
          )
        .def_static("MaterialRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::MaterialRefGUID),
                    R"#(None)#" 
          )
        .def_static("VisMaterialRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::VisMaterialRefGUID),
                    R"#(Return GUID for TreeNode representing Visualization Material.)#" 
          )
        .def_static("NoteRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::NoteRefGUID),
                    R"#(Return GUIDs for representing notes)#" 
          )
        .def_static("InvisibleGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::InvisibleGUID),
                    R"#(None)#" 
          )
        .def_static("ColorByLayerGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ColorByLayerGUID),
                    R"#(None)#" 
          )
        .def_static("ExternRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ExternRefGUID),
                    R"#(Returns GUID for UAttribute identifying external reference on no-step file)#" 
          )
        .def_static("SHUORefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::SHUORefGUID),
                    R"#(Returns GUID for UAttribute identifying specified higher usage occurrence)#" 
          )
        .def_static("ViewRefGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ViewRefGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of View)#" 
          )
        .def_static("ViewRefShapeGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ViewRefShapeGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of View)#" 
          )
        .def_static("ViewRefGDTGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ViewRefGDTGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of View)#" 
          )
        .def_static("ViewRefPlaneGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ViewRefPlaneGUID),
                    R"#(Return GUIDs for TreeNode representing specified types of View)#" 
          )
        .def_static("ViewRefNoteGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ViewRefNoteGUID),
                    R"#(Return GUIDs for GraphNode representing specified types of View)#" 
          )
        .def_static("ViewRefAnnotationGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::ViewRefAnnotationGUID),
                    R"#(None)#" 
          )
        .def_static("LockGUID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc::LockGUID),
                    R"#(Returns GUID for UAttribute identifying lock flag)#" 
          )
        .def_static("AttributeInfo_s",
                    (TCollection_AsciiString (*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<TCollection_AsciiString (*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc::AttributeInfo),
                    R"#(Prints attribute information into a string.)#"  , py::arg("theAtt")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XCAFDoc_Area from ./opencascade/XCAFDoc_Area.hxx
    klass = m.attr("XCAFDoc_Area");


    // nested enums

    static_cast<py::class_<XCAFDoc_Area ,opencascade::handle<XCAFDoc_Area>  , TDataStd_Real >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Area::*)( const Standard_Real  ) ) static_cast<void (XCAFDoc_Area::*)( const Standard_Real  ) >(&XCAFDoc_Area::Set),
             R"#(Sets a value of volume)#"  , py::arg("vol")
          )
        .def("Get",
             (Standard_Real (XCAFDoc_Area::*)() const) static_cast<Standard_Real (XCAFDoc_Area::*)() const>(&XCAFDoc_Area::Get),
             R"#(None)#" 
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_Area::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_Area::*)( std::ostream &  ) const>(&XCAFDoc_Area::Dump),
             R"#(None)#"  , py::arg("anOS")
          )
        .def("DumpJson",
             (void (XCAFDoc_Area::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Area::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Area::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Area::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Area::*)() const>(&XCAFDoc_Area::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Area::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Area> (*)( const TDF_Label & ,  const Standard_Real  ) ) static_cast<opencascade::handle<XCAFDoc_Area> (*)( const TDF_Label & ,  const Standard_Real  ) >(&XCAFDoc_Area::Set),
                    R"#(Find, or create, an Area attribute and set its value)#"  , py::arg("label"),  py::arg("area")
          )
        .def_static("Get_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  Standard_Real &  ) >(&XCAFDoc_Area::Get),
                    R"#(Returns volume of area as argument and success status returns false if no such attribute at the <label>)#"  , py::arg("label"),  py::arg("area")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Area::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Area::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Area::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Area::*)() const>(&XCAFDoc_Area::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Area::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Area::*)() const>(&XCAFDoc_Area::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_AssemblyGraph from ./opencascade/XCAFDoc_AssemblyGraph.hxx
    klass = m.attr("XCAFDoc_AssemblyGraph");


    // nested enums
        py::enum_<XCAFDoc_AssemblyGraph::NodeType>(klass, "NodeType_e", R"#(Type of the graph node.)#")
            .value("NodeType_UNDEFINED", XCAFDoc_AssemblyGraph::NodeType::NodeType_UNDEFINED)
            .value("NodeType_AssemblyRoot", XCAFDoc_AssemblyGraph::NodeType::NodeType_AssemblyRoot)
            .value("NodeType_Subassembly", XCAFDoc_AssemblyGraph::NodeType::NodeType_Subassembly)
            .value("NodeType_Occurrence", XCAFDoc_AssemblyGraph::NodeType::NodeType_Occurrence)
            .value("NodeType_Part", XCAFDoc_AssemblyGraph::NodeType::NodeType_Part)
            .value("NodeType_Subshape", XCAFDoc_AssemblyGraph::NodeType::NodeType_Subshape).export_values();

    static_cast<py::class_<XCAFDoc_AssemblyGraph ,opencascade::handle<XCAFDoc_AssemblyGraph>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<TDocStd_Document> & >()  , py::arg("theDoc") )
        .def(py::init< const TDF_Label & >()  , py::arg("theLabel") )
    // custom constructors
    // methods
        .def("IsDirectLink",
             (Standard_Boolean (XCAFDoc_AssemblyGraph::*)( const Standard_Integer ,  const Standard_Integer  ) const) static_cast<Standard_Boolean (XCAFDoc_AssemblyGraph::*)( const Standard_Integer ,  const Standard_Integer  ) const>(&XCAFDoc_AssemblyGraph::IsDirectLink),
             R"#(Checks whether the assembly graph contains (n1, n2) directed link.)#"  , py::arg("theNode1"),  py::arg("theNode2")
          )
        .def("HasChildren",
             (Standard_Boolean (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const) static_cast<Standard_Boolean (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const>(&XCAFDoc_AssemblyGraph::HasChildren),
             R"#(Checks whether direct children exist for the given node.)#"  , py::arg("theNode")
          )
        .def("GetChildren",
             (const TColStd_PackedMapOfInteger & (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const) static_cast<const TColStd_PackedMapOfInteger & (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const>(&XCAFDoc_AssemblyGraph::GetChildren),
             R"#(Returns IDs of child nodes for the given node.)#"  , py::arg("theNode")
          )
        .def("GetNodeType",
             (XCAFDoc_AssemblyGraph::NodeType (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const) static_cast<XCAFDoc_AssemblyGraph::NodeType (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const>(&XCAFDoc_AssemblyGraph::GetNodeType),
             R"#(Returns the node type from NodeType enum.)#"  , py::arg("theNode")
          )
        .def("GetNode",
             (const TDF_Label & (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const) static_cast<const TDF_Label & (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const>(&XCAFDoc_AssemblyGraph::GetNode),
             R"#(returns object ID by node ID.)#"  , py::arg("theNode")
          )
        .def("NbNodes",
             (Standard_Integer (XCAFDoc_AssemblyGraph::*)() const) static_cast<Standard_Integer (XCAFDoc_AssemblyGraph::*)() const>(&XCAFDoc_AssemblyGraph::NbNodes),
             R"#(Returns the number of graph nodes.)#" 
          )
        .def("NbLinks",
             (Standard_Integer (XCAFDoc_AssemblyGraph::*)() const) static_cast<Standard_Integer (XCAFDoc_AssemblyGraph::*)() const>(&XCAFDoc_AssemblyGraph::NbLinks),
             R"#(Returns the number of graph links.)#" 
          )
        .def("NbOccurrences",
             (Standard_Integer (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const) static_cast<Standard_Integer (XCAFDoc_AssemblyGraph::*)( const Standard_Integer  ) const>(&XCAFDoc_AssemblyGraph::NbOccurrences),
             R"#(Returns quantity of part usage occurrences.)#"  , py::arg("theNode")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetShapeTool",
             (const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_AssemblyGraph::*)() const) static_cast<const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_AssemblyGraph::*)() const>(&XCAFDoc_AssemblyGraph::GetShapeTool),
             R"#(Returns Document shape tool.)#"
             
         )
       .def("GetRoots",
             (const TColStd_PackedMapOfInteger & (XCAFDoc_AssemblyGraph::*)() const) static_cast<const TColStd_PackedMapOfInteger & (XCAFDoc_AssemblyGraph::*)() const>(&XCAFDoc_AssemblyGraph::GetRoots),
             R"#(Returns IDs of the root nodes.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("GetNodes",
             (const TDF_LabelIndexedMap & (XCAFDoc_AssemblyGraph::*)() const) static_cast<const TDF_LabelIndexedMap & (XCAFDoc_AssemblyGraph::*)() const>(&XCAFDoc_AssemblyGraph::GetNodes),
             R"#(Returns the unordered set of graph nodes.)#"
             
         )
       .def("GetLinks",
             (const XCAFDoc_AssemblyGraph::AdjacencyMap & (XCAFDoc_AssemblyGraph::*)() const) static_cast<const XCAFDoc_AssemblyGraph::AdjacencyMap & (XCAFDoc_AssemblyGraph::*)() const>(&XCAFDoc_AssemblyGraph::GetLinks),
             R"#(Returns the collection of graph links in the form of adjacency matrix.)#"
             
         )
;

    // Class XCAFDoc_AssemblyItemId from ./opencascade/XCAFDoc_AssemblyItemId.hxx
    klass = m.attr("XCAFDoc_AssemblyItemId");


    // nested enums

    static_cast<py::class_<XCAFDoc_AssemblyItemId , shared_ptr<XCAFDoc_AssemblyItemId>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const NCollection_List<TCollection_AsciiString> & >()  , py::arg("thePath") )
        .def(py::init< const TCollection_AsciiString & >()  , py::arg("theString") )
    // custom constructors
    // methods
        .def("Init",
             (void (XCAFDoc_AssemblyItemId::*)(  const NCollection_List<TCollection_AsciiString> &  ) ) static_cast<void (XCAFDoc_AssemblyItemId::*)(  const NCollection_List<TCollection_AsciiString> &  ) >(&XCAFDoc_AssemblyItemId::Init),
             R"#(Initializes the item ID from a list of strings, where every string is a label entry.)#"  , py::arg("thePath")
          )
        .def("Init",
             (void (XCAFDoc_AssemblyItemId::*)( const TCollection_AsciiString &  ) ) static_cast<void (XCAFDoc_AssemblyItemId::*)( const TCollection_AsciiString &  ) >(&XCAFDoc_AssemblyItemId::Init),
             R"#(Initializes the item ID from a formatted path, where label entries are separated by '/' symbol.)#"  , py::arg("theString")
          )
        .def("IsNull",
             (Standard_Boolean (XCAFDoc_AssemblyItemId::*)() const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemId::*)() const>(&XCAFDoc_AssemblyItemId::IsNull),
             R"#(Returns true if the full path is empty, otherwise - false.)#" 
          )
        .def("Nullify",
             (void (XCAFDoc_AssemblyItemId::*)() ) static_cast<void (XCAFDoc_AssemblyItemId::*)() >(&XCAFDoc_AssemblyItemId::Nullify),
             R"#(Clears the full path.)#" 
          )
        .def("IsChild",
             (Standard_Boolean (XCAFDoc_AssemblyItemId::*)( const XCAFDoc_AssemblyItemId &  ) const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemId::*)( const XCAFDoc_AssemblyItemId &  ) const>(&XCAFDoc_AssemblyItemId::IsChild),
             R"#(Checks if this item is a child of the given item.)#"  , py::arg("theOther")
          )
        .def("IsDirectChild",
             (Standard_Boolean (XCAFDoc_AssemblyItemId::*)( const XCAFDoc_AssemblyItemId &  ) const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemId::*)( const XCAFDoc_AssemblyItemId &  ) const>(&XCAFDoc_AssemblyItemId::IsDirectChild),
             R"#(Checks if this item is a direct child of the given item.)#"  , py::arg("theOther")
          )
        .def("IsEqual",
             (Standard_Boolean (XCAFDoc_AssemblyItemId::*)( const XCAFDoc_AssemblyItemId &  ) const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemId::*)( const XCAFDoc_AssemblyItemId &  ) const>(&XCAFDoc_AssemblyItemId::IsEqual),
             R"#(Checks for item IDs equality.)#"  , py::arg("theOther")
          )
        .def("ToString",
             (TCollection_AsciiString (XCAFDoc_AssemblyItemId::*)() const) static_cast<TCollection_AsciiString (XCAFDoc_AssemblyItemId::*)() const>(&XCAFDoc_AssemblyItemId::ToString),
             R"#(Returns the full pass as a formatted string.)#" 
          )
        .def("DumpJson",
             (void (XCAFDoc_AssemblyItemId::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_AssemblyItemId::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_AssemblyItemId::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetPath",
             (const TColStd_ListOfAsciiString & (XCAFDoc_AssemblyItemId::*)() const) static_cast<const TColStd_ListOfAsciiString & (XCAFDoc_AssemblyItemId::*)() const>(&XCAFDoc_AssemblyItemId::GetPath),
             R"#(Returns the full path as a list of label entries.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class XCAFDoc_AssemblyItemRef from ./opencascade/XCAFDoc_AssemblyItemRef.hxx
    klass = m.attr("XCAFDoc_AssemblyItemRef");


    // nested enums

    static_cast<py::class_<XCAFDoc_AssemblyItemRef ,opencascade::handle<XCAFDoc_AssemblyItemRef>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsOrphan",
             (Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::IsOrphan),
             R"#(Checks if the reference points to a really existing item in XDE document.)#" 
          )
        .def("HasExtraRef",
             (Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::HasExtraRef),
             R"#(Checks if the reference points on an item's shapeindex or attribute.)#" 
          )
        .def("IsGUID",
             (Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::IsGUID),
             R"#(Checks is the reference points to an item's attribute.)#" 
          )
        .def("IsSubshapeIndex",
             (Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const) static_cast<Standard_Boolean (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::IsSubshapeIndex),
             R"#(Checks is the reference points to an item's subshape.)#" 
          )
        .def("GetGUID",
             (Standard_GUID (XCAFDoc_AssemblyItemRef::*)() const) static_cast<Standard_GUID (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::GetGUID),
             R"#(Returns the assembly item's attribute that the reference points to. If the reference doesn't point to an attribute, returns an empty GUID.)#" 
          )
        .def("GetSubshapeIndex",
             (Standard_Integer (XCAFDoc_AssemblyItemRef::*)() const) static_cast<Standard_Integer (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::GetSubshapeIndex),
             R"#(Returns the assembly item's subshape that the reference points to. If the reference doesn't point to a subshape, returns 0.)#" 
          )
        .def("SetItem",
             (void (XCAFDoc_AssemblyItemRef::*)( const XCAFDoc_AssemblyItemId &  ) ) static_cast<void (XCAFDoc_AssemblyItemRef::*)( const XCAFDoc_AssemblyItemId &  ) >(&XCAFDoc_AssemblyItemRef::SetItem),
             R"#(Sets the assembly item ID that the reference points to. Extra reference data (if any) will be cleared.)#"  , py::arg("theItemId")
          )
        .def("SetItem",
             (void (XCAFDoc_AssemblyItemRef::*)(  const NCollection_List<TCollection_AsciiString> &  ) ) static_cast<void (XCAFDoc_AssemblyItemRef::*)(  const NCollection_List<TCollection_AsciiString> &  ) >(&XCAFDoc_AssemblyItemRef::SetItem),
             R"#(Sets the assembly item ID from a list of label entries that the reference points to. Extra reference data (if any) will be cleared.)#"  , py::arg("thePath")
          )
        .def("SetItem",
             (void (XCAFDoc_AssemblyItemRef::*)( const TCollection_AsciiString &  ) ) static_cast<void (XCAFDoc_AssemblyItemRef::*)( const TCollection_AsciiString &  ) >(&XCAFDoc_AssemblyItemRef::SetItem),
             R"#(Sets the assembly item ID from a formatted path that the reference points to. Extra reference data (if any) will be cleared.)#"  , py::arg("theString")
          )
        .def("SetGUID",
             (void (XCAFDoc_AssemblyItemRef::*)( const Standard_GUID &  ) ) static_cast<void (XCAFDoc_AssemblyItemRef::*)( const Standard_GUID &  ) >(&XCAFDoc_AssemblyItemRef::SetGUID),
             R"#(Sets the assembly item's label attribute that the reference points to. The base assembly item will not change.)#"  , py::arg("theAttrGUID")
          )
        .def("SetSubshapeIndex",
             (void (XCAFDoc_AssemblyItemRef::*)( Standard_Integer  ) ) static_cast<void (XCAFDoc_AssemblyItemRef::*)( Standard_Integer  ) >(&XCAFDoc_AssemblyItemRef::SetSubshapeIndex),
             R"#(Sets the assembly item's subshape that the reference points to. The base assembly item will not change.)#"  , py::arg("theShapeIndex")
          )
        .def("ClearExtraRef",
             (void (XCAFDoc_AssemblyItemRef::*)() ) static_cast<void (XCAFDoc_AssemblyItemRef::*)() >(&XCAFDoc_AssemblyItemRef::ClearExtraRef),
             R"#(Reverts the reference to empty state.)#" 
          )
        .def("DumpJson",
             (void (XCAFDoc_AssemblyItemRef::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_AssemblyItemRef::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_AssemblyItemRef::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_AssemblyItemRef::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::NewEmpty),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_AssemblyItemRef::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_AssemblyItemRef::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_AssemblyItemRef::Restore),
             R"#(None)#"  , py::arg("theAttrFrom")
          )
        .def("Paste",
             (void (XCAFDoc_AssemblyItemRef::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_AssemblyItemRef::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_AssemblyItemRef::Paste),
             R"#(None)#"  , py::arg("theAttrInto"),  py::arg("theRT")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_AssemblyItemRef::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_AssemblyItemRef::*)( std::ostream &  ) const>(&XCAFDoc_AssemblyItemRef::Dump),
             R"#(None)#"  , py::arg("theOS")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_AssemblyItemRef::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_AssemblyItemRef::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_AssemblyItemRef::GetID),
                    R"#(None)#" 
          )
        .def_static("Get_s",
                    (opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label &  ) >(&XCAFDoc_AssemblyItemRef::Get),
                    R"#(Finds a reference attribute on the given label and returns it, if it is found)#"  , py::arg("theLabel")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId &  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId &  ) >(&XCAFDoc_AssemblyItemRef::Set),
                    R"#(Create (if not exist) a reference to an assembly item.)#"  , py::arg("theLabel"),  py::arg("theItemId")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_GUID &  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_GUID &  ) >(&XCAFDoc_AssemblyItemRef::Set),
                    R"#(Create (if not exist) a reference to an assembly item's label attribute.)#"  , py::arg("theLabel"),  py::arg("theItemId"),  py::arg("theGUID")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_Integer  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_Integer  ) >(&XCAFDoc_AssemblyItemRef::Set),
                    R"#(Create (if not exist) a reference to an assembly item's subshape.)#"  , py::arg("theLabel"),  py::arg("theItemId"),  py::arg("theShapeIndex")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_AssemblyItemRef::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::DynamicType),
             R"#(None)#"
             
         )
       .def("GetItem",
             (const XCAFDoc_AssemblyItemId & (XCAFDoc_AssemblyItemRef::*)() const) static_cast<const XCAFDoc_AssemblyItemId & (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::GetItem),
             R"#(Returns the assembly item ID that the reference points to.)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_AssemblyItemRef::*)() const) static_cast<const Standard_GUID & (XCAFDoc_AssemblyItemRef::*)() const>(&XCAFDoc_AssemblyItemRef::ID),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_AssemblyIterator from ./opencascade/XCAFDoc_AssemblyIterator.hxx
    klass = m.attr("XCAFDoc_AssemblyIterator");


    // nested enums

    static_cast<py::class_<XCAFDoc_AssemblyIterator , shared_ptr<XCAFDoc_AssemblyIterator>  >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<TDocStd_Document> &,const Standard_Integer >()  , py::arg("theDoc"),  py::arg("theLevel")=static_cast<const Standard_Integer>(INT_MAX) )
        .def(py::init< const opencascade::handle<TDocStd_Document> &,const XCAFDoc_AssemblyItemId &,const Standard_Integer >()  , py::arg("theDoc"),  py::arg("theRoot"),  py::arg("theLevel")=static_cast<const Standard_Integer>(INT_MAX) )
    // custom constructors
    // methods
        .def("More",
             (Standard_Boolean (XCAFDoc_AssemblyIterator::*)() const) static_cast<Standard_Boolean (XCAFDoc_AssemblyIterator::*)() const>(&XCAFDoc_AssemblyIterator::More),
             R"#(Returns true if there is still something to iterate, false -- otherwise.)#" 
          )
        .def("Next",
             (void (XCAFDoc_AssemblyIterator::*)() ) static_cast<void (XCAFDoc_AssemblyIterator::*)() >(&XCAFDoc_AssemblyIterator::Next),
             R"#(Moves depth-first iterator to the next position.)#" 
          )
        .def("Current",
             (XCAFDoc_AssemblyItemId (XCAFDoc_AssemblyIterator::*)() const) static_cast<XCAFDoc_AssemblyItemId (XCAFDoc_AssemblyIterator::*)() const>(&XCAFDoc_AssemblyIterator::Current),
             R"#(Returns current item.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XCAFDoc_AssemblyTool from ./opencascade/XCAFDoc_AssemblyTool.hxx
    klass = m.attr("XCAFDoc_AssemblyTool");

    // default constructor
    register_default_constructor<XCAFDoc_AssemblyTool , shared_ptr<XCAFDoc_AssemblyTool>>(m,"XCAFDoc_AssemblyTool");

    // nested enums

    static_cast<py::class_<XCAFDoc_AssemblyTool , shared_ptr<XCAFDoc_AssemblyTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XCAFDoc_Centroid from ./opencascade/XCAFDoc_Centroid.hxx
    klass = m.attr("XCAFDoc_Centroid");


    // nested enums

    static_cast<py::class_<XCAFDoc_Centroid ,opencascade::handle<XCAFDoc_Centroid>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Centroid::*)( const gp_Pnt &  ) ) static_cast<void (XCAFDoc_Centroid::*)( const gp_Pnt &  ) >(&XCAFDoc_Centroid::Set),
             R"#(None)#"  , py::arg("pnt")
          )
        .def("Get",
             (gp_Pnt (XCAFDoc_Centroid::*)() const) static_cast<gp_Pnt (XCAFDoc_Centroid::*)() const>(&XCAFDoc_Centroid::Get),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_Centroid::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_Centroid::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_Centroid::Restore),
             R"#(None)#"  , py::arg("With")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Centroid::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Centroid::*)() const>(&XCAFDoc_Centroid::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (void (XCAFDoc_Centroid::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_Centroid::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_Centroid::Paste),
             R"#(None)#"  , py::arg("Into"),  py::arg("RT")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_Centroid::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_Centroid::*)( std::ostream &  ) const>(&XCAFDoc_Centroid::Dump),
             R"#(None)#"  , py::arg("anOS")
          )
        .def("DumpJson",
             (void (XCAFDoc_Centroid::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Centroid::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Centroid::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Centroid::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Centroid> (*)( const TDF_Label & ,  const gp_Pnt &  ) ) static_cast<opencascade::handle<XCAFDoc_Centroid> (*)( const TDF_Label & ,  const gp_Pnt &  ) >(&XCAFDoc_Centroid::Set),
                    R"#(Find, or create, a Location attribute and set it's value the Location attribute is returned. Location methods ===============)#"  , py::arg("label"),  py::arg("pnt")
          )
        .def_static("Get_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  gp_Pnt &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  gp_Pnt &  ) >(&XCAFDoc_Centroid::Get),
                    R"#(Returns point as argument returns false if no such attribute at the <label>)#"  , py::arg("label"),  py::arg("pnt")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Centroid::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Centroid::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Centroid::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Centroid::*)() const>(&XCAFDoc_Centroid::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Centroid::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Centroid::*)() const>(&XCAFDoc_Centroid::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_ClippingPlaneTool from ./opencascade/XCAFDoc_ClippingPlaneTool.hxx
    klass = m.attr("XCAFDoc_ClippingPlaneTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_ClippingPlaneTool ,opencascade::handle<XCAFDoc_ClippingPlaneTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_ClippingPlaneTool::*)() const) static_cast<TDF_Label (XCAFDoc_ClippingPlaneTool::*)() const>(&XCAFDoc_ClippingPlaneTool::BaseLabel),
             R"#(returns the label under which ClippingPlanes are stored)#" 
          )
        .def("IsClippingPlane",
             (Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ClippingPlaneTool::IsClippingPlane),
             R"#(Returns True if label belongs to a ClippingPlane table and is a ClippingPlane definition)#"  , py::arg("theLabel")
          )
        .def("GetClippingPlane",
             (Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  gp_Pln & ,  TCollection_ExtendedString & ,  Standard_Boolean &  ) const) static_cast<Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  gp_Pln & ,  TCollection_ExtendedString & ,  Standard_Boolean &  ) const>(&XCAFDoc_ClippingPlaneTool::GetClippingPlane),
             R"#(Returns ClippingPlane defined by label lab Returns False if the label is not in ClippingPlane table or does not define a ClippingPlane)#"  , py::arg("theLabel"),  py::arg("thePlane"),  py::arg("theName"),  py::arg("theCapping")
          )
        .def("GetClippingPlane",
             (Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  gp_Pln & ,  opencascade::handle<TCollection_HAsciiString> & ,  Standard_Boolean &  ) const) static_cast<Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  gp_Pln & ,  opencascade::handle<TCollection_HAsciiString> & ,  Standard_Boolean &  ) const>(&XCAFDoc_ClippingPlaneTool::GetClippingPlane),
             R"#(Returns ClippingPlane defined by label lab Returns False if the label is not in ClippingPlane table or does not define a ClippingPlane)#"  , py::arg("theLabel"),  py::arg("thePlane"),  py::arg("theName"),  py::arg("theCapping")
          )
        .def("AddClippingPlane",
             (TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) const) static_cast<TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) const>(&XCAFDoc_ClippingPlaneTool::AddClippingPlane),
             R"#(Adds a clipping plane definition to a ClippingPlane table and returns its label (returns existing label if the same clipping plane is already defined))#"  , py::arg("thePlane"),  py::arg("theName"),  py::arg("theCapping")
          )
        .def("AddClippingPlane",
             (TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Boolean  ) const) static_cast<TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Boolean  ) const>(&XCAFDoc_ClippingPlaneTool::AddClippingPlane),
             R"#(Adds a clipping plane definition to a ClippingPlane table and returns its label (returns existing label if the same clipping plane is already defined))#"  , py::arg("thePlane"),  py::arg("theName"),  py::arg("theCapping")
          )
        .def("AddClippingPlane",
             (TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const TCollection_ExtendedString &  ) const) static_cast<TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const TCollection_ExtendedString &  ) const>(&XCAFDoc_ClippingPlaneTool::AddClippingPlane),
             R"#(Adds a clipping plane definition to a ClippingPlane table and returns its label (returns existing label if the same clipping plane is already defined))#"  , py::arg("thePlane"),  py::arg("theName")
          )
        .def("AddClippingPlane",
             (TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<TDF_Label (XCAFDoc_ClippingPlaneTool::*)( const gp_Pln & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_ClippingPlaneTool::AddClippingPlane),
             R"#(Adds a clipping plane definition to a ClippingPlane table and returns its label (returns existing label if the same clipping plane is already defined))#"  , py::arg("thePlane"),  py::arg("theName")
          )
        .def("RemoveClippingPlane",
             (Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ClippingPlaneTool::RemoveClippingPlane),
             R"#(Removes clipping plane from the ClippingPlane table Return false and do nothing if clipping plane is referenced in at least one View)#"  , py::arg("theLabel")
          )
        .def("GetClippingPlanes",
             (void (XCAFDoc_ClippingPlaneTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_ClippingPlaneTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ClippingPlaneTool::GetClippingPlanes),
             R"#(Returns a sequence of clipping planes currently stored in the ClippingPlane table)#"  , py::arg("Labels")
          )
        .def("UpdateClippingPlane",
             (void (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  const gp_Pln & ,  const TCollection_ExtendedString &  ) const) static_cast<void (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  const gp_Pln & ,  const TCollection_ExtendedString &  ) const>(&XCAFDoc_ClippingPlaneTool::UpdateClippingPlane),
             R"#(Sets new value of plane and name to the given clipping plane label or do nothing, if the given label is not a clipping plane label)#"  , py::arg("theLabelL"),  py::arg("thePlane"),  py::arg("theName")
          )
        .def("SetCapping",
             (void (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<void (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_ClippingPlaneTool::SetCapping),
             R"#(Set new value of capping for given clipping plane label)#"  , py::arg("theClippingPlaneL"),  py::arg("theCapping")
          )
        .def("GetCapping",
             (Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ClippingPlaneTool::GetCapping),
             R"#(Get capping value for given clipping plane label Return capping value)#"  , py::arg("theClippingPlaneL")
          )
        .def("GetCapping",
             (Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  Standard_Boolean &  ) const) static_cast<Standard_Boolean (XCAFDoc_ClippingPlaneTool::*)( const TDF_Label & ,  Standard_Boolean &  ) const>(&XCAFDoc_ClippingPlaneTool::GetCapping),
             R"#(Get capping value for given clipping plane label Return true if Label is valid abd capping is exist.)#"  , py::arg("theClippingPlaneL"),  py::arg("theCapping")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_ClippingPlaneTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_ClippingPlaneTool::*)() const>(&XCAFDoc_ClippingPlaneTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_ClippingPlaneTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ClippingPlaneTool> (*)( const TDF_Label &  ) >(&XCAFDoc_ClippingPlaneTool::Set),
                    R"#(Creates (if not exist) ClippingPlaneTool.)#"  , py::arg("theLabel")
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_ClippingPlaneTool::GetID),
                    R"#(None)#" 
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_ClippingPlaneTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_ClippingPlaneTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_ClippingPlaneTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_ClippingPlaneTool::*)() const>(&XCAFDoc_ClippingPlaneTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_ClippingPlaneTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_ClippingPlaneTool::*)() const>(&XCAFDoc_ClippingPlaneTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_Color from ./opencascade/XCAFDoc_Color.hxx
    klass = m.attr("XCAFDoc_Color");


    // nested enums

    static_cast<py::class_<XCAFDoc_Color ,opencascade::handle<XCAFDoc_Color>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Color::*)( const Quantity_Color &  ) ) static_cast<void (XCAFDoc_Color::*)( const Quantity_Color &  ) >(&XCAFDoc_Color::Set),
             R"#(None)#"  , py::arg("C")
          )
        .def("Set",
             (void (XCAFDoc_Color::*)( const Quantity_ColorRGBA &  ) ) static_cast<void (XCAFDoc_Color::*)( const Quantity_ColorRGBA &  ) >(&XCAFDoc_Color::Set),
             R"#(None)#"  , py::arg("C")
          )
        .def("Set",
             (void (XCAFDoc_Color::*)( const Quantity_NameOfColor  ) ) static_cast<void (XCAFDoc_Color::*)( const Quantity_NameOfColor  ) >(&XCAFDoc_Color::Set),
             R"#(None)#"  , py::arg("C")
          )
        .def("Set",
             (void (XCAFDoc_Color::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<void (XCAFDoc_Color::*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) >(&XCAFDoc_Color::Set),
             R"#(None)#"  , py::arg("R"),  py::arg("G"),  py::arg("B"),  py::arg("alpha")=static_cast<const Standard_Real>(1.0)
          )
        .def("GetNOC",
             (Quantity_NameOfColor (XCAFDoc_Color::*)() const) static_cast<Quantity_NameOfColor (XCAFDoc_Color::*)() const>(&XCAFDoc_Color::GetNOC),
             R"#(None)#" 
          )
        .def("GetAlpha",
             (Standard_ShortReal (XCAFDoc_Color::*)() const) static_cast<Standard_ShortReal (XCAFDoc_Color::*)() const>(&XCAFDoc_Color::GetAlpha),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_Color::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_Color::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_Color::Restore),
             R"#(None)#"  , py::arg("With")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Color::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Color::*)() const>(&XCAFDoc_Color::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (void (XCAFDoc_Color::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_Color::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_Color::Paste),
             R"#(None)#"  , py::arg("Into"),  py::arg("RT")
          )
        .def("DumpJson",
             (void (XCAFDoc_Color::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Color::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Color::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
        .def("GetRGB",
             []( XCAFDoc_Color &self   ){
                 Standard_Real  R;
                Standard_Real  G;
                Standard_Real  B;

                 self.GetRGB(R,G,B);
                 
                 return std::make_tuple(R,G,B); },
             R"#(None)#" 
          )
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Color::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Quantity_Color &  ) ) static_cast<opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Quantity_Color &  ) >(&XCAFDoc_Color::Set),
                    R"#(None)#"  , py::arg("label"),  py::arg("C")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Quantity_ColorRGBA &  ) ) static_cast<opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Quantity_ColorRGBA &  ) >(&XCAFDoc_Color::Set),
                    R"#(None)#"  , py::arg("label"),  py::arg("C")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Quantity_NameOfColor  ) ) static_cast<opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Quantity_NameOfColor  ) >(&XCAFDoc_Color::Set),
                    R"#(None)#"  , py::arg("label"),  py::arg("C")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<opencascade::handle<XCAFDoc_Color> (*)( const TDF_Label & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real  ) >(&XCAFDoc_Color::Set),
                    R"#(Find, or create, a Color attribute and set it's value the Color attribute is returned.)#"  , py::arg("label"),  py::arg("R"),  py::arg("G"),  py::arg("B"),  py::arg("alpha")=static_cast<const Standard_Real>(1.0)
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Color::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Color::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetColor",
             (const Quantity_Color & (XCAFDoc_Color::*)() const) static_cast<const Quantity_Color & (XCAFDoc_Color::*)() const>(&XCAFDoc_Color::GetColor),
             R"#(None)#"
             
         )
       .def("GetColorRGBA",
             (const Quantity_ColorRGBA & (XCAFDoc_Color::*)() const) static_cast<const Quantity_ColorRGBA & (XCAFDoc_Color::*)() const>(&XCAFDoc_Color::GetColorRGBA),
             R"#(None)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Color::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Color::*)() const>(&XCAFDoc_Color::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Color::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Color::*)() const>(&XCAFDoc_Color::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_ColorTool from ./opencascade/XCAFDoc_ColorTool.hxx
    klass = m.attr("XCAFDoc_ColorTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_ColorTool ,opencascade::handle<XCAFDoc_ColorTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_ColorTool::*)() const) static_cast<TDF_Label (XCAFDoc_ColorTool::*)() const>(&XCAFDoc_ColorTool::BaseLabel),
             R"#(returns the label under which colors are stored)#" 
          )
        .def("IsColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ColorTool::IsColor),
             R"#(Returns True if label belongs to a colortable and is a color definition)#"  , py::arg("lab")
          )
        .def("FindColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const Quantity_Color & ,  TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const Quantity_Color & ,  TDF_Label &  ) const>(&XCAFDoc_ColorTool::FindColor),
             R"#(Finds a color definition in a colortable and returns its label if found Returns False if color is not found in colortable)#"  , py::arg("col"),  py::arg("lab")
          )
        .def("FindColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const Quantity_ColorRGBA & ,  TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const Quantity_ColorRGBA & ,  TDF_Label &  ) const>(&XCAFDoc_ColorTool::FindColor),
             R"#(Finds a color definition in a colortable and returns its label if found Returns False if color is not found in colortable)#"  , py::arg("col"),  py::arg("lab")
          )
        .def("FindColor",
             (TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_Color &  ) const) static_cast<TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_Color &  ) const>(&XCAFDoc_ColorTool::FindColor),
             R"#(Finds a color definition in a colortable and returns its label if found (or Null label else))#"  , py::arg("col")
          )
        .def("FindColor",
             (TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_ColorRGBA &  ) const) static_cast<TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_ColorRGBA &  ) const>(&XCAFDoc_ColorTool::FindColor),
             R"#(Finds a color definition in a colortable and returns its label if found (or Null label else))#"  , py::arg("col")
          )
        .def("AddColor",
             (TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_Color &  ) const) static_cast<TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_Color &  ) const>(&XCAFDoc_ColorTool::AddColor),
             R"#(Adds a color definition to a colortable and returns its label (returns existing label if the same color is already defined))#"  , py::arg("col")
          )
        .def("AddColor",
             (TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_ColorRGBA &  ) const) static_cast<TDF_Label (XCAFDoc_ColorTool::*)( const Quantity_ColorRGBA &  ) const>(&XCAFDoc_ColorTool::AddColor),
             R"#(Adds a color definition to a colortable and returns its label (returns existing label if the same color is already defined))#"  , py::arg("col")
          )
        .def("RemoveColor",
             (void (XCAFDoc_ColorTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_ColorTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ColorTool::RemoveColor),
             R"#(Removes color from the colortable)#"  , py::arg("lab")
          )
        .def("GetColors",
             (void (XCAFDoc_ColorTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_ColorTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ColorTool::GetColors),
             R"#(Returns a sequence of colors currently stored in the colortable)#"  , py::arg("Labels")
          )
        .def("SetColor",
             (void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const TDF_Label & ,  const XCAFDoc_ColorType  ) const) static_cast<void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const TDF_Label & ,  const XCAFDoc_ColorType  ) const>(&XCAFDoc_ColorTool::SetColor),
             R"#(Sets a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color defined by <colorL>. Color of shape is defined following way in dependance with type of color. If type of color is XCAFDoc_ColorGen - then this color defines default color for surfaces and curves. If for shape color with types XCAFDoc_ColorSurf or XCAFDoc_ColorCurv is specified then such color overrides generic color.)#"  , py::arg("L"),  py::arg("colorL"),  py::arg("type")
          )
        .def("SetColor",
             (void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Quantity_Color & ,  const XCAFDoc_ColorType  ) const) static_cast<void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Quantity_Color & ,  const XCAFDoc_ColorType  ) const>(&XCAFDoc_ColorTool::SetColor),
             R"#(Sets a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color <Color> in the colortable Adds a color as necessary)#"  , py::arg("L"),  py::arg("Color"),  py::arg("type")
          )
        .def("SetColor",
             (void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Quantity_ColorRGBA & ,  const XCAFDoc_ColorType  ) const) static_cast<void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Quantity_ColorRGBA & ,  const XCAFDoc_ColorType  ) const>(&XCAFDoc_ColorTool::SetColor),
             R"#(Sets a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color <Color> in the colortable Adds a color as necessary)#"  , py::arg("L"),  py::arg("Color"),  py::arg("type")
          )
        .def("UnSetColor",
             (void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const XCAFDoc_ColorType  ) const) static_cast<void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const XCAFDoc_ColorType  ) const>(&XCAFDoc_ColorTool::UnSetColor),
             R"#(Removes a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color)#"  , py::arg("L"),  py::arg("type")
          )
        .def("IsSet",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const XCAFDoc_ColorType  ) const) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const XCAFDoc_ColorType  ) const>(&XCAFDoc_ColorTool::IsSet),
             R"#(Returns True if label <L> has a color assignment of the type <type>)#"  , py::arg("L"),  py::arg("type")
          )
        .def("SetColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const TDF_Label & ,  const XCAFDoc_ColorType  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const TDF_Label & ,  const XCAFDoc_ColorType  ) >(&XCAFDoc_ColorTool::SetColor),
             R"#(Sets a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color defined by <colorL> Returns False if cannot find a label for shape S)#"  , py::arg("S"),  py::arg("colorL"),  py::arg("type")
          )
        .def("SetColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const Quantity_Color & ,  const XCAFDoc_ColorType  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const Quantity_Color & ,  const XCAFDoc_ColorType  ) >(&XCAFDoc_ColorTool::SetColor),
             R"#(Sets a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color <Color> in the colortable Adds a color as necessary Returns False if cannot find a label for shape S)#"  , py::arg("S"),  py::arg("Color"),  py::arg("type")
          )
        .def("SetColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const Quantity_ColorRGBA & ,  const XCAFDoc_ColorType  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const Quantity_ColorRGBA & ,  const XCAFDoc_ColorType  ) >(&XCAFDoc_ColorTool::SetColor),
             R"#(Sets a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color <Color> in the colortable Adds a color as necessary Returns False if cannot find a label for shape S)#"  , py::arg("S"),  py::arg("Color"),  py::arg("type")
          )
        .def("UnSetColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType  ) >(&XCAFDoc_ColorTool::UnSetColor),
             R"#(Removes a link with GUID defined by <type> (see XCAFDoc::ColorRefGUID()) from label <L> to color Returns True if such link existed)#"  , py::arg("S"),  py::arg("type")
          )
        .def("IsSet",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType  ) >(&XCAFDoc_ColorTool::IsSet),
             R"#(Returns True if label <L> has a color assignment of the type <type>)#"  , py::arg("S"),  py::arg("type")
          )
        .def("GetColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  TDF_Label &  ) >(&XCAFDoc_ColorTool::GetColor),
             R"#(Returns label with color assigned to <L> as <type> Returns False if no such color is assigned)#"  , py::arg("S"),  py::arg("type"),  py::arg("colorL")
          )
        .def("GetColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_Color &  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_Color &  ) >(&XCAFDoc_ColorTool::GetColor),
             R"#(Returns color assigned to <L> as <type> Returns False if no such color is assigned)#"  , py::arg("S"),  py::arg("type"),  py::arg("color")
          )
        .def("GetColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_ColorRGBA &  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_ColorRGBA &  ) >(&XCAFDoc_ColorTool::GetColor),
             R"#(Returns color assigned to <L> as <type> Returns False if no such color is assigned)#"  , py::arg("S"),  py::arg("type"),  py::arg("color")
          )
        .def("SetVisibility",
             (void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_ColorTool::SetVisibility),
             R"#(Set the visibility of object on label. Do nothing if there no any object. Set UAttribute with corresponding GUID.)#"  , py::arg("shapeLabel"),  py::arg("isvisible")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("IsColorByLayer",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ColorTool::IsColorByLayer),
             R"#(Return TRUE if object color defined by its Layer, FALSE if not.)#"  , py::arg("L")
          )
        .def("SetColorByLayer",
             (void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<void (XCAFDoc_ColorTool::*)( const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_ColorTool::SetColorByLayer),
             R"#(Set the Color defined by Layer flag on label. Do nothing if there no any object. Set UAttribute with corresponding GUID.)#"  , py::arg("shapeLabel"),  py::arg("isColorByLayer")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("SetInstanceColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  const Quantity_Color & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  const Quantity_Color & ,  const Standard_Boolean  ) >(&XCAFDoc_ColorTool::SetInstanceColor),
             R"#(Sets the color of component that styled with SHUO structure Returns FALSE if no sush component found NOTE: create SHUO structeure if it is necessary and if <isCreateSHUO>)#"  , py::arg("theShape"),  py::arg("type"),  py::arg("color"),  py::arg("isCreateSHUO")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetInstanceColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  const Quantity_ColorRGBA & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  const Quantity_ColorRGBA & ,  const Standard_Boolean  ) >(&XCAFDoc_ColorTool::SetInstanceColor),
             R"#(Sets the color of component that styled with SHUO structure Returns FALSE if no sush component found NOTE: create SHUO structeure if it is necessary and if <isCreateSHUO>)#"  , py::arg("theShape"),  py::arg("type"),  py::arg("color"),  py::arg("isCreateSHUO")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("GetInstanceColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_Color &  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_Color &  ) >(&XCAFDoc_ColorTool::GetInstanceColor),
             R"#(Gets the color of component that styled with SHUO structure Returns FALSE if no sush component or color type)#"  , py::arg("theShape"),  py::arg("type"),  py::arg("color")
          )
        .def("GetInstanceColor",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_ColorRGBA &  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape & ,  const XCAFDoc_ColorType ,  Quantity_ColorRGBA &  ) >(&XCAFDoc_ColorTool::GetInstanceColor),
             R"#(Gets the color of component that styled with SHUO structure Returns FALSE if no sush component or color type)#"  , py::arg("theShape"),  py::arg("type"),  py::arg("color")
          )
        .def("IsInstanceVisible",
             (Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)( const TopoDS_Shape &  ) >(&XCAFDoc_ColorTool::IsInstanceVisible),
             R"#(Gets the visibility status of component that styled with SHUO structure Returns FALSE if no sush component)#"  , py::arg("theShape")
          )
        .def("ReverseChainsOfTreeNodes",
             (Standard_Boolean (XCAFDoc_ColorTool::*)() ) static_cast<Standard_Boolean (XCAFDoc_ColorTool::*)() >(&XCAFDoc_ColorTool::ReverseChainsOfTreeNodes),
             R"#(Reverses order in chains of TreeNodes (from Last to First) under each Color Label since we became to use function ::Prepend() instead of ::Append() in method SetColor() for acceleration)#" 
          )
        .def("DumpJson",
             (void (XCAFDoc_ColorTool::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_ColorTool::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_ColorTool::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_ColorTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_ColorTool::*)() const>(&XCAFDoc_ColorTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AutoNaming_s",
                    (Standard_Boolean (*)() ) static_cast<Standard_Boolean (*)() >(&XCAFDoc_ColorTool::AutoNaming),
                    R"#(Returns current auto-naming mode; TRUE by default. If TRUE then for added colors the TDataStd_Name attribute will be automatically added. This setting is global.)#" 
          )
        .def_static("SetAutoNaming_s",
                    (void (*)( Standard_Boolean  ) ) static_cast<void (*)( Standard_Boolean  ) >(&XCAFDoc_ColorTool::SetAutoNaming),
                    R"#(See also AutoNaming().)#"  , py::arg("theIsAutoNaming")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_ColorTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ColorTool> (*)( const TDF_Label &  ) >(&XCAFDoc_ColorTool::Set),
                    R"#(Creates (if not exist) ColorTool.)#"  , py::arg("L")
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_ColorTool::GetID),
                    R"#(None)#" 
          )
        .def_static("GetColor_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  Quantity_Color &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  Quantity_Color &  ) >(&XCAFDoc_ColorTool::GetColor),
                    R"#(Returns color defined by label lab Returns False if the label is not in colortable or does not define a color)#"  , py::arg("lab"),  py::arg("col")
          )
        .def_static("GetColor_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  Quantity_ColorRGBA &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  Quantity_ColorRGBA &  ) >(&XCAFDoc_ColorTool::GetColor),
                    R"#(Returns color defined by label lab Returns False if the label is not in colortable or does not define a color)#"  , py::arg("lab"),  py::arg("col")
          )
        .def_static("GetColor_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  const XCAFDoc_ColorType ,  TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  const XCAFDoc_ColorType ,  TDF_Label &  ) >(&XCAFDoc_ColorTool::GetColor),
                    R"#(Returns label with color assigned to <L> as <type> Returns False if no such color is assigned)#"  , py::arg("L"),  py::arg("type"),  py::arg("colorL")
          )
        .def_static("GetColor_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  const XCAFDoc_ColorType ,  Quantity_Color &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  const XCAFDoc_ColorType ,  Quantity_Color &  ) >(&XCAFDoc_ColorTool::GetColor),
                    R"#(Returns color assigned to <L> as <type> Returns False if no such color is assigned)#"  , py::arg("L"),  py::arg("type"),  py::arg("color")
          )
        .def_static("GetColor_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  const XCAFDoc_ColorType ,  Quantity_ColorRGBA &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  const XCAFDoc_ColorType ,  Quantity_ColorRGBA &  ) >(&XCAFDoc_ColorTool::GetColor),
                    R"#(Returns color assigned to <L> as <type> Returns False if no such color is assigned)#"  , py::arg("L"),  py::arg("type"),  py::arg("color")
          )
        .def_static("IsVisible_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ColorTool::IsVisible),
                    R"#(Return TRUE if object on this label is visible, FALSE if invisible.)#"  , py::arg("L")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_ColorTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_ColorTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ShapeTool",
             (const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_ColorTool::*)() ) static_cast<const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_ColorTool::*)() >(&XCAFDoc_ColorTool::ShapeTool),
             R"#(Returns internal XCAFDoc_ShapeTool tool)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_ColorTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_ColorTool::*)() const>(&XCAFDoc_ColorTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_ColorTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_ColorTool::*)() const>(&XCAFDoc_ColorTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_Datum from ./opencascade/XCAFDoc_Datum.hxx
    klass = m.attr("XCAFDoc_Datum");


    // nested enums

    static_cast<py::class_<XCAFDoc_Datum ,opencascade::handle<XCAFDoc_Datum>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Datum::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDoc_Datum::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_Datum::Set),
             R"#(None)#"  , py::arg("aName"),  py::arg("aDescription"),  py::arg("anIdentification")
          )
        .def("GetName",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Datum::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Datum::*)() const>(&XCAFDoc_Datum::GetName),
             R"#(None)#" 
          )
        .def("GetDescription",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Datum::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Datum::*)() const>(&XCAFDoc_Datum::GetDescription),
             R"#(None)#" 
          )
        .def("GetIdentification",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Datum::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Datum::*)() const>(&XCAFDoc_Datum::GetIdentification),
             R"#(None)#" 
          )
        .def("GetObject",
             (opencascade::handle<XCAFDimTolObjects_DatumObject> (XCAFDoc_Datum::*)() const) static_cast<opencascade::handle<XCAFDimTolObjects_DatumObject> (XCAFDoc_Datum::*)() const>(&XCAFDoc_Datum::GetObject),
             R"#(Returns dimension object data taken from the paren's label and its sub-labels.)#" 
          )
        .def("SetObject",
             (void (XCAFDoc_Datum::*)( const opencascade::handle<XCAFDimTolObjects_DatumObject> &  ) ) static_cast<void (XCAFDoc_Datum::*)( const opencascade::handle<XCAFDimTolObjects_DatumObject> &  ) >(&XCAFDoc_Datum::SetObject),
             R"#(Updates parent's label and its sub-labels with data taken from theDatumObject. Old data associated with the label will be lost.)#"  , py::arg("theDatumObject")
          )
        .def("Restore",
             (void (XCAFDoc_Datum::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_Datum::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_Datum::Restore),
             R"#(None)#"  , py::arg("With")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Datum::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Datum::*)() const>(&XCAFDoc_Datum::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (void (XCAFDoc_Datum::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_Datum::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_Datum::Paste),
             R"#(None)#"  , py::arg("Into"),  py::arg("RT")
          )
        .def("DumpJson",
             (void (XCAFDoc_Datum::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Datum::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Datum::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Datum::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Datum> (*)( const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<opencascade::handle<XCAFDoc_Datum> (*)( const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_Datum::Set),
                    R"#(None)#"  , py::arg("label"),  py::arg("aName"),  py::arg("aDescription"),  py::arg("anIdentification")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Datum> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_Datum> (*)( const TDF_Label &  ) >(&XCAFDoc_Datum::Set),
                    R"#(None)#"  , py::arg("theLabel")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Datum::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Datum::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Datum::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Datum::*)() const>(&XCAFDoc_Datum::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Datum::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Datum::*)() const>(&XCAFDoc_Datum::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_DimTol from ./opencascade/XCAFDoc_DimTol.hxx
    klass = m.attr("XCAFDoc_DimTol");


    // nested enums

    static_cast<py::class_<XCAFDoc_DimTol ,opencascade::handle<XCAFDoc_DimTol>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_DimTol::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDoc_DimTol::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_DimTol::Set),
             R"#(None)#"  , py::arg("kind"),  py::arg("aVal"),  py::arg("aName"),  py::arg("aDescription")
          )
        .def("GetKind",
             (Standard_Integer (XCAFDoc_DimTol::*)() const) static_cast<Standard_Integer (XCAFDoc_DimTol::*)() const>(&XCAFDoc_DimTol::GetKind),
             R"#(None)#" 
          )
        .def("GetVal",
             (opencascade::handle<TColStd_HArray1OfReal> (XCAFDoc_DimTol::*)() const) static_cast<opencascade::handle<TColStd_HArray1OfReal> (XCAFDoc_DimTol::*)() const>(&XCAFDoc_DimTol::GetVal),
             R"#(None)#" 
          )
        .def("GetName",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_DimTol::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_DimTol::*)() const>(&XCAFDoc_DimTol::GetName),
             R"#(None)#" 
          )
        .def("GetDescription",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_DimTol::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_DimTol::*)() const>(&XCAFDoc_DimTol::GetDescription),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_DimTol::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_DimTol::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_DimTol::Restore),
             R"#(None)#"  , py::arg("With")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_DimTol::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_DimTol::*)() const>(&XCAFDoc_DimTol::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (void (XCAFDoc_DimTol::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_DimTol::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_DimTol::Paste),
             R"#(None)#"  , py::arg("Into"),  py::arg("RT")
          )
        .def("DumpJson",
             (void (XCAFDoc_DimTol::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_DimTol::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_DimTol::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_DimTol::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_DimTol> (*)( const TDF_Label & ,  const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<opencascade::handle<XCAFDoc_DimTol> (*)( const TDF_Label & ,  const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_DimTol::Set),
                    R"#(None)#"  , py::arg("label"),  py::arg("kind"),  py::arg("aVal"),  py::arg("aName"),  py::arg("aDescription")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_DimTol::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_DimTol::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_DimTol::*)() const) static_cast<const Standard_GUID & (XCAFDoc_DimTol::*)() const>(&XCAFDoc_DimTol::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_DimTol::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_DimTol::*)() const>(&XCAFDoc_DimTol::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_DimTolTool from ./opencascade/XCAFDoc_DimTolTool.hxx
    klass = m.attr("XCAFDoc_DimTolTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_DimTolTool ,opencascade::handle<XCAFDoc_DimTolTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_DimTolTool::*)() const) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)() const>(&XCAFDoc_DimTolTool::BaseLabel),
             R"#(Returns the label under which GD&T table is stored.)#" 
          )
        .def("IsDimension",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::IsDimension),
             R"#(Returns True if the label belongs to a GD&T table and is a Dimension definition.)#"  , py::arg("theLab")
          )
        .def("GetDimensionLabels",
             (void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetDimensionLabels),
             R"#(Returns a sequence of Dimension labels currently stored in the GD&T table.)#"  , py::arg("theLabels")
          )
        .def("SetDimension",
             (void (XCAFDoc_DimTolTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetDimension),
             R"#(Sets a dimension to sequences target labels.)#"  , py::arg("theFirstLS"),  py::arg("theSecondLS"),  py::arg("theDimL")
          )
        .def("SetDimension",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetDimension),
             R"#(Sets a dimension to target labels.)#"  , py::arg("theFirstL"),  py::arg("theSecondL"),  py::arg("theDimL")
          )
        .def("SetDimension",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetDimension),
             R"#(Sets a dimension to the target label.)#"  , py::arg("theL"),  py::arg("theDimL")
          )
        .def("GetRefDimensionLabels",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetRefDimensionLabels),
             R"#(Returns all Dimension labels defined for theShapeL.)#"  , py::arg("theShapeL"),  py::arg("theDimensions")
          )
        .def("AddDimension",
             (TDF_Label (XCAFDoc_DimTolTool::*)() ) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)() >(&XCAFDoc_DimTolTool::AddDimension),
             R"#(Adds a dimension definition to the GD&T table and returns its label.)#" 
          )
        .def("IsGeomTolerance",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::IsGeomTolerance),
             R"#(Returns True if the label belongs to the GD&T table and is a dimension tolerance.)#"  , py::arg("theLab")
          )
        .def("GetGeomToleranceLabels",
             (void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetGeomToleranceLabels),
             R"#(Returns a sequence of Tolerance labels currently stored in the GD&T table.)#"  , py::arg("theLabels")
          )
        .def("SetGeomTolerance",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetGeomTolerance),
             R"#(Sets a geometry tolerance from theGeomTolL to theL label. Checks if theGeomTolL is a geometry tolerance definition first.)#"  , py::arg("theL"),  py::arg("theGeomTolL")
          )
        .def("SetGeomTolerance",
             (void (XCAFDoc_DimTolTool::*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetGeomTolerance),
             R"#(Sets a geometry tolerance from theGeomTolL to sequence of labels theL. Checks if theGeomTolL is a geometry tolerance definition first.)#"  , py::arg("theL"),  py::arg("theGeomTolL")
          )
        .def("GetRefGeomToleranceLabels",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetRefGeomToleranceLabels),
             R"#(Returns all GeomTolerance labels defined for theShapeL.)#"  , py::arg("theShapeL"),  py::arg("theDimTols")
          )
        .def("AddGeomTolerance",
             (TDF_Label (XCAFDoc_DimTolTool::*)() ) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)() >(&XCAFDoc_DimTolTool::AddGeomTolerance),
             R"#(Adds a GeomTolerance definition to the GD&T table and returns its label.)#" 
          )
        .def("IsDimTol",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::IsDimTol),
             R"#(Returns True if theLab belongs to the GD&T table and is a dmension tolerance.)#"  , py::arg("theLab")
          )
        .def("GetDimTolLabels",
             (void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetDimTolLabels),
             R"#(Returns a sequence of D&GTs currently stored in the GD&T table.)#"  , py::arg("Labels")
          )
        .def("FindDimTol",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  TDF_Label &  ) const>(&XCAFDoc_DimTolTool::FindDimTol),
             R"#(Finds a dimension tolerance definition in the GD&T table satisfying the specified kind, values, name and description and returns its label if found. Returns False if dimension tolerance is not found in DGTtable.)#"  , py::arg("theKind"),  py::arg("theVal"),  py::arg("theName"),  py::arg("theDescription"),  py::arg("lab")
          )
        .def("FindDimTol",
             (TDF_Label (XCAFDoc_DimTolTool::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_DimTolTool::FindDimTol),
             R"#(Finds a dimension tolerance in the GD&T table satisfying the specified kind, values, name and description and returns its label if found (or Null label else).)#"  , py::arg("theKind"),  py::arg("theVal"),  py::arg("theName"),  py::arg("theDescription")
          )
        .def("AddDimTol",
             (TDF_Label (XCAFDoc_DimTolTool::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)( const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_DimTolTool::AddDimTol),
             R"#(Adds a dimension tolerance definition with the specified kind, value, name and description to the GD&T table and returns its label.)#"  , py::arg("theKind"),  py::arg("theVal"),  py::arg("theName"),  py::arg("theDescription")
          )
        .def("SetDimTol",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetDimTol),
             R"#(Sets existing dimension tolerance to theL label.)#"  , py::arg("theL"),  py::arg("theDimTolL")
          )
        .def("SetDimTol",
             (TDF_Label (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const Standard_Integer ,  const opencascade::handle<TColStd_HArray1OfReal> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_DimTolTool::SetDimTol),
             R"#(Creates a dimension tolerance and sets it to theL label.)#"  , py::arg("theL"),  py::arg("theKind"),  py::arg("theVal"),  py::arg("theName"),  py::arg("theDescription")
          )
        .def("GetDimTol",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  Standard_Integer & ,  opencascade::handle<TColStd_HArray1OfReal> & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  Standard_Integer & ,  opencascade::handle<TColStd_HArray1OfReal> & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_DimTolTool::GetDimTol),
             R"#(Returns dimension tolerance assigned to theDimTolL label. Returns False if no such dimension tolerance is assigned.)#"  , py::arg("theDimTolL"),  py::arg("theKind"),  py::arg("theVal"),  py::arg("theName"),  py::arg("theDescription")
          )
        .def("IsDatum",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::IsDatum),
             R"#(Returns True if label belongs to the GD&T table and is a Datum definition.)#"  , py::arg("lab")
          )
        .def("GetDatumLabels",
             (void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetDatumLabels),
             R"#(Returns a sequence of Datums currently stored in the GD&T table.)#"  , py::arg("Labels")
          )
        .def("FindDatum",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  TDF_Label &  ) const>(&XCAFDoc_DimTolTool::FindDatum),
             R"#(Finds a datum satisfying the specified name, description and identification and returns its label if found.)#"  , py::arg("theName"),  py::arg("theDescription"),  py::arg("theIdentification"),  py::arg("lab")
          )
        .def("AddDatum",
             (TDF_Label (XCAFDoc_DimTolTool::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_DimTolTool::AddDatum),
             R"#(Adds a datum definition to the GD&T table and returns its label.)#"  , py::arg("theName"),  py::arg("theDescription"),  py::arg("theIdentification")
          )
        .def("AddDatum",
             (TDF_Label (XCAFDoc_DimTolTool::*)() ) static_cast<TDF_Label (XCAFDoc_DimTolTool::*)() >(&XCAFDoc_DimTolTool::AddDatum),
             R"#(Adds a datum definition to the GD&T table and returns its label.)#" 
          )
        .def("SetDatum",
             (void (XCAFDoc_DimTolTool::*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetDatum),
             R"#(Sets a datum to the sequence of shape labels.)#"  , py::arg("theShapeLabels"),  py::arg("theDatumL")
          )
        .def("SetDatum",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_DimTolTool::SetDatum),
             R"#(Sets a datum to theL label and binds it with theTolerL label. A datum with the specified name, description and identification is created if it isn't found in the GD&T table.)#"  , py::arg("theL"),  py::arg("theTolerL"),  py::arg("theName"),  py::arg("theDescription"),  py::arg("theIdentification")
          )
        .def("SetDatumToGeomTol",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::SetDatumToGeomTol),
             R"#(Sets a datum from theDatumL label to theToletL label.)#"  , py::arg("theDatumL"),  py::arg("theTolerL")
          )
        .def("GetDatum",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_DimTolTool::GetDatum),
             R"#(Returns datum assigned to theDatumL label. Returns False if no such datum is assigned.)#"  , py::arg("theDatumL"),  py::arg("theName"),  py::arg("theDescription"),  py::arg("theIdentification")
          )
        .def("GetTolerOfDatumLabels",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetTolerOfDatumLabels),
             R"#(Returns all GeomToleranses labels defined for theDatumL label.)#"  , py::arg("theDatumL"),  py::arg("theTols")
          )
        .def("GetRefDatumLabel",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_DimTolTool::GetRefDatumLabel),
             R"#(Returns Datum label defined for theShapeL label.)#"  , py::arg("theShapeL"),  py::arg("theDatum")
          )
        .def("IsLocked",
             (Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::IsLocked),
             R"#(Returns true if the given GDT is marked as locked.)#"  , py::arg("theViewL")
          )
        .def("Lock",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::Lock),
             R"#(Mark the given GDT as locked.)#"  , py::arg("theViewL")
          )
        .def("GetGDTPresentations",
             (void (XCAFDoc_DimTolTool::*)( NCollection_IndexedDataMap<TDF_Label, TopoDS_Shape> &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( NCollection_IndexedDataMap<TDF_Label, TopoDS_Shape> &  ) const>(&XCAFDoc_DimTolTool::GetGDTPresentations),
             R"#(fill the map GDT label -> shape presentation)#"  , py::arg("theGDTLabelToShape")
          )
        .def("SetGDTPresentations",
             (void (XCAFDoc_DimTolTool::*)( NCollection_IndexedDataMap<TDF_Label, TopoDS_Shape> &  ) ) static_cast<void (XCAFDoc_DimTolTool::*)( NCollection_IndexedDataMap<TDF_Label, TopoDS_Shape> &  ) >(&XCAFDoc_DimTolTool::SetGDTPresentations),
             R"#(Set shape presentation for GDT labels according to given map (theGDTLabelToPrs) theGDTLabelToPrsName map is an additional argument, can be used to set presentation names. If label is not in the theGDTLabelToPrsName map, the presentation name will be empty)#"  , py::arg("theGDTLabelToPrs")
          )
        .def("Unlock",
             (void (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( const TDF_Label &  ) const>(&XCAFDoc_DimTolTool::Unlock),
             R"#(Unlock the given GDT.)#"  , py::arg("theViewL")
          )
        .def("DumpJson",
             (void (XCAFDoc_DimTolTool::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_DimTolTool::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_DimTolTool::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_DimTolTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_DimTolTool::*)() const>(&XCAFDoc_DimTolTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_DimTolTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_DimTolTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DimTolTool::Set),
                    R"#(Creates (if not exist) DimTolTool attribute.)#"  , py::arg("L")
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_DimTolTool::GetID),
                    R"#(Returns the standard GD&T tool GUID.)#" 
          )
        .def_static("GetRefShapeLabel_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_DimTolTool::GetRefShapeLabel),
                    R"#(Gets all shape labels referred by theL label of the GD&T table. Returns False if there are no shape labels added to the sequences.)#"  , py::arg("theL"),  py::arg("theShapeLFirst"),  py::arg("theShapeLSecond")
          )
        .def_static("GetDatumOfTolerLabels_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_DimTolTool::GetDatumOfTolerLabels),
                    R"#(Returns all Datum labels defined for theDimTolL label.)#"  , py::arg("theDimTolL"),  py::arg("theDatums")
          )
        .def_static("GetDatumWithObjectOfTolerLabels_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_DimTolTool::GetDatumWithObjectOfTolerLabels),
                    R"#(Returns all Datum labels with XCAFDimTolObjects_DatumObject defined for label theDimTolL.)#"  , py::arg("theDimTolL"),  py::arg("theDatums")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_DimTolTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_DimTolTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ShapeTool",
             (const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_DimTolTool::*)() ) static_cast<const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_DimTolTool::*)() >(&XCAFDoc_DimTolTool::ShapeTool),
             R"#(Returns internal XCAFDoc_ShapeTool tool)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_DimTolTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_DimTolTool::*)() const>(&XCAFDoc_DimTolTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_DimTolTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_DimTolTool::*)() const>(&XCAFDoc_DimTolTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_Dimension from ./opencascade/XCAFDoc_Dimension.hxx
    klass = m.attr("XCAFDoc_Dimension");


    // nested enums

    static_cast<py::class_<XCAFDoc_Dimension ,opencascade::handle<XCAFDoc_Dimension>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetObject",
             (void (XCAFDoc_Dimension::*)( const opencascade::handle<XCAFDimTolObjects_DimensionObject> &  ) ) static_cast<void (XCAFDoc_Dimension::*)( const opencascade::handle<XCAFDimTolObjects_DimensionObject> &  ) >(&XCAFDoc_Dimension::SetObject),
             R"#(Updates parent's label and its sub-labels with data taken from theDimensionObject. Old data associated with the label will be lost.)#"  , py::arg("theDimensionObject")
          )
        .def("GetObject",
             (opencascade::handle<XCAFDimTolObjects_DimensionObject> (XCAFDoc_Dimension::*)() const) static_cast<opencascade::handle<XCAFDimTolObjects_DimensionObject> (XCAFDoc_Dimension::*)() const>(&XCAFDoc_Dimension::GetObject),
             R"#(Returns dimension object data taken from the parent's label and its sub-labels.)#" 
          )
        .def("DumpJson",
             (void (XCAFDoc_Dimension::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Dimension::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Dimension::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Dimension::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Dimension::*)() const>(&XCAFDoc_Dimension::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Dimension::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Dimension> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_Dimension> (*)( const TDF_Label &  ) >(&XCAFDoc_Dimension::Set),
                    R"#(None)#"  , py::arg("theLabel")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Dimension::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Dimension::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Dimension::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Dimension::*)() const>(&XCAFDoc_Dimension::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Dimension::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Dimension::*)() const>(&XCAFDoc_Dimension::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_DocumentTool from ./opencascade/XCAFDoc_DocumentTool.hxx
    klass = m.attr("XCAFDoc_DocumentTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_DocumentTool ,opencascade::handle<XCAFDoc_DocumentTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (XCAFDoc_DocumentTool::*)() const) static_cast<void (XCAFDoc_DocumentTool::*)() const>(&XCAFDoc_DocumentTool::Init),
             R"#(to be called when reading this attribute from file)#" 
          )
        .def("AfterRetrieval",
             (Standard_Boolean (XCAFDoc_DocumentTool::*)( const Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_DocumentTool::*)( const Standard_Boolean  ) >(&XCAFDoc_DocumentTool::AfterRetrieval),
             R"#(To init this derived attribute after the attribute restore using the base restore-methods)#"  , py::arg("forceIt")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_DocumentTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_DocumentTool::*)() const>(&XCAFDoc_DocumentTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_DocumentTool::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_DocumentTool> (*)( const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<opencascade::handle<XCAFDoc_DocumentTool> (*)( const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_DocumentTool::Set),
                    R"#(Create (if not exist) DocumentTool attribute on 0.1 label if <IsAcces> is true, else on <L> label. This label will be returned by DocLabel(); If the attribute is already set it won't be reset on <L> even if <IsAcces> is false. ColorTool and ShapeTool attributes are also set by this method.)#"  , py::arg("L"),  py::arg("IsAcces")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("IsXCAFDocument_s",
                    (Standard_Boolean (*)( const opencascade::handle<TDocStd_Document> &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<TDocStd_Document> &  ) >(&XCAFDoc_DocumentTool::IsXCAFDocument),
                    R"#(None)#"  , py::arg("Doc")
          )
        .def_static("DocLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::DocLabel),
                    R"#(Returns label where the DocumentTool attribute is or 0.1 if DocumentTool is not yet set.)#"  , py::arg("acces")
          )
        .def_static("ShapesLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ShapesLabel),
                    R"#(Returns sub-label of DocLabel() with tag 1.)#"  , py::arg("acces")
          )
        .def_static("ColorsLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ColorsLabel),
                    R"#(Returns sub-label of DocLabel() with tag 2.)#"  , py::arg("acces")
          )
        .def_static("LayersLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::LayersLabel),
                    R"#(Returns sub-label of DocLabel() with tag 3.)#"  , py::arg("acces")
          )
        .def_static("DGTsLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::DGTsLabel),
                    R"#(Returns sub-label of DocLabel() with tag 4.)#"  , py::arg("acces")
          )
        .def_static("MaterialsLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::MaterialsLabel),
                    R"#(Returns sub-label of DocLabel() with tag 5.)#"  , py::arg("acces")
          )
        .def_static("ViewsLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ViewsLabel),
                    R"#(Returns sub-label of DocLabel() with tag 7.)#"  , py::arg("acces")
          )
        .def_static("ClippingPlanesLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ClippingPlanesLabel),
                    R"#(Returns sub-label of DocLabel() with tag 8.)#"  , py::arg("acces")
          )
        .def_static("NotesLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::NotesLabel),
                    R"#(Returns sub-label of DocLabel() with tag 9.)#"  , py::arg("acces")
          )
        .def_static("VisMaterialLabel_s",
                    (TDF_Label (*)( const TDF_Label &  ) ) static_cast<TDF_Label (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::VisMaterialLabel),
                    R"#(Returns sub-label of DocLabel() with tag 10.)#"  , py::arg("theLabel")
          )
        .def_static("ShapeTool_s",
                    (opencascade::handle<XCAFDoc_ShapeTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ShapeTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ShapeTool),
                    R"#(Creates (if it does not exist) ShapeTool attribute on ShapesLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckShapeTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckShapeTool),
                    R"#(Checks for the ShapeTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("ColorTool_s",
                    (opencascade::handle<XCAFDoc_ColorTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ColorTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ColorTool),
                    R"#(Creates (if it does not exist) ColorTool attribute on ColorsLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckColorTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckColorTool),
                    R"#(Checks for the ColorTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("VisMaterialTool_s",
                    (opencascade::handle<XCAFDoc_VisMaterialTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_VisMaterialTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::VisMaterialTool),
                    R"#(Creates (if it does not exist) XCAFDoc_VisMaterialTool attribute on VisMaterialLabel(). Should not be confused with MaterialTool() defining physical/manufacturing materials.)#"  , py::arg("theLabel")
          )
        .def_static("CheckVisMaterialTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckVisMaterialTool),
                    R"#(Checks for the VisMaterialTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("LayerTool_s",
                    (opencascade::handle<XCAFDoc_LayerTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_LayerTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::LayerTool),
                    R"#(Creates (if it does not exist) LayerTool attribute on LayersLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckLayerTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckLayerTool),
                    R"#(Checks for the LayerTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("DimTolTool_s",
                    (opencascade::handle<XCAFDoc_DimTolTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_DimTolTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::DimTolTool),
                    R"#(Creates (if it does not exist) DimTolTool attribute on DGTsLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckDimTolTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckDimTolTool),
                    R"#(Checks for the DimTolTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("MaterialTool_s",
                    (opencascade::handle<XCAFDoc_MaterialTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_MaterialTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::MaterialTool),
                    R"#(Creates (if it does not exist) DimTolTool attribute on DGTsLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckMaterialTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckMaterialTool),
                    R"#(Checks for the MaterialTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("ViewTool_s",
                    (opencascade::handle<XCAFDoc_ViewTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ViewTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ViewTool),
                    R"#(Creates (if it does not exist) ViewTool attribute on ViewsLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckViewTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckViewTool),
                    R"#(Checks for the ViewTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("ClippingPlaneTool_s",
                    (opencascade::handle<XCAFDoc_ClippingPlaneTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ClippingPlaneTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::ClippingPlaneTool),
                    R"#(Creates (if it does not exist) ClippingPlaneTool attribute on ClippingPlanesLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckClippingPlaneTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckClippingPlaneTool),
                    R"#(Checks for the ClippingPlaneTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("NotesTool_s",
                    (opencascade::handle<XCAFDoc_NotesTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_NotesTool> (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::NotesTool),
                    R"#(Creates (if it does not exist) NotesTool attribute on NotesLabel().)#"  , py::arg("acces")
          )
        .def_static("CheckNotesTool_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_DocumentTool::CheckNotesTool),
                    R"#(Checks for the NotesTool attribute on the label's document Returns TRUE if Tool exists, ELSE if it has not been created)#"  , py::arg("theAcces")
          )
        .def_static("GetLengthUnit_s",
                    (Standard_Boolean (*)( const opencascade::handle<TDocStd_Document> & ,  Standard_Real & ,  const UnitsMethods_LengthUnit  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<TDocStd_Document> & ,  Standard_Real & ,  const UnitsMethods_LengthUnit  ) >(&XCAFDoc_DocumentTool::GetLengthUnit),
                    R"#(Returns value of current internal unit for the document converted to base unit type.)#"  , py::arg("theDoc"),  py::arg("theResut"),  py::arg("theBaseUnit")
          )
        .def_static("GetLengthUnit_s",
                    (Standard_Boolean (*)( const opencascade::handle<TDocStd_Document> & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (*)( const opencascade::handle<TDocStd_Document> & ,  Standard_Real &  ) >(&XCAFDoc_DocumentTool::GetLengthUnit),
                    R"#(Returns value of current internal unit for the document in meter)#"  , py::arg("theDoc"),  py::arg("theResut")
          )
        .def_static("SetLengthUnit_s",
                    (void (*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_Real  ) ) static_cast<void (*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_Real  ) >(&XCAFDoc_DocumentTool::SetLengthUnit),
                    R"#(Sets value of current internal unit to the document in meter)#"  , py::arg("theDoc"),  py::arg("theUnitValue")
          )
        .def_static("SetLengthUnit_s",
                    (void (*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_Real ,  const UnitsMethods_LengthUnit  ) ) static_cast<void (*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_Real ,  const UnitsMethods_LengthUnit  ) >(&XCAFDoc_DocumentTool::SetLengthUnit),
                    R"#(Sets value of current internal unit to the document)#"  , py::arg("theDoc"),  py::arg("theUnitValue"),  py::arg("theBaseUnit")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_DocumentTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_DocumentTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_DocumentTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_DocumentTool::*)() const>(&XCAFDoc_DocumentTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_DocumentTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_DocumentTool::*)() const>(&XCAFDoc_DocumentTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_Editor from ./opencascade/XCAFDoc_Editor.hxx
    klass = m.attr("XCAFDoc_Editor");

    // default constructor
    register_default_constructor<XCAFDoc_Editor , shared_ptr<XCAFDoc_Editor>>(m,"XCAFDoc_Editor");

    // nested enums

    static_cast<py::class_<XCAFDoc_Editor , shared_ptr<XCAFDoc_Editor>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Expand_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_Editor::Expand),
                    R"#(Converts shape (compound/compsolid/shell/wire) to assembly.)#"  , py::arg("theDoc"),  py::arg("theShape"),  py::arg("theRecursively")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Expand_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_Editor::Expand),
                    R"#(Converts all compounds shapes in the document to assembly)#"  , py::arg("theDoc"),  py::arg("theRecursively")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("Extract_s",
                    (Standard_Boolean (*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_Editor::Extract),
                    R"#(Clones all labels to a new position, keeping the structure with all the attributes)#"  , py::arg("theSrcLabels"),  py::arg("theDstLabel"),  py::arg("theIsNoVisMat")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def_static("Extract_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_Editor::Extract),
                    R"#(Clones the label to a new position, keeping the structure with all the attributes)#"  , py::arg("theSrcLabel"),  py::arg("theDstLabel"),  py::arg("theIsNoVisMat")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def_static("CloneShapeLabel_s",
                    (TDF_Label (*)( const TDF_Label & ,  const opencascade::handle<XCAFDoc_ShapeTool> & ,  const opencascade::handle<XCAFDoc_ShapeTool> & ,  NCollection_DataMap<TDF_Label, TDF_Label> &  ) ) static_cast<TDF_Label (*)( const TDF_Label & ,  const opencascade::handle<XCAFDoc_ShapeTool> & ,  const opencascade::handle<XCAFDoc_ShapeTool> & ,  NCollection_DataMap<TDF_Label, TDF_Label> &  ) >(&XCAFDoc_Editor::CloneShapeLabel),
                    R"#(Copies shapes label with keeping of shape structure (recursively))#"  , py::arg("theSrcLabel"),  py::arg("theSrcShapeTool"),  py::arg("theDstShapeTool"),  py::arg("theMap")
          )
        .def_static("CloneMetaData_s",
                    (void (*)( const TDF_Label & ,  const TDF_Label & ,  NCollection_DataMap<opencascade::handle<XCAFDoc_VisMaterial>, opencascade::handle<XCAFDoc_VisMaterial>> * ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) ) static_cast<void (*)( const TDF_Label & ,  const TDF_Label & ,  NCollection_DataMap<opencascade::handle<XCAFDoc_VisMaterial>, opencascade::handle<XCAFDoc_VisMaterial>> * ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) >(&XCAFDoc_Editor::CloneMetaData),
                    R"#(Copies metadata contains from the source label to the destination label. Protected against creating a new label for non-existent tools)#"  , py::arg("theSrcLabel"),  py::arg("theDstLabel"),  py::arg("theVisMatMap"),  py::arg("theToCopyColor")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("theToCopyLayer")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("theToCopyMaterial")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("theToCopyVisMaterial")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("theToCopyAttributes")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def_static("RescaleGeometry_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  const Standard_Real ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  const Standard_Real ,  const Standard_Boolean  ) >(&XCAFDoc_Editor::RescaleGeometry),
                    R"#(Applies geometrical scaling to the following assembly components: - part geometry - sub-assembly/part occurrence location - part's centroid, area and volume attributes - PMIs (warnings and errors are reported if it is impossible to make changes) Normally, should start from a root sub-assembly, but if theForceIfNotRoot true scaling will be applied forcibly. If theLabel corresponds to the shape tool scaling is applied to the whole assembly.)#"  , py::arg("theLabel"),  py::arg("theScaleFactor"),  py::arg("theForceIfNotRoot")=static_cast<const Standard_Boolean>(Standard_False)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XCAFDoc_GeomTolerance from ./opencascade/XCAFDoc_GeomTolerance.hxx
    klass = m.attr("XCAFDoc_GeomTolerance");


    // nested enums

    static_cast<py::class_<XCAFDoc_GeomTolerance ,opencascade::handle<XCAFDoc_GeomTolerance>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetObject",
             (void (XCAFDoc_GeomTolerance::*)( const opencascade::handle<XCAFDimTolObjects_GeomToleranceObject> &  ) ) static_cast<void (XCAFDoc_GeomTolerance::*)( const opencascade::handle<XCAFDimTolObjects_GeomToleranceObject> &  ) >(&XCAFDoc_GeomTolerance::SetObject),
             R"#(Updates parent's label and its sub-labels with data taken from theGeomToleranceObject. Old data associated with the label will be lost.)#"  , py::arg("theGeomToleranceObject")
          )
        .def("GetObject",
             (opencascade::handle<XCAFDimTolObjects_GeomToleranceObject> (XCAFDoc_GeomTolerance::*)() const) static_cast<opencascade::handle<XCAFDimTolObjects_GeomToleranceObject> (XCAFDoc_GeomTolerance::*)() const>(&XCAFDoc_GeomTolerance::GetObject),
             R"#(Returns geometry tolerance object data taken from the paren's label and its sub-labels.)#" 
          )
        .def("DumpJson",
             (void (XCAFDoc_GeomTolerance::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_GeomTolerance::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_GeomTolerance::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_GeomTolerance::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_GeomTolerance::*)() const>(&XCAFDoc_GeomTolerance::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_GeomTolerance::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_GeomTolerance> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_GeomTolerance> (*)( const TDF_Label &  ) >(&XCAFDoc_GeomTolerance::Set),
                    R"#(None)#"  , py::arg("theLabel")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_GeomTolerance::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_GeomTolerance::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_GeomTolerance::*)() const) static_cast<const Standard_GUID & (XCAFDoc_GeomTolerance::*)() const>(&XCAFDoc_GeomTolerance::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_GeomTolerance::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_GeomTolerance::*)() const>(&XCAFDoc_GeomTolerance::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_GraphNode from ./opencascade/XCAFDoc_GraphNode.hxx
    klass = m.attr("XCAFDoc_GraphNode");


    // nested enums

    static_cast<py::class_<XCAFDoc_GraphNode ,opencascade::handle<XCAFDoc_GraphNode>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetGraphID",
             (void (XCAFDoc_GraphNode::*)( const Standard_GUID &  ) ) static_cast<void (XCAFDoc_GraphNode::*)( const Standard_GUID &  ) >(&XCAFDoc_GraphNode::SetGraphID),
             R"#(None)#"  , py::arg("explicitID")
          )
        .def("SetFather",
             (Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) ) static_cast<Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) >(&XCAFDoc_GraphNode::SetFather),
             R"#(Set GraphNode <F> as father of me and returns index of <F> in Sequence that containing Fathers GraphNodes. return index of <F> from GraphNodeSequnece)#"  , py::arg("F")
          )
        .def("SetChild",
             (Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) ) static_cast<Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) >(&XCAFDoc_GraphNode::SetChild),
             R"#(Set GraphNode <Ch> as child of me and returns index of <Ch> in Sequence that containing Children GraphNodes. return index of <Ch> from GraphNodeSequnece)#"  , py::arg("Ch")
          )
        .def("UnSetFather",
             (void (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) ) static_cast<void (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) >(&XCAFDoc_GraphNode::UnSetFather),
             R"#(Remove <F> from Fathers GraphNodeSequence. and remove link between father and child.)#"  , py::arg("F")
          )
        .def("UnSetFather",
             (void (XCAFDoc_GraphNode::*)( const Standard_Integer  ) ) static_cast<void (XCAFDoc_GraphNode::*)( const Standard_Integer  ) >(&XCAFDoc_GraphNode::UnSetFather),
             R"#(Remove Father GraphNode by index from Fathers GraphNodeSequence. and remove link between father and child.)#"  , py::arg("Findex")
          )
        .def("UnSetChild",
             (void (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) ) static_cast<void (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) >(&XCAFDoc_GraphNode::UnSetChild),
             R"#(Remove <Ch> from GraphNodeSequence. and remove link between father and child.)#"  , py::arg("Ch")
          )
        .def("UnSetChild",
             (void (XCAFDoc_GraphNode::*)( const Standard_Integer  ) ) static_cast<void (XCAFDoc_GraphNode::*)( const Standard_Integer  ) >(&XCAFDoc_GraphNode::UnSetChild),
             R"#(Remove Child GraphNode by index from Children GraphNodeSequence. and remove link between father and child.)#"  , py::arg("Chindex")
          )
        .def("GetFather",
             (opencascade::handle<XCAFDoc_GraphNode> (XCAFDoc_GraphNode::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<XCAFDoc_GraphNode> (XCAFDoc_GraphNode::*)( const Standard_Integer  ) const>(&XCAFDoc_GraphNode::GetFather),
             R"#(Return GraphNode by index from GraphNodeSequence.)#"  , py::arg("Findex")
          )
        .def("GetChild",
             (opencascade::handle<XCAFDoc_GraphNode> (XCAFDoc_GraphNode::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<XCAFDoc_GraphNode> (XCAFDoc_GraphNode::*)( const Standard_Integer  ) const>(&XCAFDoc_GraphNode::GetChild),
             R"#(Return GraphNode by index from GraphNodeSequence.)#"  , py::arg("Chindex")
          )
        .def("FatherIndex",
             (Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const) static_cast<Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const>(&XCAFDoc_GraphNode::FatherIndex),
             R"#(Return index of <F>, or zero if there is no such Graphnode.)#"  , py::arg("F")
          )
        .def("ChildIndex",
             (Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const) static_cast<Standard_Integer (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const>(&XCAFDoc_GraphNode::ChildIndex),
             R"#(Return index of <Ch>, or zero if there is no such Graphnode.)#"  , py::arg("Ch")
          )
        .def("IsFather",
             (Standard_Boolean (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const) static_cast<Standard_Boolean (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const>(&XCAFDoc_GraphNode::IsFather),
             R"#(returns TRUE if <me> is father of <Ch>.)#"  , py::arg("Ch")
          )
        .def("IsChild",
             (Standard_Boolean (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const) static_cast<Standard_Boolean (XCAFDoc_GraphNode::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const>(&XCAFDoc_GraphNode::IsChild),
             R"#(returns TRUE if <me> is child of <F>.)#"  , py::arg("F")
          )
        .def("NbFathers",
             (Standard_Integer (XCAFDoc_GraphNode::*)() const) static_cast<Standard_Integer (XCAFDoc_GraphNode::*)() const>(&XCAFDoc_GraphNode::NbFathers),
             R"#(return Number of Fathers GraphNodes.)#" 
          )
        .def("NbChildren",
             (Standard_Integer (XCAFDoc_GraphNode::*)() const) static_cast<Standard_Integer (XCAFDoc_GraphNode::*)() const>(&XCAFDoc_GraphNode::NbChildren),
             R"#(return Number of Childrens GraphNodes. Implementation of Attribute methods: ===================================)#" 
          )
        .def("Restore",
             (void (XCAFDoc_GraphNode::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_GraphNode::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_GraphNode::Restore),
             R"#(None)#"  , py::arg("with")
          )
        .def("Paste",
             (void (XCAFDoc_GraphNode::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_GraphNode::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_GraphNode::Paste),
             R"#(None)#"  , py::arg("into"),  py::arg("RT")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_GraphNode::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_GraphNode::*)() const>(&XCAFDoc_GraphNode::NewEmpty),
             R"#(None)#" 
          )
        .def("References",
             (void (XCAFDoc_GraphNode::*)( const opencascade::handle<TDF_DataSet> &  ) const) static_cast<void (XCAFDoc_GraphNode::*)( const opencascade::handle<TDF_DataSet> &  ) const>(&XCAFDoc_GraphNode::References),
             R"#(None)#"  , py::arg("aDataSet")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_GraphNode::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_GraphNode::*)( std::ostream &  ) const>(&XCAFDoc_GraphNode::Dump),
             R"#(None)#"  , py::arg("anOS")
          )
        .def("BeforeForget",
             (void (XCAFDoc_GraphNode::*)() ) static_cast<void (XCAFDoc_GraphNode::*)() >(&XCAFDoc_GraphNode::BeforeForget),
             R"#(None)#" 
          )
        .def("DumpJson",
             (void (XCAFDoc_GraphNode::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_GraphNode::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_GraphNode::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Find_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) >(&XCAFDoc_GraphNode::Find),
                    R"#(class methods working on the node =================================== Shortcut to search a Graph node attribute with default GraphID. Returns true if found.)#"  , py::arg("L"),  py::arg("G")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_GraphNode> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_GraphNode> (*)( const TDF_Label &  ) >(&XCAFDoc_GraphNode::Set),
                    R"#(Finds or Creates a GraphNode attribute on the label <L> with the default Graph ID, returned by the method <GetDefaultGraphID>. Returns the created/found GraphNode attribute.)#"  , py::arg("L")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_GraphNode> (*)( const TDF_Label & ,  const Standard_GUID &  ) ) static_cast<opencascade::handle<XCAFDoc_GraphNode> (*)( const TDF_Label & ,  const Standard_GUID &  ) >(&XCAFDoc_GraphNode::Set),
                    R"#(Finds or Creates a GraphNode attribute on the label <L>, with an explicit tree ID. <ExplicitGraphID> is the ID returned by <TDF_Attribute::ID> method. Returns the found/created GraphNode attribute.)#"  , py::arg("L"),  py::arg("ExplicitGraphID")
          )
        .def_static("GetDefaultGraphID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_GraphNode::GetDefaultGraphID),
                    R"#(returns a default Graph ID. this ID is used by the <Set> method without explicit tree ID. Instance methods: ================)#" 
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_GraphNode::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_GraphNode::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_GraphNode::*)() const) static_cast<const Standard_GUID & (XCAFDoc_GraphNode::*)() const>(&XCAFDoc_GraphNode::ID),
             R"#(Returns the Graph ID (default or explicit one depending on the Set method used).)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_GraphNode::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_GraphNode::*)() const>(&XCAFDoc_GraphNode::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_LayerTool from ./opencascade/XCAFDoc_LayerTool.hxx
    klass = m.attr("XCAFDoc_LayerTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_LayerTool ,opencascade::handle<XCAFDoc_LayerTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_LayerTool::*)() const) static_cast<TDF_Label (XCAFDoc_LayerTool::*)() const>(&XCAFDoc_LayerTool::BaseLabel),
             R"#(returns the label under which Layers are stored)#" 
          )
        .def("IsLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const>(&XCAFDoc_LayerTool::IsLayer),
             R"#(Returns True if label belongs to a Layertable and is a Layer definition)#"  , py::arg("lab")
          )
        .def("GetLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  TCollection_ExtendedString &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  TCollection_ExtendedString &  ) const>(&XCAFDoc_LayerTool::GetLayer),
             R"#(Returns Layer defined by label lab Returns False if the label is not in Layertable or does not define a Layer)#"  , py::arg("lab"),  py::arg("aLayer")
          )
        .def("FindLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString & ,  TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString & ,  TDF_Label &  ) const>(&XCAFDoc_LayerTool::FindLayer),
             R"#(Finds a Layer definition in a Layertable and returns its label if found Returns False if Layer is not found in Layertable)#"  , py::arg("aLayer"),  py::arg("lab")
          )
        .def("FindLayer",
             (TDF_Label (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString & ,  const Standard_Boolean ,  const Standard_Boolean  ) const) static_cast<TDF_Label (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString & ,  const Standard_Boolean ,  const Standard_Boolean  ) const>(&XCAFDoc_LayerTool::FindLayer),
             R"#(Finds a Layer definition in a Layertable by name Returns first founded label with the same name if <theToFindWithProperty> is false If <theToFindWithProperty> is true returns first label that contains or not contains visible attr, according to the <theToFindVisible> parameter)#"  , py::arg("aLayer"),  py::arg("theToFindWithProperty")=static_cast<const Standard_Boolean>(Standard_False),  py::arg("theToFindVisible")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("AddLayer",
             (TDF_Label (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString &  ) const) static_cast<TDF_Label (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString &  ) const>(&XCAFDoc_LayerTool::AddLayer),
             R"#(Adds a Layer definition to a Layertable and returns its label (returns existing label if the same Layer is already defined))#"  , py::arg("theLayer")
          )
        .def("AddLayer",
             (TDF_Label (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString & ,  const Standard_Boolean  ) const) static_cast<TDF_Label (XCAFDoc_LayerTool::*)( const TCollection_ExtendedString & ,  const Standard_Boolean  ) const>(&XCAFDoc_LayerTool::AddLayer),
             R"#(Adds a Layer definition to a Layertable and returns its label Returns existing label (if it is already defined) of visible or invisible layer, according to <theToFindVisible> parameter)#"  , py::arg("theLayer"),  py::arg("theToFindVisible")
          )
        .def("RemoveLayer",
             (void (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const>(&XCAFDoc_LayerTool::RemoveLayer),
             R"#(Removes Layer from the Layertable)#"  , py::arg("lab")
          )
        .def("GetLayerLabels",
             (void (XCAFDoc_LayerTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_LayerTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_LayerTool::GetLayerLabels),
             R"#(Returns a sequence of Layers currently stored in the Layertable)#"  , py::arg("Labels")
          )
        .def("SetLayer",
             (void (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_Boolean  ) const) static_cast<void (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_Boolean  ) const>(&XCAFDoc_LayerTool::SetLayer),
             R"#(Sets a link from label <L> to Layer defined by <LayerL> optional parameter <shapeInOneLayer> show could shape be in number of layers or only in one.)#"  , py::arg("L"),  py::arg("LayerL"),  py::arg("shapeInOneLayer")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("SetLayer",
             (void (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) const) static_cast<void (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) const>(&XCAFDoc_LayerTool::SetLayer),
             R"#(Sets a link from label <L> to Layer <aLayer> in the Layertable Adds a Layer as necessary optional parameter <shapeInOneLayer> show could shape be in number of layers or only in one.)#"  , py::arg("L"),  py::arg("aLayer"),  py::arg("shapeInOneLayer")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("UnSetLayers",
             (void (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const>(&XCAFDoc_LayerTool::UnSetLayers),
             R"#(Removes a link from label <L> to all layers)#"  , py::arg("L")
          )
        .def("UnSetOneLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TCollection_ExtendedString &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TCollection_ExtendedString &  ) const>(&XCAFDoc_LayerTool::UnSetOneLayer),
             R"#(Remove link from label <L> and Layer <aLayer>. returns FALSE if no such layer.)#"  , py::arg("L"),  py::arg("aLayer")
          )
        .def("UnSetOneLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_LayerTool::UnSetOneLayer),
             R"#(Remove link from label <L> and Layer <aLayerL>. returns FALSE if <aLayerL> is not a layer label.)#"  , py::arg("L"),  py::arg("aLayerL")
          )
        .def("IsSet",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TCollection_ExtendedString &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TCollection_ExtendedString &  ) const>(&XCAFDoc_LayerTool::IsSet),
             R"#(Returns True if label <L> has a Layer associated with the <aLayer>.)#"  , py::arg("L"),  py::arg("aLayer")
          )
        .def("IsSet",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_LayerTool::IsSet),
             R"#(Returns True if label <L> has a Layer associated with the <aLayerL> label.)#"  , py::arg("L"),  py::arg("aLayerL")
          )
        .def("GetLayers",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  opencascade::handle<TColStd_HSequenceOfExtendedString> &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  opencascade::handle<TColStd_HSequenceOfExtendedString> &  ) >(&XCAFDoc_LayerTool::GetLayers),
             R"#(Return sequence of strings <aLayerS> that associated with label <L>.)#"  , py::arg("L"),  py::arg("aLayerS")
          )
        .def("GetLayers",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_LayerTool::GetLayers),
             R"#(Return sequence of labels <aLayerSL> that associated with label <L>.)#"  , py::arg("L"),  py::arg("aLayerLS")
          )
        .def("GetLayers",
             (opencascade::handle<TColStd_HSequenceOfExtendedString> (XCAFDoc_LayerTool::*)( const TDF_Label &  ) ) static_cast<opencascade::handle<TColStd_HSequenceOfExtendedString> (XCAFDoc_LayerTool::*)( const TDF_Label &  ) >(&XCAFDoc_LayerTool::GetLayers),
             R"#(Return sequence of strings that associated with label <L>.)#"  , py::arg("L")
          )
        .def("IsVisible",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TDF_Label &  ) const>(&XCAFDoc_LayerTool::IsVisible),
             R"#(Return TRUE if layer is visible, FALSE if invisible.)#"  , py::arg("layerL")
          )
        .def("SetVisibility",
             (void (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const Standard_Boolean  ) const) static_cast<void (XCAFDoc_LayerTool::*)( const TDF_Label & ,  const Standard_Boolean  ) const>(&XCAFDoc_LayerTool::SetVisibility),
             R"#(Set the visibility of layer. If layer is invisible when on it's layer will set UAttribute with corresponding GUID.)#"  , py::arg("layerL"),  py::arg("isvisible")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_LayerTool::SetLayer),
             R"#(Sets a link from label that containing shape <Sh> with layer that situated at label <LayerL>. optional parameter <shapeInOneLayer> show could shape be in number of layers or only in one. return FALSE if no such shape <Sh> or label <LayerL>)#"  , py::arg("Sh"),  py::arg("LayerL"),  py::arg("shapeInOneLayer")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("SetLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) >(&XCAFDoc_LayerTool::SetLayer),
             R"#(Sets a link from label that containing shape <Sh> with layer <aLayer>. Add <aLayer> to LayerTable if nessesery. optional parameter <shapeInOneLayer> show could shape be in number of layers or only in one. return FALSE if no such shape <Sh>.)#"  , py::arg("Sh"),  py::arg("aLayer"),  py::arg("shapeInOneLayer")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("UnSetLayers",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape &  ) >(&XCAFDoc_LayerTool::UnSetLayers),
             R"#(Remove link between shape <Sh> and all Layers at LayerTable. return FALSE if no such shape <Sh> in XCAF Document.)#"  , py::arg("Sh")
          )
        .def("UnSetOneLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TCollection_ExtendedString &  ) >(&XCAFDoc_LayerTool::UnSetOneLayer),
             R"#(Remove link between shape <Sh> and layer <aLayer>. returns FALSE if no such layer <aLayer> or shape <Sh>.)#"  , py::arg("Sh"),  py::arg("aLayer")
          )
        .def("UnSetOneLayer",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TDF_Label &  ) >(&XCAFDoc_LayerTool::UnSetOneLayer),
             R"#(Remove link between shape <Sh> and layer <aLayerL>. returns FALSE if no such layer <aLayerL> or shape <Sh>.)#"  , py::arg("Sh"),  py::arg("aLayerL")
          )
        .def("IsSet",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TCollection_ExtendedString &  ) >(&XCAFDoc_LayerTool::IsSet),
             R"#(Returns True if shape <Sh> has a Layer associated with the <aLayer>.)#"  , py::arg("Sh"),  py::arg("aLayer")
          )
        .def("IsSet",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  const TDF_Label &  ) >(&XCAFDoc_LayerTool::IsSet),
             R"#(Returns True if shape <Sh> has a Layer associated with the <aLayerL>.)#"  , py::arg("Sh"),  py::arg("aLayerL")
          )
        .def("GetLayers",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  opencascade::handle<TColStd_HSequenceOfExtendedString> &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  opencascade::handle<TColStd_HSequenceOfExtendedString> &  ) >(&XCAFDoc_LayerTool::GetLayers),
             R"#(Return sequence of strings <aLayerS> that associated with shape <Sh>.)#"  , py::arg("Sh"),  py::arg("aLayerS")
          )
        .def("GetLayers",
             (Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (XCAFDoc_LayerTool::*)( const TopoDS_Shape & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_LayerTool::GetLayers),
             R"#(Return sequence of labels <aLayerLS> that associated with shape <Sh>.)#"  , py::arg("Sh"),  py::arg("aLayerLS")
          )
        .def("GetLayers",
             (opencascade::handle<TColStd_HSequenceOfExtendedString> (XCAFDoc_LayerTool::*)( const TopoDS_Shape &  ) ) static_cast<opencascade::handle<TColStd_HSequenceOfExtendedString> (XCAFDoc_LayerTool::*)( const TopoDS_Shape &  ) >(&XCAFDoc_LayerTool::GetLayers),
             R"#(Return sequence of strings that associated with shape <Sh>.)#"  , py::arg("Sh")
          )
        .def("DumpJson",
             (void (XCAFDoc_LayerTool::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_LayerTool::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_LayerTool::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_LayerTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_LayerTool::*)() const>(&XCAFDoc_LayerTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_LayerTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_LayerTool> (*)( const TDF_Label &  ) >(&XCAFDoc_LayerTool::Set),
                    R"#(Creates (if not exist) LayerTool.)#"  , py::arg("L")
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_LayerTool::GetID),
                    R"#(None)#" 
          )
        .def_static("GetShapesOfLayer_s",
                    (void (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<void (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_LayerTool::GetShapesOfLayer),
                    R"#(Return sequanese of shape labels that assigned with layers to <ShLabels>.)#"  , py::arg("theLayerL"),  py::arg("theShLabels")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_LayerTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_LayerTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ShapeTool",
             (const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_LayerTool::*)() ) static_cast<const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_LayerTool::*)() >(&XCAFDoc_LayerTool::ShapeTool),
             R"#(Returns internal XCAFDoc_ShapeTool tool)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_LayerTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_LayerTool::*)() const>(&XCAFDoc_LayerTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_LayerTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_LayerTool::*)() const>(&XCAFDoc_LayerTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_LengthUnit from ./opencascade/XCAFDoc_LengthUnit.hxx
    klass = m.attr("XCAFDoc_LengthUnit");


    // nested enums

    static_cast<py::class_<XCAFDoc_LengthUnit ,opencascade::handle<XCAFDoc_LengthUnit>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_LengthUnit::*)( const TCollection_AsciiString & ,  const Standard_Real  ) ) static_cast<void (XCAFDoc_LengthUnit::*)( const TCollection_AsciiString & ,  const Standard_Real  ) >(&XCAFDoc_LengthUnit::Set),
             R"#(Creates a LengthUnit attribute)#"  , py::arg("theUnitName"),  py::arg("theUnitValue")
          )
        .def("GetUnitValue",
             (Standard_Real (XCAFDoc_LengthUnit::*)() const) static_cast<Standard_Real (XCAFDoc_LengthUnit::*)() const>(&XCAFDoc_LengthUnit::GetUnitValue),
             R"#(Returns length unit scale factor to meter)#" 
          )
        .def("IsEmpty",
             (Standard_Boolean (XCAFDoc_LengthUnit::*)() const) static_cast<Standard_Boolean (XCAFDoc_LengthUnit::*)() const>(&XCAFDoc_LengthUnit::IsEmpty),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_LengthUnit::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_LengthUnit::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_LengthUnit::Restore),
             R"#(None)#"  , py::arg("theWith")
          )
        .def("Paste",
             (void (XCAFDoc_LengthUnit::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_LengthUnit::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_LengthUnit::Paste),
             R"#(None)#"  , py::arg("theInto"),  py::arg("theRT")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_LengthUnit::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_LengthUnit::*)( std::ostream &  ) const>(&XCAFDoc_LengthUnit::Dump),
             R"#(None)#"  , py::arg("anOS")
          )
        .def("DumpJson",
             (void (XCAFDoc_LengthUnit::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_LengthUnit::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_LengthUnit::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_LengthUnit::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_LengthUnit::*)() const>(&XCAFDoc_LengthUnit::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_LengthUnit::GetID),
                    R"#(Returns the GUID of the attribute.)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_LengthUnit> (*)( const TDF_Label & ,  const TCollection_AsciiString & ,  const Standard_Real  ) ) static_cast<opencascade::handle<XCAFDoc_LengthUnit> (*)( const TDF_Label & ,  const TCollection_AsciiString & ,  const Standard_Real  ) >(&XCAFDoc_LengthUnit::Set),
                    R"#(Finds or creates a LengthUnit attribute)#"  , py::arg("theLabel"),  py::arg("theUnitName"),  py::arg("theUnitValue")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_LengthUnit> (*)( const TDF_Label & ,  const Standard_Real  ) ) static_cast<opencascade::handle<XCAFDoc_LengthUnit> (*)( const TDF_Label & ,  const Standard_Real  ) >(&XCAFDoc_LengthUnit::Set),
                    R"#(Finds or creates a LengthUnit attribute)#"  , py::arg("theLabel"),  py::arg("theUnitValue")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_LengthUnit> (*)( const TDF_Label & ,  const Standard_GUID & ,  const TCollection_AsciiString & ,  const Standard_Real  ) ) static_cast<opencascade::handle<XCAFDoc_LengthUnit> (*)( const TDF_Label & ,  const Standard_GUID & ,  const TCollection_AsciiString & ,  const Standard_Real  ) >(&XCAFDoc_LengthUnit::Set),
                    R"#(Finds, or creates, a LengthUnit attribute with explicit user defined GUID)#"  , py::arg("theLabel"),  py::arg("theGUID"),  py::arg("theUnitName"),  py::arg("theUnitValue")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_LengthUnit::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_LengthUnit::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetUnitName",
             (const TCollection_AsciiString & (XCAFDoc_LengthUnit::*)() const) static_cast<const TCollection_AsciiString & (XCAFDoc_LengthUnit::*)() const>(&XCAFDoc_LengthUnit::GetUnitName),
             R"#(Length unit description (could be arbitrary text))#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_LengthUnit::*)() const) static_cast<const Standard_GUID & (XCAFDoc_LengthUnit::*)() const>(&XCAFDoc_LengthUnit::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_LengthUnit::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_LengthUnit::*)() const>(&XCAFDoc_LengthUnit::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_Location from ./opencascade/XCAFDoc_Location.hxx
    klass = m.attr("XCAFDoc_Location");


    // nested enums

    static_cast<py::class_<XCAFDoc_Location ,opencascade::handle<XCAFDoc_Location>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Location::*)( const TopLoc_Location &  ) ) static_cast<void (XCAFDoc_Location::*)( const TopLoc_Location &  ) >(&XCAFDoc_Location::Set),
             R"#(None)#"  , py::arg("Loc")
          )
        .def("Restore",
             (void (XCAFDoc_Location::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_Location::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_Location::Restore),
             R"#(None)#"  , py::arg("With")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Location::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Location::*)() const>(&XCAFDoc_Location::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (void (XCAFDoc_Location::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_Location::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_Location::Paste),
             R"#(None)#"  , py::arg("Into"),  py::arg("RT")
          )
        .def("DumpJson",
             (void (XCAFDoc_Location::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Location::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Location::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Location::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Location> (*)( const TDF_Label & ,  const TopLoc_Location &  ) ) static_cast<opencascade::handle<XCAFDoc_Location> (*)( const TDF_Label & ,  const TopLoc_Location &  ) >(&XCAFDoc_Location::Set),
                    R"#(Find, or create, a Location attribute and set it's value the Location attribute is returned. Location methods ===============)#"  , py::arg("label"),  py::arg("Loc")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Location::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Location::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Get",
             (const TopLoc_Location & (XCAFDoc_Location::*)() const) static_cast<const TopLoc_Location & (XCAFDoc_Location::*)() const>(&XCAFDoc_Location::Get),
             R"#(Returns True if there is a reference on the same label)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Location::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Location::*)() const>(&XCAFDoc_Location::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Location::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Location::*)() const>(&XCAFDoc_Location::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_Material from ./opencascade/XCAFDoc_Material.hxx
    klass = m.attr("XCAFDoc_Material");


    // nested enums

    static_cast<py::class_<XCAFDoc_Material ,opencascade::handle<XCAFDoc_Material>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Material::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDoc_Material::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_Material::Set),
             R"#(None)#"  , py::arg("aName"),  py::arg("aDescription"),  py::arg("aDensity"),  py::arg("aDensName"),  py::arg("aDensValType")
          )
        .def("GetName",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::GetName),
             R"#(None)#" 
          )
        .def("GetDescription",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::GetDescription),
             R"#(None)#" 
          )
        .def("GetDensity",
             (Standard_Real (XCAFDoc_Material::*)() const) static_cast<Standard_Real (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::GetDensity),
             R"#(None)#" 
          )
        .def("GetDensName",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::GetDensName),
             R"#(None)#" 
          )
        .def("GetDensValType",
             (opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::GetDensValType),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_Material::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_Material::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_Material::Restore),
             R"#(None)#"  , py::arg("With")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Material::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (void (XCAFDoc_Material::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_Material::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_Material::Paste),
             R"#(None)#"  , py::arg("Into"),  py::arg("RT")
          )
        .def("DumpJson",
             (void (XCAFDoc_Material::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Material::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Material::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Material::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Material> (*)( const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<opencascade::handle<XCAFDoc_Material> (*)( const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_Material::Set),
                    R"#(None)#"  , py::arg("label"),  py::arg("aName"),  py::arg("aDescription"),  py::arg("aDensity"),  py::arg("aDensName"),  py::arg("aDensValType")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Material::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Material::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Material::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Material::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Material::*)() const>(&XCAFDoc_Material::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_MaterialTool from ./opencascade/XCAFDoc_MaterialTool.hxx
    klass = m.attr("XCAFDoc_MaterialTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_MaterialTool ,opencascade::handle<XCAFDoc_MaterialTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_MaterialTool::*)() const) static_cast<TDF_Label (XCAFDoc_MaterialTool::*)() const>(&XCAFDoc_MaterialTool::BaseLabel),
             R"#(returns the label under which colors are stored)#" 
          )
        .def("IsMaterial",
             (Standard_Boolean (XCAFDoc_MaterialTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_MaterialTool::*)( const TDF_Label &  ) const>(&XCAFDoc_MaterialTool::IsMaterial),
             R"#(Returns True if label belongs to a material table and is a Material definition)#"  , py::arg("lab")
          )
        .def("GetMaterialLabels",
             (void (XCAFDoc_MaterialTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_MaterialTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_MaterialTool::GetMaterialLabels),
             R"#(Returns a sequence of materials currently stored in the material table)#"  , py::arg("Labels")
          )
        .def("AddMaterial",
             (TDF_Label (XCAFDoc_MaterialTool::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<TDF_Label (XCAFDoc_MaterialTool::*)( const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_MaterialTool::AddMaterial),
             R"#(Adds a Material definition to a table and returns its label)#"  , py::arg("aName"),  py::arg("aDescription"),  py::arg("aDensity"),  py::arg("aDensName"),  py::arg("aDensValType")
          )
        .def("SetMaterial",
             (void (XCAFDoc_MaterialTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_MaterialTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_MaterialTool::SetMaterial),
             R"#(Sets a link with GUID)#"  , py::arg("L"),  py::arg("MatL")
          )
        .def("SetMaterial",
             (void (XCAFDoc_MaterialTool::*)( const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const) static_cast<void (XCAFDoc_MaterialTool::*)( const TDF_Label & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Real ,  const opencascade::handle<TCollection_HAsciiString> & ,  const opencascade::handle<TCollection_HAsciiString> &  ) const>(&XCAFDoc_MaterialTool::SetMaterial),
             R"#(Sets a link with GUID Adds a Material as necessary)#"  , py::arg("L"),  py::arg("aName"),  py::arg("aDescription"),  py::arg("aDensity"),  py::arg("aDensName"),  py::arg("aDensValType")
          )
        .def("DumpJson",
             (void (XCAFDoc_MaterialTool::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_MaterialTool::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_MaterialTool::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_MaterialTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_MaterialTool::*)() const>(&XCAFDoc_MaterialTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_MaterialTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_MaterialTool> (*)( const TDF_Label &  ) >(&XCAFDoc_MaterialTool::Set),
                    R"#(Creates (if not exist) MaterialTool.)#"  , py::arg("L")
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_MaterialTool::GetID),
                    R"#(None)#" 
          )
        .def_static("GetMaterial_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> & ,  Standard_Real & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> & ,  Standard_Real & ,  opencascade::handle<TCollection_HAsciiString> & ,  opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_MaterialTool::GetMaterial),
                    R"#(Returns Material assigned to <MatL> Returns False if no such Material is assigned)#"  , py::arg("MatL"),  py::arg("aName"),  py::arg("aDescription"),  py::arg("aDensity"),  py::arg("aDensName"),  py::arg("aDensValType")
          )
        .def_static("GetDensityForShape_s",
                    (Standard_Real (*)( const TDF_Label &  ) ) static_cast<Standard_Real (*)( const TDF_Label &  ) >(&XCAFDoc_MaterialTool::GetDensityForShape),
                    R"#(Find referred material and return density from it if no material --> return 0)#"  , py::arg("ShapeL")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_MaterialTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_MaterialTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ShapeTool",
             (const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_MaterialTool::*)() ) static_cast<const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_MaterialTool::*)() >(&XCAFDoc_MaterialTool::ShapeTool),
             R"#(Returns internal XCAFDoc_ShapeTool tool)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_MaterialTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_MaterialTool::*)() const>(&XCAFDoc_MaterialTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_MaterialTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_MaterialTool::*)() const>(&XCAFDoc_MaterialTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_Note from ./opencascade/XCAFDoc_Note.hxx
    klass = m.attr("XCAFDoc_Note");


    // nested enums

    static_cast<py::class_<XCAFDoc_Note ,opencascade::handle<XCAFDoc_Note> ,Py_XCAFDoc_Note , TDF_Attribute >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Note::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) ) static_cast<void (XCAFDoc_Note::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) >(&XCAFDoc_Note::Set),
             R"#(Sets the user name and the timestamp of the note.)#"  , py::arg("theUserName"),  py::arg("theTimeStamp")
          )
        .def("IsOrphan",
             (Standard_Boolean (XCAFDoc_Note::*)() const) static_cast<Standard_Boolean (XCAFDoc_Note::*)() const>(&XCAFDoc_Note::IsOrphan),
             R"#(Checks if the note isn't linked to annotated items.)#" 
          )
        .def("GetObject",
             (opencascade::handle<XCAFNoteObjects_NoteObject> (XCAFDoc_Note::*)() const) static_cast<opencascade::handle<XCAFNoteObjects_NoteObject> (XCAFDoc_Note::*)() const>(&XCAFDoc_Note::GetObject),
             R"#(Returns auxiliary data object)#" 
          )
        .def("SetObject",
             (void (XCAFDoc_Note::*)( const opencascade::handle<XCAFNoteObjects_NoteObject> &  ) ) static_cast<void (XCAFDoc_Note::*)( const opencascade::handle<XCAFNoteObjects_NoteObject> &  ) >(&XCAFDoc_Note::SetObject),
             R"#(Updates auxiliary data)#"  , py::arg("theObject")
          )
        .def("Restore",
             (void (XCAFDoc_Note::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_Note::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_Note::Restore),
             R"#(None)#"  , py::arg("theAttrFrom")
          )
        .def("Paste",
             (void (XCAFDoc_Note::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_Note::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_Note::Paste),
             R"#(None)#"  , py::arg("theAttrInto"),  py::arg("theRT")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_Note::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_Note::*)( std::ostream &  ) const>(&XCAFDoc_Note::Dump),
             R"#(None)#"  , py::arg("theOS")
          )
        .def("DumpJson",
             (void (XCAFDoc_Note::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Note::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Note::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Note::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Note::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("IsMine_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_Note::IsMine),
                    R"#(Checks if the given label represents a note.)#"  , py::arg("theLabel")
          )
        .def_static("Get_s",
                    (opencascade::handle<XCAFDoc_Note> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_Note> (*)( const TDF_Label &  ) >(&XCAFDoc_Note::Get),
                    R"#(Finds a reference attribute on the given label and returns it, if it is found)#"  , py::arg("theLabel")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Note::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Note::*)() const>(&XCAFDoc_Note::DynamicType),
             R"#(None)#"
             
         )
       .def("UserName",
             (const TCollection_ExtendedString & (XCAFDoc_Note::*)() const) static_cast<const TCollection_ExtendedString & (XCAFDoc_Note::*)() const>(&XCAFDoc_Note::UserName),
             R"#(Returns the user name, who created the note.)#"
             
         )
       .def("TimeStamp",
             (const TCollection_ExtendedString & (XCAFDoc_Note::*)() const) static_cast<const TCollection_ExtendedString & (XCAFDoc_Note::*)() const>(&XCAFDoc_Note::TimeStamp),
             R"#(Returns the timestamp of the note.)#"
             
         )
;

    // Class XCAFDoc_NotesTool from ./opencascade/XCAFDoc_NotesTool.hxx
    klass = m.attr("XCAFDoc_NotesTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_NotesTool ,opencascade::handle<XCAFDoc_NotesTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_NotesTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::NewEmpty),
             R"#(None)#" 
          )
        .def("GetNotesLabel",
             (TDF_Label (XCAFDoc_NotesTool::*)() const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::GetNotesLabel),
             R"#(Returns the label of the notes hive.)#" 
          )
        .def("GetAnnotatedItemsLabel",
             (TDF_Label (XCAFDoc_NotesTool::*)() const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::GetAnnotatedItemsLabel),
             R"#(Returns the label of the annotated items hive.)#" 
          )
        .def("NbNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)() const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::NbNotes),
             R"#(Returns the number of labels in the notes hive.)#" 
          )
        .def("NbAnnotatedItems",
             (Standard_Integer (XCAFDoc_NotesTool::*)() const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::NbAnnotatedItems),
             R"#(Returns the number of labels in the annotated items hive.)#" 
          )
        .def("GetNotes",
             (void (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetNotes),
             R"#(Returns all labels from the notes hive. The label sequence isn't cleared beforehand.)#"  , py::arg("theNoteLabels")
          )
        .def("GetAnnotatedItems",
             (void (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetAnnotatedItems),
             R"#(Returns all labels from the annotated items hive. The label sequence isn't cleared beforehand.)#"  , py::arg("theLabels")
          )
        .def("IsAnnotatedItem",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId &  ) const) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId &  ) const>(&XCAFDoc_NotesTool::IsAnnotatedItem),
             R"#(Checks if the given assembly item is annotated.)#"  , py::arg("theItemId")
          )
        .def("IsAnnotatedItem",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label &  ) const>(&XCAFDoc_NotesTool::IsAnnotatedItem),
             R"#(Checks if the given labeled item is annotated.)#"  , py::arg("theItemLabel")
          )
        .def("FindAnnotatedItem",
             (TDF_Label (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId &  ) const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId &  ) const>(&XCAFDoc_NotesTool::FindAnnotatedItem),
             R"#(Finds a label of the given assembly item ID in the annotated items hive.)#"  , py::arg("theItemId")
          )
        .def("FindAnnotatedItem",
             (TDF_Label (XCAFDoc_NotesTool::*)( const TDF_Label &  ) const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)( const TDF_Label &  ) const>(&XCAFDoc_NotesTool::FindAnnotatedItem),
             R"#(Finds a label of the given labeled item in the annotated items hive.)#"  , py::arg("theItemLabel")
          )
        .def("FindAnnotatedItemAttr",
             (TDF_Label (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  const Standard_GUID &  ) const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  const Standard_GUID &  ) const>(&XCAFDoc_NotesTool::FindAnnotatedItemAttr),
             R"#(Finds a label of the given assembly item's attribute in the annotated items hive.)#"  , py::arg("theItemId"),  py::arg("theGUID")
          )
        .def("FindAnnotatedItemAttr",
             (TDF_Label (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const Standard_GUID &  ) const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const Standard_GUID &  ) const>(&XCAFDoc_NotesTool::FindAnnotatedItemAttr),
             R"#(Finds a label of the given labeled item's attribute in the annotated items hive.)#"  , py::arg("theItemLabel"),  py::arg("theGUID")
          )
        .def("FindAnnotatedItemSubshape",
             (TDF_Label (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Integer  ) const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Integer  ) const>(&XCAFDoc_NotesTool::FindAnnotatedItemSubshape),
             R"#(Finds a label of the given assembly item's subshape in the annotated items hive.)#"  , py::arg("theItemId"),  py::arg("theSubshapeIndex")
          )
        .def("FindAnnotatedItemSubshape",
             (TDF_Label (XCAFDoc_NotesTool::*)( const TDF_Label & ,  Standard_Integer  ) const) static_cast<TDF_Label (XCAFDoc_NotesTool::*)( const TDF_Label & ,  Standard_Integer  ) const>(&XCAFDoc_NotesTool::FindAnnotatedItemSubshape),
             R"#(Finds a label of the given labeled item's subshape in the annotated items hive.)#"  , py::arg("theItemLabel"),  py::arg("theSubshapeIndex")
          )
        .def("CreateComment",
             (opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) ) static_cast<opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) >(&XCAFDoc_NotesTool::CreateComment),
             R"#(Create a new comment note. Creates a new label under the notes hive and attaches XCAFDoc_NoteComment attribute (derived ftom XCAFDoc_Note).)#"  , py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theComment")
          )
        .def("CreateBalloon",
             (opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) ) static_cast<opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) >(&XCAFDoc_NotesTool::CreateBalloon),
             R"#(Create a new 'balloon' note. Creates a new label under the notes hive and attaches XCAFDoc_NoteBalloon attribute (derived ftom XCAFDoc_Note).)#"  , py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theComment")
          )
        .def("CreateBinData",
             (opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  OSD_File &  ) ) static_cast<opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  OSD_File &  ) >(&XCAFDoc_NotesTool::CreateBinData),
             R"#(Create a new note with data loaded from a binary file. Creates a new label under the notes hive and attaches XCAFDoc_NoteComment attribute (derived ftom XCAFDoc_Note).)#"  , py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theTitle"),  py::arg("theMIMEtype"),  py::arg("theFile")
          )
        .def("CreateBinData",
             (opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  const opencascade::handle<TColStd_HArray1OfByte> &  ) ) static_cast<opencascade::handle<XCAFDoc_Note> (XCAFDoc_NotesTool::*)( const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  const opencascade::handle<TColStd_HArray1OfByte> &  ) >(&XCAFDoc_NotesTool::CreateBinData),
             R"#(Create a new note with data loaded from a byte data array. Creates a new label under the notes hive and attaches XCAFDoc_NoteComment attribute (derived ftom XCAFDoc_Note).)#"  , py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theTitle"),  py::arg("theMIMEtype"),  py::arg("theData")
          )
        .def("GetNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetNotes),
             R"#(Gets all note labels of the assembly item. Notes linked to item's subshapes or attributes aren't taken into account. The label sequence isn't cleared beforehand.)#"  , py::arg("theItemId"),  py::arg("theNoteLabels")
          )
        .def("GetNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetNotes),
             R"#(Gets all note labels of the labeled item. Notes linked to item's attributes aren't taken into account. The label sequence isn't cleared beforehand.)#"  , py::arg("theItemLabel"),  py::arg("theNoteLabels")
          )
        .def("GetAttrNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  const Standard_GUID & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  const Standard_GUID & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetAttrNotes),
             R"#(Gets all note labels of the assembly item's attribute. Notes linked to the item itself or to item's subshapes aren't taken into account. The label sequence isn't cleared beforehand.)#"  , py::arg("theItemId"),  py::arg("theGUID"),  py::arg("theNoteLabels")
          )
        .def("GetAttrNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const Standard_GUID & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const Standard_GUID & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetAttrNotes),
             R"#(Gets all note labels of the labeled item's attribute. Notes linked to the item itself or to item's subshapes aren't taken into account. The label sequence isn't cleared beforehand.)#"  , py::arg("theItemLabel"),  py::arg("theGUID"),  py::arg("theNoteLabels")
          )
        .def("GetSubshapeNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Integer ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Integer ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetSubshapeNotes),
             R"#(Gets all note labels of the annotated item. Notes linked to the item itself or to item's attributes taken into account. The label sequence isn't cleared beforehand.)#"  , py::arg("theItemId"),  py::arg("theSubshapeIndex"),  py::arg("theNoteLabels")
          )
        .def("AddNote",
             (opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId &  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId &  ) >(&XCAFDoc_NotesTool::AddNote),
             R"#(Adds the given note to the assembly item.)#"  , py::arg("theNoteLabel"),  py::arg("theItemId")
          )
        .def("AddNote",
             (opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label &  ) >(&XCAFDoc_NotesTool::AddNote),
             R"#(Adds the given note to the labeled item.)#"  , py::arg("theNoteLabel"),  py::arg("theItemLabel")
          )
        .def("AddNoteToAttr",
             (opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_GUID &  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_GUID &  ) >(&XCAFDoc_NotesTool::AddNoteToAttr),
             R"#(Adds the given note to the assembly item's attribute.)#"  , py::arg("theNoteLabel"),  py::arg("theItemId"),  py::arg("theGUID")
          )
        .def("AddNoteToAttr",
             (opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_GUID &  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_GUID &  ) >(&XCAFDoc_NotesTool::AddNoteToAttr),
             R"#(Adds the given note to the labeled item's attribute.)#"  , py::arg("theNoteLabel"),  py::arg("theItemLabel"),  py::arg("theGUID")
          )
        .def("AddNoteToSubshape",
             (opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  Standard_Integer  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  Standard_Integer  ) >(&XCAFDoc_NotesTool::AddNoteToSubshape),
             R"#(Adds the given note to the assembly item's subshape.)#"  , py::arg("theNoteLabel"),  py::arg("theItemId"),  py::arg("theSubshapeIndex")
          )
        .def("AddNoteToSubshape",
             (opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  Standard_Integer  ) ) static_cast<opencascade::handle<XCAFDoc_AssemblyItemRef> (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  Standard_Integer  ) >(&XCAFDoc_NotesTool::AddNoteToSubshape),
             R"#(Adds the given note to the labeled item's subshape.)#"  , py::arg("theNoteLabel"),  py::arg("theItemLabel"),  py::arg("theSubshapeIndex")
          )
        .def("RemoveNote",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveNote),
             R"#(Removes the given note from the assembly item.)#"  , py::arg("theNoteLabel"),  py::arg("theItemId"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveNote",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveNote),
             R"#(Removes the given note from the labeled item.)#"  , py::arg("theNoteLabel"),  py::arg("theItemLabel"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveSubshapeNote",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  Standard_Integer ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  Standard_Integer ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveSubshapeNote),
             R"#(Removes the given note from the assembly item's subshape.)#"  , py::arg("theNoteLabel"),  py::arg("theItemId"),  py::arg("theSubshapeIndex"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveSubshapeNote",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  Standard_Integer ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  Standard_Integer ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveSubshapeNote),
             R"#(Removes the given note from the labeled item's subshape.)#"  , py::arg("theNoteLabel"),  py::arg("theItemLabel"),  py::arg("theSubshapeIndex"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveAttrNote",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_GUID & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const XCAFDoc_AssemblyItemId & ,  const Standard_GUID & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveAttrNote),
             R"#(Removes a note from the assembly item's attribute.)#"  , py::arg("theNoteLabel"),  py::arg("theItemId"),  py::arg("theGUID"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveAttrNote",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_GUID & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const TDF_Label & ,  const Standard_GUID & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveAttrNote),
             R"#(Removes a note from the labeled item's attribute.)#"  , py::arg("theNoteLabel"),  py::arg("theItemLabel"),  py::arg("theGUID"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveAllNotes",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveAllNotes),
             R"#(Removes all notes from the assembly item.)#"  , py::arg("theItemId"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveAllNotes",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveAllNotes),
             R"#(Removes all notes from the labeled item.)#"  , py::arg("theItemLabel"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveAllSubshapeNotes",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Integer ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  Standard_Integer ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveAllSubshapeNotes),
             R"#(Removes all notes from the assembly item's subshape.)#"  , py::arg("theItemId"),  py::arg("theSubshapeIndex"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveAllAttrNotes",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  const Standard_GUID & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const XCAFDoc_AssemblyItemId & ,  const Standard_GUID & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveAllAttrNotes),
             R"#(Removes all notes from the assembly item's attribute.)#"  , py::arg("theItemId"),  py::arg("theGUID"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("RemoveAllAttrNotes",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const Standard_GUID & ,  Standard_Boolean  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label & ,  const Standard_GUID & ,  Standard_Boolean  ) >(&XCAFDoc_NotesTool::RemoveAllAttrNotes),
             R"#(Removes all notes from the labeled item's attribute.)#"  , py::arg("theItemLabel"),  py::arg("theGUID"),  py::arg("theDelIfOrphan")=static_cast<Standard_Boolean>(Standard_False)
          )
        .def("DeleteNote",
             (Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_NotesTool::*)( const TDF_Label &  ) >(&XCAFDoc_NotesTool::DeleteNote),
             R"#(Deletes the given note. Removes all links with items annotated by the note.)#"  , py::arg("theNoteLabel")
          )
        .def("DeleteNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_NotesTool::DeleteNotes),
             R"#(Deletes the given notes. Removes all links with items annotated by the notes.)#"  , py::arg("theNoteLabels")
          )
        .def("DeleteAllNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)() ) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)() >(&XCAFDoc_NotesTool::DeleteAllNotes),
             R"#(Deletes all notes. Clears all annotations.)#" 
          )
        .def("NbOrphanNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)() const) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::NbOrphanNotes),
             R"#(Returns number of notes that aren't linked to annotated items.)#" 
          )
        .def("GetOrphanNotes",
             (void (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_NotesTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_NotesTool::GetOrphanNotes),
             R"#(Returns note labels that aren't linked to annotated items. The label sequence isn't cleared beforehand.)#"  , py::arg("theNoteLabels")
          )
        .def("DeleteOrphanNotes",
             (Standard_Integer (XCAFDoc_NotesTool::*)() ) static_cast<Standard_Integer (XCAFDoc_NotesTool::*)() >(&XCAFDoc_NotesTool::DeleteOrphanNotes),
             R"#(Deletes all notes that aren't linked to annotated items.)#" 
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_NotesTool::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_NotesTool::*)( std::ostream &  ) const>(&XCAFDoc_NotesTool::Dump),
             R"#(None)#"  , py::arg("theOS")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_NotesTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_NotesTool::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_NotesTool::GetID),
                    R"#(Returns default attribute GUID)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_NotesTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_NotesTool> (*)( const TDF_Label &  ) >(&XCAFDoc_NotesTool::Set),
                    R"#(Create (if not exist) a notes tool from XCAFDoc on theLabel.)#"  , py::arg("theLabel")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_NotesTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::DynamicType),
             R"#(None)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_NotesTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_NotesTool::*)() const>(&XCAFDoc_NotesTool::ID),
             R"#(@})#"
             
         )
;

    // Class XCAFDoc_ShapeMapTool from ./opencascade/XCAFDoc_ShapeMapTool.hxx
    klass = m.attr("XCAFDoc_ShapeMapTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_ShapeMapTool ,opencascade::handle<XCAFDoc_ShapeMapTool>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsSubShape",
             (Standard_Boolean (XCAFDoc_ShapeMapTool::*)( const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeMapTool::*)( const TopoDS_Shape &  ) const>(&XCAFDoc_ShapeMapTool::IsSubShape),
             R"#(Checks whether shape is subshape of shape stored on label shapeL)#"  , py::arg("sub")
          )
        .def("SetShape",
             (void (XCAFDoc_ShapeMapTool::*)( const TopoDS_Shape &  ) ) static_cast<void (XCAFDoc_ShapeMapTool::*)( const TopoDS_Shape &  ) >(&XCAFDoc_ShapeMapTool::SetShape),
             R"#(Sets representation (TopoDS_Shape) for top-level shape)#"  , py::arg("S")
          )
        .def("Restore",
             (void (XCAFDoc_ShapeMapTool::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_ShapeMapTool::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_ShapeMapTool::Restore),
             R"#(None)#"  , py::arg("with")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_ShapeMapTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_ShapeMapTool::*)() const>(&XCAFDoc_ShapeMapTool::NewEmpty),
             R"#(None)#" 
          )
        .def("Paste",
             (void (XCAFDoc_ShapeMapTool::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_ShapeMapTool::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_ShapeMapTool::Paste),
             R"#(None)#"  , py::arg("into"),  py::arg("RT")
          )
        .def("DumpJson",
             (void (XCAFDoc_ShapeMapTool::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_ShapeMapTool::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_ShapeMapTool::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_ShapeMapTool::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_ShapeMapTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ShapeMapTool> (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeMapTool::Set),
                    R"#(Create (if not exist) ShapeTool from XCAFDoc on <L>.)#"  , py::arg("L")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_ShapeMapTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_ShapeMapTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_ShapeMapTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_ShapeMapTool::*)() const>(&XCAFDoc_ShapeMapTool::ID),
             R"#(None)#"
             
         )
       .def("GetMap",
             (const TopTools_IndexedMapOfShape & (XCAFDoc_ShapeMapTool::*)() const) static_cast<const TopTools_IndexedMapOfShape & (XCAFDoc_ShapeMapTool::*)() const>(&XCAFDoc_ShapeMapTool::GetMap),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_ShapeMapTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_ShapeMapTool::*)() const>(&XCAFDoc_ShapeMapTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_ShapeTool from ./opencascade/XCAFDoc_ShapeTool.hxx
    klass = m.attr("XCAFDoc_ShapeTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_ShapeTool ,opencascade::handle<XCAFDoc_ShapeTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsTopLevel",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ShapeTool::IsTopLevel),
             R"#(Returns True if the label is a label of top-level shape, as opposed to component of assembly or subshape)#"  , py::arg("L")
          )
        .def("IsSubShape",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape &  ) const>(&XCAFDoc_ShapeTool::IsSubShape),
             R"#(Checks whether shape is subshape of shape stored on label shapeL)#"  , py::arg("shapeL"),  py::arg("sub")
          )
        .def("SearchUsingMap",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  TDF_Label & ,  const Standard_Boolean ,  const Standard_Boolean  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  TDF_Label & ,  const Standard_Boolean ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::SearchUsingMap),
             R"#(None)#"  , py::arg("S"),  py::arg("L"),  py::arg("findWithoutLoc"),  py::arg("findSubshape")
          )
        .def("Search",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  TDF_Label & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  TDF_Label & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::Search),
             R"#(General tool to find a (sub) shape in the document * If findInstance is True, and S has a non-null location, first tries to find the shape among the top-level shapes with this location * If not found, and findComponent is True, tries to find the shape among the components of assemblies * If not found, tries to find the shape without location among top-level shapes * If not found and findSubshape is True, tries to find a shape as a subshape of top-level simple shapes Returns False if nothing is found)#"  , py::arg("S"),  py::arg("L"),  py::arg("findInstance")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("findComponent")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("findSubshape")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("FindShape",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  TDF_Label & ,  const Standard_Boolean  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  TDF_Label & ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::FindShape),
             R"#(Returns the label corresponding to shape S (searches among top-level shapes, not including subcomponents of assemblies and subshapes) If findInstance is False (default), search for the input shape without location If findInstance is True, searches for the input shape as is. Return True if <S> is found.)#"  , py::arg("S"),  py::arg("L"),  py::arg("findInstance")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("FindShape",
             (TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  const Standard_Boolean  ) const) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::FindShape),
             R"#(Does the same as previous method Returns Null label if not found)#"  , py::arg("S"),  py::arg("findInstance")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("GetOneShape",
             (TopoDS_Shape (XCAFDoc_ShapeTool::*)() const) static_cast<TopoDS_Shape (XCAFDoc_ShapeTool::*)() const>(&XCAFDoc_ShapeTool::GetOneShape),
             R"#(Gets shape from a sequence of all top-level shapes which are free)#" 
          )
        .def("NewShape",
             (TDF_Label (XCAFDoc_ShapeTool::*)() const) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)() const>(&XCAFDoc_ShapeTool::NewShape),
             R"#(Creates new (empty) top-level shape. Initially it holds empty TopoDS_Compound)#" 
          )
        .def("SetShape",
             (void (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape &  ) ) static_cast<void (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape &  ) >(&XCAFDoc_ShapeTool::SetShape),
             R"#(Sets representation (TopoDS_Shape) for top-level shape.)#"  , py::arg("L"),  py::arg("S")
          )
        .def("AddShape",
             (TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  const Standard_Boolean ,  const Standard_Boolean  ) ) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  const Standard_Boolean ,  const Standard_Boolean  ) >(&XCAFDoc_ShapeTool::AddShape),
             R"#(Adds a new top-level (creates and returns a new label) If makeAssembly is True, treats TopAbs_COMPOUND shapes as assemblies (creates assembly structure). NOTE: <makePrepare> replace components without location in assembly by located components to avoid some problems. If AutoNaming() is True then automatically attaches names.)#"  , py::arg("S"),  py::arg("makeAssembly")=static_cast<const Standard_Boolean>(Standard_True),  py::arg("makePrepare")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("RemoveShape",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const Standard_Boolean  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::RemoveShape),
             R"#(Removes shape (whole label and all its sublabels) If removeCompletely is true, removes complete shape If removeCompletely is false, removes instance(location) only Returns False (and does nothing) if shape is not free or is not top-level shape)#"  , py::arg("L"),  py::arg("removeCompletely")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("Init",
             (void (XCAFDoc_ShapeTool::*)() ) static_cast<void (XCAFDoc_ShapeTool::*)() >(&XCAFDoc_ShapeTool::Init),
             R"#(set hasComponents into false)#" 
          )
        .def("ComputeShapes",
             (void (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) ) static_cast<void (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::ComputeShapes),
             R"#(recursive)#"  , py::arg("L")
          )
        .def("ComputeSimpleShapes",
             (void (XCAFDoc_ShapeTool::*)() ) static_cast<void (XCAFDoc_ShapeTool::*)() >(&XCAFDoc_ShapeTool::ComputeSimpleShapes),
             R"#(Compute a sequence of simple shapes)#" 
          )
        .def("GetShapes",
             (void (XCAFDoc_ShapeTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_ShapeTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ShapeTool::GetShapes),
             R"#(Returns a sequence of all top-level shapes)#"  , py::arg("Labels")
          )
        .def("GetFreeShapes",
             (void (XCAFDoc_ShapeTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_ShapeTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ShapeTool::GetFreeShapes),
             R"#(Returns a sequence of all top-level shapes which are free (i.e. not referred by any other))#"  , py::arg("FreeLabels")
          )
        .def("AddComponent",
             (TDF_Label (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TDF_Label & ,  const TopLoc_Location &  ) ) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TDF_Label & ,  const TopLoc_Location &  ) >(&XCAFDoc_ShapeTool::AddComponent),
             R"#(Adds a component given by its label and location to the assembly Note: assembly must be IsAssembly() or IsSimpleShape())#"  , py::arg("assembly"),  py::arg("comp"),  py::arg("Loc")
          )
        .def("AddComponent",
             (TDF_Label (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape & ,  const Standard_Boolean  ) ) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape & ,  const Standard_Boolean  ) >(&XCAFDoc_ShapeTool::AddComponent),
             R"#(Adds a shape (located) as a component to the assembly If necessary, creates an additional top-level shape for component and return the Label of component. If expand is True and component is Compound, it will be created as assembly also Note: assembly must be IsAssembly() or IsSimpleShape())#"  , py::arg("assembly"),  py::arg("comp"),  py::arg("expand")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("RemoveComponent",
             (void (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ShapeTool::RemoveComponent),
             R"#(Removes a component from its assembly)#"  , py::arg("comp")
          )
        .def("UpdateAssemblies",
             (void (XCAFDoc_ShapeTool::*)() ) static_cast<void (XCAFDoc_ShapeTool::*)() >(&XCAFDoc_ShapeTool::UpdateAssemblies),
             R"#(Top-down update for all assembly compounds stored in the document.)#" 
          )
        .def("FindSubShape",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape & ,  TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape & ,  TDF_Label &  ) const>(&XCAFDoc_ShapeTool::FindSubShape),
             R"#(Finds a label for subshape of shape stored on label shapeL Returns Null label if it is not found)#"  , py::arg("shapeL"),  py::arg("sub"),  py::arg("L")
          )
        .def("AddSubShape",
             (TDF_Label (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape &  ) const) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape &  ) const>(&XCAFDoc_ShapeTool::AddSubShape),
             R"#(Adds a label for subshape of shape stored on label shapeL Returns Null label if it is not subshape)#"  , py::arg("shapeL"),  py::arg("sub")
          )
        .def("AddSubShape",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape & ,  TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopoDS_Shape & ,  TDF_Label &  ) const>(&XCAFDoc_ShapeTool::AddSubShape),
             R"#(Adds (of finds already existed) a label for subshape of shape stored on label shapeL. Label addedSubShapeL returns added (found) label or empty in case of wrong subshape. Returns True, if new shape was added, False in case of already existed subshape/wrong subshape)#"  , py::arg("shapeL"),  py::arg("sub"),  py::arg("addedSubShapeL")
          )
        .def("FindMainShapeUsingMap",
             (TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape &  ) const) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape &  ) const>(&XCAFDoc_ShapeTool::FindMainShapeUsingMap),
             R"#(None)#"  , py::arg("sub")
          )
        .def("FindMainShape",
             (TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape &  ) const) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)( const TopoDS_Shape &  ) const>(&XCAFDoc_ShapeTool::FindMainShape),
             R"#(Performs a search among top-level shapes to find the shape containing as subshape Checks only simple shapes, and returns the first found label (which should be the only one for valid model))#"  , py::arg("sub")
          )
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_ShapeTool::*)() const) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)() const>(&XCAFDoc_ShapeTool::BaseLabel),
             R"#(returns the label under which shapes are stored)#" 
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_ShapeTool::*)( std::ostream & ,  const Standard_Boolean  ) const) static_cast<Standard_OStream & (XCAFDoc_ShapeTool::*)( std::ostream & ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::Dump),
             R"#(None)#"  , py::arg("theDumpLog"),  py::arg("deep")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_ShapeTool::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_ShapeTool::*)( std::ostream &  ) const>(&XCAFDoc_ShapeTool::Dump),
             R"#(None)#"  , py::arg("theDumpLog")
          )
        .def("SetExternRefs",
             (TDF_Label (XCAFDoc_ShapeTool::*)(  const NCollection_Sequence<opencascade::handle<TCollection_HAsciiString>> &  ) const) static_cast<TDF_Label (XCAFDoc_ShapeTool::*)(  const NCollection_Sequence<opencascade::handle<TCollection_HAsciiString>> &  ) const>(&XCAFDoc_ShapeTool::SetExternRefs),
             R"#(Sets the names of references on the no-step files)#"  , py::arg("SHAS")
          )
        .def("SetExternRefs",
             (void (XCAFDoc_ShapeTool::*)( const TDF_Label & ,   const NCollection_Sequence<opencascade::handle<TCollection_HAsciiString>> &  ) const) static_cast<void (XCAFDoc_ShapeTool::*)( const TDF_Label & ,   const NCollection_Sequence<opencascade::handle<TCollection_HAsciiString>> &  ) const>(&XCAFDoc_ShapeTool::SetExternRefs),
             R"#(Sets the names of references on the no-step files)#"  , py::arg("L"),  py::arg("SHAS")
          )
        .def("SetSHUO",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)(  const NCollection_Sequence<TDF_Label> & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)(  const NCollection_Sequence<TDF_Label> & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) const>(&XCAFDoc_ShapeTool::SetSHUO),
             R"#(Sets the SHUO structure between upper_usage and next_usage create multy-level (if number of labels > 2) SHUO from first to last Initialise out <MainSHUOAttr> by main upper_usage SHUO attribute. Returns FALSE if some of labels in not component label)#"  , py::arg("Labels"),  py::arg("MainSHUOAttr")
          )
        .def("RemoveSHUO",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ShapeTool::RemoveSHUO),
             R"#(Remove SHUO from component sublabel, remove all dependencies on other SHUO. Returns FALSE if cannot remove SHUO dependencies. NOTE: remove any styles that associated with this SHUO.)#"  , py::arg("SHUOLabel")
          )
        .def("FindComponent",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ShapeTool::FindComponent),
             R"#(Search the path of labels in the document, that corresponds the component from any assembly Try to search the sequence of labels with location that produce this shape as component of any assembly NOTE: Clear sequence of labels before filling)#"  , py::arg("theShape"),  py::arg("Labels")
          )
        .def("GetSHUOInstance",
             (TopoDS_Shape (XCAFDoc_ShapeTool::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const) static_cast<TopoDS_Shape (XCAFDoc_ShapeTool::*)( const opencascade::handle<XCAFDoc_GraphNode> &  ) const>(&XCAFDoc_ShapeTool::GetSHUOInstance),
             R"#(Search for the component shape that styled by shuo Returns null shape if no any shape is found.)#"  , py::arg("theSHUO")
          )
        .def("SetInstanceSHUO",
             (opencascade::handle<XCAFDoc_GraphNode> (XCAFDoc_ShapeTool::*)( const TopoDS_Shape &  ) const) static_cast<opencascade::handle<XCAFDoc_GraphNode> (XCAFDoc_ShapeTool::*)( const TopoDS_Shape &  ) const>(&XCAFDoc_ShapeTool::SetInstanceSHUO),
             R"#(Search for the component shape by labelks path and set SHUO structure for founded label structure Returns null attribute if no component in any assembly found.)#"  , py::arg("theShape")
          )
        .def("GetAllSHUOInstances",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const opencascade::handle<XCAFDoc_GraphNode> & ,  NCollection_Sequence<TopoDS_Shape> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const opencascade::handle<XCAFDoc_GraphNode> & ,  NCollection_Sequence<TopoDS_Shape> &  ) const>(&XCAFDoc_ShapeTool::GetAllSHUOInstances),
             R"#(Searching for component shapes that styled by shuo Returns empty sequence of shape if no any shape is found.)#"  , py::arg("theSHUO"),  py::arg("theSHUOShapeSeq")
          )
        .def("SetLocation",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopLoc_Location & ,  TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const TopLoc_Location & ,  TDF_Label &  ) >(&XCAFDoc_ShapeTool::SetLocation),
             R"#(Sets location to the shape label If label is reference -> changes location attribute If label is free shape -> creates reference with location to it)#"  , py::arg("theShapeLabel"),  py::arg("theLoc"),  py::arg("theRefLabel")
          )
        .def("Expand",
             (Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_ShapeTool::*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::Expand),
             R"#(Convert Shape (compound/compsolid/shell/wire) to assembly)#"  , py::arg("Shape")
          )
        .def("GetNamedProperties",
             (opencascade::handle<TDataStd_NamedData> (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const Standard_Boolean  ) const) static_cast<opencascade::handle<TDataStd_NamedData> (XCAFDoc_ShapeTool::*)( const TDF_Label & ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::GetNamedProperties),
             R"#(Method to get NamedData attribute assigned to the given shape label.)#"  , py::arg("theLabel"),  py::arg("theToCreate")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("GetNamedProperties",
             (opencascade::handle<TDataStd_NamedData> (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  const Standard_Boolean  ) const) static_cast<opencascade::handle<TDataStd_NamedData> (XCAFDoc_ShapeTool::*)( const TopoDS_Shape & ,  const Standard_Boolean  ) const>(&XCAFDoc_ShapeTool::GetNamedProperties),
             R"#(Method to get NamedData attribute assigned to a label of the given shape.)#"  , py::arg("theShape"),  py::arg("theToCreate")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("DumpJson",
             (void (XCAFDoc_ShapeTool::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_ShapeTool::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_ShapeTool::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_ShapeTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_ShapeTool::*)() const>(&XCAFDoc_ShapeTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_ShapeTool::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_ShapeTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ShapeTool> (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::Set),
                    R"#(Create (if not exist) ShapeTool from XCAFDoc on <L>.)#"  , py::arg("L")
          )
        .def_static("IsFree_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsFree),
                    R"#(Returns True if the label is not used by any assembly, i.e. contains sublabels which are assembly components This is relevant only if IsShape() is True (There is no Father TreeNode on this <L>))#"  , py::arg("L")
          )
        .def_static("IsShape_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsShape),
                    R"#(Returns True if the label represents a shape (simple shape, assembly or reference))#"  , py::arg("L")
          )
        .def_static("IsSimpleShape_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsSimpleShape),
                    R"#(Returns True if the label is a label of simple shape)#"  , py::arg("L")
          )
        .def_static("IsReference_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsReference),
                    R"#(Return true if <L> is a located instance of other shape i.e. reference)#"  , py::arg("L")
          )
        .def_static("IsAssembly_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsAssembly),
                    R"#(Returns True if the label is a label of assembly, i.e. contains sublabels which are assembly components This is relevant only if IsShape() is True)#"  , py::arg("L")
          )
        .def_static("IsComponent_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsComponent),
                    R"#(Return true if <L> is reference serving as component of assembly)#"  , py::arg("L")
          )
        .def_static("IsCompound_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsCompound),
                    R"#(Returns True if the label is a label of compound, i.e. contains some sublabels This is relevant only if IsShape() is True)#"  , py::arg("L")
          )
        .def_static("IsSubShape_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsSubShape),
                    R"#(Return true if <L> is subshape of the top-level shape)#"  , py::arg("L")
          )
        .def_static("GetShape_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  TopoDS_Shape &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  TopoDS_Shape &  ) >(&XCAFDoc_ShapeTool::GetShape),
                    R"#(To get TopoDS_Shape from shape's label For component, returns new shape with correct location Returns False if label does not contain shape)#"  , py::arg("L"),  py::arg("S")
          )
        .def_static("GetShape_s",
                    (TopoDS_Shape (*)( const TDF_Label &  ) ) static_cast<TopoDS_Shape (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::GetShape),
                    R"#(To get TopoDS_Shape from shape's label For component, returns new shape with correct location Returns Null shape if label does not contain shape)#"  , py::arg("L")
          )
        .def_static("GetOneShape_s",
                    (TopoDS_Shape (*)(  const NCollection_Sequence<TDF_Label> &  ) ) static_cast<TopoDS_Shape (*)(  const NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_ShapeTool::GetOneShape),
                    R"#(Gets shape from a sequence of shape's labels)#"  , py::arg("theLabels")
          )
        .def_static("SetAutoNaming_s",
                    (void (*)( const Standard_Boolean  ) ) static_cast<void (*)( const Standard_Boolean  ) >(&XCAFDoc_ShapeTool::SetAutoNaming),
                    R"#(Sets auto-naming mode to <V>. If True then for added shapes, links, assemblies and SHUO's, the TDataStd_Name attribute is automatically added. For shapes it contains a shape type (e.g. "SOLID", "SHELL", etc); for links it has a form "=>[0:1:1:2]" (where a tag is a label containing a shape without a location); for assemblies it is "ASSEMBLY", and "SHUO" for SHUO's. This setting is global; it cannot be made a member function as it is used by static methods as well. By default, auto-naming is enabled. See also AutoNaming().)#"  , py::arg("V")
          )
        .def_static("AutoNaming_s",
                    (Standard_Boolean (*)() ) static_cast<Standard_Boolean (*)() >(&XCAFDoc_ShapeTool::AutoNaming),
                    R"#(Returns current auto-naming mode. See SetAutoNaming() for description.)#" 
          )
        .def_static("GetUsers_s",
                    (Standard_Integer (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> & ,  const Standard_Boolean  ) ) static_cast<Standard_Integer (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> & ,  const Standard_Boolean  ) >(&XCAFDoc_ShapeTool::GetUsers),
                    R"#(Returns list of labels which refer shape L as component Returns number of users (0 if shape is free))#"  , py::arg("L"),  py::arg("Labels"),  py::arg("getsubchilds")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def_static("GetLocation_s",
                    (TopLoc_Location (*)( const TDF_Label &  ) ) static_cast<TopLoc_Location (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::GetLocation),
                    R"#(Returns location of instance)#"  , py::arg("L")
          )
        .def_static("GetReferredShape_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  TDF_Label &  ) >(&XCAFDoc_ShapeTool::GetReferredShape),
                    R"#(Returns label which corresponds to a shape referred by L Returns False if label is not reference)#"  , py::arg("L"),  py::arg("Label")
          )
        .def_static("NbComponents_s",
                    (Standard_Integer (*)( const TDF_Label & ,  const Standard_Boolean  ) ) static_cast<Standard_Integer (*)( const TDF_Label & ,  const Standard_Boolean  ) >(&XCAFDoc_ShapeTool::NbComponents),
                    R"#(Returns number of Assembles components)#"  , py::arg("L"),  py::arg("getsubchilds")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def_static("GetComponents_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> & ,  const Standard_Boolean  ) >(&XCAFDoc_ShapeTool::GetComponents),
                    R"#(Returns list of components of assembly Returns False if label is not assembly)#"  , py::arg("L"),  py::arg("Labels"),  py::arg("getsubchilds")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def_static("GetSubShapes_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_ShapeTool::GetSubShapes),
                    R"#(Returns list of labels identifying subshapes of the given shape Returns False if no subshapes are placed on that label)#"  , py::arg("L"),  py::arg("Labels")
          )
        .def_static("DumpShape_s",
                    (void (*)( std::ostream & ,  const TDF_Label & ,  const Standard_Integer ,  const Standard_Boolean  ) ) static_cast<void (*)( std::ostream & ,  const TDF_Label & ,  const Standard_Integer ,  const Standard_Boolean  ) >(&XCAFDoc_ShapeTool::DumpShape),
                    R"#(Print to std::ostream <theDumpLog> type of shape found on <L> label and the entry of <L>, with <level> tabs before. If <deep>, print also TShape and Location addresses)#"  , py::arg("theDumpLog"),  py::arg("L"),  py::arg("level")=static_cast<const Standard_Integer>(0),  py::arg("deep")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def_static("IsExternRef_s",
                    (Standard_Boolean (*)( const TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label &  ) >(&XCAFDoc_ShapeTool::IsExternRef),
                    R"#(Returns True if the label is a label of external references, i.e. there are some reference on the no-step files, which are described in document only their names)#"  , py::arg("L")
          )
        .def_static("GetExternRefs_s",
                    (void (*)( const TDF_Label & ,  NCollection_Sequence<opencascade::handle<TCollection_HAsciiString>> &  ) ) static_cast<void (*)( const TDF_Label & ,  NCollection_Sequence<opencascade::handle<TCollection_HAsciiString>> &  ) >(&XCAFDoc_ShapeTool::GetExternRefs),
                    R"#(Gets the names of references on the no-step files)#"  , py::arg("L"),  py::arg("SHAS")
          )
        .def_static("GetSHUO_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) >(&XCAFDoc_ShapeTool::GetSHUO),
                    R"#(Returns founded SHUO GraphNode attribute <aSHUOAttr> Returns false in other case)#"  , py::arg("SHUOLabel"),  py::arg("aSHUOAttr")
          )
        .def_static("GetAllComponentSHUO_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<opencascade::handle<TDF_Attribute>> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<opencascade::handle<TDF_Attribute>> &  ) >(&XCAFDoc_ShapeTool::GetAllComponentSHUO),
                    R"#(Returns founded SHUO GraphNodes of indicated component Returns false in other case)#"  , py::arg("CompLabel"),  py::arg("SHUOAttrs")
          )
        .def_static("GetSHUOUpperUsage_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_ShapeTool::GetSHUOUpperUsage),
                    R"#(Returns the sequence of labels of SHUO attributes, which is upper_usage for this next_usage SHUO attribute (that indicated by label) NOTE: returns upper_usages only on one level (not recurse) NOTE: do not clear the sequence before filling)#"  , py::arg("NextUsageL"),  py::arg("Labels")
          )
        .def_static("GetSHUONextUsage_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) >(&XCAFDoc_ShapeTool::GetSHUONextUsage),
                    R"#(Returns the sequence of labels of SHUO attributes, which is next_usage for this upper_usage SHUO attribute (that indicated by label) NOTE: returns next_usages only on one level (not recurse) NOTE: do not clear the sequence before filling)#"  , py::arg("UpperUsageL"),  py::arg("Labels")
          )
        .def_static("FindSHUO_s",
                    (Standard_Boolean (*)(  const NCollection_Sequence<TDF_Label> & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) ) static_cast<Standard_Boolean (*)(  const NCollection_Sequence<TDF_Label> & ,  opencascade::handle<XCAFDoc_GraphNode> &  ) >(&XCAFDoc_ShapeTool::FindSHUO),
                    R"#(Searches the SHUO by labels of components from upper_usage component to next_usage Returns null attribute if no SHUO found)#"  , py::arg("Labels"),  py::arg("theSHUOAttr")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_ShapeTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_ShapeTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_ShapeTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_ShapeTool::*)() const>(&XCAFDoc_ShapeTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_ShapeTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_ShapeTool::*)() const>(&XCAFDoc_ShapeTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_View from ./opencascade/XCAFDoc_View.hxx
    klass = m.attr("XCAFDoc_View");


    // nested enums

    static_cast<py::class_<XCAFDoc_View ,opencascade::handle<XCAFDoc_View>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetObject",
             (void (XCAFDoc_View::*)( const opencascade::handle<XCAFView_Object> &  ) ) static_cast<void (XCAFDoc_View::*)( const opencascade::handle<XCAFView_Object> &  ) >(&XCAFDoc_View::SetObject),
             R"#(Updates parent's label and its sub-labels with data taken from theViewObject. Old data associated with the label will be lost.)#"  , py::arg("theViewObject")
          )
        .def("GetObject",
             (opencascade::handle<XCAFView_Object> (XCAFDoc_View::*)() const) static_cast<opencascade::handle<XCAFView_Object> (XCAFDoc_View::*)() const>(&XCAFDoc_View::GetObject),
             R"#(Returns view object data taken from the paren's label and its sub-labels.)#" 
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_View::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_View::*)() const>(&XCAFDoc_View::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_View::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_View> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_View> (*)( const TDF_Label &  ) >(&XCAFDoc_View::Set),
                    R"#(None)#"  , py::arg("theLabel")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_View::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_View::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_View::*)() const) static_cast<const Standard_GUID & (XCAFDoc_View::*)() const>(&XCAFDoc_View::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_View::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_View::*)() const>(&XCAFDoc_View::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_ViewTool from ./opencascade/XCAFDoc_ViewTool.hxx
    klass = m.attr("XCAFDoc_ViewTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_ViewTool ,opencascade::handle<XCAFDoc_ViewTool>  , TDataStd_GenericEmpty >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_ViewTool::*)() const) static_cast<TDF_Label (XCAFDoc_ViewTool::*)() const>(&XCAFDoc_ViewTool::BaseLabel),
             R"#(Returns the label under which Views are stored)#" 
          )
        .def("IsView",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ViewTool::IsView),
             R"#(Returns True if label belongs to a View table and is a View definition)#"  , py::arg("theLabel")
          )
        .def("GetViewLabels",
             (void (XCAFDoc_ViewTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_ViewTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetViewLabels),
             R"#(Returns a sequence of View labels currently stored in the View table)#"  , py::arg("theLabels")
          )
        .def("SetView",
             (void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const>(&XCAFDoc_ViewTool::SetView),
             R"#(Sets a link with GUID)#"  , py::arg("theShapes"),  py::arg("theGDTs"),  py::arg("theClippingPlanes"),  py::arg("theNotes"),  py::arg("theAnnotations"),  py::arg("theViewL")
          )
        .def("SetView",
             (void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const>(&XCAFDoc_ViewTool::SetView),
             R"#(Sets a link with GUID)#"  , py::arg("theShapes"),  py::arg("theGDTs"),  py::arg("theClippingPlanes"),  py::arg("theViewL")
          )
        .def("SetView",
             (void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,   const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const>(&XCAFDoc_ViewTool::SetView),
             R"#(Sets a link with GUID)#"  , py::arg("theShapes"),  py::arg("theGDTs"),  py::arg("theViewL")
          )
        .def("SetClippingPlanes",
             (void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_ViewTool::*)(  const NCollection_Sequence<TDF_Label> & ,  const TDF_Label &  ) const>(&XCAFDoc_ViewTool::SetClippingPlanes),
             R"#(Set Clipping planes to given View)#"  , py::arg("theClippingPlaneLabels"),  py::arg("theViewL")
          )
        .def("RemoveView",
             (void (XCAFDoc_ViewTool::*)( const TDF_Label &  ) ) static_cast<void (XCAFDoc_ViewTool::*)( const TDF_Label &  ) >(&XCAFDoc_ViewTool::RemoveView),
             R"#(Remove View)#"  , py::arg("theViewL")
          )
        .def("GetViewLabelsForShape",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetViewLabelsForShape),
             R"#(Returns all View labels defined for label ShapeL)#"  , py::arg("theShapeL"),  py::arg("theViews")
          )
        .def("GetViewLabelsForGDT",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetViewLabelsForGDT),
             R"#(Returns all View labels defined for label GDTL)#"  , py::arg("theGDTL"),  py::arg("theViews")
          )
        .def("GetViewLabelsForClippingPlane",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetViewLabelsForClippingPlane),
             R"#(Returns all View labels defined for label ClippingPlaneL)#"  , py::arg("theClippingPlaneL"),  py::arg("theViews")
          )
        .def("GetViewLabelsForNote",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetViewLabelsForNote),
             R"#(Returns all View labels defined for label NoteL)#"  , py::arg("theNoteL"),  py::arg("theViews")
          )
        .def("GetViewLabelsForAnnotation",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetViewLabelsForAnnotation),
             R"#(Returns all View labels defined for label AnnotationL)#"  , py::arg("theAnnotationL"),  py::arg("theViews")
          )
        .def("AddView",
             (TDF_Label (XCAFDoc_ViewTool::*)() ) static_cast<TDF_Label (XCAFDoc_ViewTool::*)() >(&XCAFDoc_ViewTool::AddView),
             R"#(Adds a view definition to a View table and returns its label)#" 
          )
        .def("GetRefShapeLabel",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetRefShapeLabel),
             R"#(Returns shape labels defined for label theViewL Returns False if the theViewL is not in View table)#"  , py::arg("theViewL"),  py::arg("theShapeLabels")
          )
        .def("GetRefGDTLabel",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetRefGDTLabel),
             R"#(Returns GDT labels defined for label theViewL Returns False if the theViewL is not in View table)#"  , py::arg("theViewL"),  py::arg("theGDTLabels")
          )
        .def("GetRefClippingPlaneLabel",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetRefClippingPlaneLabel),
             R"#(Returns ClippingPlane labels defined for label theViewL Returns False if the theViewL is not in View table)#"  , py::arg("theViewL"),  py::arg("theClippingPlaneLabels")
          )
        .def("GetRefNoteLabel",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetRefNoteLabel),
             R"#(Returns Notes labels defined for label theViewL Returns False if the theViewL is not in View table)#"  , py::arg("theViewL"),  py::arg("theNoteLabels")
          )
        .def("GetRefAnnotationLabel",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label & ,  NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_ViewTool::GetRefAnnotationLabel),
             R"#(Returns Annotation labels defined for label theViewL Returns False if the theViewL is not in View table)#"  , py::arg("theViewL"),  py::arg("theAnnotationLabels")
          )
        .def("IsLocked",
             (Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ViewTool::IsLocked),
             R"#(Returns true if the given View is marked as locked)#"  , py::arg("theViewL")
          )
        .def("Lock",
             (void (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ViewTool::Lock),
             R"#(Mark the given View as locked)#"  , py::arg("theViewL")
          )
        .def("Unlock",
             (void (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_ViewTool::*)( const TDF_Label &  ) const>(&XCAFDoc_ViewTool::Unlock),
             R"#(Unlock the given View)#"  , py::arg("theViewL")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_ViewTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_ViewTool::*)() const>(&XCAFDoc_ViewTool::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_ViewTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_ViewTool> (*)( const TDF_Label &  ) >(&XCAFDoc_ViewTool::Set),
                    R"#(Creates (if not exist) ViewTool.)#"  , py::arg("L")
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_ViewTool::GetID),
                    R"#(None)#" 
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_ViewTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_ViewTool::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_ViewTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_ViewTool::*)() const>(&XCAFDoc_ViewTool::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_ViewTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_ViewTool::*)() const>(&XCAFDoc_ViewTool::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_VisMaterial from ./opencascade/XCAFDoc_VisMaterial.hxx
    klass = m.attr("XCAFDoc_VisMaterial");


    // nested enums

    static_cast<py::class_<XCAFDoc_VisMaterial ,opencascade::handle<XCAFDoc_VisMaterial>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsEmpty",
             (bool (XCAFDoc_VisMaterial::*)() const) static_cast<bool (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::IsEmpty),
             R"#(Return TRUE if material definition is empty.)#" 
          )
        .def("FillMaterialAspect",
             (void (XCAFDoc_VisMaterial::*)( Graphic3d_MaterialAspect &  ) const) static_cast<void (XCAFDoc_VisMaterial::*)( Graphic3d_MaterialAspect &  ) const>(&XCAFDoc_VisMaterial::FillMaterialAspect),
             R"#(Fill in material aspect.)#"  , py::arg("theAspect")
          )
        .def("FillAspect",
             (void (XCAFDoc_VisMaterial::*)( const opencascade::handle<Graphic3d_Aspects> &  ) const) static_cast<void (XCAFDoc_VisMaterial::*)( const opencascade::handle<Graphic3d_Aspects> &  ) const>(&XCAFDoc_VisMaterial::FillAspect),
             R"#(Fill in graphic aspects.)#"  , py::arg("theAspect")
          )
        .def("HasPbrMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterial::*)() const) static_cast<Standard_Boolean (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::HasPbrMaterial),
             R"#(Return TRUE if metal-roughness PBR material is defined; FALSE by default.)#" 
          )
        .def("SetPbrMaterial",
             (void (XCAFDoc_VisMaterial::*)( const XCAFDoc_VisMaterialPBR &  ) ) static_cast<void (XCAFDoc_VisMaterial::*)( const XCAFDoc_VisMaterialPBR &  ) >(&XCAFDoc_VisMaterial::SetPbrMaterial),
             R"#(Setup metal-roughness PBR material.)#"  , py::arg("theMaterial")
          )
        .def("UnsetPbrMaterial",
             (void (XCAFDoc_VisMaterial::*)() ) static_cast<void (XCAFDoc_VisMaterial::*)() >(&XCAFDoc_VisMaterial::UnsetPbrMaterial),
             R"#(Setup undefined metal-roughness PBR material.)#" 
          )
        .def("HasCommonMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterial::*)() const) static_cast<Standard_Boolean (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::HasCommonMaterial),
             R"#(Return TRUE if common material is defined; FALSE by default.)#" 
          )
        .def("SetCommonMaterial",
             (void (XCAFDoc_VisMaterial::*)( const XCAFDoc_VisMaterialCommon &  ) ) static_cast<void (XCAFDoc_VisMaterial::*)( const XCAFDoc_VisMaterialCommon &  ) >(&XCAFDoc_VisMaterial::SetCommonMaterial),
             R"#(Setup common material.)#"  , py::arg("theMaterial")
          )
        .def("UnsetCommonMaterial",
             (void (XCAFDoc_VisMaterial::*)() ) static_cast<void (XCAFDoc_VisMaterial::*)() >(&XCAFDoc_VisMaterial::UnsetCommonMaterial),
             R"#(Setup undefined common material.)#" 
          )
        .def("BaseColor",
             (Quantity_ColorRGBA (XCAFDoc_VisMaterial::*)() const) static_cast<Quantity_ColorRGBA (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::BaseColor),
             R"#(Return base color.)#" 
          )
        .def("AlphaMode",
             (Graphic3d_AlphaMode (XCAFDoc_VisMaterial::*)() const) static_cast<Graphic3d_AlphaMode (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::AlphaMode),
             R"#(Return alpha mode; Graphic3d_AlphaMode_BlendAuto by default.)#" 
          )
        .def("AlphaCutOff",
             (Standard_ShortReal (XCAFDoc_VisMaterial::*)() const) static_cast<Standard_ShortReal (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::AlphaCutOff),
             R"#(Return alpha cutoff value; 0.5 by default.)#" 
          )
        .def("SetAlphaMode",
             (void (XCAFDoc_VisMaterial::*)( Graphic3d_AlphaMode ,  Standard_ShortReal  ) ) static_cast<void (XCAFDoc_VisMaterial::*)( Graphic3d_AlphaMode ,  Standard_ShortReal  ) >(&XCAFDoc_VisMaterial::SetAlphaMode),
             R"#(Set alpha mode.)#"  , py::arg("theMode"),  py::arg("theCutOff")=static_cast<Standard_ShortReal>(0.5f)
          )
        .def("FaceCulling",
             (Graphic3d_TypeOfBackfacingModel (XCAFDoc_VisMaterial::*)() const) static_cast<Graphic3d_TypeOfBackfacingModel (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::FaceCulling),
             R"#(Returns if the material is double or single sided; Graphic3d_TypeOfBackfacingModel_Auto by default.)#" 
          )
        .def("SetFaceCulling",
             (void (XCAFDoc_VisMaterial::*)( Graphic3d_TypeOfBackfacingModel  ) ) static_cast<void (XCAFDoc_VisMaterial::*)( Graphic3d_TypeOfBackfacingModel  ) >(&XCAFDoc_VisMaterial::SetFaceCulling),
             R"#(Specifies whether the material is double or single sided.)#"  , py::arg("theFaceCulling")
          )
        .def("IsDoubleSided",
             (Standard_Boolean (XCAFDoc_VisMaterial::*)() const) static_cast<Standard_Boolean (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::IsDoubleSided),
             R"#(None)#" 
          )
        .def("SetDoubleSided",
             (void (XCAFDoc_VisMaterial::*)( Standard_Boolean  ) ) static_cast<void (XCAFDoc_VisMaterial::*)( Standard_Boolean  ) >(&XCAFDoc_VisMaterial::SetDoubleSided),
             R"#(None)#"  , py::arg("theIsDoubleSided")
          )
        .def("SetRawName",
             (void (XCAFDoc_VisMaterial::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDoc_VisMaterial::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&XCAFDoc_VisMaterial::SetRawName),
             R"#(Set material name / tag (transient data, not stored in the document).)#"  , py::arg("theName")
          )
        .def("IsEqual",
             (Standard_Boolean (XCAFDoc_VisMaterial::*)( const opencascade::handle<XCAFDoc_VisMaterial> &  ) const) static_cast<Standard_Boolean (XCAFDoc_VisMaterial::*)( const opencascade::handle<XCAFDoc_VisMaterial> &  ) const>(&XCAFDoc_VisMaterial::IsEqual),
             R"#(Compare two materials. Performs deep comparison by actual values - e.g. can be useful for merging materials.)#"  , py::arg("theOther")
          )
        .def("ConvertToCommonMaterial",
             (XCAFDoc_VisMaterialCommon (XCAFDoc_VisMaterial::*)() ) static_cast<XCAFDoc_VisMaterialCommon (XCAFDoc_VisMaterial::*)() >(&XCAFDoc_VisMaterial::ConvertToCommonMaterial),
             R"#(Return Common material or convert PBR into Common material.)#" 
          )
        .def("ConvertToPbrMaterial",
             (XCAFDoc_VisMaterialPBR (XCAFDoc_VisMaterial::*)() ) static_cast<XCAFDoc_VisMaterialPBR (XCAFDoc_VisMaterial::*)() >(&XCAFDoc_VisMaterial::ConvertToPbrMaterial),
             R"#(Return PBR material or convert Common into PBR material.)#" 
          )
        .def("Restore",
             (void (XCAFDoc_VisMaterial::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_VisMaterial::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_VisMaterial::Restore),
             R"#(Restore attribute from specified state.)#"  , py::arg("theWith")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_VisMaterial::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::NewEmpty),
             R"#(Create a new empty attribute.)#" 
          )
        .def("Paste",
             (void (XCAFDoc_VisMaterial::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_VisMaterial::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_VisMaterial::Paste),
             R"#(Paste this attribute into another one.)#"  , py::arg("theInto"),  py::arg("theRelTable")
          )
        .def("DumpJson",
             (void (XCAFDoc_VisMaterial::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_VisMaterial::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_VisMaterial::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_VisMaterial::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_VisMaterial::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_VisMaterial::GetID),
                    R"#(Return attribute GUID.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_VisMaterial::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::DynamicType),
             R"#(None)#"
             
         )
       .def("PbrMaterial",
             (const XCAFDoc_VisMaterialPBR & (XCAFDoc_VisMaterial::*)() const) static_cast<const XCAFDoc_VisMaterialPBR & (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::PbrMaterial),
             R"#(Return metal-roughness PBR material. Note that default constructor creates an empty material ()#"
             
         )
       .def("CommonMaterial",
             (const XCAFDoc_VisMaterialCommon & (XCAFDoc_VisMaterial::*)() const) static_cast<const XCAFDoc_VisMaterialCommon & (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::CommonMaterial),
             R"#(Return common material. Note that default constructor creates an empty material ()#"
             
         )
       .def("RawName",
             (const opencascade::handle<TCollection_HAsciiString> & (XCAFDoc_VisMaterial::*)() const) static_cast<const opencascade::handle<TCollection_HAsciiString> & (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::RawName),
             R"#(Return material name / tag (transient data, not stored in the document).)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_VisMaterial::*)() const) static_cast<const Standard_GUID & (XCAFDoc_VisMaterial::*)() const>(&XCAFDoc_VisMaterial::ID),
             R"#(Return GUID of this attribute type.)#"
             
         )
;

    // Class XCAFDoc_VisMaterialCommon from ./opencascade/XCAFDoc_VisMaterialCommon.hxx
    klass = m.attr("XCAFDoc_VisMaterialCommon");


    // nested enums

    static_cast<py::class_<XCAFDoc_VisMaterialCommon , shared_ptr<XCAFDoc_VisMaterialCommon>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsEqual",
             (Standard_Boolean (XCAFDoc_VisMaterialCommon::*)( const XCAFDoc_VisMaterialCommon &  ) const) static_cast<Standard_Boolean (XCAFDoc_VisMaterialCommon::*)( const XCAFDoc_VisMaterialCommon &  ) const>(&XCAFDoc_VisMaterialCommon::IsEqual),
             R"#(Compare two materials.)#"  , py::arg("theOther")
          )
        .def("DumpJson",
             (void (XCAFDoc_VisMaterialCommon::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_VisMaterialCommon::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_VisMaterialCommon::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("AmbientColor", &XCAFDoc_VisMaterialCommon::AmbientColor)
        .def_readwrite("DiffuseColor", &XCAFDoc_VisMaterialCommon::DiffuseColor)
        .def_readwrite("SpecularColor", &XCAFDoc_VisMaterialCommon::SpecularColor)
        .def_readwrite("EmissiveColor", &XCAFDoc_VisMaterialCommon::EmissiveColor)
        .def_readwrite("Shininess", &XCAFDoc_VisMaterialCommon::Shininess)
        .def_readwrite("Transparency", &XCAFDoc_VisMaterialCommon::Transparency)
        .def_readwrite("IsDefined", &XCAFDoc_VisMaterialCommon::IsDefined)
    // methods returning by ref wrapped as properties
;

    // Class XCAFDoc_VisMaterialPBR from ./opencascade/XCAFDoc_VisMaterialPBR.hxx
    klass = m.attr("XCAFDoc_VisMaterialPBR");


    // nested enums

    static_cast<py::class_<XCAFDoc_VisMaterialPBR , shared_ptr<XCAFDoc_VisMaterialPBR>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsEqual",
             (Standard_Boolean (XCAFDoc_VisMaterialPBR::*)( const XCAFDoc_VisMaterialPBR &  ) const) static_cast<Standard_Boolean (XCAFDoc_VisMaterialPBR::*)( const XCAFDoc_VisMaterialPBR &  ) const>(&XCAFDoc_VisMaterialPBR::IsEqual),
             R"#(Compare two materials.)#"  , py::arg("theOther")
          )
        .def("DumpJson",
             (void (XCAFDoc_VisMaterialPBR::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_VisMaterialPBR::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_VisMaterialPBR::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("BaseColor", &XCAFDoc_VisMaterialPBR::BaseColor)
        .def_readwrite("EmissiveFactor", &XCAFDoc_VisMaterialPBR::EmissiveFactor)
        .def_readwrite("Metallic", &XCAFDoc_VisMaterialPBR::Metallic)
        .def_readwrite("Roughness", &XCAFDoc_VisMaterialPBR::Roughness)
        .def_readwrite("RefractionIndex", &XCAFDoc_VisMaterialPBR::RefractionIndex)
        .def_readwrite("IsDefined", &XCAFDoc_VisMaterialPBR::IsDefined)
    // methods returning by ref wrapped as properties
;

    // Class XCAFDoc_VisMaterialTool from ./opencascade/XCAFDoc_VisMaterialTool.hxx
    klass = m.attr("XCAFDoc_VisMaterialTool");


    // nested enums

    static_cast<py::class_<XCAFDoc_VisMaterialTool ,opencascade::handle<XCAFDoc_VisMaterialTool>  , TDF_Attribute >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseLabel",
             (TDF_Label (XCAFDoc_VisMaterialTool::*)() const) static_cast<TDF_Label (XCAFDoc_VisMaterialTool::*)() const>(&XCAFDoc_VisMaterialTool::BaseLabel),
             R"#(returns the label under which colors are stored)#" 
          )
        .def("IsMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const>(&XCAFDoc_VisMaterialTool::IsMaterial),
             R"#(Returns TRUE if Label belongs to a Material Table.)#"  , py::arg("theLabel")
          )
        .def("AddMaterial",
             (TDF_Label (XCAFDoc_VisMaterialTool::*)( const opencascade::handle<XCAFDoc_VisMaterial> & ,  const TCollection_AsciiString &  ) const) static_cast<TDF_Label (XCAFDoc_VisMaterialTool::*)( const opencascade::handle<XCAFDoc_VisMaterial> & ,  const TCollection_AsciiString &  ) const>(&XCAFDoc_VisMaterialTool::AddMaterial),
             R"#(Adds Material definition to a Material Table and returns its Label.)#"  , py::arg("theMat"),  py::arg("theName")
          )
        .def("AddMaterial",
             (TDF_Label (XCAFDoc_VisMaterialTool::*)( const TCollection_AsciiString &  ) const) static_cast<TDF_Label (XCAFDoc_VisMaterialTool::*)( const TCollection_AsciiString &  ) const>(&XCAFDoc_VisMaterialTool::AddMaterial),
             R"#(Adds Material definition to a Material Table and returns its Label.)#"  , py::arg("theName")
          )
        .def("RemoveMaterial",
             (void (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const>(&XCAFDoc_VisMaterialTool::RemoveMaterial),
             R"#(Removes Material from the Material Table)#"  , py::arg("theLabel")
          )
        .def("GetMaterials",
             (void (XCAFDoc_VisMaterialTool::*)( NCollection_Sequence<TDF_Label> &  ) const) static_cast<void (XCAFDoc_VisMaterialTool::*)( NCollection_Sequence<TDF_Label> &  ) const>(&XCAFDoc_VisMaterialTool::GetMaterials),
             R"#(Returns a sequence of Materials currently stored in the Material Table.)#"  , py::arg("Labels")
          )
        .def("SetShapeMaterial",
             (void (XCAFDoc_VisMaterialTool::*)( const TDF_Label & ,  const TDF_Label &  ) const) static_cast<void (XCAFDoc_VisMaterialTool::*)( const TDF_Label & ,  const TDF_Label &  ) const>(&XCAFDoc_VisMaterialTool::SetShapeMaterial),
             R"#(Sets new material to the shape.)#"  , py::arg("theShapeLabel"),  py::arg("theMaterialLabel")
          )
        .def("UnSetShapeMaterial",
             (void (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const) static_cast<void (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const>(&XCAFDoc_VisMaterialTool::UnSetShapeMaterial),
             R"#(Removes a link with GUID XCAFDoc::VisMaterialRefGUID() from shape label to material.)#"  , py::arg("theShapeLabel")
          )
        .def("IsSetShapeMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const) static_cast<Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TDF_Label &  ) const>(&XCAFDoc_VisMaterialTool::IsSetShapeMaterial),
             R"#(Returns TRUE if label has a material assignment.)#"  , py::arg("theLabel")
          )
        .def("SetShapeMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape & ,  const TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape & ,  const TDF_Label &  ) >(&XCAFDoc_VisMaterialTool::SetShapeMaterial),
             R"#(Sets a link with GUID XCAFDoc::VisMaterialRefGUID() from shape label to material label.)#"  , py::arg("theShape"),  py::arg("theMaterialLabel")
          )
        .def("UnSetShapeMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape &  ) >(&XCAFDoc_VisMaterialTool::UnSetShapeMaterial),
             R"#(Removes a link with GUID XCAFDoc::VisMaterialRefGUID() from shape label to material.)#"  , py::arg("theShape")
          )
        .def("IsSetShapeMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape &  ) >(&XCAFDoc_VisMaterialTool::IsSetShapeMaterial),
             R"#(Returns TRUE if shape has a material assignment.)#"  , py::arg("theShape")
          )
        .def("GetShapeMaterial",
             (Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape & ,  TDF_Label &  ) ) static_cast<Standard_Boolean (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape & ,  TDF_Label &  ) >(&XCAFDoc_VisMaterialTool::GetShapeMaterial),
             R"#(Returns label with material assigned to shape.)#"  , py::arg("theShape"),  py::arg("theMaterialLabel")
          )
        .def("GetShapeMaterial",
             (opencascade::handle<XCAFDoc_VisMaterial> (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape &  ) ) static_cast<opencascade::handle<XCAFDoc_VisMaterial> (XCAFDoc_VisMaterialTool::*)( const TopoDS_Shape &  ) >(&XCAFDoc_VisMaterialTool::GetShapeMaterial),
             R"#(Returns material assigned to shape or NULL if not assigned.)#"  , py::arg("theShape")
          )
        .def("Restore",
             (void (XCAFDoc_VisMaterialTool::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_VisMaterialTool::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_VisMaterialTool::Restore),
             R"#(Does nothing.)#"  , py::arg("arg")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_VisMaterialTool::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_VisMaterialTool::*)() const>(&XCAFDoc_VisMaterialTool::NewEmpty),
             R"#(Creates new instance of this tool.)#" 
          )
        .def("Paste",
             (void (XCAFDoc_VisMaterialTool::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_VisMaterialTool::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_VisMaterialTool::Paste),
             R"#(Does nothing.)#"  , py::arg("arg"),  py::arg("arg")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_VisMaterialTool::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_VisMaterialTool::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_VisMaterialTool> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_VisMaterialTool> (*)( const TDF_Label &  ) >(&XCAFDoc_VisMaterialTool::Set),
                    R"#(Creates (if not exist) ColorTool.)#"  , py::arg("L")
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_VisMaterialTool::GetID),
                    R"#(None)#" 
          )
        .def_static("GetMaterial_s",
                    (opencascade::handle<XCAFDoc_VisMaterial> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_VisMaterial> (*)( const TDF_Label &  ) >(&XCAFDoc_VisMaterialTool::GetMaterial),
                    R"#(Returns Material defined by specified Label, or NULL if the label is not in Material Table.)#"  , py::arg("theMatLabel")
          )
        .def_static("GetShapeMaterial_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  TDF_Label &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  TDF_Label &  ) >(&XCAFDoc_VisMaterialTool::GetShapeMaterial),
                    R"#(Returns label with material assigned to shape label.)#"  , py::arg("theShapeLabel"),  py::arg("theMaterialLabel")
          )
        .def_static("GetShapeMaterial_s",
                    (opencascade::handle<XCAFDoc_VisMaterial> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_VisMaterial> (*)( const TDF_Label &  ) >(&XCAFDoc_VisMaterialTool::GetShapeMaterial),
                    R"#(Returns material assigned to the shape label.)#"  , py::arg("theShapeLabel")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_VisMaterialTool::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_VisMaterialTool::*)() const>(&XCAFDoc_VisMaterialTool::DynamicType),
             R"#(None)#"
             
         )
       .def("ShapeTool",
             (const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_VisMaterialTool::*)() ) static_cast<const opencascade::handle<XCAFDoc_ShapeTool> & (XCAFDoc_VisMaterialTool::*)() >(&XCAFDoc_VisMaterialTool::ShapeTool),
             R"#(Returns internal XCAFDoc_ShapeTool tool)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_VisMaterialTool::*)() const) static_cast<const Standard_GUID & (XCAFDoc_VisMaterialTool::*)() const>(&XCAFDoc_VisMaterialTool::ID),
             R"#(Returns GUID of this attribute type.)#"
             
         )
;

    // Class XCAFDoc_Volume from ./opencascade/XCAFDoc_Volume.hxx
    klass = m.attr("XCAFDoc_Volume");


    // nested enums

    static_cast<py::class_<XCAFDoc_Volume ,opencascade::handle<XCAFDoc_Volume>  , TDataStd_Real >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_Volume::*)( const Standard_Real  ) ) static_cast<void (XCAFDoc_Volume::*)( const Standard_Real  ) >(&XCAFDoc_Volume::Set),
             R"#(Sets a value of volume)#"  , py::arg("vol")
          )
        .def("Get",
             (Standard_Real (XCAFDoc_Volume::*)() const) static_cast<Standard_Real (XCAFDoc_Volume::*)() const>(&XCAFDoc_Volume::Get),
             R"#(None)#" 
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_Volume::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_Volume::*)( std::ostream &  ) const>(&XCAFDoc_Volume::Dump),
             R"#(None)#"  , py::arg("anOS")
          )
        .def("DumpJson",
             (void (XCAFDoc_Volume::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFDoc_Volume::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFDoc_Volume::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_Volume::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_Volume::*)() const>(&XCAFDoc_Volume::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_Volume::GetID),
                    R"#(None)#" 
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_Volume> (*)( const TDF_Label & ,  const Standard_Real  ) ) static_cast<opencascade::handle<XCAFDoc_Volume> (*)( const TDF_Label & ,  const Standard_Real  ) >(&XCAFDoc_Volume::Set),
                    R"#(Find, or create, an Volume attribute and set its value)#"  , py::arg("label"),  py::arg("vol")
          )
        .def_static("Get_s",
                    (Standard_Boolean (*)( const TDF_Label & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (*)( const TDF_Label & ,  Standard_Real &  ) >(&XCAFDoc_Volume::Get),
                    R"#(Returns volume as argument returns false if no such attribute at the <label>)#"  , py::arg("label"),  py::arg("vol")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_Volume::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_Volume::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ID",
             (const Standard_GUID & (XCAFDoc_Volume::*)() const) static_cast<const Standard_GUID & (XCAFDoc_Volume::*)() const>(&XCAFDoc_Volume::ID),
             R"#(None)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_Volume::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_Volume::*)() const>(&XCAFDoc_Volume::DynamicType),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_NoteBinData from ./opencascade/XCAFDoc_NoteBinData.hxx
    klass = m.attr("XCAFDoc_NoteBinData");


    // nested enums

    static_cast<py::class_<XCAFDoc_NoteBinData ,opencascade::handle<XCAFDoc_NoteBinData>  , XCAFDoc_Note >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (Standard_Boolean (XCAFDoc_NoteBinData::*)( const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  OSD_File &  ) ) static_cast<Standard_Boolean (XCAFDoc_NoteBinData::*)( const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  OSD_File &  ) >(&XCAFDoc_NoteBinData::Set),
             R"#(Sets title, MIME type and data from a binary file.)#"  , py::arg("theTitle"),  py::arg("theMIMEtype"),  py::arg("theFile")
          )
        .def("Set",
             (void (XCAFDoc_NoteBinData::*)( const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  const opencascade::handle<TColStd_HArray1OfByte> &  ) ) static_cast<void (XCAFDoc_NoteBinData::*)( const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  const opencascade::handle<TColStd_HArray1OfByte> &  ) >(&XCAFDoc_NoteBinData::Set),
             R"#(Sets title, MIME type and data from a byte array.)#"  , py::arg("theTitle"),  py::arg("theMIMEtype"),  py::arg("theData")
          )
        .def("Size",
             (Standard_Integer (XCAFDoc_NoteBinData::*)() const) static_cast<Standard_Integer (XCAFDoc_NoteBinData::*)() const>(&XCAFDoc_NoteBinData::Size),
             R"#(Size of data in bytes.)#" 
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_NoteBinData::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_NoteBinData::*)() const>(&XCAFDoc_NoteBinData::NewEmpty),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_NoteBinData::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_NoteBinData::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_NoteBinData::Restore),
             R"#(None)#"  , py::arg("theAttrFrom")
          )
        .def("Paste",
             (void (XCAFDoc_NoteBinData::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_NoteBinData::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_NoteBinData::Paste),
             R"#(None)#"  , py::arg("theAttrInto"),  py::arg("theRT")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_NoteBinData::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_NoteBinData::*)( std::ostream &  ) const>(&XCAFDoc_NoteBinData::Dump),
             R"#(None)#"  , py::arg("theOS")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_NoteBinData::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_NoteBinData::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_NoteBinData::GetID),
                    R"#(Returns default attribute GUID)#" 
          )
        .def_static("Get_s",
                    (opencascade::handle<XCAFDoc_NoteBinData> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_NoteBinData> (*)( const TDF_Label &  ) >(&XCAFDoc_NoteBinData::Get),
                    R"#(Finds a binary data attribute on the given label and returns it, if it is found)#"  , py::arg("theLabel")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_NoteBinData> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  OSD_File &  ) ) static_cast<opencascade::handle<XCAFDoc_NoteBinData> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  OSD_File &  ) >(&XCAFDoc_NoteBinData::Set),
                    R"#(Create (if not exist) a binary note with data loaded from a binary file.)#"  , py::arg("theLabel"),  py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theTitle"),  py::arg("theMIMEtype"),  py::arg("theFile")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_NoteBinData> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  const opencascade::handle<TColStd_HArray1OfByte> &  ) ) static_cast<opencascade::handle<XCAFDoc_NoteBinData> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_AsciiString & ,  const opencascade::handle<TColStd_HArray1OfByte> &  ) >(&XCAFDoc_NoteBinData::Set),
                    R"#(Create (if not exist) a binary note byte data array.)#"  , py::arg("theLabel"),  py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theTitle"),  py::arg("theMIMEtype"),  py::arg("theData")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_NoteBinData::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_NoteBinData::*)() const>(&XCAFDoc_NoteBinData::DynamicType),
             R"#(None)#"
             
         )
       .def("Title",
             (const TCollection_ExtendedString & (XCAFDoc_NoteBinData::*)() const) static_cast<const TCollection_ExtendedString & (XCAFDoc_NoteBinData::*)() const>(&XCAFDoc_NoteBinData::Title),
             R"#(Returns the note title.)#"
             
         )
       .def("MIMEtype",
             (const TCollection_AsciiString & (XCAFDoc_NoteBinData::*)() const) static_cast<const TCollection_AsciiString & (XCAFDoc_NoteBinData::*)() const>(&XCAFDoc_NoteBinData::MIMEtype),
             R"#(Returns data MIME type.)#"
             
         )
       .def("Data",
             (const opencascade::handle<TColStd_HArray1OfByte> & (XCAFDoc_NoteBinData::*)() const) static_cast<const opencascade::handle<TColStd_HArray1OfByte> & (XCAFDoc_NoteBinData::*)() const>(&XCAFDoc_NoteBinData::Data),
             R"#(Returns byte data array.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_NoteBinData::*)() const) static_cast<const Standard_GUID & (XCAFDoc_NoteBinData::*)() const>(&XCAFDoc_NoteBinData::ID),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_NoteComment from ./opencascade/XCAFDoc_NoteComment.hxx
    klass = m.attr("XCAFDoc_NoteComment");


    // nested enums

    static_cast<py::class_<XCAFDoc_NoteComment ,opencascade::handle<XCAFDoc_NoteComment>  , XCAFDoc_Note >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (XCAFDoc_NoteComment::*)( const TCollection_ExtendedString &  ) ) static_cast<void (XCAFDoc_NoteComment::*)( const TCollection_ExtendedString &  ) >(&XCAFDoc_NoteComment::Set),
             R"#(Sets the comment text.)#"  , py::arg("theComment")
          )
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_NoteComment::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_NoteComment::*)() const>(&XCAFDoc_NoteComment::NewEmpty),
             R"#(None)#" 
          )
        .def("Restore",
             (void (XCAFDoc_NoteComment::*)( const opencascade::handle<TDF_Attribute> &  ) ) static_cast<void (XCAFDoc_NoteComment::*)( const opencascade::handle<TDF_Attribute> &  ) >(&XCAFDoc_NoteComment::Restore),
             R"#(None)#"  , py::arg("theAttrFrom")
          )
        .def("Paste",
             (void (XCAFDoc_NoteComment::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const) static_cast<void (XCAFDoc_NoteComment::*)( const opencascade::handle<TDF_Attribute> & ,  const opencascade::handle<TDF_RelocationTable> &  ) const>(&XCAFDoc_NoteComment::Paste),
             R"#(None)#"  , py::arg("theAttrInto"),  py::arg("theRT")
          )
        .def("Dump",
             (Standard_OStream & (XCAFDoc_NoteComment::*)( std::ostream &  ) const) static_cast<Standard_OStream & (XCAFDoc_NoteComment::*)( std::ostream &  ) const>(&XCAFDoc_NoteComment::Dump),
             R"#(None)#"  , py::arg("theOS")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_NoteComment::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_NoteComment::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_NoteComment::GetID),
                    R"#(Returns default attribute GUID)#" 
          )
        .def_static("Get_s",
                    (opencascade::handle<XCAFDoc_NoteComment> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_NoteComment> (*)( const TDF_Label &  ) >(&XCAFDoc_NoteComment::Get),
                    R"#(Finds a reference attribute on the given label and returns it, if it is found)#"  , py::arg("theLabel")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_NoteComment> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) ) static_cast<opencascade::handle<XCAFDoc_NoteComment> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) >(&XCAFDoc_NoteComment::Set),
                    R"#(Create (if not exist) a comment note on the given label.)#"  , py::arg("theLabel"),  py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theComment")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_NoteComment::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_NoteComment::*)() const>(&XCAFDoc_NoteComment::DynamicType),
             R"#(None)#"
             
         )
       .def("Comment",
             (const TCollection_ExtendedString & (XCAFDoc_NoteComment::*)() const) static_cast<const TCollection_ExtendedString & (XCAFDoc_NoteComment::*)() const>(&XCAFDoc_NoteComment::Comment),
             R"#(Returns the comment text.)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_NoteComment::*)() const) static_cast<const Standard_GUID & (XCAFDoc_NoteComment::*)() const>(&XCAFDoc_NoteComment::ID),
             R"#(None)#"
             
         )
;

    // Class XCAFDoc_NoteBalloon from ./opencascade/XCAFDoc_NoteBalloon.hxx
    klass = m.attr("XCAFDoc_NoteBalloon");


    // nested enums

    static_cast<py::class_<XCAFDoc_NoteBalloon ,opencascade::handle<XCAFDoc_NoteBalloon>  , XCAFDoc_NoteComment >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("NewEmpty",
             (opencascade::handle<TDF_Attribute> (XCAFDoc_NoteBalloon::*)() const) static_cast<opencascade::handle<TDF_Attribute> (XCAFDoc_NoteBalloon::*)() const>(&XCAFDoc_NoteBalloon::NewEmpty),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFDoc_NoteBalloon::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFDoc_NoteBalloon::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("GetID_s",
                    (const Standard_GUID & (*)() ) static_cast<const Standard_GUID & (*)() >(&XCAFDoc_NoteBalloon::GetID),
                    R"#(Returns default attribute GUID)#" 
          )
        .def_static("Get_s",
                    (opencascade::handle<XCAFDoc_NoteBalloon> (*)( const TDF_Label &  ) ) static_cast<opencascade::handle<XCAFDoc_NoteBalloon> (*)( const TDF_Label &  ) >(&XCAFDoc_NoteBalloon::Get),
                    R"#(Finds a reference attribute on the given label and returns it, if it is found)#"  , py::arg("theLabel")
          )
        .def_static("Set_s",
                    (opencascade::handle<XCAFDoc_NoteBalloon> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) ) static_cast<opencascade::handle<XCAFDoc_NoteBalloon> (*)( const TDF_Label & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString & ,  const TCollection_ExtendedString &  ) >(&XCAFDoc_NoteBalloon::Set),
                    R"#(Create (if not exist) a comment note on the given label.)#"  , py::arg("theLabel"),  py::arg("theUserName"),  py::arg("theTimeStamp"),  py::arg("theComment")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFDoc_NoteBalloon::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFDoc_NoteBalloon::*)() const>(&XCAFDoc_NoteBalloon::DynamicType),
             R"#(None)#"
             
         )
       .def("ID",
             (const Standard_GUID & (XCAFDoc_NoteBalloon::*)() const) static_cast<const Standard_GUID & (XCAFDoc_NoteBalloon::*)() const>(&XCAFDoc_NoteBalloon::ID),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/XCAFDoc.hxx
// ./opencascade/XCAFDoc_Area.hxx
// ./opencascade/XCAFDoc_AssemblyGraph.hxx
// ./opencascade/XCAFDoc_AssemblyItemId.hxx
// ./opencascade/XCAFDoc_AssemblyItemRef.hxx
// ./opencascade/XCAFDoc_AssemblyIterator.hxx
// ./opencascade/XCAFDoc_AssemblyTool.hxx
// ./opencascade/XCAFDoc_Centroid.hxx
// ./opencascade/XCAFDoc_ClippingPlaneTool.hxx
// ./opencascade/XCAFDoc_Color.hxx
// ./opencascade/XCAFDoc_ColorTool.hxx
// ./opencascade/XCAFDoc_ColorType.hxx
// ./opencascade/XCAFDoc_DataMapIteratorOfDataMapOfShapeLabel.hxx
// ./opencascade/XCAFDoc_DataMapOfShapeLabel.hxx
// ./opencascade/XCAFDoc_Datum.hxx
// ./opencascade/XCAFDoc_DimTol.hxx
// ./opencascade/XCAFDoc_DimTolTool.hxx
// ./opencascade/XCAFDoc_Dimension.hxx
// ./opencascade/XCAFDoc_DocumentTool.hxx
// ./opencascade/XCAFDoc_Editor.hxx
// ./opencascade/XCAFDoc_GeomTolerance.hxx
// ./opencascade/XCAFDoc_GraphNode.hxx
// ./opencascade/XCAFDoc_GraphNodeSequence.hxx
// ./opencascade/XCAFDoc_LayerTool.hxx
// ./opencascade/XCAFDoc_LengthUnit.hxx
// ./opencascade/XCAFDoc_Location.hxx
// ./opencascade/XCAFDoc_Material.hxx
// ./opencascade/XCAFDoc_MaterialTool.hxx
// ./opencascade/XCAFDoc_Note.hxx
// ./opencascade/XCAFDoc_NoteBalloon.hxx
// ./opencascade/XCAFDoc_NoteBinData.hxx
// ./opencascade/XCAFDoc_NoteComment.hxx
// ./opencascade/XCAFDoc_NotesTool.hxx
// ./opencascade/XCAFDoc_PartId.hxx
// ./opencascade/XCAFDoc_ShapeMapTool.hxx
// ./opencascade/XCAFDoc_ShapeTool.hxx
// ./opencascade/XCAFDoc_View.hxx
// ./opencascade/XCAFDoc_ViewTool.hxx
// ./opencascade/XCAFDoc_VisMaterial.hxx
// ./opencascade/XCAFDoc_VisMaterialCommon.hxx
// ./opencascade/XCAFDoc_VisMaterialPBR.hxx
// ./opencascade/XCAFDoc_VisMaterialTool.hxx
// ./opencascade/XCAFDoc_Volume.hxx

// Additional functions

// operators

// register typdefs
    register_template_NCollection_DataMap<TopoDS_Shape, TDF_Label, TopTools_ShapeMapHasher>(m,"XCAFDoc_DataMapOfShapeLabel");
    register_template_NCollection_Sequence<opencascade::handle<XCAFDoc_GraphNode>>(m,"XCAFDoc_GraphNodeSequence");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
