# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementBucketsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_buckets_list(self, resource_group):
        response = self.client.buckets.list(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            api_version="2025-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_buckets_get(self, resource_group):
        response = await self.client.buckets.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            bucket_name="str",
            api_version="2025-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_buckets_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.buckets.begin_create_or_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                bucket_name="str",
                body={
                    "fileSystemUser": {"cifsUser": {"username": "str"}, "nfsUser": {"groupId": 0, "userId": 0}},
                    "id": "str",
                    "name": "str",
                    "path": "/",
                    "permissions": "ReadOnly",
                    "provisioningState": "str",
                    "server": {
                        "certificateCommonName": "str",
                        "certificateExpiryDate": "2020-02-20 00:00:00",
                        "certificateObject": "str",
                        "fqdn": "str",
                        "ipAddress": "str",
                    },
                    "status": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_buckets_begin_update(self, resource_group):
        response = await (
            await self.client.buckets.begin_update(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                bucket_name="str",
                body={
                    "fileSystemUser": {"cifsUser": {"username": "str"}, "nfsUser": {"groupId": 0, "userId": 0}},
                    "id": "str",
                    "name": "str",
                    "path": "str",
                    "permissions": "str",
                    "provisioningState": "str",
                    "server": {"certificateObject": "str", "fqdn": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_buckets_begin_delete(self, resource_group):
        response = await (
            await self.client.buckets.begin_delete(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                bucket_name="str",
                api_version="2025-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_buckets_generate_credentials(self, resource_group):
        response = await self.client.buckets.generate_credentials(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            bucket_name="str",
            body={"keyPairExpiryDays": 0},
            api_version="2025-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...
