# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.batch import BatchManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBatchManagementPoolOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BatchManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_batch_account(self, resource_group):
        response = self.client.pool.list_by_batch_account(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create(self, resource_group):
        response = self.client.pool.create(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            parameters={
                "allocationState": "str",
                "allocationStateTransitionTime": "2020-02-20 00:00:00",
                "applicationLicenses": ["str"],
                "applicationPackages": [{"id": "str", "version": "str"}],
                "autoScaleRun": {
                    "evaluationTime": "2020-02-20 00:00:00",
                    "error": {"code": "str", "message": "str", "details": [...]},
                    "results": "str",
                },
                "certificates": [{"id": "str", "storeLocation": "str", "storeName": "str", "visibility": ["str"]}],
                "creationTime": "2020-02-20 00:00:00",
                "currentDedicatedNodes": 0,
                "currentLowPriorityNodes": 0,
                "currentNodeCommunicationMode": "str",
                "deploymentConfiguration": {
                    "virtualMachineConfiguration": {
                        "imageReference": {
                            "communityGalleryImageId": "str",
                            "id": "str",
                            "offer": "str",
                            "publisher": "str",
                            "sharedGalleryImageId": "str",
                            "sku": "str",
                            "version": "str",
                        },
                        "nodeAgentSkuId": "str",
                        "containerConfiguration": {
                            "type": "str",
                            "containerImageNames": ["str"],
                            "containerRegistries": [
                                {
                                    "identityReference": {"resourceId": "str"},
                                    "password": "str",
                                    "registryServer": "str",
                                    "username": "str",
                                }
                            ],
                        },
                        "dataDisks": [{"diskSizeGB": 0, "lun": 0, "caching": "str", "storageAccountType": "str"}],
                        "diskEncryptionConfiguration": {"targets": ["str"]},
                        "extensions": [
                            {
                                "name": "str",
                                "publisher": "str",
                                "type": "str",
                                "autoUpgradeMinorVersion": bool,
                                "enableAutomaticUpgrade": bool,
                                "protectedSettings": {},
                                "provisionAfterExtensions": ["str"],
                                "settings": {},
                                "typeHandlerVersion": "str",
                            }
                        ],
                        "licenseType": "str",
                        "nodePlacementConfiguration": {"policy": "str"},
                        "osDisk": {
                            "caching": "str",
                            "diskSizeGB": 0,
                            "ephemeralOSDiskSettings": {"placement": "CacheDisk"},
                            "managedDisk": {
                                "securityProfile": {"securityEncryptionType": "str"},
                                "storageAccountType": "str",
                            },
                            "writeAcceleratorEnabled": bool,
                        },
                        "securityProfile": {
                            "encryptionAtHost": bool,
                            "securityType": "str",
                            "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                        },
                        "serviceArtifactReference": {"id": "str"},
                        "windowsConfiguration": {"enableAutomaticUpdates": bool},
                    }
                },
                "displayName": "str",
                "etag": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "interNodeCommunication": "str",
                "lastModified": "2020-02-20 00:00:00",
                "metadata": [{"name": "str", "value": "str"}],
                "mountConfiguration": [
                    {
                        "azureBlobFileSystemConfiguration": {
                            "accountName": "str",
                            "containerName": "str",
                            "relativeMountPath": "str",
                            "accountKey": "str",
                            "blobfuseOptions": "str",
                            "identityReference": {"resourceId": "str"},
                            "sasKey": "str",
                        },
                        "azureFileShareConfiguration": {
                            "accountKey": "str",
                            "accountName": "str",
                            "azureFileUrl": "str",
                            "relativeMountPath": "str",
                            "mountOptions": "str",
                        },
                        "cifsMountConfiguration": {
                            "password": "str",
                            "relativeMountPath": "str",
                            "source": "str",
                            "userName": "str",
                            "mountOptions": "str",
                        },
                        "nfsMountConfiguration": {"relativeMountPath": "str", "source": "str", "mountOptions": "str"},
                    }
                ],
                "name": "str",
                "networkConfiguration": {
                    "dynamicVnetAssignmentScope": "none",
                    "enableAcceleratedNetworking": bool,
                    "endpointConfiguration": {
                        "inboundNatPools": [
                            {
                                "backendPort": 0,
                                "frontendPortRangeEnd": 0,
                                "frontendPortRangeStart": 0,
                                "name": "str",
                                "protocol": "str",
                                "networkSecurityGroupRules": [
                                    {
                                        "access": "str",
                                        "priority": 0,
                                        "sourceAddressPrefix": "str",
                                        "sourcePortRanges": ["str"],
                                    }
                                ],
                            }
                        ]
                    },
                    "publicIPAddressConfiguration": {"ipAddressIds": ["str"], "provision": "str"},
                    "subnetId": "str",
                },
                "provisioningState": "str",
                "provisioningStateTransitionTime": "2020-02-20 00:00:00",
                "resizeOperationStatus": {
                    "errors": [{"code": "str", "message": "str", "details": [...]}],
                    "nodeDeallocationOption": "str",
                    "resizeTimeout": "1 day, 0:00:00",
                    "startTime": "2020-02-20 00:00:00",
                    "targetDedicatedNodes": 0,
                    "targetLowPriorityNodes": 0,
                },
                "resourceTags": {"str": "str"},
                "scaleSettings": {
                    "autoScale": {"formula": "str", "evaluationInterval": "1 day, 0:00:00"},
                    "fixedScale": {
                        "nodeDeallocationOption": "str",
                        "resizeTimeout": "PT15M",
                        "targetDedicatedNodes": 0,
                        "targetLowPriorityNodes": 0,
                    },
                },
                "startTask": {
                    "commandLine": "str",
                    "containerSettings": {
                        "imageName": "str",
                        "containerHostBatchBindMounts": [{"isReadOnly": bool, "source": "str"}],
                        "containerRunOptions": "str",
                        "registry": {
                            "identityReference": {"resourceId": "str"},
                            "password": "str",
                            "registryServer": "str",
                            "username": "str",
                        },
                        "workingDirectory": "str",
                    },
                    "environmentSettings": [{"name": "str", "value": "str"}],
                    "maxTaskRetryCount": 0,
                    "resourceFiles": [
                        {
                            "autoStorageContainerName": "str",
                            "blobPrefix": "str",
                            "fileMode": "str",
                            "filePath": "str",
                            "httpUrl": "str",
                            "identityReference": {"resourceId": "str"},
                            "storageContainerUrl": "str",
                        }
                    ],
                    "userIdentity": {"autoUser": {"elevationLevel": "str", "scope": "str"}, "userName": "str"},
                    "waitForSuccess": bool,
                },
                "tags": {"str": "str"},
                "targetNodeCommunicationMode": "str",
                "taskSchedulingPolicy": {"nodeFillType": "Spread"},
                "taskSlotsPerNode": 1,
                "type": "str",
                "upgradePolicy": {
                    "mode": "str",
                    "automaticOSUpgradePolicy": {
                        "disableAutomaticRollback": bool,
                        "enableAutomaticOSUpgrade": bool,
                        "osRollingUpgradeDeferral": bool,
                        "useRollingUpgradePolicy": bool,
                    },
                    "rollingUpgradePolicy": {
                        "enableCrossZoneUpgrade": bool,
                        "maxBatchInstancePercent": 0,
                        "maxUnhealthyInstancePercent": 0,
                        "maxUnhealthyUpgradedInstancePercent": 0,
                        "pauseTimeBetweenBatches": "str",
                        "prioritizeUnhealthyInstances": bool,
                        "rollbackFailedInstancesOnPolicyBreach": bool,
                    },
                },
                "userAccounts": [
                    {
                        "name": "str",
                        "password": "str",
                        "elevationLevel": "str",
                        "linuxUserConfiguration": {"gid": 0, "sshPrivateKey": "str", "uid": 0},
                        "windowsUserConfiguration": {"loginMode": "str"},
                    }
                ],
                "vmSize": "str",
            },
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.pool.update(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            parameters={
                "allocationState": "str",
                "allocationStateTransitionTime": "2020-02-20 00:00:00",
                "applicationLicenses": ["str"],
                "applicationPackages": [{"id": "str", "version": "str"}],
                "autoScaleRun": {
                    "evaluationTime": "2020-02-20 00:00:00",
                    "error": {"code": "str", "message": "str", "details": [...]},
                    "results": "str",
                },
                "certificates": [{"id": "str", "storeLocation": "str", "storeName": "str", "visibility": ["str"]}],
                "creationTime": "2020-02-20 00:00:00",
                "currentDedicatedNodes": 0,
                "currentLowPriorityNodes": 0,
                "currentNodeCommunicationMode": "str",
                "deploymentConfiguration": {
                    "virtualMachineConfiguration": {
                        "imageReference": {
                            "communityGalleryImageId": "str",
                            "id": "str",
                            "offer": "str",
                            "publisher": "str",
                            "sharedGalleryImageId": "str",
                            "sku": "str",
                            "version": "str",
                        },
                        "nodeAgentSkuId": "str",
                        "containerConfiguration": {
                            "type": "str",
                            "containerImageNames": ["str"],
                            "containerRegistries": [
                                {
                                    "identityReference": {"resourceId": "str"},
                                    "password": "str",
                                    "registryServer": "str",
                                    "username": "str",
                                }
                            ],
                        },
                        "dataDisks": [{"diskSizeGB": 0, "lun": 0, "caching": "str", "storageAccountType": "str"}],
                        "diskEncryptionConfiguration": {"targets": ["str"]},
                        "extensions": [
                            {
                                "name": "str",
                                "publisher": "str",
                                "type": "str",
                                "autoUpgradeMinorVersion": bool,
                                "enableAutomaticUpgrade": bool,
                                "protectedSettings": {},
                                "provisionAfterExtensions": ["str"],
                                "settings": {},
                                "typeHandlerVersion": "str",
                            }
                        ],
                        "licenseType": "str",
                        "nodePlacementConfiguration": {"policy": "str"},
                        "osDisk": {
                            "caching": "str",
                            "diskSizeGB": 0,
                            "ephemeralOSDiskSettings": {"placement": "CacheDisk"},
                            "managedDisk": {
                                "securityProfile": {"securityEncryptionType": "str"},
                                "storageAccountType": "str",
                            },
                            "writeAcceleratorEnabled": bool,
                        },
                        "securityProfile": {
                            "encryptionAtHost": bool,
                            "securityType": "str",
                            "uefiSettings": {"secureBootEnabled": bool, "vTpmEnabled": bool},
                        },
                        "serviceArtifactReference": {"id": "str"},
                        "windowsConfiguration": {"enableAutomaticUpdates": bool},
                    }
                },
                "displayName": "str",
                "etag": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "interNodeCommunication": "str",
                "lastModified": "2020-02-20 00:00:00",
                "metadata": [{"name": "str", "value": "str"}],
                "mountConfiguration": [
                    {
                        "azureBlobFileSystemConfiguration": {
                            "accountName": "str",
                            "containerName": "str",
                            "relativeMountPath": "str",
                            "accountKey": "str",
                            "blobfuseOptions": "str",
                            "identityReference": {"resourceId": "str"},
                            "sasKey": "str",
                        },
                        "azureFileShareConfiguration": {
                            "accountKey": "str",
                            "accountName": "str",
                            "azureFileUrl": "str",
                            "relativeMountPath": "str",
                            "mountOptions": "str",
                        },
                        "cifsMountConfiguration": {
                            "password": "str",
                            "relativeMountPath": "str",
                            "source": "str",
                            "userName": "str",
                            "mountOptions": "str",
                        },
                        "nfsMountConfiguration": {"relativeMountPath": "str", "source": "str", "mountOptions": "str"},
                    }
                ],
                "name": "str",
                "networkConfiguration": {
                    "dynamicVnetAssignmentScope": "none",
                    "enableAcceleratedNetworking": bool,
                    "endpointConfiguration": {
                        "inboundNatPools": [
                            {
                                "backendPort": 0,
                                "frontendPortRangeEnd": 0,
                                "frontendPortRangeStart": 0,
                                "name": "str",
                                "protocol": "str",
                                "networkSecurityGroupRules": [
                                    {
                                        "access": "str",
                                        "priority": 0,
                                        "sourceAddressPrefix": "str",
                                        "sourcePortRanges": ["str"],
                                    }
                                ],
                            }
                        ]
                    },
                    "publicIPAddressConfiguration": {"ipAddressIds": ["str"], "provision": "str"},
                    "subnetId": "str",
                },
                "provisioningState": "str",
                "provisioningStateTransitionTime": "2020-02-20 00:00:00",
                "resizeOperationStatus": {
                    "errors": [{"code": "str", "message": "str", "details": [...]}],
                    "nodeDeallocationOption": "str",
                    "resizeTimeout": "1 day, 0:00:00",
                    "startTime": "2020-02-20 00:00:00",
                    "targetDedicatedNodes": 0,
                    "targetLowPriorityNodes": 0,
                },
                "resourceTags": {"str": "str"},
                "scaleSettings": {
                    "autoScale": {"formula": "str", "evaluationInterval": "1 day, 0:00:00"},
                    "fixedScale": {
                        "nodeDeallocationOption": "str",
                        "resizeTimeout": "PT15M",
                        "targetDedicatedNodes": 0,
                        "targetLowPriorityNodes": 0,
                    },
                },
                "startTask": {
                    "commandLine": "str",
                    "containerSettings": {
                        "imageName": "str",
                        "containerHostBatchBindMounts": [{"isReadOnly": bool, "source": "str"}],
                        "containerRunOptions": "str",
                        "registry": {
                            "identityReference": {"resourceId": "str"},
                            "password": "str",
                            "registryServer": "str",
                            "username": "str",
                        },
                        "workingDirectory": "str",
                    },
                    "environmentSettings": [{"name": "str", "value": "str"}],
                    "maxTaskRetryCount": 0,
                    "resourceFiles": [
                        {
                            "autoStorageContainerName": "str",
                            "blobPrefix": "str",
                            "fileMode": "str",
                            "filePath": "str",
                            "httpUrl": "str",
                            "identityReference": {"resourceId": "str"},
                            "storageContainerUrl": "str",
                        }
                    ],
                    "userIdentity": {"autoUser": {"elevationLevel": "str", "scope": "str"}, "userName": "str"},
                    "waitForSuccess": bool,
                },
                "tags": {"str": "str"},
                "targetNodeCommunicationMode": "str",
                "taskSchedulingPolicy": {"nodeFillType": "Spread"},
                "taskSlotsPerNode": 1,
                "type": "str",
                "upgradePolicy": {
                    "mode": "str",
                    "automaticOSUpgradePolicy": {
                        "disableAutomaticRollback": bool,
                        "enableAutomaticOSUpgrade": bool,
                        "osRollingUpgradeDeferral": bool,
                        "useRollingUpgradePolicy": bool,
                    },
                    "rollingUpgradePolicy": {
                        "enableCrossZoneUpgrade": bool,
                        "maxBatchInstancePercent": 0,
                        "maxUnhealthyInstancePercent": 0,
                        "maxUnhealthyUpgradedInstancePercent": 0,
                        "pauseTimeBetweenBatches": "str",
                        "prioritizeUnhealthyInstances": bool,
                        "rollbackFailedInstancesOnPolicyBreach": bool,
                    },
                },
                "userAccounts": [
                    {
                        "name": "str",
                        "password": "str",
                        "elevationLevel": "str",
                        "linuxUserConfiguration": {"gid": 0, "sshPrivateKey": "str", "uid": 0},
                        "windowsUserConfiguration": {"loginMode": "str"},
                    }
                ],
                "vmSize": "str",
            },
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.pool.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            api_version="2024-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.pool.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disable_auto_scale(self, resource_group):
        response = self.client.pool.disable_auto_scale(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_stop_resize(self, resource_group):
        response = self.client.pool.stop_resize(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...
