/*
 * Copyright 2021-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.java;

import org.opentest4j.reporting.events.api.ChildElement;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.events.core.Infrastructure;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

/**
 * The {@code heapSize} element of the Java namespace.
 */
public class HeapSize extends ChildElement<Infrastructure, HeapSize> {

	private static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_JAVA, "heapSize");
	private static final QualifiedName MAX = QualifiedName.of(Namespace.REPORTING_JAVA, "max");

	HeapSize(Context context) {
		super(context, ELEMENT);
	}

	/**
	 * Set the {@code max} attribute of this element.
	 *
	 * @param bytes the number of bytes
	 * @return this element
	 */
	public HeapSize withMax(long bytes) {
		withAttribute(MAX, String.valueOf(bytes));
		return this;
	}
}
