#ifndef INCLUDED_SCRIPTOPTS_
#define INCLUDED_SCRIPTOPTS_

#include "../stbase/stbase.h"

namespace FBB
{
    class TempStream;
}

class ScriptOpts: public STBase     // with -t, with -s SourceOpts is used
{
    PtrVect     d_orgArgs;

    FBB::TempStream *d_imFile;
    FBB::TempStream *d_bimFile;

    bool d_keepBim;
    std::string d_bimName;          // the base [dir/]name of the .bim files
    size_t d_idx;

    public:
        ScriptOpts(PtrVect &argv);
        ~ScriptOpts() override;

    private:
        void addArguments();        // add arguments, including filenames

                                    // reset may change tmpDir(), puts all
                                    // remaining -t options in argv and sets
                                    // d_bimName
        void reset();               // d_argv is OptsBase's d_argv

                                        // may change tmpDir()
        void setBim(std::string arg1);  // 1st -t argument

        void setOptions();          // set compile/execute options      // .ih

        void addImAndBim();
        char *imName();
        char *bimName();

        void tmpBim();

        void addBeyondNonOpt();     // add options beyond the 1st non-opt
        void addCmdlineArgs();

                                    // returns 1 for non-existing files
        static size_t lastModified(std::string const &filename);        // .ih
};
        
#endif
