//*
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//*
// These .proto interfaces are private and stable.
// Please see http://wiki.apache.org/hadoop/Compatibility
// for what changes are allowed for a *stable* .proto interface.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.19.4
// source: hdfs.proto

package hadoop_hdfs

import (
	hadoop_common "github.com/colinmarc/hdfs/v2/internal/protocol/hadoop_common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

//*
// Types of recognized storage media.
type StorageTypeProto int32

const (
	StorageTypeProto_DISK     StorageTypeProto = 1
	StorageTypeProto_SSD      StorageTypeProto = 2
	StorageTypeProto_ARCHIVE  StorageTypeProto = 3
	StorageTypeProto_RAM_DISK StorageTypeProto = 4
	StorageTypeProto_PROVIDED StorageTypeProto = 5
)

// Enum value maps for StorageTypeProto.
var (
	StorageTypeProto_name = map[int32]string{
		1: "DISK",
		2: "SSD",
		3: "ARCHIVE",
		4: "RAM_DISK",
		5: "PROVIDED",
	}
	StorageTypeProto_value = map[string]int32{
		"DISK":     1,
		"SSD":      2,
		"ARCHIVE":  3,
		"RAM_DISK": 4,
		"PROVIDED": 5,
	}
)

func (x StorageTypeProto) Enum() *StorageTypeProto {
	p := new(StorageTypeProto)
	*p = x
	return p
}

func (x StorageTypeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StorageTypeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[0].Descriptor()
}

func (StorageTypeProto) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[0]
}

func (x StorageTypeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *StorageTypeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = StorageTypeProto(num)
	return nil
}

// Deprecated: Use StorageTypeProto.Descriptor instead.
func (StorageTypeProto) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{0}
}

//*
// Types of recognized blocks.
type BlockTypeProto int32

const (
	BlockTypeProto_CONTIGUOUS BlockTypeProto = 0
	BlockTypeProto_STRIPED    BlockTypeProto = 1
)

// Enum value maps for BlockTypeProto.
var (
	BlockTypeProto_name = map[int32]string{
		0: "CONTIGUOUS",
		1: "STRIPED",
	}
	BlockTypeProto_value = map[string]int32{
		"CONTIGUOUS": 0,
		"STRIPED":    1,
	}
)

func (x BlockTypeProto) Enum() *BlockTypeProto {
	p := new(BlockTypeProto)
	*p = x
	return p
}

func (x BlockTypeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BlockTypeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[1].Descriptor()
}

func (BlockTypeProto) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[1]
}

func (x BlockTypeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *BlockTypeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = BlockTypeProto(num)
	return nil
}

// Deprecated: Use BlockTypeProto.Descriptor instead.
func (BlockTypeProto) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{1}
}

//*
// Cipher suite.
type CipherSuiteProto int32

const (
	CipherSuiteProto_UNKNOWN           CipherSuiteProto = 1
	CipherSuiteProto_AES_CTR_NOPADDING CipherSuiteProto = 2
)

// Enum value maps for CipherSuiteProto.
var (
	CipherSuiteProto_name = map[int32]string{
		1: "UNKNOWN",
		2: "AES_CTR_NOPADDING",
	}
	CipherSuiteProto_value = map[string]int32{
		"UNKNOWN":           1,
		"AES_CTR_NOPADDING": 2,
	}
)

func (x CipherSuiteProto) Enum() *CipherSuiteProto {
	p := new(CipherSuiteProto)
	*p = x
	return p
}

func (x CipherSuiteProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CipherSuiteProto) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[2].Descriptor()
}

func (CipherSuiteProto) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[2]
}

func (x CipherSuiteProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CipherSuiteProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CipherSuiteProto(num)
	return nil
}

// Deprecated: Use CipherSuiteProto.Descriptor instead.
func (CipherSuiteProto) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{2}
}

//*
// Crypto protocol version used to access encrypted files.
type CryptoProtocolVersionProto int32

const (
	CryptoProtocolVersionProto_UNKNOWN_PROTOCOL_VERSION CryptoProtocolVersionProto = 1
	CryptoProtocolVersionProto_ENCRYPTION_ZONES         CryptoProtocolVersionProto = 2
)

// Enum value maps for CryptoProtocolVersionProto.
var (
	CryptoProtocolVersionProto_name = map[int32]string{
		1: "UNKNOWN_PROTOCOL_VERSION",
		2: "ENCRYPTION_ZONES",
	}
	CryptoProtocolVersionProto_value = map[string]int32{
		"UNKNOWN_PROTOCOL_VERSION": 1,
		"ENCRYPTION_ZONES":         2,
	}
)

func (x CryptoProtocolVersionProto) Enum() *CryptoProtocolVersionProto {
	p := new(CryptoProtocolVersionProto)
	*p = x
	return p
}

func (x CryptoProtocolVersionProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoProtocolVersionProto) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[3].Descriptor()
}

func (CryptoProtocolVersionProto) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[3]
}

func (x CryptoProtocolVersionProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CryptoProtocolVersionProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CryptoProtocolVersionProto(num)
	return nil
}

// Deprecated: Use CryptoProtocolVersionProto.Descriptor instead.
func (CryptoProtocolVersionProto) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{3}
}

//*
// EC policy state.
type ErasureCodingPolicyState int32

const (
	ErasureCodingPolicyState_DISABLED ErasureCodingPolicyState = 1
	ErasureCodingPolicyState_ENABLED  ErasureCodingPolicyState = 2
	ErasureCodingPolicyState_REMOVED  ErasureCodingPolicyState = 3
)

// Enum value maps for ErasureCodingPolicyState.
var (
	ErasureCodingPolicyState_name = map[int32]string{
		1: "DISABLED",
		2: "ENABLED",
		3: "REMOVED",
	}
	ErasureCodingPolicyState_value = map[string]int32{
		"DISABLED": 1,
		"ENABLED":  2,
		"REMOVED":  3,
	}
)

func (x ErasureCodingPolicyState) Enum() *ErasureCodingPolicyState {
	p := new(ErasureCodingPolicyState)
	*p = x
	return p
}

func (x ErasureCodingPolicyState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErasureCodingPolicyState) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[4].Descriptor()
}

func (ErasureCodingPolicyState) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[4]
}

func (x ErasureCodingPolicyState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ErasureCodingPolicyState) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ErasureCodingPolicyState(num)
	return nil
}

// Deprecated: Use ErasureCodingPolicyState.Descriptor instead.
func (ErasureCodingPolicyState) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{4}
}

//*
// Checksum algorithms/types used in HDFS
// Make sure this enum's integer values match enum values' id properties defined
// in org.apache.hadoop.util.DataChecksum.Type
type ChecksumTypeProto int32

const (
	ChecksumTypeProto_CHECKSUM_NULL   ChecksumTypeProto = 0
	ChecksumTypeProto_CHECKSUM_CRC32  ChecksumTypeProto = 1
	ChecksumTypeProto_CHECKSUM_CRC32C ChecksumTypeProto = 2
)

// Enum value maps for ChecksumTypeProto.
var (
	ChecksumTypeProto_name = map[int32]string{
		0: "CHECKSUM_NULL",
		1: "CHECKSUM_CRC32",
		2: "CHECKSUM_CRC32C",
	}
	ChecksumTypeProto_value = map[string]int32{
		"CHECKSUM_NULL":   0,
		"CHECKSUM_CRC32":  1,
		"CHECKSUM_CRC32C": 2,
	}
)

func (x ChecksumTypeProto) Enum() *ChecksumTypeProto {
	p := new(ChecksumTypeProto)
	*p = x
	return p
}

func (x ChecksumTypeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChecksumTypeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[5].Descriptor()
}

func (ChecksumTypeProto) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[5]
}

func (x ChecksumTypeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ChecksumTypeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ChecksumTypeProto(num)
	return nil
}

// Deprecated: Use ChecksumTypeProto.Descriptor instead.
func (ChecksumTypeProto) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{5}
}

type BlockChecksumTypeProto int32

const (
	BlockChecksumTypeProto_MD5CRC        BlockChecksumTypeProto = 1 // BlockChecksum obtained by taking the MD5 digest of chunk CRCs
	BlockChecksumTypeProto_COMPOSITE_CRC BlockChecksumTypeProto = 2 // Chunk-independent CRC, optionally striped
)

// Enum value maps for BlockChecksumTypeProto.
var (
	BlockChecksumTypeProto_name = map[int32]string{
		1: "MD5CRC",
		2: "COMPOSITE_CRC",
	}
	BlockChecksumTypeProto_value = map[string]int32{
		"MD5CRC":        1,
		"COMPOSITE_CRC": 2,
	}
)

func (x BlockChecksumTypeProto) Enum() *BlockChecksumTypeProto {
	p := new(BlockChecksumTypeProto)
	*p = x
	return p
}

func (x BlockChecksumTypeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BlockChecksumTypeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[6].Descriptor()
}

func (BlockChecksumTypeProto) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[6]
}

func (x BlockChecksumTypeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *BlockChecksumTypeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = BlockChecksumTypeProto(num)
	return nil
}

// Deprecated: Use BlockChecksumTypeProto.Descriptor instead.
func (BlockChecksumTypeProto) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{6}
}

//*
// File access permissions mode.
type AccessModeProto int32

const (
	AccessModeProto_READ    AccessModeProto = 1
	AccessModeProto_WRITE   AccessModeProto = 2
	AccessModeProto_COPY    AccessModeProto = 3
	AccessModeProto_REPLACE AccessModeProto = 4
)

// Enum value maps for AccessModeProto.
var (
	AccessModeProto_name = map[int32]string{
		1: "READ",
		2: "WRITE",
		3: "COPY",
		4: "REPLACE",
	}
	AccessModeProto_value = map[string]int32{
		"READ":    1,
		"WRITE":   2,
		"COPY":    3,
		"REPLACE": 4,
	}
)

func (x AccessModeProto) Enum() *AccessModeProto {
	p := new(AccessModeProto)
	*p = x
	return p
}

func (x AccessModeProto) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessModeProto) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[7].Descriptor()
}

func (AccessModeProto) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[7]
}

func (x AccessModeProto) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *AccessModeProto) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = AccessModeProto(num)
	return nil
}

// Deprecated: Use AccessModeProto.Descriptor instead.
func (AccessModeProto) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{7}
}

type DatanodeInfoProto_AdminState int32

const (
	DatanodeInfoProto_NORMAL                  DatanodeInfoProto_AdminState = 0
	DatanodeInfoProto_DECOMMISSION_INPROGRESS DatanodeInfoProto_AdminState = 1
	DatanodeInfoProto_DECOMMISSIONED          DatanodeInfoProto_AdminState = 2
	DatanodeInfoProto_ENTERING_MAINTENANCE    DatanodeInfoProto_AdminState = 3
	DatanodeInfoProto_IN_MAINTENANCE          DatanodeInfoProto_AdminState = 4
)

// Enum value maps for DatanodeInfoProto_AdminState.
var (
	DatanodeInfoProto_AdminState_name = map[int32]string{
		0: "NORMAL",
		1: "DECOMMISSION_INPROGRESS",
		2: "DECOMMISSIONED",
		3: "ENTERING_MAINTENANCE",
		4: "IN_MAINTENANCE",
	}
	DatanodeInfoProto_AdminState_value = map[string]int32{
		"NORMAL":                  0,
		"DECOMMISSION_INPROGRESS": 1,
		"DECOMMISSIONED":          2,
		"ENTERING_MAINTENANCE":    3,
		"IN_MAINTENANCE":          4,
	}
)

func (x DatanodeInfoProto_AdminState) Enum() *DatanodeInfoProto_AdminState {
	p := new(DatanodeInfoProto_AdminState)
	*p = x
	return p
}

func (x DatanodeInfoProto_AdminState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatanodeInfoProto_AdminState) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[8].Descriptor()
}

func (DatanodeInfoProto_AdminState) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[8]
}

func (x DatanodeInfoProto_AdminState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *DatanodeInfoProto_AdminState) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = DatanodeInfoProto_AdminState(num)
	return nil
}

// Deprecated: Use DatanodeInfoProto_AdminState.Descriptor instead.
func (DatanodeInfoProto_AdminState) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{6, 0}
}

type DatanodeStorageProto_StorageState int32

const (
	DatanodeStorageProto_NORMAL           DatanodeStorageProto_StorageState = 0
	DatanodeStorageProto_READ_ONLY_SHARED DatanodeStorageProto_StorageState = 1
)

// Enum value maps for DatanodeStorageProto_StorageState.
var (
	DatanodeStorageProto_StorageState_name = map[int32]string{
		0: "NORMAL",
		1: "READ_ONLY_SHARED",
	}
	DatanodeStorageProto_StorageState_value = map[string]int32{
		"NORMAL":           0,
		"READ_ONLY_SHARED": 1,
	}
)

func (x DatanodeStorageProto_StorageState) Enum() *DatanodeStorageProto_StorageState {
	p := new(DatanodeStorageProto_StorageState)
	*p = x
	return p
}

func (x DatanodeStorageProto_StorageState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatanodeStorageProto_StorageState) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[9].Descriptor()
}

func (DatanodeStorageProto_StorageState) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[9]
}

func (x DatanodeStorageProto_StorageState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *DatanodeStorageProto_StorageState) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = DatanodeStorageProto_StorageState(num)
	return nil
}

// Deprecated: Use DatanodeStorageProto_StorageState.Descriptor instead.
func (DatanodeStorageProto_StorageState) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{7, 0}
}

type HdfsFileStatusProto_FileType int32

const (
	HdfsFileStatusProto_IS_DIR     HdfsFileStatusProto_FileType = 1
	HdfsFileStatusProto_IS_FILE    HdfsFileStatusProto_FileType = 2
	HdfsFileStatusProto_IS_SYMLINK HdfsFileStatusProto_FileType = 3
)

// Enum value maps for HdfsFileStatusProto_FileType.
var (
	HdfsFileStatusProto_FileType_name = map[int32]string{
		1: "IS_DIR",
		2: "IS_FILE",
		3: "IS_SYMLINK",
	}
	HdfsFileStatusProto_FileType_value = map[string]int32{
		"IS_DIR":     1,
		"IS_FILE":    2,
		"IS_SYMLINK": 3,
	}
)

func (x HdfsFileStatusProto_FileType) Enum() *HdfsFileStatusProto_FileType {
	p := new(HdfsFileStatusProto_FileType)
	*p = x
	return p
}

func (x HdfsFileStatusProto_FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HdfsFileStatusProto_FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[10].Descriptor()
}

func (HdfsFileStatusProto_FileType) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[10]
}

func (x HdfsFileStatusProto_FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *HdfsFileStatusProto_FileType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = HdfsFileStatusProto_FileType(num)
	return nil
}

// Deprecated: Use HdfsFileStatusProto_FileType.Descriptor instead.
func (HdfsFileStatusProto_FileType) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{31, 0}
}

type HdfsFileStatusProto_Flags int32

const (
	HdfsFileStatusProto_HAS_ACL          HdfsFileStatusProto_Flags = 1 // has ACLs
	HdfsFileStatusProto_HAS_CRYPT        HdfsFileStatusProto_Flags = 2 // encrypted
	HdfsFileStatusProto_HAS_EC           HdfsFileStatusProto_Flags = 4 // erasure coded
	HdfsFileStatusProto_SNAPSHOT_ENABLED HdfsFileStatusProto_Flags = 8 // SNAPSHOT ENABLED
)

// Enum value maps for HdfsFileStatusProto_Flags.
var (
	HdfsFileStatusProto_Flags_name = map[int32]string{
		1: "HAS_ACL",
		2: "HAS_CRYPT",
		4: "HAS_EC",
		8: "SNAPSHOT_ENABLED",
	}
	HdfsFileStatusProto_Flags_value = map[string]int32{
		"HAS_ACL":          1,
		"HAS_CRYPT":        2,
		"HAS_EC":           4,
		"SNAPSHOT_ENABLED": 8,
	}
)

func (x HdfsFileStatusProto_Flags) Enum() *HdfsFileStatusProto_Flags {
	p := new(HdfsFileStatusProto_Flags)
	*p = x
	return p
}

func (x HdfsFileStatusProto_Flags) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HdfsFileStatusProto_Flags) Descriptor() protoreflect.EnumDescriptor {
	return file_hdfs_proto_enumTypes[11].Descriptor()
}

func (HdfsFileStatusProto_Flags) Type() protoreflect.EnumType {
	return &file_hdfs_proto_enumTypes[11]
}

func (x HdfsFileStatusProto_Flags) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *HdfsFileStatusProto_Flags) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = HdfsFileStatusProto_Flags(num)
	return nil
}

// Deprecated: Use HdfsFileStatusProto_Flags.Descriptor instead.
func (HdfsFileStatusProto_Flags) EnumDescriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{31, 1}
}

//*
// Extended block idenfies a block
type ExtendedBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PoolId          *string `protobuf:"bytes,1,req,name=poolId" json:"poolId,omitempty"`    // Block pool id - globally unique across clusters
	BlockId         *uint64 `protobuf:"varint,2,req,name=blockId" json:"blockId,omitempty"` // the local id within a pool
	GenerationStamp *uint64 `protobuf:"varint,3,req,name=generationStamp" json:"generationStamp,omitempty"`
	NumBytes        *uint64 `protobuf:"varint,4,opt,name=numBytes,def=0" json:"numBytes,omitempty"` // len does not belong in ebid
}

// Default values for ExtendedBlockProto fields.
const (
	Default_ExtendedBlockProto_NumBytes = uint64(0)
)

func (x *ExtendedBlockProto) Reset() {
	*x = ExtendedBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtendedBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtendedBlockProto) ProtoMessage() {}

func (x *ExtendedBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtendedBlockProto.ProtoReflect.Descriptor instead.
func (*ExtendedBlockProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{0}
}

func (x *ExtendedBlockProto) GetPoolId() string {
	if x != nil && x.PoolId != nil {
		return *x.PoolId
	}
	return ""
}

func (x *ExtendedBlockProto) GetBlockId() uint64 {
	if x != nil && x.BlockId != nil {
		return *x.BlockId
	}
	return 0
}

func (x *ExtendedBlockProto) GetGenerationStamp() uint64 {
	if x != nil && x.GenerationStamp != nil {
		return *x.GenerationStamp
	}
	return 0
}

func (x *ExtendedBlockProto) GetNumBytes() uint64 {
	if x != nil && x.NumBytes != nil {
		return *x.NumBytes
	}
	return Default_ExtendedBlockProto_NumBytes
}

type ProvidedStorageLocationProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path   *string `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	Offset *int64  `protobuf:"varint,2,req,name=offset" json:"offset,omitempty"`
	Length *int64  `protobuf:"varint,3,req,name=length" json:"length,omitempty"`
	Nonce  []byte  `protobuf:"bytes,4,req,name=nonce" json:"nonce,omitempty"`
}

func (x *ProvidedStorageLocationProto) Reset() {
	*x = ProvidedStorageLocationProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvidedStorageLocationProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvidedStorageLocationProto) ProtoMessage() {}

func (x *ProvidedStorageLocationProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvidedStorageLocationProto.ProtoReflect.Descriptor instead.
func (*ProvidedStorageLocationProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{1}
}

func (x *ProvidedStorageLocationProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *ProvidedStorageLocationProto) GetOffset() int64 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

func (x *ProvidedStorageLocationProto) GetLength() int64 {
	if x != nil && x.Length != nil {
		return *x.Length
	}
	return 0
}

func (x *ProvidedStorageLocationProto) GetNonce() []byte {
	if x != nil {
		return x.Nonce
	}
	return nil
}

//*
// Identifies a Datanode
type DatanodeIDProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IpAddr       *string `protobuf:"bytes,1,req,name=ipAddr" json:"ipAddr,omitempty"`             // IP address
	HostName     *string `protobuf:"bytes,2,req,name=hostName" json:"hostName,omitempty"`         // hostname
	DatanodeUuid *string `protobuf:"bytes,3,req,name=datanodeUuid" json:"datanodeUuid,omitempty"` // UUID assigned to the Datanode. For
	// upgraded clusters this is the same
	// as the original StorageID of the
	// Datanode.
	XferPort       *uint32 `protobuf:"varint,4,req,name=xferPort" json:"xferPort,omitempty"`                   // data streaming port
	InfoPort       *uint32 `protobuf:"varint,5,req,name=infoPort" json:"infoPort,omitempty"`                   // datanode http port
	IpcPort        *uint32 `protobuf:"varint,6,req,name=ipcPort" json:"ipcPort,omitempty"`                     // ipc server port
	InfoSecurePort *uint32 `protobuf:"varint,7,opt,name=infoSecurePort,def=0" json:"infoSecurePort,omitempty"` // datanode https port
}

// Default values for DatanodeIDProto fields.
const (
	Default_DatanodeIDProto_InfoSecurePort = uint32(0)
)

func (x *DatanodeIDProto) Reset() {
	*x = DatanodeIDProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatanodeIDProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatanodeIDProto) ProtoMessage() {}

func (x *DatanodeIDProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatanodeIDProto.ProtoReflect.Descriptor instead.
func (*DatanodeIDProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{2}
}

func (x *DatanodeIDProto) GetIpAddr() string {
	if x != nil && x.IpAddr != nil {
		return *x.IpAddr
	}
	return ""
}

func (x *DatanodeIDProto) GetHostName() string {
	if x != nil && x.HostName != nil {
		return *x.HostName
	}
	return ""
}

func (x *DatanodeIDProto) GetDatanodeUuid() string {
	if x != nil && x.DatanodeUuid != nil {
		return *x.DatanodeUuid
	}
	return ""
}

func (x *DatanodeIDProto) GetXferPort() uint32 {
	if x != nil && x.XferPort != nil {
		return *x.XferPort
	}
	return 0
}

func (x *DatanodeIDProto) GetInfoPort() uint32 {
	if x != nil && x.InfoPort != nil {
		return *x.InfoPort
	}
	return 0
}

func (x *DatanodeIDProto) GetIpcPort() uint32 {
	if x != nil && x.IpcPort != nil {
		return *x.IpcPort
	}
	return 0
}

func (x *DatanodeIDProto) GetInfoSecurePort() uint32 {
	if x != nil && x.InfoSecurePort != nil {
		return *x.InfoSecurePort
	}
	return Default_DatanodeIDProto_InfoSecurePort
}

//*
// Datanode local information
type DatanodeLocalInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SoftwareVersion *string `protobuf:"bytes,1,req,name=softwareVersion" json:"softwareVersion,omitempty"`
	ConfigVersion   *string `protobuf:"bytes,2,req,name=configVersion" json:"configVersion,omitempty"`
	Uptime          *uint64 `protobuf:"varint,3,req,name=uptime" json:"uptime,omitempty"`
}

func (x *DatanodeLocalInfoProto) Reset() {
	*x = DatanodeLocalInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatanodeLocalInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatanodeLocalInfoProto) ProtoMessage() {}

func (x *DatanodeLocalInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatanodeLocalInfoProto.ProtoReflect.Descriptor instead.
func (*DatanodeLocalInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{3}
}

func (x *DatanodeLocalInfoProto) GetSoftwareVersion() string {
	if x != nil && x.SoftwareVersion != nil {
		return *x.SoftwareVersion
	}
	return ""
}

func (x *DatanodeLocalInfoProto) GetConfigVersion() string {
	if x != nil && x.ConfigVersion != nil {
		return *x.ConfigVersion
	}
	return ""
}

func (x *DatanodeLocalInfoProto) GetUptime() uint64 {
	if x != nil && x.Uptime != nil {
		return *x.Uptime
	}
	return 0
}

//*
// Datanode volume information
type DatanodeVolumeInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path                     *string           `protobuf:"bytes,1,req,name=path" json:"path,omitempty"`
	StorageType              *StorageTypeProto `protobuf:"varint,2,req,name=storageType,enum=hadoop.hdfs.StorageTypeProto" json:"storageType,omitempty"`
	UsedSpace                *uint64           `protobuf:"varint,3,req,name=usedSpace" json:"usedSpace,omitempty"`
	FreeSpace                *uint64           `protobuf:"varint,4,req,name=freeSpace" json:"freeSpace,omitempty"`
	ReservedSpace            *uint64           `protobuf:"varint,5,req,name=reservedSpace" json:"reservedSpace,omitempty"`
	ReservedSpaceForReplicas *uint64           `protobuf:"varint,6,req,name=reservedSpaceForReplicas" json:"reservedSpaceForReplicas,omitempty"`
	NumBlocks                *uint64           `protobuf:"varint,7,req,name=numBlocks" json:"numBlocks,omitempty"`
}

func (x *DatanodeVolumeInfoProto) Reset() {
	*x = DatanodeVolumeInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatanodeVolumeInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatanodeVolumeInfoProto) ProtoMessage() {}

func (x *DatanodeVolumeInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatanodeVolumeInfoProto.ProtoReflect.Descriptor instead.
func (*DatanodeVolumeInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{4}
}

func (x *DatanodeVolumeInfoProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *DatanodeVolumeInfoProto) GetStorageType() StorageTypeProto {
	if x != nil && x.StorageType != nil {
		return *x.StorageType
	}
	return StorageTypeProto_DISK
}

func (x *DatanodeVolumeInfoProto) GetUsedSpace() uint64 {
	if x != nil && x.UsedSpace != nil {
		return *x.UsedSpace
	}
	return 0
}

func (x *DatanodeVolumeInfoProto) GetFreeSpace() uint64 {
	if x != nil && x.FreeSpace != nil {
		return *x.FreeSpace
	}
	return 0
}

func (x *DatanodeVolumeInfoProto) GetReservedSpace() uint64 {
	if x != nil && x.ReservedSpace != nil {
		return *x.ReservedSpace
	}
	return 0
}

func (x *DatanodeVolumeInfoProto) GetReservedSpaceForReplicas() uint64 {
	if x != nil && x.ReservedSpaceForReplicas != nil {
		return *x.ReservedSpaceForReplicas
	}
	return 0
}

func (x *DatanodeVolumeInfoProto) GetNumBlocks() uint64 {
	if x != nil && x.NumBlocks != nil {
		return *x.NumBlocks
	}
	return 0
}

//*
// DatanodeInfo array
type DatanodeInfosProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Datanodes []*DatanodeInfoProto `protobuf:"bytes,1,rep,name=datanodes" json:"datanodes,omitempty"`
}

func (x *DatanodeInfosProto) Reset() {
	*x = DatanodeInfosProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatanodeInfosProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatanodeInfosProto) ProtoMessage() {}

func (x *DatanodeInfosProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatanodeInfosProto.ProtoReflect.Descriptor instead.
func (*DatanodeInfosProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{5}
}

func (x *DatanodeInfosProto) GetDatanodes() []*DatanodeInfoProto {
	if x != nil {
		return x.Datanodes
	}
	return nil
}

//*
// The status of a Datanode
type DatanodeInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id                       *DatanodeIDProto              `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	Capacity                 *uint64                       `protobuf:"varint,2,opt,name=capacity,def=0" json:"capacity,omitempty"`
	DfsUsed                  *uint64                       `protobuf:"varint,3,opt,name=dfsUsed,def=0" json:"dfsUsed,omitempty"`
	Remaining                *uint64                       `protobuf:"varint,4,opt,name=remaining,def=0" json:"remaining,omitempty"`
	BlockPoolUsed            *uint64                       `protobuf:"varint,5,opt,name=blockPoolUsed,def=0" json:"blockPoolUsed,omitempty"`
	LastUpdate               *uint64                       `protobuf:"varint,6,opt,name=lastUpdate,def=0" json:"lastUpdate,omitempty"`
	XceiverCount             *uint32                       `protobuf:"varint,7,opt,name=xceiverCount,def=0" json:"xceiverCount,omitempty"`
	Location                 *string                       `protobuf:"bytes,8,opt,name=location" json:"location,omitempty"`
	NonDfsUsed               *uint64                       `protobuf:"varint,9,opt,name=nonDfsUsed" json:"nonDfsUsed,omitempty"`
	AdminState               *DatanodeInfoProto_AdminState `protobuf:"varint,10,opt,name=adminState,enum=hadoop.hdfs.DatanodeInfoProto_AdminState,def=0" json:"adminState,omitempty"`
	CacheCapacity            *uint64                       `protobuf:"varint,11,opt,name=cacheCapacity,def=0" json:"cacheCapacity,omitempty"`
	CacheUsed                *uint64                       `protobuf:"varint,12,opt,name=cacheUsed,def=0" json:"cacheUsed,omitempty"`
	LastUpdateMonotonic      *uint64                       `protobuf:"varint,13,opt,name=lastUpdateMonotonic,def=0" json:"lastUpdateMonotonic,omitempty"`
	UpgradeDomain            *string                       `protobuf:"bytes,14,opt,name=upgradeDomain" json:"upgradeDomain,omitempty"`
	LastBlockReportTime      *uint64                       `protobuf:"varint,15,opt,name=lastBlockReportTime,def=0" json:"lastBlockReportTime,omitempty"`
	LastBlockReportMonotonic *uint64                       `protobuf:"varint,16,opt,name=lastBlockReportMonotonic,def=0" json:"lastBlockReportMonotonic,omitempty"`
	NumBlocks                *uint32                       `protobuf:"varint,17,opt,name=numBlocks,def=0" json:"numBlocks,omitempty"`
}

// Default values for DatanodeInfoProto fields.
const (
	Default_DatanodeInfoProto_Capacity                 = uint64(0)
	Default_DatanodeInfoProto_DfsUsed                  = uint64(0)
	Default_DatanodeInfoProto_Remaining                = uint64(0)
	Default_DatanodeInfoProto_BlockPoolUsed            = uint64(0)
	Default_DatanodeInfoProto_LastUpdate               = uint64(0)
	Default_DatanodeInfoProto_XceiverCount             = uint32(0)
	Default_DatanodeInfoProto_AdminState               = DatanodeInfoProto_NORMAL
	Default_DatanodeInfoProto_CacheCapacity            = uint64(0)
	Default_DatanodeInfoProto_CacheUsed                = uint64(0)
	Default_DatanodeInfoProto_LastUpdateMonotonic      = uint64(0)
	Default_DatanodeInfoProto_LastBlockReportTime      = uint64(0)
	Default_DatanodeInfoProto_LastBlockReportMonotonic = uint64(0)
	Default_DatanodeInfoProto_NumBlocks                = uint32(0)
)

func (x *DatanodeInfoProto) Reset() {
	*x = DatanodeInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatanodeInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatanodeInfoProto) ProtoMessage() {}

func (x *DatanodeInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatanodeInfoProto.ProtoReflect.Descriptor instead.
func (*DatanodeInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{6}
}

func (x *DatanodeInfoProto) GetId() *DatanodeIDProto {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *DatanodeInfoProto) GetCapacity() uint64 {
	if x != nil && x.Capacity != nil {
		return *x.Capacity
	}
	return Default_DatanodeInfoProto_Capacity
}

func (x *DatanodeInfoProto) GetDfsUsed() uint64 {
	if x != nil && x.DfsUsed != nil {
		return *x.DfsUsed
	}
	return Default_DatanodeInfoProto_DfsUsed
}

func (x *DatanodeInfoProto) GetRemaining() uint64 {
	if x != nil && x.Remaining != nil {
		return *x.Remaining
	}
	return Default_DatanodeInfoProto_Remaining
}

func (x *DatanodeInfoProto) GetBlockPoolUsed() uint64 {
	if x != nil && x.BlockPoolUsed != nil {
		return *x.BlockPoolUsed
	}
	return Default_DatanodeInfoProto_BlockPoolUsed
}

func (x *DatanodeInfoProto) GetLastUpdate() uint64 {
	if x != nil && x.LastUpdate != nil {
		return *x.LastUpdate
	}
	return Default_DatanodeInfoProto_LastUpdate
}

func (x *DatanodeInfoProto) GetXceiverCount() uint32 {
	if x != nil && x.XceiverCount != nil {
		return *x.XceiverCount
	}
	return Default_DatanodeInfoProto_XceiverCount
}

func (x *DatanodeInfoProto) GetLocation() string {
	if x != nil && x.Location != nil {
		return *x.Location
	}
	return ""
}

func (x *DatanodeInfoProto) GetNonDfsUsed() uint64 {
	if x != nil && x.NonDfsUsed != nil {
		return *x.NonDfsUsed
	}
	return 0
}

func (x *DatanodeInfoProto) GetAdminState() DatanodeInfoProto_AdminState {
	if x != nil && x.AdminState != nil {
		return *x.AdminState
	}
	return Default_DatanodeInfoProto_AdminState
}

func (x *DatanodeInfoProto) GetCacheCapacity() uint64 {
	if x != nil && x.CacheCapacity != nil {
		return *x.CacheCapacity
	}
	return Default_DatanodeInfoProto_CacheCapacity
}

func (x *DatanodeInfoProto) GetCacheUsed() uint64 {
	if x != nil && x.CacheUsed != nil {
		return *x.CacheUsed
	}
	return Default_DatanodeInfoProto_CacheUsed
}

func (x *DatanodeInfoProto) GetLastUpdateMonotonic() uint64 {
	if x != nil && x.LastUpdateMonotonic != nil {
		return *x.LastUpdateMonotonic
	}
	return Default_DatanodeInfoProto_LastUpdateMonotonic
}

func (x *DatanodeInfoProto) GetUpgradeDomain() string {
	if x != nil && x.UpgradeDomain != nil {
		return *x.UpgradeDomain
	}
	return ""
}

func (x *DatanodeInfoProto) GetLastBlockReportTime() uint64 {
	if x != nil && x.LastBlockReportTime != nil {
		return *x.LastBlockReportTime
	}
	return Default_DatanodeInfoProto_LastBlockReportTime
}

func (x *DatanodeInfoProto) GetLastBlockReportMonotonic() uint64 {
	if x != nil && x.LastBlockReportMonotonic != nil {
		return *x.LastBlockReportMonotonic
	}
	return Default_DatanodeInfoProto_LastBlockReportMonotonic
}

func (x *DatanodeInfoProto) GetNumBlocks() uint32 {
	if x != nil && x.NumBlocks != nil {
		return *x.NumBlocks
	}
	return Default_DatanodeInfoProto_NumBlocks
}

//*
// Represents a storage available on the datanode
type DatanodeStorageProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StorageUuid *string                            `protobuf:"bytes,1,req,name=storageUuid" json:"storageUuid,omitempty"`
	State       *DatanodeStorageProto_StorageState `protobuf:"varint,2,opt,name=state,enum=hadoop.hdfs.DatanodeStorageProto_StorageState,def=0" json:"state,omitempty"`
	StorageType *StorageTypeProto                  `protobuf:"varint,3,opt,name=storageType,enum=hadoop.hdfs.StorageTypeProto,def=1" json:"storageType,omitempty"`
}

// Default values for DatanodeStorageProto fields.
const (
	Default_DatanodeStorageProto_State       = DatanodeStorageProto_NORMAL
	Default_DatanodeStorageProto_StorageType = StorageTypeProto_DISK
)

func (x *DatanodeStorageProto) Reset() {
	*x = DatanodeStorageProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatanodeStorageProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatanodeStorageProto) ProtoMessage() {}

func (x *DatanodeStorageProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatanodeStorageProto.ProtoReflect.Descriptor instead.
func (*DatanodeStorageProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{7}
}

func (x *DatanodeStorageProto) GetStorageUuid() string {
	if x != nil && x.StorageUuid != nil {
		return *x.StorageUuid
	}
	return ""
}

func (x *DatanodeStorageProto) GetState() DatanodeStorageProto_StorageState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return Default_DatanodeStorageProto_State
}

func (x *DatanodeStorageProto) GetStorageType() StorageTypeProto {
	if x != nil && x.StorageType != nil {
		return *x.StorageType
	}
	return Default_DatanodeStorageProto_StorageType
}

type StorageReportProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Do not use.
	StorageUuid   *string               `protobuf:"bytes,1,req,name=storageUuid" json:"storageUuid,omitempty"`
	Failed        *bool                 `protobuf:"varint,2,opt,name=failed,def=0" json:"failed,omitempty"`
	Capacity      *uint64               `protobuf:"varint,3,opt,name=capacity,def=0" json:"capacity,omitempty"`
	DfsUsed       *uint64               `protobuf:"varint,4,opt,name=dfsUsed,def=0" json:"dfsUsed,omitempty"`
	Remaining     *uint64               `protobuf:"varint,5,opt,name=remaining,def=0" json:"remaining,omitempty"`
	BlockPoolUsed *uint64               `protobuf:"varint,6,opt,name=blockPoolUsed,def=0" json:"blockPoolUsed,omitempty"`
	Storage       *DatanodeStorageProto `protobuf:"bytes,7,opt,name=storage" json:"storage,omitempty"` // supersedes StorageUuid
	NonDfsUsed    *uint64               `protobuf:"varint,8,opt,name=nonDfsUsed" json:"nonDfsUsed,omitempty"`
}

// Default values for StorageReportProto fields.
const (
	Default_StorageReportProto_Failed        = bool(false)
	Default_StorageReportProto_Capacity      = uint64(0)
	Default_StorageReportProto_DfsUsed       = uint64(0)
	Default_StorageReportProto_Remaining     = uint64(0)
	Default_StorageReportProto_BlockPoolUsed = uint64(0)
)

func (x *StorageReportProto) Reset() {
	*x = StorageReportProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageReportProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageReportProto) ProtoMessage() {}

func (x *StorageReportProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageReportProto.ProtoReflect.Descriptor instead.
func (*StorageReportProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{8}
}

// Deprecated: Do not use.
func (x *StorageReportProto) GetStorageUuid() string {
	if x != nil && x.StorageUuid != nil {
		return *x.StorageUuid
	}
	return ""
}

func (x *StorageReportProto) GetFailed() bool {
	if x != nil && x.Failed != nil {
		return *x.Failed
	}
	return Default_StorageReportProto_Failed
}

func (x *StorageReportProto) GetCapacity() uint64 {
	if x != nil && x.Capacity != nil {
		return *x.Capacity
	}
	return Default_StorageReportProto_Capacity
}

func (x *StorageReportProto) GetDfsUsed() uint64 {
	if x != nil && x.DfsUsed != nil {
		return *x.DfsUsed
	}
	return Default_StorageReportProto_DfsUsed
}

func (x *StorageReportProto) GetRemaining() uint64 {
	if x != nil && x.Remaining != nil {
		return *x.Remaining
	}
	return Default_StorageReportProto_Remaining
}

func (x *StorageReportProto) GetBlockPoolUsed() uint64 {
	if x != nil && x.BlockPoolUsed != nil {
		return *x.BlockPoolUsed
	}
	return Default_StorageReportProto_BlockPoolUsed
}

func (x *StorageReportProto) GetStorage() *DatanodeStorageProto {
	if x != nil {
		return x.Storage
	}
	return nil
}

func (x *StorageReportProto) GetNonDfsUsed() uint64 {
	if x != nil && x.NonDfsUsed != nil {
		return *x.NonDfsUsed
	}
	return 0
}

//*
// Summary of a file or directory
type ContentSummaryProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Length                 *uint64                     `protobuf:"varint,1,req,name=length" json:"length,omitempty"`
	FileCount              *uint64                     `protobuf:"varint,2,req,name=fileCount" json:"fileCount,omitempty"`
	DirectoryCount         *uint64                     `protobuf:"varint,3,req,name=directoryCount" json:"directoryCount,omitempty"`
	Quota                  *uint64                     `protobuf:"varint,4,req,name=quota" json:"quota,omitempty"`
	SpaceConsumed          *uint64                     `protobuf:"varint,5,req,name=spaceConsumed" json:"spaceConsumed,omitempty"`
	SpaceQuota             *uint64                     `protobuf:"varint,6,req,name=spaceQuota" json:"spaceQuota,omitempty"`
	TypeQuotaInfos         *StorageTypeQuotaInfosProto `protobuf:"bytes,7,opt,name=typeQuotaInfos" json:"typeQuotaInfos,omitempty"`
	SnapshotLength         *uint64                     `protobuf:"varint,8,opt,name=snapshotLength" json:"snapshotLength,omitempty"`
	SnapshotFileCount      *uint64                     `protobuf:"varint,9,opt,name=snapshotFileCount" json:"snapshotFileCount,omitempty"`
	SnapshotDirectoryCount *uint64                     `protobuf:"varint,10,opt,name=snapshotDirectoryCount" json:"snapshotDirectoryCount,omitempty"`
	SnapshotSpaceConsumed  *uint64                     `protobuf:"varint,11,opt,name=snapshotSpaceConsumed" json:"snapshotSpaceConsumed,omitempty"`
	ErasureCodingPolicy    *string                     `protobuf:"bytes,12,opt,name=erasureCodingPolicy" json:"erasureCodingPolicy,omitempty"`
}

func (x *ContentSummaryProto) Reset() {
	*x = ContentSummaryProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentSummaryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentSummaryProto) ProtoMessage() {}

func (x *ContentSummaryProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentSummaryProto.ProtoReflect.Descriptor instead.
func (*ContentSummaryProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{9}
}

func (x *ContentSummaryProto) GetLength() uint64 {
	if x != nil && x.Length != nil {
		return *x.Length
	}
	return 0
}

func (x *ContentSummaryProto) GetFileCount() uint64 {
	if x != nil && x.FileCount != nil {
		return *x.FileCount
	}
	return 0
}

func (x *ContentSummaryProto) GetDirectoryCount() uint64 {
	if x != nil && x.DirectoryCount != nil {
		return *x.DirectoryCount
	}
	return 0
}

func (x *ContentSummaryProto) GetQuota() uint64 {
	if x != nil && x.Quota != nil {
		return *x.Quota
	}
	return 0
}

func (x *ContentSummaryProto) GetSpaceConsumed() uint64 {
	if x != nil && x.SpaceConsumed != nil {
		return *x.SpaceConsumed
	}
	return 0
}

func (x *ContentSummaryProto) GetSpaceQuota() uint64 {
	if x != nil && x.SpaceQuota != nil {
		return *x.SpaceQuota
	}
	return 0
}

func (x *ContentSummaryProto) GetTypeQuotaInfos() *StorageTypeQuotaInfosProto {
	if x != nil {
		return x.TypeQuotaInfos
	}
	return nil
}

func (x *ContentSummaryProto) GetSnapshotLength() uint64 {
	if x != nil && x.SnapshotLength != nil {
		return *x.SnapshotLength
	}
	return 0
}

func (x *ContentSummaryProto) GetSnapshotFileCount() uint64 {
	if x != nil && x.SnapshotFileCount != nil {
		return *x.SnapshotFileCount
	}
	return 0
}

func (x *ContentSummaryProto) GetSnapshotDirectoryCount() uint64 {
	if x != nil && x.SnapshotDirectoryCount != nil {
		return *x.SnapshotDirectoryCount
	}
	return 0
}

func (x *ContentSummaryProto) GetSnapshotSpaceConsumed() uint64 {
	if x != nil && x.SnapshotSpaceConsumed != nil {
		return *x.SnapshotSpaceConsumed
	}
	return 0
}

func (x *ContentSummaryProto) GetErasureCodingPolicy() string {
	if x != nil && x.ErasureCodingPolicy != nil {
		return *x.ErasureCodingPolicy
	}
	return ""
}

//*
// Summary of quota usage of a directory
type QuotaUsageProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FileAndDirectoryCount *uint64                     `protobuf:"varint,1,req,name=fileAndDirectoryCount" json:"fileAndDirectoryCount,omitempty"`
	Quota                 *uint64                     `protobuf:"varint,2,req,name=quota" json:"quota,omitempty"`
	SpaceConsumed         *uint64                     `protobuf:"varint,3,req,name=spaceConsumed" json:"spaceConsumed,omitempty"`
	SpaceQuota            *uint64                     `protobuf:"varint,4,req,name=spaceQuota" json:"spaceQuota,omitempty"`
	TypeQuotaInfos        *StorageTypeQuotaInfosProto `protobuf:"bytes,5,opt,name=typeQuotaInfos" json:"typeQuotaInfos,omitempty"`
}

func (x *QuotaUsageProto) Reset() {
	*x = QuotaUsageProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuotaUsageProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaUsageProto) ProtoMessage() {}

func (x *QuotaUsageProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaUsageProto.ProtoReflect.Descriptor instead.
func (*QuotaUsageProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{10}
}

func (x *QuotaUsageProto) GetFileAndDirectoryCount() uint64 {
	if x != nil && x.FileAndDirectoryCount != nil {
		return *x.FileAndDirectoryCount
	}
	return 0
}

func (x *QuotaUsageProto) GetQuota() uint64 {
	if x != nil && x.Quota != nil {
		return *x.Quota
	}
	return 0
}

func (x *QuotaUsageProto) GetSpaceConsumed() uint64 {
	if x != nil && x.SpaceConsumed != nil {
		return *x.SpaceConsumed
	}
	return 0
}

func (x *QuotaUsageProto) GetSpaceQuota() uint64 {
	if x != nil && x.SpaceQuota != nil {
		return *x.SpaceQuota
	}
	return 0
}

func (x *QuotaUsageProto) GetTypeQuotaInfos() *StorageTypeQuotaInfosProto {
	if x != nil {
		return x.TypeQuotaInfos
	}
	return nil
}

//*
// Storage type quota and usage information of a file or directory
type StorageTypeQuotaInfosProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TypeQuotaInfo []*StorageTypeQuotaInfoProto `protobuf:"bytes,1,rep,name=typeQuotaInfo" json:"typeQuotaInfo,omitempty"`
}

func (x *StorageTypeQuotaInfosProto) Reset() {
	*x = StorageTypeQuotaInfosProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageTypeQuotaInfosProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageTypeQuotaInfosProto) ProtoMessage() {}

func (x *StorageTypeQuotaInfosProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageTypeQuotaInfosProto.ProtoReflect.Descriptor instead.
func (*StorageTypeQuotaInfosProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{11}
}

func (x *StorageTypeQuotaInfosProto) GetTypeQuotaInfo() []*StorageTypeQuotaInfoProto {
	if x != nil {
		return x.TypeQuotaInfo
	}
	return nil
}

type StorageTypeQuotaInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type     *StorageTypeProto `protobuf:"varint,1,opt,name=type,enum=hadoop.hdfs.StorageTypeProto,def=1" json:"type,omitempty"`
	Quota    *uint64           `protobuf:"varint,2,req,name=quota" json:"quota,omitempty"`
	Consumed *uint64           `protobuf:"varint,3,req,name=consumed" json:"consumed,omitempty"`
}

// Default values for StorageTypeQuotaInfoProto fields.
const (
	Default_StorageTypeQuotaInfoProto_Type = StorageTypeProto_DISK
)

func (x *StorageTypeQuotaInfoProto) Reset() {
	*x = StorageTypeQuotaInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageTypeQuotaInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageTypeQuotaInfoProto) ProtoMessage() {}

func (x *StorageTypeQuotaInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageTypeQuotaInfoProto.ProtoReflect.Descriptor instead.
func (*StorageTypeQuotaInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{12}
}

func (x *StorageTypeQuotaInfoProto) GetType() StorageTypeProto {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return Default_StorageTypeQuotaInfoProto_Type
}

func (x *StorageTypeQuotaInfoProto) GetQuota() uint64 {
	if x != nil && x.Quota != nil {
		return *x.Quota
	}
	return 0
}

func (x *StorageTypeQuotaInfoProto) GetConsumed() uint64 {
	if x != nil && x.Consumed != nil {
		return *x.Consumed
	}
	return 0
}

//*
// Contains a list of paths corresponding to corrupt files and a cookie
// used for iterative calls to NameNode.listCorruptFileBlocks.
//
type CorruptFileBlocksProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Files  []string `protobuf:"bytes,1,rep,name=files" json:"files,omitempty"`
	Cookie *string  `protobuf:"bytes,2,req,name=cookie" json:"cookie,omitempty"`
}

func (x *CorruptFileBlocksProto) Reset() {
	*x = CorruptFileBlocksProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CorruptFileBlocksProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorruptFileBlocksProto) ProtoMessage() {}

func (x *CorruptFileBlocksProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorruptFileBlocksProto.ProtoReflect.Descriptor instead.
func (*CorruptFileBlocksProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{13}
}

func (x *CorruptFileBlocksProto) GetFiles() []string {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *CorruptFileBlocksProto) GetCookie() string {
	if x != nil && x.Cookie != nil {
		return *x.Cookie
	}
	return ""
}

//*
// A list of storage types.
type StorageTypesProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StorageTypes []StorageTypeProto `protobuf:"varint,1,rep,name=storageTypes,enum=hadoop.hdfs.StorageTypeProto" json:"storageTypes,omitempty"`
}

func (x *StorageTypesProto) Reset() {
	*x = StorageTypesProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageTypesProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageTypesProto) ProtoMessage() {}

func (x *StorageTypesProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageTypesProto.ProtoReflect.Descriptor instead.
func (*StorageTypesProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{14}
}

func (x *StorageTypesProto) GetStorageTypes() []StorageTypeProto {
	if x != nil {
		return x.StorageTypes
	}
	return nil
}

//*
// Block replica storage policy.
type BlockStoragePolicyProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PolicyId *uint32 `protobuf:"varint,1,req,name=policyId" json:"policyId,omitempty"`
	Name     *string `protobuf:"bytes,2,req,name=name" json:"name,omitempty"`
	// a list of storage types for storing the block replicas when creating a
	// block.
	CreationPolicy *StorageTypesProto `protobuf:"bytes,3,req,name=creationPolicy" json:"creationPolicy,omitempty"`
	// A list of storage types for creation fallback storage.
	CreationFallbackPolicy    *StorageTypesProto `protobuf:"bytes,4,opt,name=creationFallbackPolicy" json:"creationFallbackPolicy,omitempty"`
	ReplicationFallbackPolicy *StorageTypesProto `protobuf:"bytes,5,opt,name=replicationFallbackPolicy" json:"replicationFallbackPolicy,omitempty"`
}

func (x *BlockStoragePolicyProto) Reset() {
	*x = BlockStoragePolicyProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockStoragePolicyProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockStoragePolicyProto) ProtoMessage() {}

func (x *BlockStoragePolicyProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockStoragePolicyProto.ProtoReflect.Descriptor instead.
func (*BlockStoragePolicyProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{15}
}

func (x *BlockStoragePolicyProto) GetPolicyId() uint32 {
	if x != nil && x.PolicyId != nil {
		return *x.PolicyId
	}
	return 0
}

func (x *BlockStoragePolicyProto) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *BlockStoragePolicyProto) GetCreationPolicy() *StorageTypesProto {
	if x != nil {
		return x.CreationPolicy
	}
	return nil
}

func (x *BlockStoragePolicyProto) GetCreationFallbackPolicy() *StorageTypesProto {
	if x != nil {
		return x.CreationFallbackPolicy
	}
	return nil
}

func (x *BlockStoragePolicyProto) GetReplicationFallbackPolicy() *StorageTypesProto {
	if x != nil {
		return x.ReplicationFallbackPolicy
	}
	return nil
}

//*
// A LocatedBlock gives information about a block and its location.
type LocatedBlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	B            *ExtendedBlockProto       `protobuf:"bytes,1,req,name=b" json:"b,omitempty"`
	Offset       *uint64                   `protobuf:"varint,2,req,name=offset" json:"offset,omitempty"`   // offset of first byte of block in the file
	Locs         []*DatanodeInfoProto      `protobuf:"bytes,3,rep,name=locs" json:"locs,omitempty"`        // Locations ordered by proximity to client ip
	Corrupt      *bool                     `protobuf:"varint,4,req,name=corrupt" json:"corrupt,omitempty"` // true if all replicas of a block are corrupt, else false
	BlockToken   *hadoop_common.TokenProto `protobuf:"bytes,5,req,name=blockToken" json:"blockToken,omitempty"`
	IsCached     []bool                    `protobuf:"varint,6,rep,packed,name=isCached" json:"isCached,omitempty"` // if a location in locs is cached
	StorageTypes []StorageTypeProto        `protobuf:"varint,7,rep,name=storageTypes,enum=hadoop.hdfs.StorageTypeProto" json:"storageTypes,omitempty"`
	StorageIDs   []string                  `protobuf:"bytes,8,rep,name=storageIDs" json:"storageIDs,omitempty"`
	// striped block related fields
	BlockIndices []byte                      `protobuf:"bytes,9,opt,name=blockIndices" json:"blockIndices,omitempty"` // used for striped block to indicate block index for each storage
	BlockTokens  []*hadoop_common.TokenProto `protobuf:"bytes,10,rep,name=blockTokens" json:"blockTokens,omitempty"`  // each internal block has a block token
}

func (x *LocatedBlockProto) Reset() {
	*x = LocatedBlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocatedBlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocatedBlockProto) ProtoMessage() {}

func (x *LocatedBlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocatedBlockProto.ProtoReflect.Descriptor instead.
func (*LocatedBlockProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{16}
}

func (x *LocatedBlockProto) GetB() *ExtendedBlockProto {
	if x != nil {
		return x.B
	}
	return nil
}

func (x *LocatedBlockProto) GetOffset() uint64 {
	if x != nil && x.Offset != nil {
		return *x.Offset
	}
	return 0
}

func (x *LocatedBlockProto) GetLocs() []*DatanodeInfoProto {
	if x != nil {
		return x.Locs
	}
	return nil
}

func (x *LocatedBlockProto) GetCorrupt() bool {
	if x != nil && x.Corrupt != nil {
		return *x.Corrupt
	}
	return false
}

func (x *LocatedBlockProto) GetBlockToken() *hadoop_common.TokenProto {
	if x != nil {
		return x.BlockToken
	}
	return nil
}

func (x *LocatedBlockProto) GetIsCached() []bool {
	if x != nil {
		return x.IsCached
	}
	return nil
}

func (x *LocatedBlockProto) GetStorageTypes() []StorageTypeProto {
	if x != nil {
		return x.StorageTypes
	}
	return nil
}

func (x *LocatedBlockProto) GetStorageIDs() []string {
	if x != nil {
		return x.StorageIDs
	}
	return nil
}

func (x *LocatedBlockProto) GetBlockIndices() []byte {
	if x != nil {
		return x.BlockIndices
	}
	return nil
}

func (x *LocatedBlockProto) GetBlockTokens() []*hadoop_common.TokenProto {
	if x != nil {
		return x.BlockTokens
	}
	return nil
}

type BatchedListingKeyProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Checksum   []byte  `protobuf:"bytes,1,req,name=checksum" json:"checksum,omitempty"`
	PathIndex  *uint32 `protobuf:"varint,2,req,name=pathIndex" json:"pathIndex,omitempty"`
	StartAfter []byte  `protobuf:"bytes,3,req,name=startAfter" json:"startAfter,omitempty"`
}

func (x *BatchedListingKeyProto) Reset() {
	*x = BatchedListingKeyProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchedListingKeyProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchedListingKeyProto) ProtoMessage() {}

func (x *BatchedListingKeyProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchedListingKeyProto.ProtoReflect.Descriptor instead.
func (*BatchedListingKeyProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{17}
}

func (x *BatchedListingKeyProto) GetChecksum() []byte {
	if x != nil {
		return x.Checksum
	}
	return nil
}

func (x *BatchedListingKeyProto) GetPathIndex() uint32 {
	if x != nil && x.PathIndex != nil {
		return *x.PathIndex
	}
	return 0
}

func (x *BatchedListingKeyProto) GetStartAfter() []byte {
	if x != nil {
		return x.StartAfter
	}
	return nil
}

type DataEncryptionKeyProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyId               *uint32 `protobuf:"varint,1,req,name=keyId" json:"keyId,omitempty"`
	BlockPoolId         *string `protobuf:"bytes,2,req,name=blockPoolId" json:"blockPoolId,omitempty"`
	Nonce               []byte  `protobuf:"bytes,3,req,name=nonce" json:"nonce,omitempty"`
	EncryptionKey       []byte  `protobuf:"bytes,4,req,name=encryptionKey" json:"encryptionKey,omitempty"`
	ExpiryDate          *uint64 `protobuf:"varint,5,req,name=expiryDate" json:"expiryDate,omitempty"`
	EncryptionAlgorithm *string `protobuf:"bytes,6,opt,name=encryptionAlgorithm" json:"encryptionAlgorithm,omitempty"`
}

func (x *DataEncryptionKeyProto) Reset() {
	*x = DataEncryptionKeyProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataEncryptionKeyProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataEncryptionKeyProto) ProtoMessage() {}

func (x *DataEncryptionKeyProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataEncryptionKeyProto.ProtoReflect.Descriptor instead.
func (*DataEncryptionKeyProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{18}
}

func (x *DataEncryptionKeyProto) GetKeyId() uint32 {
	if x != nil && x.KeyId != nil {
		return *x.KeyId
	}
	return 0
}

func (x *DataEncryptionKeyProto) GetBlockPoolId() string {
	if x != nil && x.BlockPoolId != nil {
		return *x.BlockPoolId
	}
	return ""
}

func (x *DataEncryptionKeyProto) GetNonce() []byte {
	if x != nil {
		return x.Nonce
	}
	return nil
}

func (x *DataEncryptionKeyProto) GetEncryptionKey() []byte {
	if x != nil {
		return x.EncryptionKey
	}
	return nil
}

func (x *DataEncryptionKeyProto) GetExpiryDate() uint64 {
	if x != nil && x.ExpiryDate != nil {
		return *x.ExpiryDate
	}
	return 0
}

func (x *DataEncryptionKeyProto) GetEncryptionAlgorithm() string {
	if x != nil && x.EncryptionAlgorithm != nil {
		return *x.EncryptionAlgorithm
	}
	return ""
}

//*
// Encryption information for a file.
type FileEncryptionInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Suite                 *CipherSuiteProto           `protobuf:"varint,1,req,name=suite,enum=hadoop.hdfs.CipherSuiteProto" json:"suite,omitempty"`
	CryptoProtocolVersion *CryptoProtocolVersionProto `protobuf:"varint,2,req,name=cryptoProtocolVersion,enum=hadoop.hdfs.CryptoProtocolVersionProto" json:"cryptoProtocolVersion,omitempty"`
	Key                   []byte                      `protobuf:"bytes,3,req,name=key" json:"key,omitempty"`
	Iv                    []byte                      `protobuf:"bytes,4,req,name=iv" json:"iv,omitempty"`
	KeyName               *string                     `protobuf:"bytes,5,req,name=keyName" json:"keyName,omitempty"`
	EzKeyVersionName      *string                     `protobuf:"bytes,6,req,name=ezKeyVersionName" json:"ezKeyVersionName,omitempty"`
}

func (x *FileEncryptionInfoProto) Reset() {
	*x = FileEncryptionInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileEncryptionInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileEncryptionInfoProto) ProtoMessage() {}

func (x *FileEncryptionInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileEncryptionInfoProto.ProtoReflect.Descriptor instead.
func (*FileEncryptionInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{19}
}

func (x *FileEncryptionInfoProto) GetSuite() CipherSuiteProto {
	if x != nil && x.Suite != nil {
		return *x.Suite
	}
	return CipherSuiteProto_UNKNOWN
}

func (x *FileEncryptionInfoProto) GetCryptoProtocolVersion() CryptoProtocolVersionProto {
	if x != nil && x.CryptoProtocolVersion != nil {
		return *x.CryptoProtocolVersion
	}
	return CryptoProtocolVersionProto_UNKNOWN_PROTOCOL_VERSION
}

func (x *FileEncryptionInfoProto) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *FileEncryptionInfoProto) GetIv() []byte {
	if x != nil {
		return x.Iv
	}
	return nil
}

func (x *FileEncryptionInfoProto) GetKeyName() string {
	if x != nil && x.KeyName != nil {
		return *x.KeyName
	}
	return ""
}

func (x *FileEncryptionInfoProto) GetEzKeyVersionName() string {
	if x != nil && x.EzKeyVersionName != nil {
		return *x.EzKeyVersionName
	}
	return ""
}

//*
// Encryption information for an individual
// file within an encryption zone
type PerFileEncryptionInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key              []byte  `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Iv               []byte  `protobuf:"bytes,2,req,name=iv" json:"iv,omitempty"`
	EzKeyVersionName *string `protobuf:"bytes,3,req,name=ezKeyVersionName" json:"ezKeyVersionName,omitempty"`
}

func (x *PerFileEncryptionInfoProto) Reset() {
	*x = PerFileEncryptionInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PerFileEncryptionInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerFileEncryptionInfoProto) ProtoMessage() {}

func (x *PerFileEncryptionInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerFileEncryptionInfoProto.ProtoReflect.Descriptor instead.
func (*PerFileEncryptionInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{20}
}

func (x *PerFileEncryptionInfoProto) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PerFileEncryptionInfoProto) GetIv() []byte {
	if x != nil {
		return x.Iv
	}
	return nil
}

func (x *PerFileEncryptionInfoProto) GetEzKeyVersionName() string {
	if x != nil && x.EzKeyVersionName != nil {
		return *x.EzKeyVersionName
	}
	return ""
}

//*
// Encryption information for an encryption
// zone
type ZoneEncryptionInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Suite                 *CipherSuiteProto           `protobuf:"varint,1,req,name=suite,enum=hadoop.hdfs.CipherSuiteProto" json:"suite,omitempty"`
	CryptoProtocolVersion *CryptoProtocolVersionProto `protobuf:"varint,2,req,name=cryptoProtocolVersion,enum=hadoop.hdfs.CryptoProtocolVersionProto" json:"cryptoProtocolVersion,omitempty"`
	KeyName               *string                     `protobuf:"bytes,3,req,name=keyName" json:"keyName,omitempty"`
	ReencryptionProto     *ReencryptionInfoProto      `protobuf:"bytes,4,opt,name=reencryptionProto" json:"reencryptionProto,omitempty"`
}

func (x *ZoneEncryptionInfoProto) Reset() {
	*x = ZoneEncryptionInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZoneEncryptionInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZoneEncryptionInfoProto) ProtoMessage() {}

func (x *ZoneEncryptionInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZoneEncryptionInfoProto.ProtoReflect.Descriptor instead.
func (*ZoneEncryptionInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{21}
}

func (x *ZoneEncryptionInfoProto) GetSuite() CipherSuiteProto {
	if x != nil && x.Suite != nil {
		return *x.Suite
	}
	return CipherSuiteProto_UNKNOWN
}

func (x *ZoneEncryptionInfoProto) GetCryptoProtocolVersion() CryptoProtocolVersionProto {
	if x != nil && x.CryptoProtocolVersion != nil {
		return *x.CryptoProtocolVersion
	}
	return CryptoProtocolVersionProto_UNKNOWN_PROTOCOL_VERSION
}

func (x *ZoneEncryptionInfoProto) GetKeyName() string {
	if x != nil && x.KeyName != nil {
		return *x.KeyName
	}
	return ""
}

func (x *ZoneEncryptionInfoProto) GetReencryptionProto() *ReencryptionInfoProto {
	if x != nil {
		return x.ReencryptionProto
	}
	return nil
}

//*
// Re-encryption information for an encryption zone
type ReencryptionInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EzKeyVersionName *string `protobuf:"bytes,1,req,name=ezKeyVersionName" json:"ezKeyVersionName,omitempty"`
	SubmissionTime   *uint64 `protobuf:"varint,2,req,name=submissionTime" json:"submissionTime,omitempty"`
	Canceled         *bool   `protobuf:"varint,3,req,name=canceled" json:"canceled,omitempty"`
	NumReencrypted   *int64  `protobuf:"varint,4,req,name=numReencrypted" json:"numReencrypted,omitempty"`
	NumFailures      *int64  `protobuf:"varint,5,req,name=numFailures" json:"numFailures,omitempty"`
	CompletionTime   *uint64 `protobuf:"varint,6,opt,name=completionTime" json:"completionTime,omitempty"`
	LastFile         *string `protobuf:"bytes,7,opt,name=lastFile" json:"lastFile,omitempty"`
}

func (x *ReencryptionInfoProto) Reset() {
	*x = ReencryptionInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReencryptionInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReencryptionInfoProto) ProtoMessage() {}

func (x *ReencryptionInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReencryptionInfoProto.ProtoReflect.Descriptor instead.
func (*ReencryptionInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{22}
}

func (x *ReencryptionInfoProto) GetEzKeyVersionName() string {
	if x != nil && x.EzKeyVersionName != nil {
		return *x.EzKeyVersionName
	}
	return ""
}

func (x *ReencryptionInfoProto) GetSubmissionTime() uint64 {
	if x != nil && x.SubmissionTime != nil {
		return *x.SubmissionTime
	}
	return 0
}

func (x *ReencryptionInfoProto) GetCanceled() bool {
	if x != nil && x.Canceled != nil {
		return *x.Canceled
	}
	return false
}

func (x *ReencryptionInfoProto) GetNumReencrypted() int64 {
	if x != nil && x.NumReencrypted != nil {
		return *x.NumReencrypted
	}
	return 0
}

func (x *ReencryptionInfoProto) GetNumFailures() int64 {
	if x != nil && x.NumFailures != nil {
		return *x.NumFailures
	}
	return 0
}

func (x *ReencryptionInfoProto) GetCompletionTime() uint64 {
	if x != nil && x.CompletionTime != nil {
		return *x.CompletionTime
	}
	return 0
}

func (x *ReencryptionInfoProto) GetLastFile() string {
	if x != nil && x.LastFile != nil {
		return *x.LastFile
	}
	return ""
}

//*
// Cipher option
type CipherOptionProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Suite  *CipherSuiteProto `protobuf:"varint,1,req,name=suite,enum=hadoop.hdfs.CipherSuiteProto" json:"suite,omitempty"`
	InKey  []byte            `protobuf:"bytes,2,opt,name=inKey" json:"inKey,omitempty"`
	InIv   []byte            `protobuf:"bytes,3,opt,name=inIv" json:"inIv,omitempty"`
	OutKey []byte            `protobuf:"bytes,4,opt,name=outKey" json:"outKey,omitempty"`
	OutIv  []byte            `protobuf:"bytes,5,opt,name=outIv" json:"outIv,omitempty"`
}

func (x *CipherOptionProto) Reset() {
	*x = CipherOptionProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CipherOptionProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CipherOptionProto) ProtoMessage() {}

func (x *CipherOptionProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CipherOptionProto.ProtoReflect.Descriptor instead.
func (*CipherOptionProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{23}
}

func (x *CipherOptionProto) GetSuite() CipherSuiteProto {
	if x != nil && x.Suite != nil {
		return *x.Suite
	}
	return CipherSuiteProto_UNKNOWN
}

func (x *CipherOptionProto) GetInKey() []byte {
	if x != nil {
		return x.InKey
	}
	return nil
}

func (x *CipherOptionProto) GetInIv() []byte {
	if x != nil {
		return x.InIv
	}
	return nil
}

func (x *CipherOptionProto) GetOutKey() []byte {
	if x != nil {
		return x.OutKey
	}
	return nil
}

func (x *CipherOptionProto) GetOutIv() []byte {
	if x != nil {
		return x.OutIv
	}
	return nil
}

//*
// A set of file blocks and their locations.
type LocatedBlocksProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FileLength          *uint64                  `protobuf:"varint,1,req,name=fileLength" json:"fileLength,omitempty"`
	Blocks              []*LocatedBlockProto     `protobuf:"bytes,2,rep,name=blocks" json:"blocks,omitempty"`
	UnderConstruction   *bool                    `protobuf:"varint,3,req,name=underConstruction" json:"underConstruction,omitempty"`
	LastBlock           *LocatedBlockProto       `protobuf:"bytes,4,opt,name=lastBlock" json:"lastBlock,omitempty"`
	IsLastBlockComplete *bool                    `protobuf:"varint,5,req,name=isLastBlockComplete" json:"isLastBlockComplete,omitempty"`
	FileEncryptionInfo  *FileEncryptionInfoProto `protobuf:"bytes,6,opt,name=fileEncryptionInfo" json:"fileEncryptionInfo,omitempty"`
	// Optional field for erasure coding
	EcPolicy *ErasureCodingPolicyProto `protobuf:"bytes,7,opt,name=ecPolicy" json:"ecPolicy,omitempty"`
}

func (x *LocatedBlocksProto) Reset() {
	*x = LocatedBlocksProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocatedBlocksProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocatedBlocksProto) ProtoMessage() {}

func (x *LocatedBlocksProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocatedBlocksProto.ProtoReflect.Descriptor instead.
func (*LocatedBlocksProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{24}
}

func (x *LocatedBlocksProto) GetFileLength() uint64 {
	if x != nil && x.FileLength != nil {
		return *x.FileLength
	}
	return 0
}

func (x *LocatedBlocksProto) GetBlocks() []*LocatedBlockProto {
	if x != nil {
		return x.Blocks
	}
	return nil
}

func (x *LocatedBlocksProto) GetUnderConstruction() bool {
	if x != nil && x.UnderConstruction != nil {
		return *x.UnderConstruction
	}
	return false
}

func (x *LocatedBlocksProto) GetLastBlock() *LocatedBlockProto {
	if x != nil {
		return x.LastBlock
	}
	return nil
}

func (x *LocatedBlocksProto) GetIsLastBlockComplete() bool {
	if x != nil && x.IsLastBlockComplete != nil {
		return *x.IsLastBlockComplete
	}
	return false
}

func (x *LocatedBlocksProto) GetFileEncryptionInfo() *FileEncryptionInfoProto {
	if x != nil {
		return x.FileEncryptionInfo
	}
	return nil
}

func (x *LocatedBlocksProto) GetEcPolicy() *ErasureCodingPolicyProto {
	if x != nil {
		return x.EcPolicy
	}
	return nil
}

//*
// ECSchema options entry
type ECSchemaOptionEntryProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
}

func (x *ECSchemaOptionEntryProto) Reset() {
	*x = ECSchemaOptionEntryProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ECSchemaOptionEntryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ECSchemaOptionEntryProto) ProtoMessage() {}

func (x *ECSchemaOptionEntryProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ECSchemaOptionEntryProto.ProtoReflect.Descriptor instead.
func (*ECSchemaOptionEntryProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{25}
}

func (x *ECSchemaOptionEntryProto) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *ECSchemaOptionEntryProto) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

//*
// ECSchema for erasurecoding
type ECSchemaProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CodecName   *string                     `protobuf:"bytes,1,req,name=codecName" json:"codecName,omitempty"`
	DataUnits   *uint32                     `protobuf:"varint,2,req,name=dataUnits" json:"dataUnits,omitempty"`
	ParityUnits *uint32                     `protobuf:"varint,3,req,name=parityUnits" json:"parityUnits,omitempty"`
	Options     []*ECSchemaOptionEntryProto `protobuf:"bytes,4,rep,name=options" json:"options,omitempty"`
}

func (x *ECSchemaProto) Reset() {
	*x = ECSchemaProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ECSchemaProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ECSchemaProto) ProtoMessage() {}

func (x *ECSchemaProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ECSchemaProto.ProtoReflect.Descriptor instead.
func (*ECSchemaProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{26}
}

func (x *ECSchemaProto) GetCodecName() string {
	if x != nil && x.CodecName != nil {
		return *x.CodecName
	}
	return ""
}

func (x *ECSchemaProto) GetDataUnits() uint32 {
	if x != nil && x.DataUnits != nil {
		return *x.DataUnits
	}
	return 0
}

func (x *ECSchemaProto) GetParityUnits() uint32 {
	if x != nil && x.ParityUnits != nil {
		return *x.ParityUnits
	}
	return 0
}

func (x *ECSchemaProto) GetOptions() []*ECSchemaOptionEntryProto {
	if x != nil {
		return x.Options
	}
	return nil
}

type ErasureCodingPolicyProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     *string                   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Schema   *ECSchemaProto            `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
	CellSize *uint32                   `protobuf:"varint,3,opt,name=cellSize" json:"cellSize,omitempty"`
	Id       *uint32                   `protobuf:"varint,4,req,name=id" json:"id,omitempty"` // Actually a byte - only 8 bits used
	State    *ErasureCodingPolicyState `protobuf:"varint,5,opt,name=state,enum=hadoop.hdfs.ErasureCodingPolicyState,def=2" json:"state,omitempty"`
}

// Default values for ErasureCodingPolicyProto fields.
const (
	Default_ErasureCodingPolicyProto_State = ErasureCodingPolicyState_ENABLED
)

func (x *ErasureCodingPolicyProto) Reset() {
	*x = ErasureCodingPolicyProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErasureCodingPolicyProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErasureCodingPolicyProto) ProtoMessage() {}

func (x *ErasureCodingPolicyProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErasureCodingPolicyProto.ProtoReflect.Descriptor instead.
func (*ErasureCodingPolicyProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{27}
}

func (x *ErasureCodingPolicyProto) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *ErasureCodingPolicyProto) GetSchema() *ECSchemaProto {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *ErasureCodingPolicyProto) GetCellSize() uint32 {
	if x != nil && x.CellSize != nil {
		return *x.CellSize
	}
	return 0
}

func (x *ErasureCodingPolicyProto) GetId() uint32 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *ErasureCodingPolicyProto) GetState() ErasureCodingPolicyState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return Default_ErasureCodingPolicyProto_State
}

type AddErasureCodingPolicyResponseProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policy   *ErasureCodingPolicyProto `protobuf:"bytes,1,req,name=policy" json:"policy,omitempty"`
	Succeed  *bool                     `protobuf:"varint,2,req,name=succeed" json:"succeed,omitempty"`
	ErrorMsg *string                   `protobuf:"bytes,3,opt,name=errorMsg" json:"errorMsg,omitempty"`
}

func (x *AddErasureCodingPolicyResponseProto) Reset() {
	*x = AddErasureCodingPolicyResponseProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddErasureCodingPolicyResponseProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddErasureCodingPolicyResponseProto) ProtoMessage() {}

func (x *AddErasureCodingPolicyResponseProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddErasureCodingPolicyResponseProto.ProtoReflect.Descriptor instead.
func (*AddErasureCodingPolicyResponseProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{28}
}

func (x *AddErasureCodingPolicyResponseProto) GetPolicy() *ErasureCodingPolicyProto {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *AddErasureCodingPolicyResponseProto) GetSucceed() bool {
	if x != nil && x.Succeed != nil {
		return *x.Succeed
	}
	return false
}

func (x *AddErasureCodingPolicyResponseProto) GetErrorMsg() string {
	if x != nil && x.ErrorMsg != nil {
		return *x.ErrorMsg
	}
	return ""
}

type ECTopologyVerifierResultProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ResultMessage *string `protobuf:"bytes,1,req,name=resultMessage" json:"resultMessage,omitempty"`
	IsSupported   *bool   `protobuf:"varint,2,req,name=isSupported" json:"isSupported,omitempty"`
}

func (x *ECTopologyVerifierResultProto) Reset() {
	*x = ECTopologyVerifierResultProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ECTopologyVerifierResultProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ECTopologyVerifierResultProto) ProtoMessage() {}

func (x *ECTopologyVerifierResultProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ECTopologyVerifierResultProto.ProtoReflect.Descriptor instead.
func (*ECTopologyVerifierResultProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{29}
}

func (x *ECTopologyVerifierResultProto) GetResultMessage() string {
	if x != nil && x.ResultMessage != nil {
		return *x.ResultMessage
	}
	return ""
}

func (x *ECTopologyVerifierResultProto) GetIsSupported() bool {
	if x != nil && x.IsSupported != nil {
		return *x.IsSupported
	}
	return false
}

//*
// Placeholder type for consistent HDFS operations.
type HdfsPathHandleProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InodeId *uint64 `protobuf:"varint,1,opt,name=inodeId" json:"inodeId,omitempty"`
	Mtime   *uint64 `protobuf:"varint,2,opt,name=mtime" json:"mtime,omitempty"`
	Path    *string `protobuf:"bytes,3,opt,name=path" json:"path,omitempty"`
}

func (x *HdfsPathHandleProto) Reset() {
	*x = HdfsPathHandleProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HdfsPathHandleProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HdfsPathHandleProto) ProtoMessage() {}

func (x *HdfsPathHandleProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HdfsPathHandleProto.ProtoReflect.Descriptor instead.
func (*HdfsPathHandleProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{30}
}

func (x *HdfsPathHandleProto) GetInodeId() uint64 {
	if x != nil && x.InodeId != nil {
		return *x.InodeId
	}
	return 0
}

func (x *HdfsPathHandleProto) GetMtime() uint64 {
	if x != nil && x.Mtime != nil {
		return *x.Mtime
	}
	return 0
}

func (x *HdfsPathHandleProto) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

//*
// Status of a file, directory or symlink
// Optionally includes a file's block locations if requested by client on the rpc call.
type HdfsFileStatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FileType         *HdfsFileStatusProto_FileType `protobuf:"varint,1,req,name=fileType,enum=hadoop.hdfs.HdfsFileStatusProto_FileType" json:"fileType,omitempty"`
	Path             []byte                        `protobuf:"bytes,2,req,name=path" json:"path,omitempty"` // local name of inode encoded java UTF8
	Length           *uint64                       `protobuf:"varint,3,req,name=length" json:"length,omitempty"`
	Permission       *FsPermissionProto            `protobuf:"bytes,4,req,name=permission" json:"permission,omitempty"`
	Owner            *string                       `protobuf:"bytes,5,req,name=owner" json:"owner,omitempty"`
	Group            *string                       `protobuf:"bytes,6,req,name=group" json:"group,omitempty"`
	ModificationTime *uint64                       `protobuf:"varint,7,req,name=modification_time,json=modificationTime" json:"modification_time,omitempty"`
	AccessTime       *uint64                       `protobuf:"varint,8,req,name=access_time,json=accessTime" json:"access_time,omitempty"`
	// Optional fields for symlink
	Symlink []byte `protobuf:"bytes,9,opt,name=symlink" json:"symlink,omitempty"` // if symlink, target encoded java UTF8
	// Optional fields for file
	BlockReplication *uint32             `protobuf:"varint,10,opt,name=block_replication,json=blockReplication,def=0" json:"block_replication,omitempty"` // only 16bits used
	Blocksize        *uint64             `protobuf:"varint,11,opt,name=blocksize,def=0" json:"blocksize,omitempty"`
	Locations        *LocatedBlocksProto `protobuf:"bytes,12,opt,name=locations" json:"locations,omitempty"` // suppled only if asked by client
	// Optional field for fileId
	FileId      *uint64 `protobuf:"varint,13,opt,name=fileId,def=0" json:"fileId,omitempty"` // default as an invalid id
	ChildrenNum *int32  `protobuf:"varint,14,opt,name=childrenNum,def=-1" json:"childrenNum,omitempty"`
	// Optional field for file encryption
	FileEncryptionInfo *FileEncryptionInfoProto `protobuf:"bytes,15,opt,name=fileEncryptionInfo" json:"fileEncryptionInfo,omitempty"`
	StoragePolicy      *uint32                  `protobuf:"varint,16,opt,name=storagePolicy,def=0" json:"storagePolicy,omitempty"` // block storage policy id
	// Optional field for erasure coding
	EcPolicy *ErasureCodingPolicyProto `protobuf:"bytes,17,opt,name=ecPolicy" json:"ecPolicy,omitempty"`
	// Set of flags
	Flags *uint32 `protobuf:"varint,18,opt,name=flags,def=0" json:"flags,omitempty"`
}

// Default values for HdfsFileStatusProto fields.
const (
	Default_HdfsFileStatusProto_BlockReplication = uint32(0)
	Default_HdfsFileStatusProto_Blocksize        = uint64(0)
	Default_HdfsFileStatusProto_FileId           = uint64(0)
	Default_HdfsFileStatusProto_ChildrenNum      = int32(-1)
	Default_HdfsFileStatusProto_StoragePolicy    = uint32(0)
	Default_HdfsFileStatusProto_Flags            = uint32(0)
)

func (x *HdfsFileStatusProto) Reset() {
	*x = HdfsFileStatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HdfsFileStatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HdfsFileStatusProto) ProtoMessage() {}

func (x *HdfsFileStatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HdfsFileStatusProto.ProtoReflect.Descriptor instead.
func (*HdfsFileStatusProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{31}
}

func (x *HdfsFileStatusProto) GetFileType() HdfsFileStatusProto_FileType {
	if x != nil && x.FileType != nil {
		return *x.FileType
	}
	return HdfsFileStatusProto_IS_DIR
}

func (x *HdfsFileStatusProto) GetPath() []byte {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *HdfsFileStatusProto) GetLength() uint64 {
	if x != nil && x.Length != nil {
		return *x.Length
	}
	return 0
}

func (x *HdfsFileStatusProto) GetPermission() *FsPermissionProto {
	if x != nil {
		return x.Permission
	}
	return nil
}

func (x *HdfsFileStatusProto) GetOwner() string {
	if x != nil && x.Owner != nil {
		return *x.Owner
	}
	return ""
}

func (x *HdfsFileStatusProto) GetGroup() string {
	if x != nil && x.Group != nil {
		return *x.Group
	}
	return ""
}

func (x *HdfsFileStatusProto) GetModificationTime() uint64 {
	if x != nil && x.ModificationTime != nil {
		return *x.ModificationTime
	}
	return 0
}

func (x *HdfsFileStatusProto) GetAccessTime() uint64 {
	if x != nil && x.AccessTime != nil {
		return *x.AccessTime
	}
	return 0
}

func (x *HdfsFileStatusProto) GetSymlink() []byte {
	if x != nil {
		return x.Symlink
	}
	return nil
}

func (x *HdfsFileStatusProto) GetBlockReplication() uint32 {
	if x != nil && x.BlockReplication != nil {
		return *x.BlockReplication
	}
	return Default_HdfsFileStatusProto_BlockReplication
}

func (x *HdfsFileStatusProto) GetBlocksize() uint64 {
	if x != nil && x.Blocksize != nil {
		return *x.Blocksize
	}
	return Default_HdfsFileStatusProto_Blocksize
}

func (x *HdfsFileStatusProto) GetLocations() *LocatedBlocksProto {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *HdfsFileStatusProto) GetFileId() uint64 {
	if x != nil && x.FileId != nil {
		return *x.FileId
	}
	return Default_HdfsFileStatusProto_FileId
}

func (x *HdfsFileStatusProto) GetChildrenNum() int32 {
	if x != nil && x.ChildrenNum != nil {
		return *x.ChildrenNum
	}
	return Default_HdfsFileStatusProto_ChildrenNum
}

func (x *HdfsFileStatusProto) GetFileEncryptionInfo() *FileEncryptionInfoProto {
	if x != nil {
		return x.FileEncryptionInfo
	}
	return nil
}

func (x *HdfsFileStatusProto) GetStoragePolicy() uint32 {
	if x != nil && x.StoragePolicy != nil {
		return *x.StoragePolicy
	}
	return Default_HdfsFileStatusProto_StoragePolicy
}

func (x *HdfsFileStatusProto) GetEcPolicy() *ErasureCodingPolicyProto {
	if x != nil {
		return x.EcPolicy
	}
	return nil
}

func (x *HdfsFileStatusProto) GetFlags() uint32 {
	if x != nil && x.Flags != nil {
		return *x.Flags
	}
	return Default_HdfsFileStatusProto_Flags
}

//*
// Algorithms/types denoting how block-level checksums are computed using
// lower-level chunk checksums/CRCs.
// These options should be kept in sync with
// org.apache.hadoop.hdfs.protocol.BlockChecksumOptions.
type BlockChecksumOptionsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BlockChecksumType *BlockChecksumTypeProto `protobuf:"varint,1,opt,name=blockChecksumType,enum=hadoop.hdfs.BlockChecksumTypeProto,def=1" json:"blockChecksumType,omitempty"`
	// Only used if blockChecksumType specifies a striped format, such as
	// COMPOSITE_CRC. If so, then the blockChecksum in the response is expected
	// to be the concatenation of N crcs, where
	// N == ((requestedLength - 1) / stripedLength) + 1
	StripeLength *uint64 `protobuf:"varint,2,opt,name=stripeLength" json:"stripeLength,omitempty"`
}

// Default values for BlockChecksumOptionsProto fields.
const (
	Default_BlockChecksumOptionsProto_BlockChecksumType = BlockChecksumTypeProto_MD5CRC
)

func (x *BlockChecksumOptionsProto) Reset() {
	*x = BlockChecksumOptionsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockChecksumOptionsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockChecksumOptionsProto) ProtoMessage() {}

func (x *BlockChecksumOptionsProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockChecksumOptionsProto.ProtoReflect.Descriptor instead.
func (*BlockChecksumOptionsProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{32}
}

func (x *BlockChecksumOptionsProto) GetBlockChecksumType() BlockChecksumTypeProto {
	if x != nil && x.BlockChecksumType != nil {
		return *x.BlockChecksumType
	}
	return Default_BlockChecksumOptionsProto_BlockChecksumType
}

func (x *BlockChecksumOptionsProto) GetStripeLength() uint64 {
	if x != nil && x.StripeLength != nil {
		return *x.StripeLength
	}
	return 0
}

//*
// HDFS Server Defaults
type FsServerDefaultsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BlockSize           *uint64            `protobuf:"varint,1,req,name=blockSize" json:"blockSize,omitempty"`
	BytesPerChecksum    *uint32            `protobuf:"varint,2,req,name=bytesPerChecksum" json:"bytesPerChecksum,omitempty"`
	WritePacketSize     *uint32            `protobuf:"varint,3,req,name=writePacketSize" json:"writePacketSize,omitempty"`
	Replication         *uint32            `protobuf:"varint,4,req,name=replication" json:"replication,omitempty"` // Actually a short - only 16 bits used
	FileBufferSize      *uint32            `protobuf:"varint,5,req,name=fileBufferSize" json:"fileBufferSize,omitempty"`
	EncryptDataTransfer *bool              `protobuf:"varint,6,opt,name=encryptDataTransfer,def=0" json:"encryptDataTransfer,omitempty"`
	TrashInterval       *uint64            `protobuf:"varint,7,opt,name=trashInterval,def=0" json:"trashInterval,omitempty"`
	ChecksumType        *ChecksumTypeProto `protobuf:"varint,8,opt,name=checksumType,enum=hadoop.hdfs.ChecksumTypeProto,def=1" json:"checksumType,omitempty"`
	KeyProviderUri      *string            `protobuf:"bytes,9,opt,name=keyProviderUri" json:"keyProviderUri,omitempty"`
	PolicyId            *uint32            `protobuf:"varint,10,opt,name=policyId,def=0" json:"policyId,omitempty"`
}

// Default values for FsServerDefaultsProto fields.
const (
	Default_FsServerDefaultsProto_EncryptDataTransfer = bool(false)
	Default_FsServerDefaultsProto_TrashInterval       = uint64(0)
	Default_FsServerDefaultsProto_ChecksumType        = ChecksumTypeProto_CHECKSUM_CRC32
	Default_FsServerDefaultsProto_PolicyId            = uint32(0)
)

func (x *FsServerDefaultsProto) Reset() {
	*x = FsServerDefaultsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FsServerDefaultsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FsServerDefaultsProto) ProtoMessage() {}

func (x *FsServerDefaultsProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FsServerDefaultsProto.ProtoReflect.Descriptor instead.
func (*FsServerDefaultsProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{33}
}

func (x *FsServerDefaultsProto) GetBlockSize() uint64 {
	if x != nil && x.BlockSize != nil {
		return *x.BlockSize
	}
	return 0
}

func (x *FsServerDefaultsProto) GetBytesPerChecksum() uint32 {
	if x != nil && x.BytesPerChecksum != nil {
		return *x.BytesPerChecksum
	}
	return 0
}

func (x *FsServerDefaultsProto) GetWritePacketSize() uint32 {
	if x != nil && x.WritePacketSize != nil {
		return *x.WritePacketSize
	}
	return 0
}

func (x *FsServerDefaultsProto) GetReplication() uint32 {
	if x != nil && x.Replication != nil {
		return *x.Replication
	}
	return 0
}

func (x *FsServerDefaultsProto) GetFileBufferSize() uint32 {
	if x != nil && x.FileBufferSize != nil {
		return *x.FileBufferSize
	}
	return 0
}

func (x *FsServerDefaultsProto) GetEncryptDataTransfer() bool {
	if x != nil && x.EncryptDataTransfer != nil {
		return *x.EncryptDataTransfer
	}
	return Default_FsServerDefaultsProto_EncryptDataTransfer
}

func (x *FsServerDefaultsProto) GetTrashInterval() uint64 {
	if x != nil && x.TrashInterval != nil {
		return *x.TrashInterval
	}
	return Default_FsServerDefaultsProto_TrashInterval
}

func (x *FsServerDefaultsProto) GetChecksumType() ChecksumTypeProto {
	if x != nil && x.ChecksumType != nil {
		return *x.ChecksumType
	}
	return Default_FsServerDefaultsProto_ChecksumType
}

func (x *FsServerDefaultsProto) GetKeyProviderUri() string {
	if x != nil && x.KeyProviderUri != nil {
		return *x.KeyProviderUri
	}
	return ""
}

func (x *FsServerDefaultsProto) GetPolicyId() uint32 {
	if x != nil && x.PolicyId != nil {
		return *x.PolicyId
	}
	return Default_FsServerDefaultsProto_PolicyId
}

//*
// Directory listing
type DirectoryListingProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PartialListing   []*HdfsFileStatusProto `protobuf:"bytes,1,rep,name=partialListing" json:"partialListing,omitempty"`
	RemainingEntries *uint32                `protobuf:"varint,2,req,name=remainingEntries" json:"remainingEntries,omitempty"`
}

func (x *DirectoryListingProto) Reset() {
	*x = DirectoryListingProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectoryListingProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectoryListingProto) ProtoMessage() {}

func (x *DirectoryListingProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectoryListingProto.ProtoReflect.Descriptor instead.
func (*DirectoryListingProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{34}
}

func (x *DirectoryListingProto) GetPartialListing() []*HdfsFileStatusProto {
	if x != nil {
		return x.PartialListing
	}
	return nil
}

func (x *DirectoryListingProto) GetRemainingEntries() uint32 {
	if x != nil && x.RemainingEntries != nil {
		return *x.RemainingEntries
	}
	return 0
}

type RemoteExceptionProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClassName *string `protobuf:"bytes,1,req,name=className" json:"className,omitempty"`
	Message   *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (x *RemoteExceptionProto) Reset() {
	*x = RemoteExceptionProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteExceptionProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteExceptionProto) ProtoMessage() {}

func (x *RemoteExceptionProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteExceptionProto.ProtoReflect.Descriptor instead.
func (*RemoteExceptionProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{35}
}

func (x *RemoteExceptionProto) GetClassName() string {
	if x != nil && x.ClassName != nil {
		return *x.ClassName
	}
	return ""
}

func (x *RemoteExceptionProto) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

// Directory listing result for a batched listing call.
type BatchedDirectoryListingProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PartialListing []*HdfsFileStatusProto `protobuf:"bytes,1,rep,name=partialListing" json:"partialListing,omitempty"`
	ParentIdx      *uint32                `protobuf:"varint,2,req,name=parentIdx" json:"parentIdx,omitempty"`
	Exception      *RemoteExceptionProto  `protobuf:"bytes,3,opt,name=exception" json:"exception,omitempty"`
}

func (x *BatchedDirectoryListingProto) Reset() {
	*x = BatchedDirectoryListingProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchedDirectoryListingProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchedDirectoryListingProto) ProtoMessage() {}

func (x *BatchedDirectoryListingProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchedDirectoryListingProto.ProtoReflect.Descriptor instead.
func (*BatchedDirectoryListingProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{36}
}

func (x *BatchedDirectoryListingProto) GetPartialListing() []*HdfsFileStatusProto {
	if x != nil {
		return x.PartialListing
	}
	return nil
}

func (x *BatchedDirectoryListingProto) GetParentIdx() uint32 {
	if x != nil && x.ParentIdx != nil {
		return *x.ParentIdx
	}
	return 0
}

func (x *BatchedDirectoryListingProto) GetException() *RemoteExceptionProto {
	if x != nil {
		return x.Exception
	}
	return nil
}

//*
// Status of a snapshottable directory: besides the normal information for
// a directory status, also include snapshot quota, number of snapshots, and
// the full path of the parent directory.
type SnapshottableDirectoryStatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DirStatus *HdfsFileStatusProto `protobuf:"bytes,1,req,name=dirStatus" json:"dirStatus,omitempty"`
	// Fields specific for snapshottable directory
	SnapshotQuota  *uint32 `protobuf:"varint,2,req,name=snapshot_quota,json=snapshotQuota" json:"snapshot_quota,omitempty"`
	SnapshotNumber *uint32 `protobuf:"varint,3,req,name=snapshot_number,json=snapshotNumber" json:"snapshot_number,omitempty"`
	ParentFullpath []byte  `protobuf:"bytes,4,req,name=parent_fullpath,json=parentFullpath" json:"parent_fullpath,omitempty"`
}

func (x *SnapshottableDirectoryStatusProto) Reset() {
	*x = SnapshottableDirectoryStatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshottableDirectoryStatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshottableDirectoryStatusProto) ProtoMessage() {}

func (x *SnapshottableDirectoryStatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshottableDirectoryStatusProto.ProtoReflect.Descriptor instead.
func (*SnapshottableDirectoryStatusProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{37}
}

func (x *SnapshottableDirectoryStatusProto) GetDirStatus() *HdfsFileStatusProto {
	if x != nil {
		return x.DirStatus
	}
	return nil
}

func (x *SnapshottableDirectoryStatusProto) GetSnapshotQuota() uint32 {
	if x != nil && x.SnapshotQuota != nil {
		return *x.SnapshotQuota
	}
	return 0
}

func (x *SnapshottableDirectoryStatusProto) GetSnapshotNumber() uint32 {
	if x != nil && x.SnapshotNumber != nil {
		return *x.SnapshotNumber
	}
	return 0
}

func (x *SnapshottableDirectoryStatusProto) GetParentFullpath() []byte {
	if x != nil {
		return x.ParentFullpath
	}
	return nil
}

//*
// Snapshottable directory listing
type SnapshottableDirectoryListingProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshottableDirListing []*SnapshottableDirectoryStatusProto `protobuf:"bytes,1,rep,name=snapshottableDirListing" json:"snapshottableDirListing,omitempty"`
}

func (x *SnapshottableDirectoryListingProto) Reset() {
	*x = SnapshottableDirectoryListingProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshottableDirectoryListingProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshottableDirectoryListingProto) ProtoMessage() {}

func (x *SnapshottableDirectoryListingProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshottableDirectoryListingProto.ProtoReflect.Descriptor instead.
func (*SnapshottableDirectoryListingProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{38}
}

func (x *SnapshottableDirectoryListingProto) GetSnapshottableDirListing() []*SnapshottableDirectoryStatusProto {
	if x != nil {
		return x.SnapshottableDirListing
	}
	return nil
}

//*
// Snapshot diff report entry
type SnapshotDiffReportEntryProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fullpath          []byte  `protobuf:"bytes,1,req,name=fullpath" json:"fullpath,omitempty"`
	ModificationLabel *string `protobuf:"bytes,2,req,name=modificationLabel" json:"modificationLabel,omitempty"`
	TargetPath        []byte  `protobuf:"bytes,3,opt,name=targetPath" json:"targetPath,omitempty"`
}

func (x *SnapshotDiffReportEntryProto) Reset() {
	*x = SnapshotDiffReportEntryProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotDiffReportEntryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotDiffReportEntryProto) ProtoMessage() {}

func (x *SnapshotDiffReportEntryProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotDiffReportEntryProto.ProtoReflect.Descriptor instead.
func (*SnapshotDiffReportEntryProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{39}
}

func (x *SnapshotDiffReportEntryProto) GetFullpath() []byte {
	if x != nil {
		return x.Fullpath
	}
	return nil
}

func (x *SnapshotDiffReportEntryProto) GetModificationLabel() string {
	if x != nil && x.ModificationLabel != nil {
		return *x.ModificationLabel
	}
	return ""
}

func (x *SnapshotDiffReportEntryProto) GetTargetPath() []byte {
	if x != nil {
		return x.TargetPath
	}
	return nil
}

//*
// Snapshot diff report
type SnapshotDiffReportProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// full path of the directory where snapshots were taken
	SnapshotRoot      *string                         `protobuf:"bytes,1,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
	FromSnapshot      *string                         `protobuf:"bytes,2,req,name=fromSnapshot" json:"fromSnapshot,omitempty"`
	ToSnapshot        *string                         `protobuf:"bytes,3,req,name=toSnapshot" json:"toSnapshot,omitempty"`
	DiffReportEntries []*SnapshotDiffReportEntryProto `protobuf:"bytes,4,rep,name=diffReportEntries" json:"diffReportEntries,omitempty"`
}

func (x *SnapshotDiffReportProto) Reset() {
	*x = SnapshotDiffReportProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotDiffReportProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotDiffReportProto) ProtoMessage() {}

func (x *SnapshotDiffReportProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotDiffReportProto.ProtoReflect.Descriptor instead.
func (*SnapshotDiffReportProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{40}
}

func (x *SnapshotDiffReportProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

func (x *SnapshotDiffReportProto) GetFromSnapshot() string {
	if x != nil && x.FromSnapshot != nil {
		return *x.FromSnapshot
	}
	return ""
}

func (x *SnapshotDiffReportProto) GetToSnapshot() string {
	if x != nil && x.ToSnapshot != nil {
		return *x.ToSnapshot
	}
	return ""
}

func (x *SnapshotDiffReportProto) GetDiffReportEntries() []*SnapshotDiffReportEntryProto {
	if x != nil {
		return x.DiffReportEntries
	}
	return nil
}

//*
// Snapshot diff report listing entry
type SnapshotDiffReportListingEntryProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fullpath    []byte  `protobuf:"bytes,1,req,name=fullpath" json:"fullpath,omitempty"`
	DirId       *uint64 `protobuf:"varint,2,req,name=dirId" json:"dirId,omitempty"`
	IsReference *bool   `protobuf:"varint,3,req,name=isReference" json:"isReference,omitempty"`
	TargetPath  []byte  `protobuf:"bytes,4,opt,name=targetPath" json:"targetPath,omitempty"`
	FileId      *uint64 `protobuf:"varint,5,opt,name=fileId" json:"fileId,omitempty"`
}

func (x *SnapshotDiffReportListingEntryProto) Reset() {
	*x = SnapshotDiffReportListingEntryProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotDiffReportListingEntryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotDiffReportListingEntryProto) ProtoMessage() {}

func (x *SnapshotDiffReportListingEntryProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotDiffReportListingEntryProto.ProtoReflect.Descriptor instead.
func (*SnapshotDiffReportListingEntryProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{41}
}

func (x *SnapshotDiffReportListingEntryProto) GetFullpath() []byte {
	if x != nil {
		return x.Fullpath
	}
	return nil
}

func (x *SnapshotDiffReportListingEntryProto) GetDirId() uint64 {
	if x != nil && x.DirId != nil {
		return *x.DirId
	}
	return 0
}

func (x *SnapshotDiffReportListingEntryProto) GetIsReference() bool {
	if x != nil && x.IsReference != nil {
		return *x.IsReference
	}
	return false
}

func (x *SnapshotDiffReportListingEntryProto) GetTargetPath() []byte {
	if x != nil {
		return x.TargetPath
	}
	return nil
}

func (x *SnapshotDiffReportListingEntryProto) GetFileId() uint64 {
	if x != nil && x.FileId != nil {
		return *x.FileId
	}
	return 0
}

type SnapshotDiffReportCursorProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartPath []byte `protobuf:"bytes,1,req,name=startPath" json:"startPath,omitempty"`
	Index     *int32 `protobuf:"varint,2,req,name=index,def=-1" json:"index,omitempty"`
}

// Default values for SnapshotDiffReportCursorProto fields.
const (
	Default_SnapshotDiffReportCursorProto_Index = int32(-1)
)

func (x *SnapshotDiffReportCursorProto) Reset() {
	*x = SnapshotDiffReportCursorProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotDiffReportCursorProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotDiffReportCursorProto) ProtoMessage() {}

func (x *SnapshotDiffReportCursorProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotDiffReportCursorProto.ProtoReflect.Descriptor instead.
func (*SnapshotDiffReportCursorProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{42}
}

func (x *SnapshotDiffReportCursorProto) GetStartPath() []byte {
	if x != nil {
		return x.StartPath
	}
	return nil
}

func (x *SnapshotDiffReportCursorProto) GetIndex() int32 {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return Default_SnapshotDiffReportCursorProto_Index
}

//*
// Snapshot diff report listing
type SnapshotDiffReportListingProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// full path of the directory where snapshots were taken
	ModifiedEntries []*SnapshotDiffReportListingEntryProto `protobuf:"bytes,1,rep,name=modifiedEntries" json:"modifiedEntries,omitempty"`
	CreatedEntries  []*SnapshotDiffReportListingEntryProto `protobuf:"bytes,2,rep,name=createdEntries" json:"createdEntries,omitempty"`
	DeletedEntries  []*SnapshotDiffReportListingEntryProto `protobuf:"bytes,3,rep,name=deletedEntries" json:"deletedEntries,omitempty"`
	IsFromEarlier   *bool                                  `protobuf:"varint,4,req,name=isFromEarlier" json:"isFromEarlier,omitempty"`
	Cursor          *SnapshotDiffReportCursorProto         `protobuf:"bytes,5,opt,name=cursor" json:"cursor,omitempty"`
}

func (x *SnapshotDiffReportListingProto) Reset() {
	*x = SnapshotDiffReportListingProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotDiffReportListingProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotDiffReportListingProto) ProtoMessage() {}

func (x *SnapshotDiffReportListingProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotDiffReportListingProto.ProtoReflect.Descriptor instead.
func (*SnapshotDiffReportListingProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{43}
}

func (x *SnapshotDiffReportListingProto) GetModifiedEntries() []*SnapshotDiffReportListingEntryProto {
	if x != nil {
		return x.ModifiedEntries
	}
	return nil
}

func (x *SnapshotDiffReportListingProto) GetCreatedEntries() []*SnapshotDiffReportListingEntryProto {
	if x != nil {
		return x.CreatedEntries
	}
	return nil
}

func (x *SnapshotDiffReportListingProto) GetDeletedEntries() []*SnapshotDiffReportListingEntryProto {
	if x != nil {
		return x.DeletedEntries
	}
	return nil
}

func (x *SnapshotDiffReportListingProto) GetIsFromEarlier() bool {
	if x != nil && x.IsFromEarlier != nil {
		return *x.IsFromEarlier
	}
	return false
}

func (x *SnapshotDiffReportListingProto) GetCursor() *SnapshotDiffReportCursorProto {
	if x != nil {
		return x.Cursor
	}
	return nil
}

//*
// Block information
//
// Please be wary of adding additional fields here, since INodeFiles
// need to fit in PB's default max message size of 64MB.
// We restrict the max # of blocks per file
// (dfs.namenode.fs-limits.max-blocks-per-file), but it's better
// to avoid changing this.
type BlockProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BlockId  *uint64 `protobuf:"varint,1,req,name=blockId" json:"blockId,omitempty"`
	GenStamp *uint64 `protobuf:"varint,2,req,name=genStamp" json:"genStamp,omitempty"`
	NumBytes *uint64 `protobuf:"varint,3,opt,name=numBytes,def=0" json:"numBytes,omitempty"`
}

// Default values for BlockProto fields.
const (
	Default_BlockProto_NumBytes = uint64(0)
)

func (x *BlockProto) Reset() {
	*x = BlockProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockProto) ProtoMessage() {}

func (x *BlockProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockProto.ProtoReflect.Descriptor instead.
func (*BlockProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{44}
}

func (x *BlockProto) GetBlockId() uint64 {
	if x != nil && x.BlockId != nil {
		return *x.BlockId
	}
	return 0
}

func (x *BlockProto) GetGenStamp() uint64 {
	if x != nil && x.GenStamp != nil {
		return *x.GenStamp
	}
	return 0
}

func (x *BlockProto) GetNumBytes() uint64 {
	if x != nil && x.NumBytes != nil {
		return *x.NumBytes
	}
	return Default_BlockProto_NumBytes
}

//*
// Information related to a snapshot
// TODO: add more information
type SnapshotInfoProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SnapshotName *string            `protobuf:"bytes,1,req,name=snapshotName" json:"snapshotName,omitempty"`
	SnapshotRoot *string            `protobuf:"bytes,2,req,name=snapshotRoot" json:"snapshotRoot,omitempty"`
	Permission   *FsPermissionProto `protobuf:"bytes,3,req,name=permission" json:"permission,omitempty"`
	Owner        *string            `protobuf:"bytes,4,req,name=owner" json:"owner,omitempty"`
	Group        *string            `protobuf:"bytes,5,req,name=group" json:"group,omitempty"`
	CreateTime   *string            `protobuf:"bytes,6,req,name=createTime" json:"createTime,omitempty"` // TODO: do we need access time?
}

func (x *SnapshotInfoProto) Reset() {
	*x = SnapshotInfoProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SnapshotInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SnapshotInfoProto) ProtoMessage() {}

func (x *SnapshotInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SnapshotInfoProto.ProtoReflect.Descriptor instead.
func (*SnapshotInfoProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{45}
}

func (x *SnapshotInfoProto) GetSnapshotName() string {
	if x != nil && x.SnapshotName != nil {
		return *x.SnapshotName
	}
	return ""
}

func (x *SnapshotInfoProto) GetSnapshotRoot() string {
	if x != nil && x.SnapshotRoot != nil {
		return *x.SnapshotRoot
	}
	return ""
}

func (x *SnapshotInfoProto) GetPermission() *FsPermissionProto {
	if x != nil {
		return x.Permission
	}
	return nil
}

func (x *SnapshotInfoProto) GetOwner() string {
	if x != nil && x.Owner != nil {
		return *x.Owner
	}
	return ""
}

func (x *SnapshotInfoProto) GetGroup() string {
	if x != nil && x.Group != nil {
		return *x.Group
	}
	return ""
}

func (x *SnapshotInfoProto) GetCreateTime() string {
	if x != nil && x.CreateTime != nil {
		return *x.CreateTime
	}
	return ""
}

//*
// Rolling upgrade status
type RollingUpgradeStatusProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BlockPoolId *string `protobuf:"bytes,1,req,name=blockPoolId" json:"blockPoolId,omitempty"`
	Finalized   *bool   `protobuf:"varint,2,opt,name=finalized,def=0" json:"finalized,omitempty"`
}

// Default values for RollingUpgradeStatusProto fields.
const (
	Default_RollingUpgradeStatusProto_Finalized = bool(false)
)

func (x *RollingUpgradeStatusProto) Reset() {
	*x = RollingUpgradeStatusProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RollingUpgradeStatusProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollingUpgradeStatusProto) ProtoMessage() {}

func (x *RollingUpgradeStatusProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollingUpgradeStatusProto.ProtoReflect.Descriptor instead.
func (*RollingUpgradeStatusProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{46}
}

func (x *RollingUpgradeStatusProto) GetBlockPoolId() string {
	if x != nil && x.BlockPoolId != nil {
		return *x.BlockPoolId
	}
	return ""
}

func (x *RollingUpgradeStatusProto) GetFinalized() bool {
	if x != nil && x.Finalized != nil {
		return *x.Finalized
	}
	return Default_RollingUpgradeStatusProto_Finalized
}

//*
// A list of storage IDs.
type StorageUuidsProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StorageUuids []string `protobuf:"bytes,1,rep,name=storageUuids" json:"storageUuids,omitempty"`
}

func (x *StorageUuidsProto) Reset() {
	*x = StorageUuidsProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageUuidsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageUuidsProto) ProtoMessage() {}

func (x *StorageUuidsProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageUuidsProto.ProtoReflect.Descriptor instead.
func (*StorageUuidsProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{47}
}

func (x *StorageUuidsProto) GetStorageUuids() []string {
	if x != nil {
		return x.StorageUuids
	}
	return nil
}

//*
// Secret information for the BlockKeyProto. This is not sent on the wire as
// such but is used to pack a byte array and encrypted and put in
// BlockKeyProto.bytes
// When adding further fields, make sure they are optional as they would
// otherwise not be backwards compatible.
//
// Note: As part of the migration from WritableUtils based tokens (aka "legacy")
// to Protocol Buffers, we use the first byte to determine the type. If the
// first byte is <=0 then it is a legacy token. This means that when using
// protobuf tokens, the the first field sent must have a `field_number` less
// than 16 to make sure that the first byte is positive. Otherwise it could be
// parsed as a legacy token. See HDFS-11026 for more discussion.
type BlockTokenSecretProto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ExpiryDate      *uint64            `protobuf:"varint,1,opt,name=expiryDate" json:"expiryDate,omitempty"`
	KeyId           *uint32            `protobuf:"varint,2,opt,name=keyId" json:"keyId,omitempty"`
	UserId          *string            `protobuf:"bytes,3,opt,name=userId" json:"userId,omitempty"`
	BlockPoolId     *string            `protobuf:"bytes,4,opt,name=blockPoolId" json:"blockPoolId,omitempty"`
	BlockId         *uint64            `protobuf:"varint,5,opt,name=blockId" json:"blockId,omitempty"`
	Modes           []AccessModeProto  `protobuf:"varint,6,rep,name=modes,enum=hadoop.hdfs.AccessModeProto" json:"modes,omitempty"`
	StorageTypes    []StorageTypeProto `protobuf:"varint,7,rep,name=storageTypes,enum=hadoop.hdfs.StorageTypeProto" json:"storageTypes,omitempty"`
	StorageIds      []string           `protobuf:"bytes,8,rep,name=storageIds" json:"storageIds,omitempty"`
	HandshakeSecret []byte             `protobuf:"bytes,9,opt,name=handshakeSecret" json:"handshakeSecret,omitempty"`
}

func (x *BlockTokenSecretProto) Reset() {
	*x = BlockTokenSecretProto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_hdfs_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlockTokenSecretProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlockTokenSecretProto) ProtoMessage() {}

func (x *BlockTokenSecretProto) ProtoReflect() protoreflect.Message {
	mi := &file_hdfs_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlockTokenSecretProto.ProtoReflect.Descriptor instead.
func (*BlockTokenSecretProto) Descriptor() ([]byte, []int) {
	return file_hdfs_proto_rawDescGZIP(), []int{48}
}

func (x *BlockTokenSecretProto) GetExpiryDate() uint64 {
	if x != nil && x.ExpiryDate != nil {
		return *x.ExpiryDate
	}
	return 0
}

func (x *BlockTokenSecretProto) GetKeyId() uint32 {
	if x != nil && x.KeyId != nil {
		return *x.KeyId
	}
	return 0
}

func (x *BlockTokenSecretProto) GetUserId() string {
	if x != nil && x.UserId != nil {
		return *x.UserId
	}
	return ""
}

func (x *BlockTokenSecretProto) GetBlockPoolId() string {
	if x != nil && x.BlockPoolId != nil {
		return *x.BlockPoolId
	}
	return ""
}

func (x *BlockTokenSecretProto) GetBlockId() uint64 {
	if x != nil && x.BlockId != nil {
		return *x.BlockId
	}
	return 0
}

func (x *BlockTokenSecretProto) GetModes() []AccessModeProto {
	if x != nil {
		return x.Modes
	}
	return nil
}

func (x *BlockTokenSecretProto) GetStorageTypes() []StorageTypeProto {
	if x != nil {
		return x.StorageTypes
	}
	return nil
}

func (x *BlockTokenSecretProto) GetStorageIds() []string {
	if x != nil {
		return x.StorageIds
	}
	return nil
}

func (x *BlockTokenSecretProto) GetHandshakeSecret() []byte {
	if x != nil {
		return x.HandshakeSecret
	}
	return nil
}

var File_hdfs_proto protoreflect.FileDescriptor

var file_hdfs_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x1a, 0x0e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x09, 0x61, 0x63, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8f, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65,
	0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6f,
	0x6c, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1d, 0x0a, 0x08, 0x6e, 0x75, 0x6d, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x08, 0x6e, 0x75,
	0x6d, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x78, 0x0a, 0x1c, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x03, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f,
	0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x22, 0xe6, 0x01, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x12, 0x1a, 0x0a, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61,
	0x6e, 0x6f, 0x64, 0x65, 0x55, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c,
	0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x55, 0x75, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x78, 0x66, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x08,
	0x78, 0x66, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x66, 0x6f,
	0x50, 0x6f, 0x72, 0x74, 0x18, 0x05, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x70, 0x63, 0x50, 0x6f, 0x72, 0x74, 0x18,
	0x06, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x07, 0x69, 0x70, 0x63, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x29,
	0x0a, 0x0e, 0x69, 0x6e, 0x66, 0x6f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x72, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30, 0x52, 0x0e, 0x69, 0x6e, 0x66, 0x6f, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x22, 0x80, 0x01, 0x0a, 0x16, 0x44, 0x61,
	0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x0a, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0f, 0x73,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x06, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xaa, 0x02, 0x0a,
	0x17, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x3f, 0x0a, 0x0b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x75, 0x73, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x09, 0x75, 0x73, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x66,
	0x72, 0x65, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09,
	0x66, 0x72, 0x65, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x0d, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x3a, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x46, 0x6f, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x06, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x18, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x46, 0x6f, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x6e,
	0x75, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x07, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09,
	0x6e, 0x75, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x52, 0x0a, 0x12, 0x44, 0x61, 0x74,
	0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x3c, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x22, 0xd3, 0x06,
	0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x2c, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x44, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x1d, 0x0a, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x12, 0x1b, 0x0a, 0x07, 0x64, 0x66, 0x73, 0x55, 0x73, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x3a, 0x01, 0x30, 0x52, 0x07, 0x64, 0x66, 0x73, 0x55, 0x73, 0x65, 0x64, 0x12, 0x1f, 0x0a,
	0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x27,
	0x0a, 0x0d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50,
	0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0a,
	0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x78, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d,
	0x3a, 0x01, 0x30, 0x52, 0x0c, 0x78, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a,
	0x0a, 0x6e, 0x6f, 0x6e, 0x44, 0x66, 0x73, 0x55, 0x73, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0a, 0x6e, 0x6f, 0x6e, 0x44, 0x66, 0x73, 0x55, 0x73, 0x65, 0x64, 0x12, 0x51, 0x0a,
	0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x06, 0x4e, 0x4f,
	0x52, 0x4d, 0x41, 0x4c, 0x52, 0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x27, 0x0a, 0x0d, 0x63, 0x61, 0x63, 0x68, 0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x63, 0x61, 0x63, 0x68,
	0x65, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x09, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x55, 0x73, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x09, 0x63, 0x61, 0x63, 0x68, 0x65, 0x55, 0x73, 0x65, 0x64, 0x12, 0x33, 0x0a, 0x13, 0x6c, 0x61,
	0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x69,
	0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x13, 0x6c, 0x61, 0x73, 0x74,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x12,
	0x24, 0x0a, 0x0d, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x33, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x18, 0x6c, 0x61,
	0x73, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x6e,
	0x6f, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x18, 0x10, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x18, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x4d, 0x6f, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x12, 0x1f, 0x0a, 0x09, 0x6e, 0x75, 0x6d,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30, 0x52,
	0x09, 0x6e, 0x75, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x77, 0x0a, 0x0a, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d,
	0x41, 0x4c, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10,
	0x01, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x45, 0x44, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x49, 0x4e,
	0x47, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x04, 0x22, 0xff, 0x01, 0x0a, 0x14, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x0a, 0x0b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x12, 0x4c,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x6e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x06, 0x4e,
	0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x45, 0x0a, 0x0b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x3a, 0x04, 0x44, 0x49, 0x53, 0x4b, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x22, 0x30, 0x0a, 0x0c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x5f, 0x53, 0x48, 0x41,
	0x52, 0x45, 0x44, 0x10, 0x01, 0x22, 0xbc, 0x02, 0x0a, 0x12, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x0a, 0x0b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75,
	0x69, 0x64, 0x12, 0x1d, 0x0a, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x06, 0x66, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x12, 0x1d, 0x0a, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x12, 0x1b, 0x0a, 0x07, 0x64, 0x66, 0x73, 0x55, 0x73, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x04, 0x3a, 0x01, 0x30, 0x52, 0x07, 0x64, 0x66, 0x73, 0x55, 0x73, 0x65, 0x64, 0x12, 0x1f, 0x0a,
	0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04,
	0x3a, 0x01, 0x30, 0x52, 0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x27,
	0x0a, 0x0d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x0d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50,
	0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x64, 0x12, 0x3b, 0x0a, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x6e, 0x6f, 0x64, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x6e, 0x6f, 0x6e, 0x44, 0x66, 0x73, 0x55, 0x73,
	0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x6e, 0x6f, 0x6e, 0x44, 0x66, 0x73,
	0x55, 0x73, 0x65, 0x64, 0x22, 0x96, 0x04, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x0a, 0x06,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x06, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0e, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0e, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x12, 0x24, 0x0a, 0x0d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x64, 0x18, 0x05, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x70, 0x61, 0x63, 0x65, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x18, 0x06, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x4f, 0x0a, 0x0e, 0x74, 0x79, 0x70, 0x65, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66,
	0x6f, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x74, 0x79, 0x70, 0x65, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0e, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12,
	0x2c, 0x0a, 0x11, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36, 0x0a,
	0x16, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x16, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x15, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x15, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x13, 0x65,
	0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65, 0x72, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xf4, 0x01,
	0x0a, 0x0f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x34, 0x0a, 0x15, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x6e, 0x64, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x15, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x6e, 0x64, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x24, 0x0a,
	0x0d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x0d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x70, 0x61, 0x63, 0x65, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x18, 0x04, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x73, 0x70, 0x61, 0x63, 0x65, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x12, 0x4f, 0x0a, 0x0e, 0x74, 0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x74, 0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x6f, 0x73, 0x22, 0x6a, 0x0a, 0x1a, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x4c, 0x0a, 0x0d, 0x74, 0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x0d, 0x74, 0x79, 0x70, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f,
	0x22, 0x86, 0x01, 0x0a, 0x19, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x37,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x04, 0x44, 0x49, 0x53,
	0x4b, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x03, 0x20, 0x02, 0x28, 0x04, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x22, 0x46, 0x0a, 0x16, 0x43, 0x6f, 0x72,
	0x72, 0x75, 0x70, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69,
	0x65, 0x22, 0x56, 0x0a, 0x11, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x41, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xc7, 0x02, 0x0a, 0x17, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49,
	0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x56, 0x0a,
	0x16, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x16, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5c, 0x0a, 0x19, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x19, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0xc7, 0x03, 0x0a, 0x11, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x0a, 0x01, 0x62, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x01, 0x62, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x12, 0x32, 0x0a, 0x04, 0x6c, 0x6f, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x04,
	0x6c, 0x6f, 0x63, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x12, 0x39,
	0x0a, 0x0a, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x02,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x69, 0x73, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x18, 0x06, 0x20, 0x03, 0x28, 0x08, 0x42, 0x02, 0x10, 0x01, 0x52,
	0x08, 0x69, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64, 0x12, 0x41, 0x0a, 0x0c, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x44, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x44, 0x73, 0x12, 0x22, 0x0a, 0x0c,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x3b, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x22, 0x72, 0x0a,
	0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4b,
	0x65, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x74, 0x68, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x61, 0x74, 0x68, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65,
	0x72, 0x22, 0xde, 0x01, 0x0a, 0x16, 0x44, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x05,
	0x6b, 0x65, 0x79, 0x49, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x05, 0x6b, 0x65, 0x79,
	0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49,
	0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f,
	0x6f, 0x6c, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x02, 0x28, 0x0c, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x02, 0x28,
	0x0c, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65,
	0x12, 0x30, 0x0a, 0x13, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x22, 0x95, 0x02, 0x0a, 0x17, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x33,
	0x0a, 0x05, 0x73, 0x75, 0x69, 0x74, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x1d, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x69, 0x70, 0x68,
	0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x12, 0x5d, 0x0a, 0x15, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x15, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0c, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x76, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0c,
	0x52, 0x02, 0x69, 0x76, 0x12, 0x18, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a,
	0x0a, 0x10, 0x65, 0x7a, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x02, 0x28, 0x09, 0x52, 0x10, 0x65, 0x7a, 0x4b, 0x65, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x1a, 0x50, 0x65,
	0x72, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x76,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x02, 0x69, 0x76, 0x12, 0x2a, 0x0a, 0x10, 0x65, 0x7a,
	0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x10, 0x65, 0x7a, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x99, 0x02, 0x0a, 0x17, 0x5a, 0x6f, 0x6e, 0x65, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x33, 0x0a, 0x05, 0x73, 0x75, 0x69, 0x74, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0e, 0x32, 0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x05, 0x73, 0x75, 0x69, 0x74, 0x65, 0x12, 0x5d, 0x0a, 0x15, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x15, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x50, 0x0a, 0x11, 0x72, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x11, 0x72, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x95, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x0a, 0x10,
	0x65, 0x7a, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x10, 0x65, 0x7a, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04,
	0x52, 0x0e, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x08, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x65, 0x64, 0x12, 0x26, 0x0a, 0x0e,
	0x6e, 0x75, 0x6d, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x18, 0x04,
	0x20, 0x02, 0x28, 0x03, 0x52, 0x0e, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x6e, 0x75, 0x6d, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x05, 0x20, 0x02, 0x28, 0x03, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x11, 0x43,
	0x69, 0x70, 0x68, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x33, 0x0a, 0x05, 0x73, 0x75, 0x69, 0x74, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32,
	0x1d, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x43, 0x69,
	0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05,
	0x73, 0x75, 0x69, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x69,
	0x6e, 0x49, 0x76, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x69, 0x6e, 0x49, 0x76, 0x12,
	0x16, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x06, 0x6f, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x75, 0x74, 0x49, 0x76,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x6f, 0x75, 0x74, 0x49, 0x76, 0x22, 0xa3, 0x03,
	0x0a, 0x12, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x4c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x12, 0x36, 0x0a, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x2c, 0x0a, 0x11,
	0x75, 0x6e, 0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x11, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x09, 0x6c, 0x61,
	0x73, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x6c,
	0x61, 0x73, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x30, 0x0a, 0x13, 0x69, 0x73, 0x4c, 0x61,
	0x73, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x02, 0x28, 0x08, 0x52, 0x13, 0x69, 0x73, 0x4c, 0x61, 0x73, 0x74, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x12, 0x66, 0x69,
	0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x12, 0x66, 0x69,
	0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x41, 0x0a, 0x08, 0x65, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x65, 0x63, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0x42, 0x0a, 0x18, 0x45, 0x43, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xae, 0x01, 0x0a, 0x0d, 0x45, 0x43, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x64,
	0x65, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x55,
	0x6e, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x69, 0x74, 0x79, 0x55,
	0x6e, 0x69, 0x74, 0x73, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x43, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd4, 0x01, 0x0a, 0x18, 0x45, 0x72, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x43, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x65, 0x6c, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x63, 0x65, 0x6c, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f,
	0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x3a,
	0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x9a, 0x01, 0x0a, 0x23, 0x41, 0x64, 0x64, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70,
	0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x73, 0x67, 0x22, 0x67, 0x0a, 0x1d,
	0x45, 0x43, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x69, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x73, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x22, 0x59, 0x0a, 0x13, 0x48, 0x64, 0x66, 0x73, 0x50, 0x61, 0x74,
	0x68, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x0a, 0x07,
	0x69, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x69,
	0x6e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x22, 0x84, 0x07, 0x0a, 0x13, 0x48, 0x64, 0x66, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x45, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x64, 0x66, 0x73, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x02, 0x28, 0x04, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x3e, 0x0a, 0x0a, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52,
	0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x18, 0x05, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x06, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x02,
	0x28, 0x04, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x02, 0x28, 0x04, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x73, 0x79, 0x6d, 0x6c, 0x69, 0x6e, 0x6b, 0x12,
	0x2e, 0x0a, 0x11, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30, 0x52, 0x10, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1f, 0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x69, 0x7a, 0x65,
	0x12, 0x3d, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66,
	0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x19, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x3a,
	0x01, 0x30, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x68,
	0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x4e, 0x75, 0x6d, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x3a,
	0x02, 0x2d, 0x31, 0x52, 0x0b, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x4e, 0x75, 0x6d,
	0x12, 0x54, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x12, 0x66, 0x69, 0x6c, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30,
	0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x41, 0x0a, 0x08, 0x65, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x65, 0x63, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x17, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0d, 0x3a, 0x01, 0x30, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x33, 0x0a, 0x08, 0x46,
	0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x53, 0x5f, 0x44, 0x49,
	0x52, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02,
	0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x53, 0x5f, 0x53, 0x59, 0x4d, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x03,
	0x22, 0x45, 0x0a, 0x05, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x41, 0x53,
	0x5f, 0x41, 0x43, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x41, 0x53, 0x5f, 0x43, 0x52,
	0x59, 0x50, 0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x41, 0x53, 0x5f, 0x45, 0x43, 0x10,
	0x04, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x08, 0x22, 0x9a, 0x01, 0x0a, 0x19, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x59, 0x0a, 0x11, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x23, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x06, 0x4d, 0x44, 0x35, 0x43, 0x52, 0x43, 0x52, 0x11, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x22, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x70, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x70, 0x65, 0x4c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x22, 0xd2, 0x03, 0x0a, 0x15, 0x46, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c,
	0x0a, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x04, 0x52, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x10,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d,
	0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x10, 0x62, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12, 0x28, 0x0a, 0x0f, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28,
	0x0d, 0x52, 0x0f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0e, 0x66, 0x69,
	0x6c, 0x65, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x37, 0x0a, 0x13,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x52, 0x13, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x73, 0x68, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52,
	0x0d, 0x74, 0x72, 0x61, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x52,
	0x0a, 0x0c, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x0e, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x53, 0x55, 0x4d, 0x5f, 0x43,
	0x52, 0x43, 0x33, 0x32, 0x52, 0x0c, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x6b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x55, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6b, 0x65, 0x79, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x55, 0x72, 0x69, 0x12, 0x1d, 0x0a, 0x08, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30, 0x52,
	0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x22, 0x8d, 0x01, 0x0a, 0x15, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x48, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61,
	0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x64, 0x66, 0x73, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a,
	0x10, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x10, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x4e, 0x0a, 0x14, 0x52, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x1c, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x48, 0x0a, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x48, 0x64, 0x66, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x78, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x78, 0x12, 0x3f, 0x0a, 0x09, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68,
	0x64, 0x66, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xdc, 0x01, 0x0a, 0x21, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3e, 0x0a, 0x09, 0x64, 0x69, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x68,
	0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x48, 0x64, 0x66, 0x73, 0x46,
	0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09,
	0x64, 0x69, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x02, 0x20, 0x02, 0x28,
	0x0d, 0x52, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x12, 0x27, 0x0a, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0e, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x02,
	0x28, 0x0c, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x70, 0x61,
	0x74, 0x68, 0x22, 0x8e, 0x01, 0x0a, 0x22, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x68, 0x0a, 0x17, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x4c, 0x69, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x17, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x22, 0x88, 0x01, 0x0a, 0x1c, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68,
	0x12, 0x2c, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x11, 0x6d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1e,
	0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0xda,
	0x01, 0x0a, 0x17, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09,
	0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x22,
	0x0a, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x02,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x72, 0x6f, 0x6d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x18, 0x03, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x57, 0x0a, 0x11, 0x64, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x11, 0x64, 0x69, 0x66, 0x66, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xb1, 0x01, 0x0a, 0x23,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68, 0x12,
	0x14, 0x0a, 0x05, 0x64, 0x69, 0x72, 0x49, 0x64, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52, 0x05,
	0x64, 0x69, 0x72, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x69, 0x73, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x02, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x73, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x50, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22,
	0x57, 0x0a, 0x1d, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x02, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x18,
	0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x02, 0x28, 0x05, 0x3a, 0x02, 0x2d,
	0x31, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x9a, 0x03, 0x0a, 0x1e, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c,
	0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x5a, 0x0a, 0x0f, 0x6d,
	0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64,
	0x66, 0x73, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x58, 0x0a, 0x0e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x64, 0x6f,
	0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x69,
	0x73, 0x46, 0x72, 0x6f, 0x6d, 0x45, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x72, 0x18, 0x04, 0x20, 0x02,
	0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x45, 0x61, 0x72, 0x6c, 0x69, 0x65,
	0x72, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x63,
	0x75, 0x72, 0x73, 0x6f, 0x72, 0x22, 0x61, 0x0a, 0x0a, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x64, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x04, 0x52, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x67, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x02, 0x28, 0x04, 0x52,
	0x08, 0x67, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1d, 0x0a, 0x08, 0x6e, 0x75, 0x6d,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x3a, 0x01, 0x30, 0x52, 0x08,
	0x6e, 0x75, 0x6d, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0xe7, 0x01, 0x0a, 0x11, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22,
	0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x6f,
	0x6f, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x3e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x68, 0x61, 0x64,
	0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x46, 0x73, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x05, 0x20, 0x02, 0x28, 0x09, 0x52, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x62, 0x0a, 0x19, 0x52, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x55, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x3a, 0x05, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x52, 0x09, 0x66, 0x69, 0x6e,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x22, 0x37, 0x0a, 0x11, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x55, 0x75, 0x69, 0x64, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x75, 0x69, 0x64, 0x73, 0x22,
	0xe2, 0x02, 0x0a, 0x15, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6b, 0x65, 0x79,
	0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x49, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1d, 0x2e,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e, 0x68, 0x64, 0x66, 0x73, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x0f, 0x68, 0x61,
	0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0f, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x2a, 0x4e, 0x0a, 0x10, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x49, 0x53, 0x4b,
	0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x53, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x41,
	0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x41, 0x4d, 0x5f,
	0x44, 0x49, 0x53, 0x4b, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44,
	0x45, 0x44, 0x10, 0x05, 0x2a, 0x2d, 0x0a, 0x0e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x79, 0x70,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x47,
	0x55, 0x4f, 0x55, 0x53, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x52, 0x49, 0x50, 0x45,
	0x44, 0x10, 0x01, 0x2a, 0x36, 0x0a, 0x10, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x45, 0x53, 0x5f, 0x43, 0x54, 0x52, 0x5f,
	0x4e, 0x4f, 0x50, 0x41, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x2a, 0x50, 0x0a, 0x1a, 0x43,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e, 0x43, 0x52, 0x59,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x5a, 0x4f, 0x4e, 0x45, 0x53, 0x10, 0x02, 0x2a, 0x42, 0x0a,
	0x18, 0x45, 0x72, 0x61, 0x73, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10,
	0x03, 0x2a, 0x4f, 0x0a, 0x11, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x54, 0x79, 0x70,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x53,
	0x55, 0x4d, 0x5f, 0x4e, 0x55, 0x4c, 0x4c, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x48, 0x45,
	0x43, 0x4b, 0x53, 0x55, 0x4d, 0x5f, 0x43, 0x52, 0x43, 0x33, 0x32, 0x10, 0x01, 0x12, 0x13, 0x0a,
	0x0f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x53, 0x55, 0x4d, 0x5f, 0x43, 0x52, 0x43, 0x33, 0x32, 0x43,
	0x10, 0x02, 0x2a, 0x37, 0x0a, 0x16, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x0a, 0x06,
	0x4d, 0x44, 0x35, 0x43, 0x52, 0x43, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4f, 0x4d, 0x50,
	0x4f, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x43, 0x52, 0x43, 0x10, 0x02, 0x2a, 0x3d, 0x0a, 0x0f, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08,
	0x0a, 0x04, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x57, 0x52, 0x49, 0x54,
	0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x03, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x04, 0x42, 0x72, 0x0a, 0x25, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x2e,
	0x68, 0x64, 0x66, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x42, 0x0a, 0x48, 0x64, 0x66, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x5a,
	0x3a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x6c, 0x69,
	0x6e, 0x6d, 0x61, 0x72, 0x63, 0x2f, 0x68, 0x64, 0x66, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f,
	0x68, 0x61, 0x64, 0x6f, 0x6f, 0x70, 0x5f, 0x68, 0x64, 0x66, 0x73, 0xa0, 0x01, 0x01,
}

var (
	file_hdfs_proto_rawDescOnce sync.Once
	file_hdfs_proto_rawDescData = file_hdfs_proto_rawDesc
)

func file_hdfs_proto_rawDescGZIP() []byte {
	file_hdfs_proto_rawDescOnce.Do(func() {
		file_hdfs_proto_rawDescData = protoimpl.X.CompressGZIP(file_hdfs_proto_rawDescData)
	})
	return file_hdfs_proto_rawDescData
}

var file_hdfs_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_hdfs_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_hdfs_proto_goTypes = []interface{}{
	(StorageTypeProto)(0),                       // 0: hadoop.hdfs.StorageTypeProto
	(BlockTypeProto)(0),                         // 1: hadoop.hdfs.BlockTypeProto
	(CipherSuiteProto)(0),                       // 2: hadoop.hdfs.CipherSuiteProto
	(CryptoProtocolVersionProto)(0),             // 3: hadoop.hdfs.CryptoProtocolVersionProto
	(ErasureCodingPolicyState)(0),               // 4: hadoop.hdfs.ErasureCodingPolicyState
	(ChecksumTypeProto)(0),                      // 5: hadoop.hdfs.ChecksumTypeProto
	(BlockChecksumTypeProto)(0),                 // 6: hadoop.hdfs.BlockChecksumTypeProto
	(AccessModeProto)(0),                        // 7: hadoop.hdfs.AccessModeProto
	(DatanodeInfoProto_AdminState)(0),           // 8: hadoop.hdfs.DatanodeInfoProto.AdminState
	(DatanodeStorageProto_StorageState)(0),      // 9: hadoop.hdfs.DatanodeStorageProto.StorageState
	(HdfsFileStatusProto_FileType)(0),           // 10: hadoop.hdfs.HdfsFileStatusProto.FileType
	(HdfsFileStatusProto_Flags)(0),              // 11: hadoop.hdfs.HdfsFileStatusProto.Flags
	(*ExtendedBlockProto)(nil),                  // 12: hadoop.hdfs.ExtendedBlockProto
	(*ProvidedStorageLocationProto)(nil),        // 13: hadoop.hdfs.ProvidedStorageLocationProto
	(*DatanodeIDProto)(nil),                     // 14: hadoop.hdfs.DatanodeIDProto
	(*DatanodeLocalInfoProto)(nil),              // 15: hadoop.hdfs.DatanodeLocalInfoProto
	(*DatanodeVolumeInfoProto)(nil),             // 16: hadoop.hdfs.DatanodeVolumeInfoProto
	(*DatanodeInfosProto)(nil),                  // 17: hadoop.hdfs.DatanodeInfosProto
	(*DatanodeInfoProto)(nil),                   // 18: hadoop.hdfs.DatanodeInfoProto
	(*DatanodeStorageProto)(nil),                // 19: hadoop.hdfs.DatanodeStorageProto
	(*StorageReportProto)(nil),                  // 20: hadoop.hdfs.StorageReportProto
	(*ContentSummaryProto)(nil),                 // 21: hadoop.hdfs.ContentSummaryProto
	(*QuotaUsageProto)(nil),                     // 22: hadoop.hdfs.QuotaUsageProto
	(*StorageTypeQuotaInfosProto)(nil),          // 23: hadoop.hdfs.StorageTypeQuotaInfosProto
	(*StorageTypeQuotaInfoProto)(nil),           // 24: hadoop.hdfs.StorageTypeQuotaInfoProto
	(*CorruptFileBlocksProto)(nil),              // 25: hadoop.hdfs.CorruptFileBlocksProto
	(*StorageTypesProto)(nil),                   // 26: hadoop.hdfs.StorageTypesProto
	(*BlockStoragePolicyProto)(nil),             // 27: hadoop.hdfs.BlockStoragePolicyProto
	(*LocatedBlockProto)(nil),                   // 28: hadoop.hdfs.LocatedBlockProto
	(*BatchedListingKeyProto)(nil),              // 29: hadoop.hdfs.BatchedListingKeyProto
	(*DataEncryptionKeyProto)(nil),              // 30: hadoop.hdfs.DataEncryptionKeyProto
	(*FileEncryptionInfoProto)(nil),             // 31: hadoop.hdfs.FileEncryptionInfoProto
	(*PerFileEncryptionInfoProto)(nil),          // 32: hadoop.hdfs.PerFileEncryptionInfoProto
	(*ZoneEncryptionInfoProto)(nil),             // 33: hadoop.hdfs.ZoneEncryptionInfoProto
	(*ReencryptionInfoProto)(nil),               // 34: hadoop.hdfs.ReencryptionInfoProto
	(*CipherOptionProto)(nil),                   // 35: hadoop.hdfs.CipherOptionProto
	(*LocatedBlocksProto)(nil),                  // 36: hadoop.hdfs.LocatedBlocksProto
	(*ECSchemaOptionEntryProto)(nil),            // 37: hadoop.hdfs.ECSchemaOptionEntryProto
	(*ECSchemaProto)(nil),                       // 38: hadoop.hdfs.ECSchemaProto
	(*ErasureCodingPolicyProto)(nil),            // 39: hadoop.hdfs.ErasureCodingPolicyProto
	(*AddErasureCodingPolicyResponseProto)(nil), // 40: hadoop.hdfs.AddErasureCodingPolicyResponseProto
	(*ECTopologyVerifierResultProto)(nil),       // 41: hadoop.hdfs.ECTopologyVerifierResultProto
	(*HdfsPathHandleProto)(nil),                 // 42: hadoop.hdfs.HdfsPathHandleProto
	(*HdfsFileStatusProto)(nil),                 // 43: hadoop.hdfs.HdfsFileStatusProto
	(*BlockChecksumOptionsProto)(nil),           // 44: hadoop.hdfs.BlockChecksumOptionsProto
	(*FsServerDefaultsProto)(nil),               // 45: hadoop.hdfs.FsServerDefaultsProto
	(*DirectoryListingProto)(nil),               // 46: hadoop.hdfs.DirectoryListingProto
	(*RemoteExceptionProto)(nil),                // 47: hadoop.hdfs.RemoteExceptionProto
	(*BatchedDirectoryListingProto)(nil),        // 48: hadoop.hdfs.BatchedDirectoryListingProto
	(*SnapshottableDirectoryStatusProto)(nil),   // 49: hadoop.hdfs.SnapshottableDirectoryStatusProto
	(*SnapshottableDirectoryListingProto)(nil),  // 50: hadoop.hdfs.SnapshottableDirectoryListingProto
	(*SnapshotDiffReportEntryProto)(nil),        // 51: hadoop.hdfs.SnapshotDiffReportEntryProto
	(*SnapshotDiffReportProto)(nil),             // 52: hadoop.hdfs.SnapshotDiffReportProto
	(*SnapshotDiffReportListingEntryProto)(nil), // 53: hadoop.hdfs.SnapshotDiffReportListingEntryProto
	(*SnapshotDiffReportCursorProto)(nil),       // 54: hadoop.hdfs.SnapshotDiffReportCursorProto
	(*SnapshotDiffReportListingProto)(nil),      // 55: hadoop.hdfs.SnapshotDiffReportListingProto
	(*BlockProto)(nil),                          // 56: hadoop.hdfs.BlockProto
	(*SnapshotInfoProto)(nil),                   // 57: hadoop.hdfs.SnapshotInfoProto
	(*RollingUpgradeStatusProto)(nil),           // 58: hadoop.hdfs.RollingUpgradeStatusProto
	(*StorageUuidsProto)(nil),                   // 59: hadoop.hdfs.StorageUuidsProto
	(*BlockTokenSecretProto)(nil),               // 60: hadoop.hdfs.BlockTokenSecretProto
	(*hadoop_common.TokenProto)(nil),            // 61: hadoop.common.TokenProto
	(*FsPermissionProto)(nil),                   // 62: hadoop.hdfs.FsPermissionProto
}
var file_hdfs_proto_depIdxs = []int32{
	0,  // 0: hadoop.hdfs.DatanodeVolumeInfoProto.storageType:type_name -> hadoop.hdfs.StorageTypeProto
	18, // 1: hadoop.hdfs.DatanodeInfosProto.datanodes:type_name -> hadoop.hdfs.DatanodeInfoProto
	14, // 2: hadoop.hdfs.DatanodeInfoProto.id:type_name -> hadoop.hdfs.DatanodeIDProto
	8,  // 3: hadoop.hdfs.DatanodeInfoProto.adminState:type_name -> hadoop.hdfs.DatanodeInfoProto.AdminState
	9,  // 4: hadoop.hdfs.DatanodeStorageProto.state:type_name -> hadoop.hdfs.DatanodeStorageProto.StorageState
	0,  // 5: hadoop.hdfs.DatanodeStorageProto.storageType:type_name -> hadoop.hdfs.StorageTypeProto
	19, // 6: hadoop.hdfs.StorageReportProto.storage:type_name -> hadoop.hdfs.DatanodeStorageProto
	23, // 7: hadoop.hdfs.ContentSummaryProto.typeQuotaInfos:type_name -> hadoop.hdfs.StorageTypeQuotaInfosProto
	23, // 8: hadoop.hdfs.QuotaUsageProto.typeQuotaInfos:type_name -> hadoop.hdfs.StorageTypeQuotaInfosProto
	24, // 9: hadoop.hdfs.StorageTypeQuotaInfosProto.typeQuotaInfo:type_name -> hadoop.hdfs.StorageTypeQuotaInfoProto
	0,  // 10: hadoop.hdfs.StorageTypeQuotaInfoProto.type:type_name -> hadoop.hdfs.StorageTypeProto
	0,  // 11: hadoop.hdfs.StorageTypesProto.storageTypes:type_name -> hadoop.hdfs.StorageTypeProto
	26, // 12: hadoop.hdfs.BlockStoragePolicyProto.creationPolicy:type_name -> hadoop.hdfs.StorageTypesProto
	26, // 13: hadoop.hdfs.BlockStoragePolicyProto.creationFallbackPolicy:type_name -> hadoop.hdfs.StorageTypesProto
	26, // 14: hadoop.hdfs.BlockStoragePolicyProto.replicationFallbackPolicy:type_name -> hadoop.hdfs.StorageTypesProto
	12, // 15: hadoop.hdfs.LocatedBlockProto.b:type_name -> hadoop.hdfs.ExtendedBlockProto
	18, // 16: hadoop.hdfs.LocatedBlockProto.locs:type_name -> hadoop.hdfs.DatanodeInfoProto
	61, // 17: hadoop.hdfs.LocatedBlockProto.blockToken:type_name -> hadoop.common.TokenProto
	0,  // 18: hadoop.hdfs.LocatedBlockProto.storageTypes:type_name -> hadoop.hdfs.StorageTypeProto
	61, // 19: hadoop.hdfs.LocatedBlockProto.blockTokens:type_name -> hadoop.common.TokenProto
	2,  // 20: hadoop.hdfs.FileEncryptionInfoProto.suite:type_name -> hadoop.hdfs.CipherSuiteProto
	3,  // 21: hadoop.hdfs.FileEncryptionInfoProto.cryptoProtocolVersion:type_name -> hadoop.hdfs.CryptoProtocolVersionProto
	2,  // 22: hadoop.hdfs.ZoneEncryptionInfoProto.suite:type_name -> hadoop.hdfs.CipherSuiteProto
	3,  // 23: hadoop.hdfs.ZoneEncryptionInfoProto.cryptoProtocolVersion:type_name -> hadoop.hdfs.CryptoProtocolVersionProto
	34, // 24: hadoop.hdfs.ZoneEncryptionInfoProto.reencryptionProto:type_name -> hadoop.hdfs.ReencryptionInfoProto
	2,  // 25: hadoop.hdfs.CipherOptionProto.suite:type_name -> hadoop.hdfs.CipherSuiteProto
	28, // 26: hadoop.hdfs.LocatedBlocksProto.blocks:type_name -> hadoop.hdfs.LocatedBlockProto
	28, // 27: hadoop.hdfs.LocatedBlocksProto.lastBlock:type_name -> hadoop.hdfs.LocatedBlockProto
	31, // 28: hadoop.hdfs.LocatedBlocksProto.fileEncryptionInfo:type_name -> hadoop.hdfs.FileEncryptionInfoProto
	39, // 29: hadoop.hdfs.LocatedBlocksProto.ecPolicy:type_name -> hadoop.hdfs.ErasureCodingPolicyProto
	37, // 30: hadoop.hdfs.ECSchemaProto.options:type_name -> hadoop.hdfs.ECSchemaOptionEntryProto
	38, // 31: hadoop.hdfs.ErasureCodingPolicyProto.schema:type_name -> hadoop.hdfs.ECSchemaProto
	4,  // 32: hadoop.hdfs.ErasureCodingPolicyProto.state:type_name -> hadoop.hdfs.ErasureCodingPolicyState
	39, // 33: hadoop.hdfs.AddErasureCodingPolicyResponseProto.policy:type_name -> hadoop.hdfs.ErasureCodingPolicyProto
	10, // 34: hadoop.hdfs.HdfsFileStatusProto.fileType:type_name -> hadoop.hdfs.HdfsFileStatusProto.FileType
	62, // 35: hadoop.hdfs.HdfsFileStatusProto.permission:type_name -> hadoop.hdfs.FsPermissionProto
	36, // 36: hadoop.hdfs.HdfsFileStatusProto.locations:type_name -> hadoop.hdfs.LocatedBlocksProto
	31, // 37: hadoop.hdfs.HdfsFileStatusProto.fileEncryptionInfo:type_name -> hadoop.hdfs.FileEncryptionInfoProto
	39, // 38: hadoop.hdfs.HdfsFileStatusProto.ecPolicy:type_name -> hadoop.hdfs.ErasureCodingPolicyProto
	6,  // 39: hadoop.hdfs.BlockChecksumOptionsProto.blockChecksumType:type_name -> hadoop.hdfs.BlockChecksumTypeProto
	5,  // 40: hadoop.hdfs.FsServerDefaultsProto.checksumType:type_name -> hadoop.hdfs.ChecksumTypeProto
	43, // 41: hadoop.hdfs.DirectoryListingProto.partialListing:type_name -> hadoop.hdfs.HdfsFileStatusProto
	43, // 42: hadoop.hdfs.BatchedDirectoryListingProto.partialListing:type_name -> hadoop.hdfs.HdfsFileStatusProto
	47, // 43: hadoop.hdfs.BatchedDirectoryListingProto.exception:type_name -> hadoop.hdfs.RemoteExceptionProto
	43, // 44: hadoop.hdfs.SnapshottableDirectoryStatusProto.dirStatus:type_name -> hadoop.hdfs.HdfsFileStatusProto
	49, // 45: hadoop.hdfs.SnapshottableDirectoryListingProto.snapshottableDirListing:type_name -> hadoop.hdfs.SnapshottableDirectoryStatusProto
	51, // 46: hadoop.hdfs.SnapshotDiffReportProto.diffReportEntries:type_name -> hadoop.hdfs.SnapshotDiffReportEntryProto
	53, // 47: hadoop.hdfs.SnapshotDiffReportListingProto.modifiedEntries:type_name -> hadoop.hdfs.SnapshotDiffReportListingEntryProto
	53, // 48: hadoop.hdfs.SnapshotDiffReportListingProto.createdEntries:type_name -> hadoop.hdfs.SnapshotDiffReportListingEntryProto
	53, // 49: hadoop.hdfs.SnapshotDiffReportListingProto.deletedEntries:type_name -> hadoop.hdfs.SnapshotDiffReportListingEntryProto
	54, // 50: hadoop.hdfs.SnapshotDiffReportListingProto.cursor:type_name -> hadoop.hdfs.SnapshotDiffReportCursorProto
	62, // 51: hadoop.hdfs.SnapshotInfoProto.permission:type_name -> hadoop.hdfs.FsPermissionProto
	7,  // 52: hadoop.hdfs.BlockTokenSecretProto.modes:type_name -> hadoop.hdfs.AccessModeProto
	0,  // 53: hadoop.hdfs.BlockTokenSecretProto.storageTypes:type_name -> hadoop.hdfs.StorageTypeProto
	54, // [54:54] is the sub-list for method output_type
	54, // [54:54] is the sub-list for method input_type
	54, // [54:54] is the sub-list for extension type_name
	54, // [54:54] is the sub-list for extension extendee
	0,  // [0:54] is the sub-list for field type_name
}

func init() { file_hdfs_proto_init() }
func file_hdfs_proto_init() {
	if File_hdfs_proto != nil {
		return
	}
	file_acl_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_hdfs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtendedBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvidedStorageLocationProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatanodeIDProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatanodeLocalInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatanodeVolumeInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatanodeInfosProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatanodeInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatanodeStorageProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageReportProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContentSummaryProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuotaUsageProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageTypeQuotaInfosProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageTypeQuotaInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CorruptFileBlocksProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageTypesProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockStoragePolicyProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocatedBlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchedListingKeyProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataEncryptionKeyProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileEncryptionInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PerFileEncryptionInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ZoneEncryptionInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReencryptionInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CipherOptionProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocatedBlocksProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ECSchemaOptionEntryProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ECSchemaProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErasureCodingPolicyProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddErasureCodingPolicyResponseProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ECTopologyVerifierResultProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HdfsPathHandleProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HdfsFileStatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockChecksumOptionsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FsServerDefaultsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectoryListingProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteExceptionProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchedDirectoryListingProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshottableDirectoryStatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshottableDirectoryListingProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotDiffReportEntryProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotDiffReportProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotDiffReportListingEntryProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotDiffReportCursorProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotDiffReportListingProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SnapshotInfoProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RollingUpgradeStatusProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageUuidsProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_hdfs_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlockTokenSecretProto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_hdfs_proto_rawDesc,
			NumEnums:      12,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_hdfs_proto_goTypes,
		DependencyIndexes: file_hdfs_proto_depIdxs,
		EnumInfos:         file_hdfs_proto_enumTypes,
		MessageInfos:      file_hdfs_proto_msgTypes,
	}.Build()
	File_hdfs_proto = out.File
	file_hdfs_proto_rawDesc = nil
	file_hdfs_proto_goTypes = nil
	file_hdfs_proto_depIdxs = nil
}
