package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleAssignmentScheduleInstancesClient is the client for the RoleAssignmentScheduleInstances methods of the
// Authorization service.
type RoleAssignmentScheduleInstancesClient struct {
	BaseClient
}

// NewRoleAssignmentScheduleInstancesClient creates an instance of the RoleAssignmentScheduleInstancesClient client.
func NewRoleAssignmentScheduleInstancesClient(subscriptionID string) RoleAssignmentScheduleInstancesClient {
	return NewRoleAssignmentScheduleInstancesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRoleAssignmentScheduleInstancesClientWithBaseURI creates an instance of the RoleAssignmentScheduleInstancesClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewRoleAssignmentScheduleInstancesClientWithBaseURI(baseURI string, subscriptionID string) RoleAssignmentScheduleInstancesClient {
	return RoleAssignmentScheduleInstancesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets the specified role assignment schedule instance.
// Parameters:
// scope - the scope of the role assignments schedules.
// roleAssignmentScheduleInstanceName - the name (hash of schedule name + time) of the role assignment schedule
// to get.
func (client RoleAssignmentScheduleInstancesClient) Get(ctx context.Context, scope string, roleAssignmentScheduleInstanceName string) (result RoleAssignmentScheduleInstance, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleInstancesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, roleAssignmentScheduleInstanceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RoleAssignmentScheduleInstancesClient) GetPreparer(ctx context.Context, scope string, roleAssignmentScheduleInstanceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleAssignmentScheduleInstanceName": autorest.Encode("path", roleAssignmentScheduleInstanceName),
		"scope":                              scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleInstances/{roleAssignmentScheduleInstanceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentScheduleInstancesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RoleAssignmentScheduleInstancesClient) GetResponder(resp *http.Response) (result RoleAssignmentScheduleInstance, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListForScope gets role assignment schedule instances of a role assignment schedule.
// Parameters:
// scope - the scope of the role assignment schedule.
// filter - the filter to apply on the operation. Use $filter=atScope() to return all role assignment schedules
// at or above the scope. Use $filter=principalId eq {id} to return all role assignment schedules at, above or
// below the scope for the specified principal.  Use $filter=assignedTo('{userId}') to return all role
// assignment schedule instances for the user. Use $filter=asTarget() to return all role assignment schedule
// instances created for the current user.
func (client RoleAssignmentScheduleInstancesClient) ListForScope(ctx context.Context, scope string, filter string) (result RoleAssignmentScheduleInstanceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleInstancesClient.ListForScope")
		defer func() {
			sc := -1
			if result.rasilr.Response.Response != nil {
				sc = result.rasilr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForScopeNextResults
	req, err := client.ListForScopePreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "ListForScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.rasilr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "ListForScope", resp, "Failure sending request")
		return
	}

	result.rasilr, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "ListForScope", resp, "Failure responding to request")
		return
	}
	if result.rasilr.hasNextLink() && result.rasilr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForScopePreparer prepares the ListForScope request.
func (client RoleAssignmentScheduleInstancesClient) ListForScopePreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleInstances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForScopeSender sends the ListForScope request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentScheduleInstancesClient) ListForScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForScopeResponder handles the response to the ListForScope request. The method always
// closes the http.Response Body.
func (client RoleAssignmentScheduleInstancesClient) ListForScopeResponder(resp *http.Response) (result RoleAssignmentScheduleInstanceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForScopeNextResults retrieves the next set of results, if any.
func (client RoleAssignmentScheduleInstancesClient) listForScopeNextResults(ctx context.Context, lastResults RoleAssignmentScheduleInstanceListResult) (result RoleAssignmentScheduleInstanceListResult, err error) {
	req, err := lastResults.roleAssignmentScheduleInstanceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "listForScopeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "listForScopeNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleInstancesClient", "listForScopeNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForScopeComplete enumerates all values, automatically crossing page boundaries as required.
func (client RoleAssignmentScheduleInstancesClient) ListForScopeComplete(ctx context.Context, scope string, filter string) (result RoleAssignmentScheduleInstanceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleInstancesClient.ListForScope")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForScope(ctx, scope, filter)
	return
}
