//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package insights

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2022-10-01-preview/insights"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AggregationType = original.AggregationType

const (
	Average AggregationType = original.Average
	Count   AggregationType = original.Count
	Maximum AggregationType = original.Maximum
	Minimum AggregationType = original.Minimum
	None    AggregationType = original.None
	Total   AggregationType = original.Total
)

type AggregationTypeEnum = original.AggregationTypeEnum

const (
	AggregationTypeEnumAverage AggregationTypeEnum = original.AggregationTypeEnumAverage
	AggregationTypeEnumCount   AggregationTypeEnum = original.AggregationTypeEnumCount
	AggregationTypeEnumMaximum AggregationTypeEnum = original.AggregationTypeEnumMaximum
	AggregationTypeEnumMinimum AggregationTypeEnum = original.AggregationTypeEnumMinimum
	AggregationTypeEnumTotal   AggregationTypeEnum = original.AggregationTypeEnumTotal
)

type BaselineSensitivity = original.BaselineSensitivity

const (
	High   BaselineSensitivity = original.High
	Low    BaselineSensitivity = original.Low
	Medium BaselineSensitivity = original.Medium
)

type CategoryType = original.CategoryType

const (
	Logs    CategoryType = original.Logs
	Metrics CategoryType = original.Metrics
)

type ComparisonOperationType = original.ComparisonOperationType

const (
	Equals             ComparisonOperationType = original.Equals
	GreaterThan        ComparisonOperationType = original.GreaterThan
	GreaterThanOrEqual ComparisonOperationType = original.GreaterThanOrEqual
	LessThan           ComparisonOperationType = original.LessThan
	LessThanOrEqual    ComparisonOperationType = original.LessThanOrEqual
	NotEquals          ComparisonOperationType = original.NotEquals
)

type ConditionOperator = original.ConditionOperator

const (
	ConditionOperatorGreaterThan        ConditionOperator = original.ConditionOperatorGreaterThan
	ConditionOperatorGreaterThanOrEqual ConditionOperator = original.ConditionOperatorGreaterThanOrEqual
	ConditionOperatorLessThan           ConditionOperator = original.ConditionOperatorLessThan
	ConditionOperatorLessThanOrEqual    ConditionOperator = original.ConditionOperatorLessThanOrEqual
)

type CreatedByType = original.CreatedByType

const (
	Application     CreatedByType = original.Application
	Key             CreatedByType = original.Key
	ManagedIdentity CreatedByType = original.ManagedIdentity
	User            CreatedByType = original.User
)

type CriterionType = original.CriterionType

const (
	CriterionTypeDynamicThresholdCriterion CriterionType = original.CriterionTypeDynamicThresholdCriterion
	CriterionTypeMultiMetricCriteria       CriterionType = original.CriterionTypeMultiMetricCriteria
	CriterionTypeStaticThresholdCriterion  CriterionType = original.CriterionTypeStaticThresholdCriterion
)

type DataStatus = original.DataStatus

const (
	NotPresent DataStatus = original.NotPresent
	Present    DataStatus = original.Present
)

type DimensionOperator = original.DimensionOperator

const (
	Exclude DimensionOperator = original.Exclude
	Include DimensionOperator = original.Include
)

type DynamicThresholdOperator = original.DynamicThresholdOperator

const (
	DynamicThresholdOperatorGreaterOrLessThan DynamicThresholdOperator = original.DynamicThresholdOperatorGreaterOrLessThan
	DynamicThresholdOperatorGreaterThan       DynamicThresholdOperator = original.DynamicThresholdOperatorGreaterThan
	DynamicThresholdOperatorLessThan          DynamicThresholdOperator = original.DynamicThresholdOperatorLessThan
)

type DynamicThresholdSensitivity = original.DynamicThresholdSensitivity

const (
	DynamicThresholdSensitivityHigh   DynamicThresholdSensitivity = original.DynamicThresholdSensitivityHigh
	DynamicThresholdSensitivityLow    DynamicThresholdSensitivity = original.DynamicThresholdSensitivityLow
	DynamicThresholdSensitivityMedium DynamicThresholdSensitivity = original.DynamicThresholdSensitivityMedium
)

type EventLevel = original.EventLevel

const (
	EventLevelCritical      EventLevel = original.EventLevelCritical
	EventLevelError         EventLevel = original.EventLevelError
	EventLevelInformational EventLevel = original.EventLevelInformational
	EventLevelVerbose       EventLevel = original.EventLevelVerbose
	EventLevelWarning       EventLevel = original.EventLevelWarning
)

type Kind = original.Kind

const (
	LogAlert    Kind = original.LogAlert
	LogToMetric Kind = original.LogToMetric
)

type KnownColumnDefinitionType = original.KnownColumnDefinitionType

const (
	Boolean  KnownColumnDefinitionType = original.Boolean
	Datetime KnownColumnDefinitionType = original.Datetime
	Dynamic  KnownColumnDefinitionType = original.Dynamic
	Int      KnownColumnDefinitionType = original.Int
	Long     KnownColumnDefinitionType = original.Long
	Real     KnownColumnDefinitionType = original.Real
	String   KnownColumnDefinitionType = original.String
)

type KnownDataCollectionEndpointProvisioningState = original.KnownDataCollectionEndpointProvisioningState

const (
	Creating  KnownDataCollectionEndpointProvisioningState = original.Creating
	Deleting  KnownDataCollectionEndpointProvisioningState = original.Deleting
	Failed    KnownDataCollectionEndpointProvisioningState = original.Failed
	Succeeded KnownDataCollectionEndpointProvisioningState = original.Succeeded
	Updating  KnownDataCollectionEndpointProvisioningState = original.Updating
)

type KnownDataCollectionEndpointResourceKind = original.KnownDataCollectionEndpointResourceKind

const (
	Linux   KnownDataCollectionEndpointResourceKind = original.Linux
	Windows KnownDataCollectionEndpointResourceKind = original.Windows
)

type KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningState

const (
	KnownDataCollectionRuleAssociationProvisioningStateCreating  KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateCreating
	KnownDataCollectionRuleAssociationProvisioningStateDeleting  KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateDeleting
	KnownDataCollectionRuleAssociationProvisioningStateFailed    KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateFailed
	KnownDataCollectionRuleAssociationProvisioningStateSucceeded KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateSucceeded
	KnownDataCollectionRuleAssociationProvisioningStateUpdating  KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateUpdating
)

type KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningState

const (
	KnownDataCollectionRuleProvisioningStateCreating  KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateCreating
	KnownDataCollectionRuleProvisioningStateDeleting  KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateDeleting
	KnownDataCollectionRuleProvisioningStateFailed    KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateFailed
	KnownDataCollectionRuleProvisioningStateSucceeded KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateSucceeded
	KnownDataCollectionRuleProvisioningStateUpdating  KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateUpdating
)

type KnownDataCollectionRuleResourceKind = original.KnownDataCollectionRuleResourceKind

const (
	KnownDataCollectionRuleResourceKindLinux   KnownDataCollectionRuleResourceKind = original.KnownDataCollectionRuleResourceKindLinux
	KnownDataCollectionRuleResourceKindWindows KnownDataCollectionRuleResourceKind = original.KnownDataCollectionRuleResourceKindWindows
)

type KnownDataFlowStreams = original.KnownDataFlowStreams

const (
	MicrosoftEvent           KnownDataFlowStreams = original.MicrosoftEvent
	MicrosoftInsightsMetrics KnownDataFlowStreams = original.MicrosoftInsightsMetrics
	MicrosoftPerf            KnownDataFlowStreams = original.MicrosoftPerf
	MicrosoftSyslog          KnownDataFlowStreams = original.MicrosoftSyslog
	MicrosoftWindowsEvent    KnownDataFlowStreams = original.MicrosoftWindowsEvent
)

type KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreams

const (
	KnownExtensionDataSourceStreamsMicrosoftEvent           KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftEvent
	KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics
	KnownExtensionDataSourceStreamsMicrosoftPerf            KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftPerf
	KnownExtensionDataSourceStreamsMicrosoftSyslog          KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftSyslog
	KnownExtensionDataSourceStreamsMicrosoftWindowsEvent    KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftWindowsEvent
)

type KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormat

const (
	DdMMMyyyyHHmmsszzz KnownLogFileTextSettingsRecordStartTimestampFormat = original.DdMMMyyyyHHmmsszzz
	DdMMyyHHmmss       KnownLogFileTextSettingsRecordStartTimestampFormat = original.DdMMyyHHmmss
	ISO8601            KnownLogFileTextSettingsRecordStartTimestampFormat = original.ISO8601
	MDYYYYHHMMSSAMPM   KnownLogFileTextSettingsRecordStartTimestampFormat = original.MDYYYYHHMMSSAMPM
	MMMdhhmmss         KnownLogFileTextSettingsRecordStartTimestampFormat = original.MMMdhhmmss
	MonDDYYYYHHMMSS    KnownLogFileTextSettingsRecordStartTimestampFormat = original.MonDDYYYYHHMMSS
	YyMMddHHmmss       KnownLogFileTextSettingsRecordStartTimestampFormat = original.YyMMddHHmmss
	YYYYMMDDHHMMSS     KnownLogFileTextSettingsRecordStartTimestampFormat = original.YYYYMMDDHHMMSS
	YyyyMMDdTHHmmssK   KnownLogFileTextSettingsRecordStartTimestampFormat = original.YyyyMMDdTHHmmssK
)

type KnownPerfCounterDataSourceStreams = original.KnownPerfCounterDataSourceStreams

const (
	KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics KnownPerfCounterDataSourceStreams = original.KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics
	KnownPerfCounterDataSourceStreamsMicrosoftPerf            KnownPerfCounterDataSourceStreams = original.KnownPerfCounterDataSourceStreamsMicrosoftPerf
)

type KnownPublicNetworkAccessOptions = original.KnownPublicNetworkAccessOptions

const (
	Disabled KnownPublicNetworkAccessOptions = original.Disabled
	Enabled  KnownPublicNetworkAccessOptions = original.Enabled
)

type KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNames

const (
	KnownSyslogDataSourceFacilityNamesAsterisk KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesAsterisk
	KnownSyslogDataSourceFacilityNamesAuth     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesAuth
	KnownSyslogDataSourceFacilityNamesAuthpriv KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesAuthpriv
	KnownSyslogDataSourceFacilityNamesCron     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesCron
	KnownSyslogDataSourceFacilityNamesDaemon   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesDaemon
	KnownSyslogDataSourceFacilityNamesKern     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesKern
	KnownSyslogDataSourceFacilityNamesLocal0   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal0
	KnownSyslogDataSourceFacilityNamesLocal1   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal1
	KnownSyslogDataSourceFacilityNamesLocal2   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal2
	KnownSyslogDataSourceFacilityNamesLocal3   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal3
	KnownSyslogDataSourceFacilityNamesLocal4   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal4
	KnownSyslogDataSourceFacilityNamesLocal5   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal5
	KnownSyslogDataSourceFacilityNamesLocal6   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal6
	KnownSyslogDataSourceFacilityNamesLocal7   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal7
	KnownSyslogDataSourceFacilityNamesLpr      KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLpr
	KnownSyslogDataSourceFacilityNamesMail     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesMail
	KnownSyslogDataSourceFacilityNamesMark     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesMark
	KnownSyslogDataSourceFacilityNamesNews     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesNews
	KnownSyslogDataSourceFacilityNamesSyslog   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesSyslog
	KnownSyslogDataSourceFacilityNamesUser     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesUser
	KnownSyslogDataSourceFacilityNamesUucp     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesUucp
)

type KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevels

const (
	KnownSyslogDataSourceLogLevelsAlert     KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsAlert
	KnownSyslogDataSourceLogLevelsAsterisk  KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsAsterisk
	KnownSyslogDataSourceLogLevelsCritical  KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsCritical
	KnownSyslogDataSourceLogLevelsDebug     KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsDebug
	KnownSyslogDataSourceLogLevelsEmergency KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsEmergency
	KnownSyslogDataSourceLogLevelsError     KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsError
	KnownSyslogDataSourceLogLevelsInfo      KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsInfo
	KnownSyslogDataSourceLogLevelsNotice    KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsNotice
	KnownSyslogDataSourceLogLevelsWarning   KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsWarning
)

type KnownSyslogDataSourceStreams = original.KnownSyslogDataSourceStreams

const (
	KnownSyslogDataSourceStreamsMicrosoftSyslog KnownSyslogDataSourceStreams = original.KnownSyslogDataSourceStreamsMicrosoftSyslog
)

type KnownWindowsEventLogDataSourceStreams = original.KnownWindowsEventLogDataSourceStreams

const (
	KnownWindowsEventLogDataSourceStreamsMicrosoftEvent        KnownWindowsEventLogDataSourceStreams = original.KnownWindowsEventLogDataSourceStreamsMicrosoftEvent
	KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent KnownWindowsEventLogDataSourceStreams = original.KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent
)

type MetricClass = original.MetricClass

const (
	Availability MetricClass = original.Availability
	Errors       MetricClass = original.Errors
	Latency      MetricClass = original.Latency
	Saturation   MetricClass = original.Saturation
	Transactions MetricClass = original.Transactions
)

type MetricStatisticType = original.MetricStatisticType

const (
	MetricStatisticTypeAverage MetricStatisticType = original.MetricStatisticTypeAverage
	MetricStatisticTypeCount   MetricStatisticType = original.MetricStatisticTypeCount
	MetricStatisticTypeMax     MetricStatisticType = original.MetricStatisticTypeMax
	MetricStatisticTypeMin     MetricStatisticType = original.MetricStatisticTypeMin
	MetricStatisticTypeSum     MetricStatisticType = original.MetricStatisticTypeSum
)

type MetricUnit = original.MetricUnit

const (
	MetricUnitBitsPerSecond  MetricUnit = original.MetricUnitBitsPerSecond
	MetricUnitBytes          MetricUnit = original.MetricUnitBytes
	MetricUnitByteSeconds    MetricUnit = original.MetricUnitByteSeconds
	MetricUnitBytesPerSecond MetricUnit = original.MetricUnitBytesPerSecond
	MetricUnitCores          MetricUnit = original.MetricUnitCores
	MetricUnitCount          MetricUnit = original.MetricUnitCount
	MetricUnitCountPerSecond MetricUnit = original.MetricUnitCountPerSecond
	MetricUnitMilliCores     MetricUnit = original.MetricUnitMilliCores
	MetricUnitMilliSeconds   MetricUnit = original.MetricUnitMilliSeconds
	MetricUnitNanoCores      MetricUnit = original.MetricUnitNanoCores
	MetricUnitPercent        MetricUnit = original.MetricUnitPercent
	MetricUnitSeconds        MetricUnit = original.MetricUnitSeconds
	MetricUnitUnspecified    MetricUnit = original.MetricUnitUnspecified
)

type NamespaceClassification = original.NamespaceClassification

const (
	Custom   NamespaceClassification = original.Custom
	Platform NamespaceClassification = original.Platform
	Qos      NamespaceClassification = original.Qos
)

type OdataType = original.OdataType

const (
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource OdataType = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource          OdataType = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource
	OdataTypeRuleDataSource                                                      OdataType = original.OdataTypeRuleDataSource
)

type OdataTypeBasicMetricAlertCriteria = original.OdataTypeBasicMetricAlertCriteria

const (
	OdataTypeMetricAlertCriteria                                         OdataTypeBasicMetricAlertCriteria = original.OdataTypeMetricAlertCriteria
	OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria OdataTypeBasicMetricAlertCriteria = original.OdataTypeMicrosoftAzureMonitorMultipleResourceMultipleMetricCriteria
	OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria   OdataTypeBasicMetricAlertCriteria = original.OdataTypeMicrosoftAzureMonitorSingleResourceMultipleMetricCriteria
	OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria    OdataTypeBasicMetricAlertCriteria = original.OdataTypeMicrosoftAzureMonitorWebtestLocationAvailabilityCriteria
)

type OdataTypeBasicRuleAction = original.OdataTypeBasicRuleAction

const (
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction   OdataTypeBasicRuleAction = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction OdataTypeBasicRuleAction = original.OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction
	OdataTypeRuleAction                                              OdataTypeBasicRuleAction = original.OdataTypeRuleAction
)

type OdataTypeBasicRuleCondition = original.OdataTypeBasicRuleCondition

const (
	OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition OdataTypeBasicRuleCondition = original.OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition
	OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition   OdataTypeBasicRuleCondition = original.OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition
	OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition         OdataTypeBasicRuleCondition = original.OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition
	OdataTypeRuleCondition                                                        OdataTypeBasicRuleCondition = original.OdataTypeRuleCondition
)

type OnboardingStatus = original.OnboardingStatus

const (
	NotOnboarded OnboardingStatus = original.NotOnboarded
	Onboarded    OnboardingStatus = original.Onboarded
	Unknown      OnboardingStatus = original.Unknown
)

type Operator = original.Operator

const (
	OperatorEquals             Operator = original.OperatorEquals
	OperatorGreaterThan        Operator = original.OperatorGreaterThan
	OperatorGreaterThanOrEqual Operator = original.OperatorGreaterThanOrEqual
	OperatorLessThan           Operator = original.OperatorLessThan
	OperatorLessThanOrEqual    Operator = original.OperatorLessThanOrEqual
)

type OperatorForCondition = original.OperatorForCondition

const (
	OperatorForConditionEquals             OperatorForCondition = original.OperatorForConditionEquals
	OperatorForConditionGreaterThan        OperatorForCondition = original.OperatorForConditionGreaterThan
	OperatorForConditionGreaterThanOrEqual OperatorForCondition = original.OperatorForConditionGreaterThanOrEqual
	OperatorForConditionLessThan           OperatorForCondition = original.OperatorForConditionLessThan
	OperatorForConditionLessThanOrEqual    OperatorForCondition = original.OperatorForConditionLessThanOrEqual
)

type PredictiveAutoscalePolicyScaleMode = original.PredictiveAutoscalePolicyScaleMode

const (
	PredictiveAutoscalePolicyScaleModeDisabled     PredictiveAutoscalePolicyScaleMode = original.PredictiveAutoscalePolicyScaleModeDisabled
	PredictiveAutoscalePolicyScaleModeEnabled      PredictiveAutoscalePolicyScaleMode = original.PredictiveAutoscalePolicyScaleModeEnabled
	PredictiveAutoscalePolicyScaleModeForecastOnly PredictiveAutoscalePolicyScaleMode = original.PredictiveAutoscalePolicyScaleModeForecastOnly
)

type ReceiverStatus = original.ReceiverStatus

const (
	ReceiverStatusDisabled     ReceiverStatus = original.ReceiverStatusDisabled
	ReceiverStatusEnabled      ReceiverStatus = original.ReceiverStatusEnabled
	ReceiverStatusNotSpecified ReceiverStatus = original.ReceiverStatusNotSpecified
)

type RecurrenceFrequency = original.RecurrenceFrequency

const (
	RecurrenceFrequencyDay    RecurrenceFrequency = original.RecurrenceFrequencyDay
	RecurrenceFrequencyHour   RecurrenceFrequency = original.RecurrenceFrequencyHour
	RecurrenceFrequencyMinute RecurrenceFrequency = original.RecurrenceFrequencyMinute
	RecurrenceFrequencyMonth  RecurrenceFrequency = original.RecurrenceFrequencyMonth
	RecurrenceFrequencyNone   RecurrenceFrequency = original.RecurrenceFrequencyNone
	RecurrenceFrequencySecond RecurrenceFrequency = original.RecurrenceFrequencySecond
	RecurrenceFrequencyWeek   RecurrenceFrequency = original.RecurrenceFrequencyWeek
	RecurrenceFrequencyYear   RecurrenceFrequency = original.RecurrenceFrequencyYear
)

type ResultType = original.ResultType

const (
	ResultTypeData     ResultType = original.ResultTypeData
	ResultTypeMetadata ResultType = original.ResultTypeMetadata
)

type ScaleDirection = original.ScaleDirection

const (
	ScaleDirectionDecrease ScaleDirection = original.ScaleDirectionDecrease
	ScaleDirectionIncrease ScaleDirection = original.ScaleDirectionIncrease
	ScaleDirectionNone     ScaleDirection = original.ScaleDirectionNone
)

type ScaleRuleMetricDimensionOperationType = original.ScaleRuleMetricDimensionOperationType

const (
	ScaleRuleMetricDimensionOperationTypeEquals    ScaleRuleMetricDimensionOperationType = original.ScaleRuleMetricDimensionOperationTypeEquals
	ScaleRuleMetricDimensionOperationTypeNotEquals ScaleRuleMetricDimensionOperationType = original.ScaleRuleMetricDimensionOperationTypeNotEquals
)

type ScaleType = original.ScaleType

const (
	ChangeCount             ScaleType = original.ChangeCount
	ExactCount              ScaleType = original.ExactCount
	PercentChangeCount      ScaleType = original.PercentChangeCount
	ServiceAllowedNextValue ScaleType = original.ServiceAllowedNextValue
)

type TimeAggregation = original.TimeAggregation

const (
	TimeAggregationAverage TimeAggregation = original.TimeAggregationAverage
	TimeAggregationCount   TimeAggregation = original.TimeAggregationCount
	TimeAggregationMaximum TimeAggregation = original.TimeAggregationMaximum
	TimeAggregationMinimum TimeAggregation = original.TimeAggregationMinimum
	TimeAggregationTotal   TimeAggregation = original.TimeAggregationTotal
)

type TimeAggregationOperator = original.TimeAggregationOperator

const (
	TimeAggregationOperatorAverage TimeAggregationOperator = original.TimeAggregationOperatorAverage
	TimeAggregationOperatorLast    TimeAggregationOperator = original.TimeAggregationOperatorLast
	TimeAggregationOperatorMaximum TimeAggregationOperator = original.TimeAggregationOperatorMaximum
	TimeAggregationOperatorMinimum TimeAggregationOperator = original.TimeAggregationOperatorMinimum
	TimeAggregationOperatorTotal   TimeAggregationOperator = original.TimeAggregationOperatorTotal
)

type TimeAggregationType = original.TimeAggregationType

const (
	TimeAggregationTypeAverage TimeAggregationType = original.TimeAggregationTypeAverage
	TimeAggregationTypeCount   TimeAggregationType = original.TimeAggregationTypeCount
	TimeAggregationTypeLast    TimeAggregationType = original.TimeAggregationTypeLast
	TimeAggregationTypeMaximum TimeAggregationType = original.TimeAggregationTypeMaximum
	TimeAggregationTypeMinimum TimeAggregationType = original.TimeAggregationTypeMinimum
	TimeAggregationTypeTotal   TimeAggregationType = original.TimeAggregationTypeTotal
)

type ActionDetail = original.ActionDetail
type ActionGroup = original.ActionGroup
type ActionGroupForActivityLogAlerts = original.ActionGroupForActivityLogAlerts
type ActionGroupList = original.ActionGroupList
type ActionGroupPatch = original.ActionGroupPatch
type ActionGroupPatchBody = original.ActionGroupPatchBody
type ActionGroupResource = original.ActionGroupResource
type ActionGroupsClient = original.ActionGroupsClient
type ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture = original.ActionGroupsCreateNotificationsAtActionGroupResourceLevelFuture
type ActionGroupsCreateNotificationsAtResourceGroupLevelFuture = original.ActionGroupsCreateNotificationsAtResourceGroupLevelFuture
type ActionGroupsPostTestNotificationsFuture = original.ActionGroupsPostTestNotificationsFuture
type ActionList = original.ActionList
type Actions = original.Actions
type ActivityLogAlertResource = original.ActivityLogAlertResource
type ActivityLogAlertsClient = original.ActivityLogAlertsClient
type ActivityLogsClient = original.ActivityLogsClient
type AlertRule = original.AlertRule
type AlertRuleAllOfCondition = original.AlertRuleAllOfCondition
type AlertRuleAnyOfOrLeafCondition = original.AlertRuleAnyOfOrLeafCondition
type AlertRuleIncidentsClient = original.AlertRuleIncidentsClient
type AlertRuleLeafCondition = original.AlertRuleLeafCondition
type AlertRuleList = original.AlertRuleList
type AlertRuleListIterator = original.AlertRuleListIterator
type AlertRuleListPage = original.AlertRuleListPage
type AlertRulePatchObject = original.AlertRulePatchObject
type AlertRulePatchProperties = original.AlertRulePatchProperties
type AlertRuleProperties = original.AlertRuleProperties
type AlertRuleResource = original.AlertRuleResource
type AlertRuleResourceCollection = original.AlertRuleResourceCollection
type AlertRuleResourcePatch = original.AlertRuleResourcePatch
type AlertRulesClient = original.AlertRulesClient
type ArmRoleReceiver = original.ArmRoleReceiver
type AutomationRunbookReceiver = original.AutomationRunbookReceiver
type AutoscaleErrorResponse = original.AutoscaleErrorResponse
type AutoscaleErrorResponseError = original.AutoscaleErrorResponseError
type AutoscaleNotification = original.AutoscaleNotification
type AutoscaleProfile = original.AutoscaleProfile
type AutoscaleSetting = original.AutoscaleSetting
type AutoscaleSettingResource = original.AutoscaleSettingResource
type AutoscaleSettingResourceCollection = original.AutoscaleSettingResourceCollection
type AutoscaleSettingResourceCollectionIterator = original.AutoscaleSettingResourceCollectionIterator
type AutoscaleSettingResourceCollectionPage = original.AutoscaleSettingResourceCollectionPage
type AutoscaleSettingResourcePatch = original.AutoscaleSettingResourcePatch
type AutoscaleSettingsClient = original.AutoscaleSettingsClient
type AzureAppPushReceiver = original.AzureAppPushReceiver
type AzureFunctionReceiver = original.AzureFunctionReceiver
type AzureMonitorMetricsDestination = original.AzureMonitorMetricsDestination
type AzureMonitorPrivateLinkScope = original.AzureMonitorPrivateLinkScope
type AzureMonitorPrivateLinkScopeListResult = original.AzureMonitorPrivateLinkScopeListResult
type AzureMonitorPrivateLinkScopeListResultIterator = original.AzureMonitorPrivateLinkScopeListResultIterator
type AzureMonitorPrivateLinkScopeListResultPage = original.AzureMonitorPrivateLinkScopeListResultPage
type AzureMonitorPrivateLinkScopeProperties = original.AzureMonitorPrivateLinkScopeProperties
type AzureResource = original.AzureResource
type BaseClient = original.BaseClient
type BaselineMetadata = original.BaselineMetadata
type BaselinesClient = original.BaselinesClient
type BasicMetricAlertCriteria = original.BasicMetricAlertCriteria
type BasicMultiMetricCriteria = original.BasicMultiMetricCriteria
type BasicRuleAction = original.BasicRuleAction
type BasicRuleCondition = original.BasicRuleCondition
type BasicRuleDataSource = original.BasicRuleDataSource
type ColumnDefinition = original.ColumnDefinition
type Condition = original.Condition
type ConditionFailingPeriods = original.ConditionFailingPeriods
type ConfigurationAccessEndpointSpec = original.ConfigurationAccessEndpointSpec
type Context = original.Context
type DataCollectionEndpoint = original.DataCollectionEndpoint
type DataCollectionEndpointConfigurationAccess = original.DataCollectionEndpointConfigurationAccess
type DataCollectionEndpointLogsIngestion = original.DataCollectionEndpointLogsIngestion
type DataCollectionEndpointNetworkAcls = original.DataCollectionEndpointNetworkAcls
type DataCollectionEndpointResource = original.DataCollectionEndpointResource
type DataCollectionEndpointResourceListResult = original.DataCollectionEndpointResourceListResult
type DataCollectionEndpointResourceListResultIterator = original.DataCollectionEndpointResourceListResultIterator
type DataCollectionEndpointResourceListResultPage = original.DataCollectionEndpointResourceListResultPage
type DataCollectionEndpointResourceProperties = original.DataCollectionEndpointResourceProperties
type DataCollectionEndpointResourceSystemData = original.DataCollectionEndpointResourceSystemData
type DataCollectionEndpointsClient = original.DataCollectionEndpointsClient
type DataCollectionRule = original.DataCollectionRule
type DataCollectionRuleAssociation = original.DataCollectionRuleAssociation
type DataCollectionRuleAssociationMetadata = original.DataCollectionRuleAssociationMetadata
type DataCollectionRuleAssociationProxyOnlyResource = original.DataCollectionRuleAssociationProxyOnlyResource
type DataCollectionRuleAssociationProxyOnlyResourceListResult = original.DataCollectionRuleAssociationProxyOnlyResourceListResult
type DataCollectionRuleAssociationProxyOnlyResourceListResultIterator = original.DataCollectionRuleAssociationProxyOnlyResourceListResultIterator
type DataCollectionRuleAssociationProxyOnlyResourceListResultPage = original.DataCollectionRuleAssociationProxyOnlyResourceListResultPage
type DataCollectionRuleAssociationProxyOnlyResourceProperties = original.DataCollectionRuleAssociationProxyOnlyResourceProperties
type DataCollectionRuleAssociationProxyOnlyResourceSystemData = original.DataCollectionRuleAssociationProxyOnlyResourceSystemData
type DataCollectionRuleAssociationsClient = original.DataCollectionRuleAssociationsClient
type DataCollectionRuleDataSources = original.DataCollectionRuleDataSources
type DataCollectionRuleDestinations = original.DataCollectionRuleDestinations
type DataCollectionRuleMetadata = original.DataCollectionRuleMetadata
type DataCollectionRuleResource = original.DataCollectionRuleResource
type DataCollectionRuleResourceListResult = original.DataCollectionRuleResourceListResult
type DataCollectionRuleResourceListResultIterator = original.DataCollectionRuleResourceListResultIterator
type DataCollectionRuleResourceListResultPage = original.DataCollectionRuleResourceListResultPage
type DataCollectionRuleResourceProperties = original.DataCollectionRuleResourceProperties
type DataCollectionRuleResourceSystemData = original.DataCollectionRuleResourceSystemData
type DataCollectionRulesClient = original.DataCollectionRulesClient
type DataContainer = original.DataContainer
type DataFlow = original.DataFlow
type DataSourcesSpec = original.DataSourcesSpec
type DestinationsSpec = original.DestinationsSpec
type DestinationsSpecAzureMonitorMetrics = original.DestinationsSpecAzureMonitorMetrics
type DiagnosticSettings = original.DiagnosticSettings
type DiagnosticSettingsCategory = original.DiagnosticSettingsCategory
type DiagnosticSettingsCategoryClient = original.DiagnosticSettingsCategoryClient
type DiagnosticSettingsCategoryResource = original.DiagnosticSettingsCategoryResource
type DiagnosticSettingsCategoryResourceCollection = original.DiagnosticSettingsCategoryResourceCollection
type DiagnosticSettingsClient = original.DiagnosticSettingsClient
type DiagnosticSettingsResource = original.DiagnosticSettingsResource
type DiagnosticSettingsResourceCollection = original.DiagnosticSettingsResourceCollection
type Dimension = original.Dimension
type DynamicMetricCriteria = original.DynamicMetricCriteria
type DynamicThresholdFailingPeriods = original.DynamicThresholdFailingPeriods
type EmailNotification = original.EmailNotification
type EmailReceiver = original.EmailReceiver
type EnableRequest = original.EnableRequest
type Error = original.Error
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorContract = original.ErrorContract
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type ErrorResponseAdditionalInfo = original.ErrorResponseAdditionalInfo
type ErrorResponseCommon = original.ErrorResponseCommon
type ErrorResponseCommonV2 = original.ErrorResponseCommonV2
type ErrorResponseDetails = original.ErrorResponseDetails
type EventCategoriesClient = original.EventCategoriesClient
type EventCategoryCollection = original.EventCategoryCollection
type EventData = original.EventData
type EventDataCollection = original.EventDataCollection
type EventDataCollectionIterator = original.EventDataCollectionIterator
type EventDataCollectionPage = original.EventDataCollectionPage
type EventHubReceiver = original.EventHubReceiver
type ExtensionDataSource = original.ExtensionDataSource
type HTTPRequestInfo = original.HTTPRequestInfo
type IisLogsDataSource = original.IisLogsDataSource
type Incident = original.Incident
type IncidentListResult = original.IncidentListResult
type ItsmReceiver = original.ItsmReceiver
type LocalizableString = original.LocalizableString
type LocationThresholdRuleCondition = original.LocationThresholdRuleCondition
type LogAnalyticsDestination = original.LogAnalyticsDestination
type LogFileSettings = original.LogFileSettings
type LogFileSettingsText = original.LogFileSettingsText
type LogFileTextSettings = original.LogFileTextSettings
type LogFilesDataSource = original.LogFilesDataSource
type LogFilesDataSourceSettings = original.LogFilesDataSourceSettings
type LogProfileCollection = original.LogProfileCollection
type LogProfileProperties = original.LogProfileProperties
type LogProfileResource = original.LogProfileResource
type LogProfileResourcePatch = original.LogProfileResourcePatch
type LogProfilesClient = original.LogProfilesClient
type LogSettings = original.LogSettings
type LogicAppReceiver = original.LogicAppReceiver
type LogsIngestionEndpointSpec = original.LogsIngestionEndpointSpec
type ManagementEventAggregationCondition = original.ManagementEventAggregationCondition
type ManagementEventRuleCondition = original.ManagementEventRuleCondition
type Metadata = original.Metadata
type MetadataValue = original.MetadataValue
type Metric = original.Metric
type MetricAlertAction = original.MetricAlertAction
type MetricAlertCriteria = original.MetricAlertCriteria
type MetricAlertMultipleResourceMultipleMetricCriteria = original.MetricAlertMultipleResourceMultipleMetricCriteria
type MetricAlertProperties = original.MetricAlertProperties
type MetricAlertPropertiesPatch = original.MetricAlertPropertiesPatch
type MetricAlertResource = original.MetricAlertResource
type MetricAlertResourceCollection = original.MetricAlertResourceCollection
type MetricAlertResourcePatch = original.MetricAlertResourcePatch
type MetricAlertSingleResourceMultipleMetricCriteria = original.MetricAlertSingleResourceMultipleMetricCriteria
type MetricAlertStatus = original.MetricAlertStatus
type MetricAlertStatusCollection = original.MetricAlertStatusCollection
type MetricAlertStatusProperties = original.MetricAlertStatusProperties
type MetricAlertsClient = original.MetricAlertsClient
type MetricAlertsStatusClient = original.MetricAlertsStatusClient
type MetricAvailability = original.MetricAvailability
type MetricBaselinesProperties = original.MetricBaselinesProperties
type MetricBaselinesResponse = original.MetricBaselinesResponse
type MetricCriteria = original.MetricCriteria
type MetricDefinition = original.MetricDefinition
type MetricDefinitionCollection = original.MetricDefinitionCollection
type MetricDefinitionsClient = original.MetricDefinitionsClient
type MetricDimension = original.MetricDimension
type MetricNamespace = original.MetricNamespace
type MetricNamespaceCollection = original.MetricNamespaceCollection
type MetricNamespaceName = original.MetricNamespaceName
type MetricNamespacesClient = original.MetricNamespacesClient
type MetricSettings = original.MetricSettings
type MetricSingleDimension = original.MetricSingleDimension
type MetricTrigger = original.MetricTrigger
type MetricValue = original.MetricValue
type MetricsClient = original.MetricsClient
type MultiMetricCriteria = original.MultiMetricCriteria
type NetworkRuleSet = original.NetworkRuleSet
type NotificationRequestBody = original.NotificationRequestBody
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationStatus = original.OperationStatus
type OperationsClient = original.OperationsClient
type PerfCounterDataSource = original.PerfCounterDataSource
type PredictiveAutoscalePolicy = original.PredictiveAutoscalePolicy
type PredictiveMetricClient = original.PredictiveMetricClient
type PredictiveResponse = original.PredictiveResponse
type PredictiveValue = original.PredictiveValue
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsCreateOrUpdateFuture = original.PrivateEndpointConnectionsCreateOrUpdateFuture
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateEndpointProperty = original.PrivateEndpointProperty
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceListResultIterator = original.PrivateLinkResourceListResultIterator
type PrivateLinkResourceListResultPage = original.PrivateLinkResourceListResultPage
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkScopeOperationStatusClient = original.PrivateLinkScopeOperationStatusClient
type PrivateLinkScopedResourcesClient = original.PrivateLinkScopedResourcesClient
type PrivateLinkScopedResourcesCreateOrUpdateFuture = original.PrivateLinkScopedResourcesCreateOrUpdateFuture
type PrivateLinkScopedResourcesDeleteFuture = original.PrivateLinkScopedResourcesDeleteFuture
type PrivateLinkScopesClient = original.PrivateLinkScopesClient
type PrivateLinkScopesDeleteFuture = original.PrivateLinkScopesDeleteFuture
type PrivateLinkScopesResource = original.PrivateLinkScopesResource
type PrivateLinkServiceConnectionStateProperty = original.PrivateLinkServiceConnectionStateProperty
type ProxyOnlyResource = original.ProxyOnlyResource
type ProxyResource = original.ProxyResource
type Recurrence = original.Recurrence
type RecurrentSchedule = original.RecurrentSchedule
type Resource = original.Resource
type ResourceForAutoscale = original.ResourceForAutoscale
type ResourceForUpdate = original.ResourceForUpdate
type Response = original.Response
type ResponseWithError = original.ResponseWithError
type RetentionPolicy = original.RetentionPolicy
type RuleAction = original.RuleAction
type RuleCondition = original.RuleCondition
type RuleDataSource = original.RuleDataSource
type RuleEmailAction = original.RuleEmailAction
type RuleManagementEventClaimsDataSource = original.RuleManagementEventClaimsDataSource
type RuleManagementEventDataSource = original.RuleManagementEventDataSource
type RuleMetricDataSource = original.RuleMetricDataSource
type RuleWebhookAction = original.RuleWebhookAction
type ScaleAction = original.ScaleAction
type ScaleCapacity = original.ScaleCapacity
type ScaleRule = original.ScaleRule
type ScaleRuleMetricDimension = original.ScaleRuleMetricDimension
type ScheduledQueryRuleCriteria = original.ScheduledQueryRuleCriteria
type ScheduledQueryRuleProperties = original.ScheduledQueryRuleProperties
type ScheduledQueryRuleResource = original.ScheduledQueryRuleResource
type ScheduledQueryRuleResourceCollection = original.ScheduledQueryRuleResourceCollection
type ScheduledQueryRuleResourceCollectionIterator = original.ScheduledQueryRuleResourceCollectionIterator
type ScheduledQueryRuleResourceCollectionPage = original.ScheduledQueryRuleResourceCollectionPage
type ScheduledQueryRuleResourcePatch = original.ScheduledQueryRuleResourcePatch
type ScheduledQueryRulesClient = original.ScheduledQueryRulesClient
type ScopedResource = original.ScopedResource
type ScopedResourceListResult = original.ScopedResourceListResult
type ScopedResourceListResultIterator = original.ScopedResourceListResultIterator
type ScopedResourceListResultPage = original.ScopedResourceListResultPage
type ScopedResourceProperties = original.ScopedResourceProperties
type SenderAuthorization = original.SenderAuthorization
type SingleBaseline = original.SingleBaseline
type SingleMetricBaseline = original.SingleMetricBaseline
type SmsReceiver = original.SmsReceiver
type StreamDeclaration = original.StreamDeclaration
type SyslogDataSource = original.SyslogDataSource
type SystemData = original.SystemData
type TagsResource = original.TagsResource
type TenantActivityLogsClient = original.TenantActivityLogsClient
type TestNotificationDetailsResponse = original.TestNotificationDetailsResponse
type ThresholdRuleCondition = original.ThresholdRuleCondition
type TimeSeriesBaseline = original.TimeSeriesBaseline
type TimeSeriesElement = original.TimeSeriesElement
type TimeWindow = original.TimeWindow
type VMInsightsClient = original.VMInsightsClient
type VMInsightsOnboardingStatus = original.VMInsightsOnboardingStatus
type VMInsightsOnboardingStatusProperties = original.VMInsightsOnboardingStatusProperties
type VoiceReceiver = original.VoiceReceiver
type WebhookNotification = original.WebhookNotification
type WebhookReceiver = original.WebhookReceiver
type WebtestLocationAvailabilityCriteria = original.WebtestLocationAvailabilityCriteria
type WindowsEventLogDataSource = original.WindowsEventLogDataSource
type WorkspaceInfo = original.WorkspaceInfo
type WorkspaceInfoProperties = original.WorkspaceInfoProperties

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewActionGroupsClient(subscriptionID string) ActionGroupsClient {
	return original.NewActionGroupsClient(subscriptionID)
}
func NewActionGroupsClientWithBaseURI(baseURI string, subscriptionID string) ActionGroupsClient {
	return original.NewActionGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewActivityLogAlertsClient(subscriptionID string) ActivityLogAlertsClient {
	return original.NewActivityLogAlertsClient(subscriptionID)
}
func NewActivityLogAlertsClientWithBaseURI(baseURI string, subscriptionID string) ActivityLogAlertsClient {
	return original.NewActivityLogAlertsClientWithBaseURI(baseURI, subscriptionID)
}
func NewActivityLogsClient(subscriptionID string) ActivityLogsClient {
	return original.NewActivityLogsClient(subscriptionID)
}
func NewActivityLogsClientWithBaseURI(baseURI string, subscriptionID string) ActivityLogsClient {
	return original.NewActivityLogsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertRuleIncidentsClient(subscriptionID string) AlertRuleIncidentsClient {
	return original.NewAlertRuleIncidentsClient(subscriptionID)
}
func NewAlertRuleIncidentsClientWithBaseURI(baseURI string, subscriptionID string) AlertRuleIncidentsClient {
	return original.NewAlertRuleIncidentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertRuleListIterator(page AlertRuleListPage) AlertRuleListIterator {
	return original.NewAlertRuleListIterator(page)
}
func NewAlertRuleListPage(cur AlertRuleList, getNextPage func(context.Context, AlertRuleList) (AlertRuleList, error)) AlertRuleListPage {
	return original.NewAlertRuleListPage(cur, getNextPage)
}
func NewAlertRulesClient(subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClient(subscriptionID)
}
func NewAlertRulesClientWithBaseURI(baseURI string, subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAutoscaleSettingResourceCollectionIterator(page AutoscaleSettingResourceCollectionPage) AutoscaleSettingResourceCollectionIterator {
	return original.NewAutoscaleSettingResourceCollectionIterator(page)
}
func NewAutoscaleSettingResourceCollectionPage(cur AutoscaleSettingResourceCollection, getNextPage func(context.Context, AutoscaleSettingResourceCollection) (AutoscaleSettingResourceCollection, error)) AutoscaleSettingResourceCollectionPage {
	return original.NewAutoscaleSettingResourceCollectionPage(cur, getNextPage)
}
func NewAutoscaleSettingsClient(subscriptionID string) AutoscaleSettingsClient {
	return original.NewAutoscaleSettingsClient(subscriptionID)
}
func NewAutoscaleSettingsClientWithBaseURI(baseURI string, subscriptionID string) AutoscaleSettingsClient {
	return original.NewAutoscaleSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAzureMonitorPrivateLinkScopeListResultIterator(page AzureMonitorPrivateLinkScopeListResultPage) AzureMonitorPrivateLinkScopeListResultIterator {
	return original.NewAzureMonitorPrivateLinkScopeListResultIterator(page)
}
func NewAzureMonitorPrivateLinkScopeListResultPage(cur AzureMonitorPrivateLinkScopeListResult, getNextPage func(context.Context, AzureMonitorPrivateLinkScopeListResult) (AzureMonitorPrivateLinkScopeListResult, error)) AzureMonitorPrivateLinkScopeListResultPage {
	return original.NewAzureMonitorPrivateLinkScopeListResultPage(cur, getNextPage)
}
func NewBaselinesClient(subscriptionID string) BaselinesClient {
	return original.NewBaselinesClient(subscriptionID)
}
func NewBaselinesClientWithBaseURI(baseURI string, subscriptionID string) BaselinesClient {
	return original.NewBaselinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataCollectionEndpointResourceListResultIterator(page DataCollectionEndpointResourceListResultPage) DataCollectionEndpointResourceListResultIterator {
	return original.NewDataCollectionEndpointResourceListResultIterator(page)
}
func NewDataCollectionEndpointResourceListResultPage(cur DataCollectionEndpointResourceListResult, getNextPage func(context.Context, DataCollectionEndpointResourceListResult) (DataCollectionEndpointResourceListResult, error)) DataCollectionEndpointResourceListResultPage {
	return original.NewDataCollectionEndpointResourceListResultPage(cur, getNextPage)
}
func NewDataCollectionEndpointsClient(subscriptionID string) DataCollectionEndpointsClient {
	return original.NewDataCollectionEndpointsClient(subscriptionID)
}
func NewDataCollectionEndpointsClientWithBaseURI(baseURI string, subscriptionID string) DataCollectionEndpointsClient {
	return original.NewDataCollectionEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataCollectionRuleAssociationProxyOnlyResourceListResultIterator(page DataCollectionRuleAssociationProxyOnlyResourceListResultPage) DataCollectionRuleAssociationProxyOnlyResourceListResultIterator {
	return original.NewDataCollectionRuleAssociationProxyOnlyResourceListResultIterator(page)
}
func NewDataCollectionRuleAssociationProxyOnlyResourceListResultPage(cur DataCollectionRuleAssociationProxyOnlyResourceListResult, getNextPage func(context.Context, DataCollectionRuleAssociationProxyOnlyResourceListResult) (DataCollectionRuleAssociationProxyOnlyResourceListResult, error)) DataCollectionRuleAssociationProxyOnlyResourceListResultPage {
	return original.NewDataCollectionRuleAssociationProxyOnlyResourceListResultPage(cur, getNextPage)
}
func NewDataCollectionRuleAssociationsClient(subscriptionID string) DataCollectionRuleAssociationsClient {
	return original.NewDataCollectionRuleAssociationsClient(subscriptionID)
}
func NewDataCollectionRuleAssociationsClientWithBaseURI(baseURI string, subscriptionID string) DataCollectionRuleAssociationsClient {
	return original.NewDataCollectionRuleAssociationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataCollectionRuleResourceListResultIterator(page DataCollectionRuleResourceListResultPage) DataCollectionRuleResourceListResultIterator {
	return original.NewDataCollectionRuleResourceListResultIterator(page)
}
func NewDataCollectionRuleResourceListResultPage(cur DataCollectionRuleResourceListResult, getNextPage func(context.Context, DataCollectionRuleResourceListResult) (DataCollectionRuleResourceListResult, error)) DataCollectionRuleResourceListResultPage {
	return original.NewDataCollectionRuleResourceListResultPage(cur, getNextPage)
}
func NewDataCollectionRulesClient(subscriptionID string) DataCollectionRulesClient {
	return original.NewDataCollectionRulesClient(subscriptionID)
}
func NewDataCollectionRulesClientWithBaseURI(baseURI string, subscriptionID string) DataCollectionRulesClient {
	return original.NewDataCollectionRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiagnosticSettingsCategoryClient(subscriptionID string) DiagnosticSettingsCategoryClient {
	return original.NewDiagnosticSettingsCategoryClient(subscriptionID)
}
func NewDiagnosticSettingsCategoryClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticSettingsCategoryClient {
	return original.NewDiagnosticSettingsCategoryClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiagnosticSettingsClient(subscriptionID string) DiagnosticSettingsClient {
	return original.NewDiagnosticSettingsClient(subscriptionID)
}
func NewDiagnosticSettingsClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticSettingsClient {
	return original.NewDiagnosticSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEventCategoriesClient(subscriptionID string) EventCategoriesClient {
	return original.NewEventCategoriesClient(subscriptionID)
}
func NewEventCategoriesClientWithBaseURI(baseURI string, subscriptionID string) EventCategoriesClient {
	return original.NewEventCategoriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEventDataCollectionIterator(page EventDataCollectionPage) EventDataCollectionIterator {
	return original.NewEventDataCollectionIterator(page)
}
func NewEventDataCollectionPage(cur EventDataCollection, getNextPage func(context.Context, EventDataCollection) (EventDataCollection, error)) EventDataCollectionPage {
	return original.NewEventDataCollectionPage(cur, getNextPage)
}
func NewLogProfilesClient(subscriptionID string) LogProfilesClient {
	return original.NewLogProfilesClient(subscriptionID)
}
func NewLogProfilesClientWithBaseURI(baseURI string, subscriptionID string) LogProfilesClient {
	return original.NewLogProfilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewMetricAlertsClient(subscriptionID string) MetricAlertsClient {
	return original.NewMetricAlertsClient(subscriptionID)
}
func NewMetricAlertsClientWithBaseURI(baseURI string, subscriptionID string) MetricAlertsClient {
	return original.NewMetricAlertsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMetricAlertsStatusClient(subscriptionID string) MetricAlertsStatusClient {
	return original.NewMetricAlertsStatusClient(subscriptionID)
}
func NewMetricAlertsStatusClientWithBaseURI(baseURI string, subscriptionID string) MetricAlertsStatusClient {
	return original.NewMetricAlertsStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewMetricDefinitionsClient(subscriptionID string) MetricDefinitionsClient {
	return original.NewMetricDefinitionsClient(subscriptionID)
}
func NewMetricDefinitionsClientWithBaseURI(baseURI string, subscriptionID string) MetricDefinitionsClient {
	return original.NewMetricDefinitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMetricNamespacesClient(subscriptionID string) MetricNamespacesClient {
	return original.NewMetricNamespacesClient(subscriptionID)
}
func NewMetricNamespacesClientWithBaseURI(baseURI string, subscriptionID string) MetricNamespacesClient {
	return original.NewMetricNamespacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewMetricsClient(subscriptionID string) MetricsClient {
	return original.NewMetricsClient(subscriptionID)
}
func NewMetricsClientWithBaseURI(baseURI string, subscriptionID string) MetricsClient {
	return original.NewMetricsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPredictiveMetricClient(subscriptionID string) PredictiveMetricClient {
	return original.NewPredictiveMetricClient(subscriptionID)
}
func NewPredictiveMetricClientWithBaseURI(baseURI string, subscriptionID string) PredictiveMetricClient {
	return original.NewPredictiveMetricClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return original.NewPrivateLinkResourceListResultIterator(page)
}
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return original.NewPrivateLinkResourceListResultPage(cur, getNextPage)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkScopeOperationStatusClient(subscriptionID string) PrivateLinkScopeOperationStatusClient {
	return original.NewPrivateLinkScopeOperationStatusClient(subscriptionID)
}
func NewPrivateLinkScopeOperationStatusClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkScopeOperationStatusClient {
	return original.NewPrivateLinkScopeOperationStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkScopedResourcesClient(subscriptionID string) PrivateLinkScopedResourcesClient {
	return original.NewPrivateLinkScopedResourcesClient(subscriptionID)
}
func NewPrivateLinkScopedResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkScopedResourcesClient {
	return original.NewPrivateLinkScopedResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkScopesClient(subscriptionID string) PrivateLinkScopesClient {
	return original.NewPrivateLinkScopesClient(subscriptionID)
}
func NewPrivateLinkScopesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkScopesClient {
	return original.NewPrivateLinkScopesClientWithBaseURI(baseURI, subscriptionID)
}
func NewScheduledQueryRuleResourceCollectionIterator(page ScheduledQueryRuleResourceCollectionPage) ScheduledQueryRuleResourceCollectionIterator {
	return original.NewScheduledQueryRuleResourceCollectionIterator(page)
}
func NewScheduledQueryRuleResourceCollectionPage(cur ScheduledQueryRuleResourceCollection, getNextPage func(context.Context, ScheduledQueryRuleResourceCollection) (ScheduledQueryRuleResourceCollection, error)) ScheduledQueryRuleResourceCollectionPage {
	return original.NewScheduledQueryRuleResourceCollectionPage(cur, getNextPage)
}
func NewScheduledQueryRulesClient(subscriptionID string) ScheduledQueryRulesClient {
	return original.NewScheduledQueryRulesClient(subscriptionID)
}
func NewScheduledQueryRulesClientWithBaseURI(baseURI string, subscriptionID string) ScheduledQueryRulesClient {
	return original.NewScheduledQueryRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewScopedResourceListResultIterator(page ScopedResourceListResultPage) ScopedResourceListResultIterator {
	return original.NewScopedResourceListResultIterator(page)
}
func NewScopedResourceListResultPage(cur ScopedResourceListResult, getNextPage func(context.Context, ScopedResourceListResult) (ScopedResourceListResult, error)) ScopedResourceListResultPage {
	return original.NewScopedResourceListResultPage(cur, getNextPage)
}
func NewTenantActivityLogsClient(subscriptionID string) TenantActivityLogsClient {
	return original.NewTenantActivityLogsClient(subscriptionID)
}
func NewTenantActivityLogsClientWithBaseURI(baseURI string, subscriptionID string) TenantActivityLogsClient {
	return original.NewTenantActivityLogsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVMInsightsClient(subscriptionID string) VMInsightsClient {
	return original.NewVMInsightsClient(subscriptionID)
}
func NewVMInsightsClientWithBaseURI(baseURI string, subscriptionID string) VMInsightsClient {
	return original.NewVMInsightsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAggregationTypeEnumValues() []AggregationTypeEnum {
	return original.PossibleAggregationTypeEnumValues()
}
func PossibleAggregationTypeValues() []AggregationType {
	return original.PossibleAggregationTypeValues()
}
func PossibleBaselineSensitivityValues() []BaselineSensitivity {
	return original.PossibleBaselineSensitivityValues()
}
func PossibleCategoryTypeValues() []CategoryType {
	return original.PossibleCategoryTypeValues()
}
func PossibleComparisonOperationTypeValues() []ComparisonOperationType {
	return original.PossibleComparisonOperationTypeValues()
}
func PossibleConditionOperatorValues() []ConditionOperator {
	return original.PossibleConditionOperatorValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleCriterionTypeValues() []CriterionType {
	return original.PossibleCriterionTypeValues()
}
func PossibleDataStatusValues() []DataStatus {
	return original.PossibleDataStatusValues()
}
func PossibleDimensionOperatorValues() []DimensionOperator {
	return original.PossibleDimensionOperatorValues()
}
func PossibleDynamicThresholdOperatorValues() []DynamicThresholdOperator {
	return original.PossibleDynamicThresholdOperatorValues()
}
func PossibleDynamicThresholdSensitivityValues() []DynamicThresholdSensitivity {
	return original.PossibleDynamicThresholdSensitivityValues()
}
func PossibleEventLevelValues() []EventLevel {
	return original.PossibleEventLevelValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleKnownColumnDefinitionTypeValues() []KnownColumnDefinitionType {
	return original.PossibleKnownColumnDefinitionTypeValues()
}
func PossibleKnownDataCollectionEndpointProvisioningStateValues() []KnownDataCollectionEndpointProvisioningState {
	return original.PossibleKnownDataCollectionEndpointProvisioningStateValues()
}
func PossibleKnownDataCollectionEndpointResourceKindValues() []KnownDataCollectionEndpointResourceKind {
	return original.PossibleKnownDataCollectionEndpointResourceKindValues()
}
func PossibleKnownDataCollectionRuleAssociationProvisioningStateValues() []KnownDataCollectionRuleAssociationProvisioningState {
	return original.PossibleKnownDataCollectionRuleAssociationProvisioningStateValues()
}
func PossibleKnownDataCollectionRuleProvisioningStateValues() []KnownDataCollectionRuleProvisioningState {
	return original.PossibleKnownDataCollectionRuleProvisioningStateValues()
}
func PossibleKnownDataCollectionRuleResourceKindValues() []KnownDataCollectionRuleResourceKind {
	return original.PossibleKnownDataCollectionRuleResourceKindValues()
}
func PossibleKnownDataFlowStreamsValues() []KnownDataFlowStreams {
	return original.PossibleKnownDataFlowStreamsValues()
}
func PossibleKnownExtensionDataSourceStreamsValues() []KnownExtensionDataSourceStreams {
	return original.PossibleKnownExtensionDataSourceStreamsValues()
}
func PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues() []KnownLogFileTextSettingsRecordStartTimestampFormat {
	return original.PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues()
}
func PossibleKnownPerfCounterDataSourceStreamsValues() []KnownPerfCounterDataSourceStreams {
	return original.PossibleKnownPerfCounterDataSourceStreamsValues()
}
func PossibleKnownPublicNetworkAccessOptionsValues() []KnownPublicNetworkAccessOptions {
	return original.PossibleKnownPublicNetworkAccessOptionsValues()
}
func PossibleKnownSyslogDataSourceFacilityNamesValues() []KnownSyslogDataSourceFacilityNames {
	return original.PossibleKnownSyslogDataSourceFacilityNamesValues()
}
func PossibleKnownSyslogDataSourceLogLevelsValues() []KnownSyslogDataSourceLogLevels {
	return original.PossibleKnownSyslogDataSourceLogLevelsValues()
}
func PossibleKnownSyslogDataSourceStreamsValues() []KnownSyslogDataSourceStreams {
	return original.PossibleKnownSyslogDataSourceStreamsValues()
}
func PossibleKnownWindowsEventLogDataSourceStreamsValues() []KnownWindowsEventLogDataSourceStreams {
	return original.PossibleKnownWindowsEventLogDataSourceStreamsValues()
}
func PossibleMetricClassValues() []MetricClass {
	return original.PossibleMetricClassValues()
}
func PossibleMetricStatisticTypeValues() []MetricStatisticType {
	return original.PossibleMetricStatisticTypeValues()
}
func PossibleMetricUnitValues() []MetricUnit {
	return original.PossibleMetricUnitValues()
}
func PossibleNamespaceClassificationValues() []NamespaceClassification {
	return original.PossibleNamespaceClassificationValues()
}
func PossibleOdataTypeBasicMetricAlertCriteriaValues() []OdataTypeBasicMetricAlertCriteria {
	return original.PossibleOdataTypeBasicMetricAlertCriteriaValues()
}
func PossibleOdataTypeBasicRuleActionValues() []OdataTypeBasicRuleAction {
	return original.PossibleOdataTypeBasicRuleActionValues()
}
func PossibleOdataTypeBasicRuleConditionValues() []OdataTypeBasicRuleCondition {
	return original.PossibleOdataTypeBasicRuleConditionValues()
}
func PossibleOdataTypeValues() []OdataType {
	return original.PossibleOdataTypeValues()
}
func PossibleOnboardingStatusValues() []OnboardingStatus {
	return original.PossibleOnboardingStatusValues()
}
func PossibleOperatorForConditionValues() []OperatorForCondition {
	return original.PossibleOperatorForConditionValues()
}
func PossibleOperatorValues() []Operator {
	return original.PossibleOperatorValues()
}
func PossiblePredictiveAutoscalePolicyScaleModeValues() []PredictiveAutoscalePolicyScaleMode {
	return original.PossiblePredictiveAutoscalePolicyScaleModeValues()
}
func PossibleReceiverStatusValues() []ReceiverStatus {
	return original.PossibleReceiverStatusValues()
}
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return original.PossibleRecurrenceFrequencyValues()
}
func PossibleResultTypeValues() []ResultType {
	return original.PossibleResultTypeValues()
}
func PossibleScaleDirectionValues() []ScaleDirection {
	return original.PossibleScaleDirectionValues()
}
func PossibleScaleRuleMetricDimensionOperationTypeValues() []ScaleRuleMetricDimensionOperationType {
	return original.PossibleScaleRuleMetricDimensionOperationTypeValues()
}
func PossibleScaleTypeValues() []ScaleType {
	return original.PossibleScaleTypeValues()
}
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return original.PossibleTimeAggregationOperatorValues()
}
func PossibleTimeAggregationTypeValues() []TimeAggregationType {
	return original.PossibleTimeAggregationTypeValues()
}
func PossibleTimeAggregationValues() []TimeAggregation {
	return original.PossibleTimeAggregationValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
