package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VulnerabilityAssessmentScansClient is the the Azure SQL Database management API provides a RESTful set of web
// services that interact with Azure SQL Database services to manage your databases. The API enables you to create,
// retrieve, update, and delete databases.
type VulnerabilityAssessmentScansClient struct {
	BaseClient
}

// NewVulnerabilityAssessmentScansClient creates an instance of the VulnerabilityAssessmentScansClient client.
func NewVulnerabilityAssessmentScansClient(subscriptionID string) VulnerabilityAssessmentScansClient {
	return NewVulnerabilityAssessmentScansClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVulnerabilityAssessmentScansClientWithBaseURI creates an instance of the VulnerabilityAssessmentScansClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewVulnerabilityAssessmentScansClientWithBaseURI(baseURI string, subscriptionID string) VulnerabilityAssessmentScansClient {
	return VulnerabilityAssessmentScansClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get a system database vulnerability assessment scan record.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
func (client VulnerabilityAssessmentScansClient) Get(ctx context.Context, resourceGroupName string, serverName string, scanID string) (result VulnerabilityAssessmentScanRecordType, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScansClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName, scanID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VulnerabilityAssessmentScansClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string, scanID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":        APIVersion,
		"systemDatabaseName": autorest.Encode("query", "master"),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VulnerabilityAssessmentScansClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VulnerabilityAssessmentScansClient) GetResponder(resp *http.Response) (result VulnerabilityAssessmentScanRecordType, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySQLVulnerabilityAssessments lists the vulnerability assessment scans of a database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
func (client VulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessments(ctx context.Context, resourceGroupName string, serverName string) (result VulnerabilityAssessmentScanRecordListResultTypePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScansClient.ListBySQLVulnerabilityAssessments")
		defer func() {
			sc := -1
			if result.vasrlrt.Response.Response != nil {
				sc = result.vasrlrt.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySQLVulnerabilityAssessmentsNextResults
	req, err := client.ListBySQLVulnerabilityAssessmentsPreparer(ctx, resourceGroupName, serverName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "ListBySQLVulnerabilityAssessments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySQLVulnerabilityAssessmentsSender(req)
	if err != nil {
		result.vasrlrt.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "ListBySQLVulnerabilityAssessments", resp, "Failure sending request")
		return
	}

	result.vasrlrt, err = client.ListBySQLVulnerabilityAssessmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "ListBySQLVulnerabilityAssessments", resp, "Failure responding to request")
		return
	}
	if result.vasrlrt.hasNextLink() && result.vasrlrt.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySQLVulnerabilityAssessmentsPreparer prepares the ListBySQLVulnerabilityAssessments request.
func (client VulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsPreparer(ctx context.Context, resourceGroupName string, serverName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":        APIVersion,
		"systemDatabaseName": autorest.Encode("query", "master"),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySQLVulnerabilityAssessmentsSender sends the ListBySQLVulnerabilityAssessments request. The method will close the
// http.Response Body if it receives an error.
func (client VulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySQLVulnerabilityAssessmentsResponder handles the response to the ListBySQLVulnerabilityAssessments request. The method always
// closes the http.Response Body.
func (client VulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsResponder(resp *http.Response) (result VulnerabilityAssessmentScanRecordListResultType, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySQLVulnerabilityAssessmentsNextResults retrieves the next set of results, if any.
func (client VulnerabilityAssessmentScansClient) listBySQLVulnerabilityAssessmentsNextResults(ctx context.Context, lastResults VulnerabilityAssessmentScanRecordListResultType) (result VulnerabilityAssessmentScanRecordListResultType, err error) {
	req, err := lastResults.vulnerabilityAssessmentScanRecordListResultTypePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "listBySQLVulnerabilityAssessmentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySQLVulnerabilityAssessmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "listBySQLVulnerabilityAssessmentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySQLVulnerabilityAssessmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScansClient", "listBySQLVulnerabilityAssessmentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySQLVulnerabilityAssessmentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client VulnerabilityAssessmentScansClient) ListBySQLVulnerabilityAssessmentsComplete(ctx context.Context, resourceGroupName string, serverName string) (result VulnerabilityAssessmentScanRecordListResultTypeIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScansClient.ListBySQLVulnerabilityAssessments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySQLVulnerabilityAssessments(ctx, resourceGroupName, serverName)
	return
}
