// Code generated by smithy-go-codegen DO NOT EDIT.

package awsrestjson

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This example operation serializes a payload targeting a blob. The Blob shape is
// not structured content and we cannot make assumptions about what data will be
// sent. This test ensures only a generic "Content-Type: application/octet-stream"
// header is used, and that we are not treating an empty body as an empty JSON
// document.
func (c *Client) TestPayloadBlob(ctx context.Context, params *TestPayloadBlobInput, optFns ...func(*Options)) (*TestPayloadBlobOutput, error) {
	if params == nil {
		params = &TestPayloadBlobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TestPayloadBlob", params, optFns, c.addOperationTestPayloadBlobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TestPayloadBlobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TestPayloadBlobInput struct {
	ContentType *string

	Data []byte

	noSmithyDocumentSerde
}

type TestPayloadBlobOutput struct {
	ContentType *string

	Data []byte

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTestPayloadBlobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpTestPayloadBlob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpTestPayloadBlob{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTestPayloadBlob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTestPayloadBlob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TestPayloadBlob",
	}
}
