// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package cmd

import (
	"fmt"
	"sort"

	filesystem_options "code.forgejo.org/f3/gof3/v3/forges/filesystem/options"
	"code.forgejo.org/f3/gof3/v3/options"

	"github.com/urfave/cli/v3"
)

func ForgeTypeOption(direction string) string {
	return direction + "-type"
}

func GetFlagsCommon(prefix, category string) []cli.Flag {
	flags := make([]cli.Flag, 0, 10)

	forgeTypes := make([]string, 0, 10)
	for name := range options.GetFactories() {
		forgeTypes = append(forgeTypes, name)
	}
	sort.Strings(forgeTypes)
	values := &enumType{
		Enum:    forgeTypes,
		Default: filesystem_options.Name,
	}

	flags = append(flags, &cli.GenericFlag{
		Name:        ForgeTypeOption(prefix),
		Usage:       fmt.Sprintf("`TYPE` of the %s forge", prefix),
		Value:       values,
		DefaultText: values.GetDefaultText(),
		Category:    prefix,
	})

	flags = append(flags, &cli.StringFlag{
		Name:     BuildForgePrefix(prefix, "path"),
		Usage:    "resource to mirror (e.g. /forge/users/myuser/projects/myproject)",
		Category: prefix,
	})

	return flags
}
