/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(sig_source.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(43a7b6efe653f8ebf2285ea5732b4c81)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/analog/sig_source.h>

template <typename T>
void bind_sig_source_template(py::module& m, const char* classname)
{
    using sig_source = gr::analog::sig_source<T>;

    py::class_<sig_source,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<sig_source>>(m, classname)
        .def(py::init(&gr::analog::sig_source<T>::make),
             py::arg("sampling_freq"),
             py::arg("waveform"),
             py::arg("wave_freq"),
             py::arg("ampl"),
             py::arg("offset") = 0,
             py::arg("phase") = 0)
        .def("sampling_freq", &sig_source::sampling_freq)
        .def("waveform", &sig_source::waveform)
        .def("frequency", &sig_source::frequency)
        .def("amplitude", &sig_source::amplitude)
        .def("offset", &sig_source::offset)
        .def("phase", &sig_source::phase)

        .def(
            "set_sampling_freq", &sig_source::set_sampling_freq, py::arg("sampling_freq"))
        .def("set_waveform", &sig_source::set_waveform, py::arg("waveform"))
        .def("set_frequency", &sig_source::set_frequency, py::arg("frequency"))
        .def("set_amplitude", &sig_source::set_amplitude, py::arg("amplitude"))
        .def("set_offset", &sig_source::set_offset, py::arg("offset"))
        .def("set_phase", &sig_source::set_phase, py::arg("phase"));
}

void bind_sig_source(py::module& m)
{
    bind_sig_source_template<std::int8_t>(m, "sig_source_b");
    bind_sig_source_template<std::int16_t>(m, "sig_source_s");
    bind_sig_source_template<std::int32_t>(m, "sig_source_i");
    bind_sig_source_template<float>(m, "sig_source_f");
    bind_sig_source_template<gr_complex>(m, "sig_source_c");
}
