#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "パッチ 1.0.1.0が適用されていません"},
    {TR_NO_PATCH_MESSAGE,
        "インストールされているCaesar 3にパッチ1.0.1.0が適用されていません。 パッチはこちらからダウンロードできます:\n"
        URL_PATCHES "\n"
        "続行される場合は自己責任でお願いします。"},
    // Do not translate the following message since it cannot be shown in Japanese:
    {TR_MISSING_FONTS_TITLE, "Missing fonts"},
    {TR_MISSING_FONTS_MESSAGE,
        "Your Caesar 3 installation requires extra font files. "
        "You can download them for your language from:\n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "エディターがありません"},
    {TR_NO_EDITOR_MESSAGE,
        "インストールされているCaesar 3にエディターファイルがありません。 ファイルはこちらからダウンロードできます:\n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "不正な言語ディレクトリ"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "選択されたディレクトリには有効な言語パックがありません。 ログでエラー詳細をご確認ください。"},
    {TR_BUILD_ALL_TEMPLES, "すべて"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "キャンセル"},
    {TR_BUTTON_RESET_DEFAULTS, "デフォルトに戻す"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "ホットキーを変更"},
    {TR_CONFIG_TITLE, "Julius コンフィグ設定"},
    {TR_CONFIG_LANGUAGE_LABEL, "言語:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(デフォルト)"},
    {TR_CONFIG_DISPLAY_SCALE, "画面スケール:"},
    {TR_CONFIG_CURSOR_SCALE, "カーソルスケール:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "UI設定"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "ゲームプレイ設定"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "イントロビデオを再生"},
    {TR_CONFIG_SIDEBAR_INFO, "コントロールパネルに追加情報を表示"},
    {TR_CONFIG_SMOOTH_SCROLLING, "スムーズなスクロールを有効化"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "画面端へカーソル移動時のスクロールを無効化"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "右クリックによるマップのドラッグを無効化"},
    {TR_CONFIG_INVERSE_RIGHT_CLICK_MAP_DRAG, "マウスの右ボタンでマップを逆方向にドラッグ"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "整地時のビジュアル演出を改善"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "神殿の連続建設を許可"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "貯水場、噴水、井戸の建築時に範囲を表示"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "ドラッグ可能な建設サイズを表示"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "カーソルを合わせた軍団をハイライト"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "軍事サイドバーを有効化"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "「とても難しい」難易度の移民バグを修正"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "100歳の幽霊バグを修正"},
    {TR_HOTKEY_TITLE, "Julius ホットキー設定"},
    {TR_HOTKEY_LABEL, "ホットキーを変更"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "代替"},
    {TR_HOTKEY_HEADER_ARROWS, "矢印キー"},
    {TR_HOTKEY_HEADER_GLOBAL, "グローバルホットキー"},
    {TR_HOTKEY_HEADER_CITY, "都市ホットキー"},
    {TR_HOTKEY_HEADER_ADVISORS, "顧問"},
    {TR_HOTKEY_HEADER_OVERLAYS, "オーバーレイ"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "都市マップのブックマーク"},
    {TR_HOTKEY_HEADER_EDITOR, "エディターがありません"},
    {TR_HOTKEY_HEADER_BUILD, "建設ホットキー"},
    {TR_HOTKEY_ARROW_UP, "上"},
    {TR_HOTKEY_ARROW_DOWN, "下"},
    {TR_HOTKEY_ARROW_LEFT, "左"},
    {TR_HOTKEY_ARROW_RIGHT, "右"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "フルスクリーン切替"},
    {TR_HOTKEY_CENTER_WINDOW, "ウィンドウを中央へ移動"},
    {TR_HOTKEY_RESIZE_TO_640, "ウィンドウを640x480にリサイズ"},
    {TR_HOTKEY_RESIZE_TO_800, "ウィンドウを800x600にリサイズ"},
    {TR_HOTKEY_RESIZE_TO_1024, "ウィンドウを1024x768にリサイズ"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "スクリーンショットを保存"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "都市全体図のｽｸﾘｰﾝｼｮｯﾄを保存"},
    {TR_HOTKEY_BUILD_CLONE, "カーソル下の施設をクローン"},
    {TR_HOTKEY_LOAD_FILE, "ファイルをロード"},
    {TR_HOTKEY_SAVE_FILE, "ファイルをセーブ"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "ゲーム速度を上げる"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "ゲーム速度を下げる"},
    {TR_HOTKEY_TOGGLE_PAUSE, "ポーズ切替"},
    {TR_HOTKEY_CYCLE_LEGION, "軍団をサイクル選択"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "マップを左回転"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "マップを右回転"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "労働顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "軍事顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "皇帝顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "レーティング顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "交易顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "人口顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "健康顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "教育顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "娯楽顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "宗教顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "財務顧問"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "主任顧問"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "現在のオーバーレイを切替"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "水のオーバーレイを表示"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "火のオーバーレイを表示"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "ダメージオーバーレイ"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "犯罪オーバーレイ"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "問題オーバーレイ"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "ブックマーク1へ移動"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "ブックマーク2へ移動"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "ブックマーク3へ移動"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "ブックマーク4へ移動"},
    {TR_HOTKEY_SET_BOOKMARK_1, "ブックマーク1を設定"},
    {TR_HOTKEY_SET_BOOKMARK_2, "ブックマーク2を設定"},
    {TR_HOTKEY_SET_BOOKMARK_3, "ブックマーク3を設定"},
    {TR_HOTKEY_SET_BOOKMARK_4, "ブックマーク4を設定"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "戦闘情報の切替"},
    {TR_HOTKEY_EDIT_TITLE, "新しいホットキーを押してください"},
    {TR_HOTKEY_DUPLICATE_TITLE, "ホットキーは使用中です"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "このキー操作は次の操作に割り当てられています:"},
    {TR_WARNING_SCREENSHOT_SAVED, "保存したスクリーンショット： "}, // TODO: Google translate
};

void translation_japanese(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
