/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.util.PropertyValidator;

public class Available
extends Component {
    private static final long serialVersionUID = -2494710612002978763L;

    public Available() {
        super("AVAILABLE");
    }

    public Available(PropertyList properties) {
        super("AVAILABLE", properties);
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        DtStart start = (DtStart)this.getProperty("DTSTART");
        if (Value.DATE.equals(start.getParameter("VALUE"))) {
            throw new ValidationException("Property [DTSTART] must be a " + Value.DATE_TIME);
        }
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RRULE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        if (this.getProperty("DTEND") != null) {
            PropertyValidator.getInstance().assertOne("DTEND", this.getProperties());
            DtEnd end = (DtEnd)this.getProperty("DTEND");
            if (Value.DATE.equals(end.getParameter("VALUE"))) {
                throw new ValidationException("Property [DTEND] must be a " + Value.DATE_TIME);
            }
        } else {
            PropertyValidator.getInstance().assertOne("DURATION", this.getProperties());
        }
        if (recurse) {
            this.validateProperties();
        }
    }
}

