/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.applet;

import CH.ifa.draw.applet.SleeperThread;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandButton;
import CH.ifa.draw.util.CommandChoice;
import CH.ifa.draw.util.Filler;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteLayout;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.StorableInput;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.StringTokenizer;

public class DrawApplet
extends Applet
implements DrawingEditor,
PaletteListener {
    private transient Drawing fDrawing;
    private transient Tool fTool;
    private transient StandardDrawingView fView;
    private transient ToolButton fDefaultToolButton;
    private transient ToolButton fSelectedToolButton;
    private transient boolean fSimpleUpdate;
    private transient Button fUpdateButton;
    private transient Choice fFrameColor;
    private transient Choice fFillColor;
    private transient Choice fArrowChoice;
    private transient Choice fFontChoice;
    private transient Thread fSleeper;
    private Iconkit fIconkit;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";

    public void init() {
        this.fIconkit = new Iconkit(this);
        this.setLayout(new BorderLayout());
        this.fView = this.createDrawingView();
        Panel panel = this.createAttributesPanel();
        this.createAttributeChoices(panel);
        this.add("North", panel);
        Panel panel2 = this.createToolPalette();
        this.createTools(panel2);
        this.add("West", panel2);
        this.add("Center", this.fView);
        Panel panel3 = this.createButtonPanel();
        this.createButtons(panel3);
        this.add("South", panel3);
        this.initDrawing();
        this.setBufferedDisplayUpdate();
        this.setupAttributes();
    }

    protected Panel createAttributesPanel() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void createAttributeChoices(Panel panel) {
        panel.add(new Label("Fill"));
        this.fFillColor = this.createColorChoice("FillColor");
        panel.add(this.fFillColor);
        panel.add(new Label("Pen"));
        this.fFrameColor = this.createColorChoice("FrameColor");
        panel.add(this.fFrameColor);
        panel.add(new Label("Arrow"));
        CommandChoice commandChoice = new CommandChoice();
        this.fArrowChoice = commandChoice;
        commandChoice.addItem(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.fView));
        commandChoice.addItem(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.fView));
        commandChoice.addItem(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.fView));
        commandChoice.addItem(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3), this.fView));
        panel.add(this.fArrowChoice);
        panel.add(new Label("Font"));
        this.fFontChoice = this.createFontChoice();
        panel.add(this.fFontChoice);
    }

    protected Choice createColorChoice(String string) {
        CommandChoice commandChoice = new CommandChoice();
        ColorMap colorMap = ColorMap.getColorMap();
        for (int i = 0; i < colorMap.size(); ++i) {
            commandChoice.addItem(new ChangeAttributeCommand(colorMap.name(i), string, colorMap.color(i), this.fView));
        }
        return commandChoice;
    }

    protected Choice createFontChoice() {
        CommandChoice commandChoice = new CommandChoice();
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < stringArray.length; ++i) {
            commandChoice.addItem(new ChangeAttributeCommand(stringArray[i], "FontName", stringArray[i], this.fView));
        }
        return commandChoice;
    }

    protected Panel createButtonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void createButtons(Panel panel) {
        panel.add(new Filler(24, 20));
        Choice choice = new Choice();
        choice.addItem(fgUntitled);
        String string = this.getParameter("DRAWINGS");
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            choice.addItem(stringTokenizer.nextToken());
        }
        if (choice.getItemCount() > 1) {
            panel.add(choice);
        } else {
            panel.add(new Label(fgUntitled));
        }
        choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DrawApplet.this.loadDrawing((String)itemEvent.getItem());
                }
            }
        });
        panel.add(new Filler(6, 20));
        Button button = new CommandButton(new DeleteCommand("Delete", this.fView));
        panel.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this.fView));
        panel.add(button);
        button = new CommandButton(new GroupCommand("Group", this.fView));
        panel.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this.fView));
        panel.add(button);
        button = new Button("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawApplet.this.showHelp();
            }
        });
        panel.add(button);
        this.fUpdateButton = new Button("Simple Update");
        this.fUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawApplet.this.fSimpleUpdate) {
                    DrawApplet.this.setBufferedDisplayUpdate();
                } else {
                    DrawApplet.this.setSimpleDisplayUpdate();
                }
            }
        });
    }

    protected Panel createToolPalette() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2)));
        return panel;
    }

    protected void createTools(Panel panel) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        panel.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this.view());
    }

    protected ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton(this, string, string2, tool);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected StandardDrawingView createDrawingView() {
        return new StandardDrawingView(this, 410, 370);
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        ToolButton toolButton = (ToolButton)paletteButton;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean bl) {
        if (bl) {
            this.showStatus(((ToolButton)paletteButton).name());
        } else {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    public void toolDone() {
        this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
        this.setSelected(this.fDefaultToolButton);
    }

    public void selectionChanged(DrawingView drawingView) {
        this.setupAttributes();
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.fView.setDrawing(this.fDrawing);
        this.toolDone();
    }

    private void setTool(Tool tool, String string) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = tool;
        if (this.fTool != null) {
            this.showStatus(string);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton toolButton) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = toolButton;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    protected void loadDrawing(String string) {
        if (string == fgUntitled) {
            this.fDrawing.release();
            this.initDrawing();
            return;
        }
        String string2 = this.getParameter(string);
        if (string2 != null) {
            this.readDrawing(string2);
        }
    }

    private void readDrawing(String string) {
        this.toolDone();
        String string2 = this.guessType(string);
        if (string2.equals("storable")) {
            this.readFromStorableInput(string);
        } else if (string2.equals("serialized")) {
            this.readFromObjectInput(string);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String string) {
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            InputStream inputStream = uRL.openStream();
            StorableInput storableInput = new StorableInput(inputStream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)storableInput.readStorable();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException iOException) {
            this.initDrawing();
            this.showStatus("Error:" + iOException);
        }
    }

    private void readFromObjectInput(String string) {
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)objectInputStream.readObject();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException iOException) {
            this.initDrawing();
            this.showStatus("Error: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.initDrawing();
            this.showStatus("Class not found: " + classNotFoundException);
        }
    }

    private String guessType(String string) {
        if (string.endsWith(".draw")) {
            return "storable";
        }
        if (string.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    private void setupAttributes() {
        Color color = (Color)AttributeFigure.getDefaultAttribute("FrameColor");
        Color color2 = (Color)AttributeFigure.getDefaultAttribute("FillColor");
        Color color3 = (Color)AttributeFigure.getDefaultAttribute("TextColor");
        Integer n = (Integer)AttributeFigure.getDefaultAttribute("ArrowMode");
        String string = (String)AttributeFigure.getDefaultAttribute("FontName");
        FigureEnumeration figureEnumeration = this.fView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            color = (Color)figure.getAttribute("FrameColor");
            color2 = (Color)figure.getAttribute("FillColor");
            color3 = (Color)figure.getAttribute("TextColor");
            n = (Integer)figure.getAttribute("ArrowMode");
            string = (String)figure.getAttribute("FontName");
        }
        this.fFrameColor.select(ColorMap.getColorMap().colorIndex(color));
        this.fFillColor.select(ColorMap.getColorMap().colorIndex(color2));
        if (n != null) {
            this.fArrowChoice.select(n);
        }
        if (string != null) {
            this.fFontChoice.select(string);
        }
    }

    protected void setSimpleDisplayUpdate() {
        this.fView.setDisplayUpdate(new SimpleUpdateStrategy());
        this.fUpdateButton.setLabel("Simple Update");
        this.fSimpleUpdate = true;
    }

    protected void setBufferedDisplayUpdate() {
        this.fView.setDisplayUpdate(new BufferedUpdateStrategy());
        this.fUpdateButton.setLabel("Buffered Update");
        this.fSimpleUpdate = false;
    }

    protected void showHelp() {
        try {
            String string = this.getClass().getName().replace('.', '/');
            URL uRL = new URL(this.getCodeBase(), string + "Help.html");
            this.getAppletContext().showDocument(uRL, "Help");
        }
        catch (IOException iOException) {
            this.showStatus("Help file not found");
        }
    }

    private void startSleeper() {
        if (this.fSleeper == null) {
            this.fSleeper = new SleeperThread(this);
        }
        this.fSleeper.start();
    }

    private void stopSleeper() {
        if (this.fSleeper != null) {
            this.fSleeper.stop();
        }
    }
}

