/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.PopupListenerHandler;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class PopupJTreeAction
extends AbstractAction {
    private final JPanel panel;
    private final JTree tree;
    private final JButton button;
    private final List<Class<?>> validSelectionClasses;
    private PopupListenerHandler popupListenerHandler;
    private final TreeSelectionListener treeListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path != null) {
                Object node = path.getLastPathComponent();
                for (Class c : PopupJTreeAction.this.validSelectionClasses) {
                    if (!c.isAssignableFrom(node.getClass())) continue;
                    PopupJTreeAction.this.popupCleanup();
                    break;
                }
            }
        }
    };

    public PopupJTreeAction(JPanel panel, JTree tree, JButton button, Class<?> validSelectionClass) {
        this(panel, tree, button, validSelectionClass == null ? Collections.emptyList() : Collections.singletonList(validSelectionClass));
    }

    public PopupJTreeAction(JPanel panel, JTree tree, JButton button, List<Class<?>> validSelectionClasses) {
        this.panel = panel;
        this.tree = tree;
        this.button = button;
        this.validSelectionClasses = Collections.unmodifiableList(new ArrayList(validSelectionClasses));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.popupListenerHandler != null && this.popupListenerHandler.isPopupVisible()) {
            this.popupCleanup();
        } else {
            Point windowLocation = new Point(0, 0);
            SwingUtilities.convertPointToScreen(windowLocation, this.button);
            windowLocation.y += this.button.getHeight();
            this.popupListenerHandler = SPSUtils.popupComponent(this.panel, this.tree, windowLocation);
            this.popupConnect();
        }
    }

    private void popupConnect() {
        if (this.popupListenerHandler != null) {
            this.popupListenerHandler.connect();
        }
        if (this.tree != null) {
            this.tree.addTreeSelectionListener(this.treeListener);
        }
    }

    private void popupCleanup() {
        if (this.popupListenerHandler != null && this.popupListenerHandler.isPopupVisible()) {
            this.popupListenerHandler.cleanup();
        }
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this.treeListener);
        }
    }
}

