# Community Guidelines and Code of Conduct

We want to keep the Puppet communities awesome, and we need your help to keep it
that way. While we have specific guidelines for various tools (see links below),
in general, you should:

* **Be nice**: Be courteous, respectful and polite to fellow community members. No
  offensive comments related to gender, gender identity or expression, sexual
  orientation, disability, physical appearance, body size, race, religion; no
  sexual images in public spaces, real or implied violence, intimidation,
  oppression, stalking, following, harassing photography or recording, sustained
  disruption of talks or other events, inappropriate physical contact, doxxing, or
  unwelcome sexual attention will be tolerated. We like nice people way better
  than mean ones!
* **Encourage diversity and participation**: Make everyone in our community feel
  welcome, regardless of their background, and do everything possible to encourage
  participation in our community.
* **Focus on constructive criticisms**: When offering suggestions, whether in online
  discussions or as comments on a pull request, you should always use welcoming
  and inclusive language. Be respectful of differing viewpoints and the fact that
  others may not have the same experiences you do. Offer suggestions for
  improvement, rather than focusing on mistakes. When others critique your work or
  ideas, gracefully accept the criticisms and default to assuming good intentions.
* **Keep it legal**: Basically, don't get us in trouble. Share only content that you
  own, do not share private or sensitive information, and don't break the law.
* **Stay on topic**: Keep conversation in a thread on topic, whether that's a pull
  request or a Slack conversation or anything else. Make sure that you are posting
  to the correct channel and remember that nobody likes spam.

## Guideline violations --- 3 strikes method

The point of this section is not to find opportunities to punish people, but we
do need a fair way to deal with people who do harm to our community. Extreme
violations of a threatening, abusive, destructive, or illegal nature will be
addressed immediately and are not subject to 3 strikes.

* First occurrence: We'll give you a friendly, but public, reminder that the
  behavior is inappropriate according to our guidelines.
* Second occurrence: We'll send you a private message with a warning that any
  additional violations will result in removal from the community.
* Third occurrence: Depending on the violation, we might need to delete or ban
  your account.

Notes:

* Obvious spammers are banned on first occurrence. If we don’t do this, we’ll
  have spam all over the place.
* Violations are forgiven after 6 months of good behavior, and we won’t hold a grudge.
* People who are committing minor formatting / style infractions will get some
  education, rather than hammering them in the 3 strikes process.

Contact conduct@puppet.com to report abuse or appeal violations. This email list
goes to Kara Sowles (kara at puppet.com) and Katie Abbott (katie dot abbott at
puppet.com). In the case of appeals, we know that mistakes happen, and we’ll
work with you to come up with a fair solution if there has been a
misunderstanding.

## Full text

See our [full community guidelines](https://puppet.com/community/community-guidelines),
covering Slack, IRC, events and other forms of community participation.

## Credits

Credit to [01.org](https://01.org/community/participation-guidelines) and
[meego.com](http://wiki.meego.com/Community_guidelines), since they formed the
starting point for many of these guidelines.

The Event Code of Conduct is based on the [example policy from the Geek Feminism wiki](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment),
created by the Ada Initiative and other volunteers. The [PyCon Code of Conduct](https://github.com/python/pycon-code-of-conduct) also served as inspiration.
