/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.map.HashIndex;

public class BaseHashMap {
    boolean isIntKey;
    boolean isLongKey;
    boolean isObjectKey;
    boolean isNoValue;
    boolean isIntValue;
    boolean isLongValue;
    boolean isObjectValue;
    protected boolean isTwoObjectValue;
    protected boolean isList;
    protected boolean isAccessCount;
    protected boolean isLastAccessCount;
    private ValuesIterator valuesIterator;
    protected HashIndex hashIndex;
    protected int[] intKeyTable;
    protected Object[] objectKeyTable;
    protected long[] longKeyTable;
    protected int[] intValueTable;
    protected Object[] objectValueTable;
    protected long[] longValueTable;
    protected int accessMin;
    protected int accessCount;
    protected int[] accessTable;
    protected boolean[] multiValueTable;
    protected Object[] objectValueTable2;
    final float loadFactor;
    final int initialCapacity;
    int threshold;
    protected int maxCapacity;
    protected int purgePolicy = 0;
    protected boolean minimizeOnEmpty;
    protected ObjectComparator comparator;
    boolean hasZeroKey;
    int zeroKeyIndex = -1;
    protected static final int noKeyOrValue = 0;
    protected static final int intKeyOrValue = 1;
    protected static final int longKeyOrValue = 2;
    protected static final int objectKeyOrValue = 3;
    protected static final int NO_PURGE = 0;
    protected static final int PURGE_ALL = 1;
    protected static final int PURGE_HALF = 2;
    public static final int ACCESS_MAX = 0x7FEFFFFF;
    public static final Object[] emptyObjectArray = new Object[0];

    protected BaseHashMap(int n, int n2, int n3, boolean bl) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n < 3) {
            n = 3;
        }
        this.loadFactor = 1.0f;
        this.initialCapacity = n;
        this.threshold = n;
        int n4 = (int)((float)n * this.loadFactor);
        if (n4 < 3) {
            n4 = 3;
        }
        this.hashIndex = new HashIndex(n4, n, true);
        int n5 = this.threshold;
        if (n2 == 1) {
            this.isIntKey = true;
            this.intKeyTable = new int[n5];
        } else if (n2 == 3) {
            this.isObjectKey = true;
            this.objectKeyTable = new Object[n5];
        } else {
            this.isLongKey = true;
            this.longKeyTable = new long[n5];
        }
        if (n3 == 1) {
            this.isIntValue = true;
            this.intValueTable = new int[n5];
        } else if (n3 == 3) {
            this.isObjectValue = true;
            this.objectValueTable = new Object[n5];
        } else if (n3 == 2) {
            this.isLongValue = true;
            this.longValueTable = new long[n5];
        } else {
            this.isNoValue = true;
        }
        this.isLastAccessCount = bl;
        if (bl) {
            this.accessTable = new int[n5];
        }
    }

    protected int getLookup(Object object, int n) {
        Object object2;
        int n2 = this.hashIndex.getLookup(n);
        while (n2 >= 0 && !object.equals(object2 = this.objectKeyTable[n2])) {
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected int getLookup(int n) {
        int n2;
        int n3 = this.hashIndex.getLookup(n);
        while (n3 >= 0 && n != (n2 = this.intKeyTable[n3])) {
            n3 = this.hashIndex.linkTable[n3];
        }
        return n3;
    }

    protected int getLookup(long l) {
        long l2;
        int n = this.hashIndex.getLookup((int)l);
        while (n >= 0 && l != (l2 = this.longKeyTable[n])) {
            n = this.hashIndex.getNextLookup(n);
        }
        return n;
    }

    protected int getObjectLookup(long l) {
        long l2;
        int n = this.hashIndex.getLookup((int)l);
        while (n >= 0 && (l2 = this.comparator.longKey(this.objectKeyTable[n])) != l) {
            n = this.hashIndex.getNextLookup(n);
        }
        return n;
    }

    protected Iterator getValuesIterator(Object object, int n) {
        int n2 = this.getLookup(object, n);
        if (this.valuesIterator == null) {
            this.valuesIterator = new ValuesIterator();
        }
        this.valuesIterator.reset(object, n2);
        return this.valuesIterator;
    }

    protected int valueCount(Object object, int n) {
        int n2 = this.getLookup(object, n);
        if (n2 == -1) {
            return 0;
        }
        int n3 = 1;
        while ((n2 = this.hashIndex.getNextLookup(n2)) != -1) {
            if (!this.objectKeyTable[n2].equals(object)) continue;
            ++n3;
        }
        return n3;
    }

    protected Object addOrRemove(long l, long l2, Object object, Object object2, boolean bl) {
        int n = (int)l;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n = this.comparator == null ? object.hashCode() : this.comparator.hashCode(object);
        }
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object3 = null;
        while (n3 >= 0 && !(this.isObjectKey ? (this.comparator == null ? this.objectKeyTable[n3].equals(object) : this.comparator.compare(this.objectKeyTable[n3], object) == 0) : (this.isIntKey ? l == (long)this.intKeyTable[n3] : this.isLongKey && l == this.longKeyTable[n3]))) {
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (n3 >= 0) {
            if (bl) {
                if (this.isObjectKey) {
                    this.objectKeyTable[n3] = null;
                } else {
                    if (l == 0L) {
                        this.hasZeroKey = false;
                        this.zeroKeyIndex = -1;
                    }
                    if (this.isIntKey) {
                        this.intKeyTable[n3] = 0;
                    } else {
                        this.longKeyTable[n3] = 0L;
                    }
                }
                if (this.isObjectValue) {
                    object3 = this.objectValueTable[n3];
                    this.objectValueTable[n3] = null;
                } else if (this.isIntValue) {
                    this.intValueTable[n3] = 0;
                } else if (this.isLongValue) {
                    this.longValueTable[n3] = 0L;
                }
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.accessTable != null) {
                    this.accessTable[n3] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
                return object3;
            }
            if (this.isObjectKey) {
                object3 = this.objectKeyTable[n3];
            }
            if (this.isObjectValue) {
                object3 = this.objectValueTable[n3];
                this.objectValueTable[n3] = object2;
            } else if (this.isIntValue) {
                this.intValueTable[n3] = (int)l2;
            } else if (this.isLongValue) {
                this.longValueTable[n3] = l2;
            }
            if (this.isLastAccessCount) {
                this.accessTable[n3] = ++this.accessCount;
            } else if (this.isAccessCount) {
                int n5 = n3;
                this.accessTable[n5] = this.accessTable[n5] + 1;
            }
            return object3;
        }
        if (bl) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(l, l2, object, object2, bl);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        if (this.isObjectKey) {
            this.objectKeyTable[n3] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n3] = (int)l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n3] = l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[n3] = object2;
        } else if (this.isIntValue) {
            this.intValueTable[n3] = (int)l2;
        } else if (this.isLongValue) {
            this.longValueTable[n3] = l2;
        }
        if (this.isLastAccessCount) {
            this.accessTable[n3] = ++this.accessCount;
        } else if (this.isAccessCount) {
            this.accessTable[n3] = 1;
        }
        return object3;
    }

    protected Object addOrRemoveMultiVal(long l, long l2, Object object, Object object2, boolean bl, boolean bl2) {
        int n = (int)l;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n = this.comparator == null ? object.hashCode() : this.comparator.hashCode(object);
        }
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object3 = null;
        boolean bl3 = false;
        while (n3 >= 0) {
            if (this.isObjectKey) {
                if (this.comparator == null ? this.objectKeyTable[n3].equals(object) : this.comparator.compare(this.objectKeyTable[n3], object) == 0) {
                    if (bl) {
                        do {
                            this.objectKeyTable[n3] = null;
                            object3 = this.objectValueTable[n3];
                            this.objectValueTable[n3] = null;
                            this.hashIndex.unlinkNode(n2, n4, n3);
                            this.multiValueTable[n3] = false;
                        } while ((n3 = this.hashIndex.hashTable[n2]) >= 0 && this.objectKeyTable[n3].equals(object));
                        return object3;
                    }
                    if (this.objectValueTable[n3].equals(object2)) {
                        if (bl2) {
                            this.objectKeyTable[n3] = null;
                            object3 = this.objectValueTable[n3];
                            this.objectValueTable[n3] = null;
                            this.hashIndex.unlinkNode(n2, n4, n3);
                            this.multiValueTable[n3] = false;
                            n3 = n4;
                            return object3;
                        }
                        return this.objectValueTable[n3];
                    }
                    bl3 = true;
                }
            } else if (this.isIntKey) {
                if (l == (long)this.intKeyTable[n3]) {
                    if (bl) {
                        do {
                            if (l == 0L) {
                                this.hasZeroKey = false;
                                this.zeroKeyIndex = -1;
                            }
                            this.intKeyTable[n3] = 0;
                            this.intValueTable[n3] = 0;
                            this.hashIndex.unlinkNode(n2, n4, n3);
                            this.multiValueTable[n3] = false;
                        } while ((n3 = this.hashIndex.hashTable[n2]) >= 0 && l == (long)this.intKeyTable[n3]);
                        return null;
                    }
                    if ((long)this.intValueTable[n3] == l2) {
                        return null;
                    }
                    bl3 = true;
                }
            } else if (this.isLongKey && l == this.longKeyTable[n3]) {
                if (bl) {
                    do {
                        if (l == 0L) {
                            this.hasZeroKey = false;
                            this.zeroKeyIndex = -1;
                        }
                        this.longKeyTable[n3] = 0L;
                        this.longValueTable[n3] = 0L;
                        this.hashIndex.unlinkNode(n2, n4, n3);
                        this.multiValueTable[n3] = false;
                    } while ((n3 = this.hashIndex.hashTable[n2]) >= 0 && l == this.longKeyTable[n3]);
                    return null;
                }
                if ((long)this.intValueTable[n3] == l2) {
                    return null;
                }
                bl3 = true;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (bl || bl2) {
            return object3;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemoveMultiVal(l, l2, object, object2, bl, bl2);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        if (this.isObjectKey) {
            this.objectKeyTable[n3] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n3] = (int)l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n3] = l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[n3] = object2;
        } else if (this.isIntValue) {
            this.intValueTable[n3] = (int)l2;
        } else if (this.isLongValue) {
            this.longValueTable[n3] = l2;
        }
        if (bl3) {
            this.multiValueTable[n3] = true;
        }
        if (this.isLastAccessCount) {
            this.accessTable[n3] = ++this.accessCount;
        } else if (this.isAccessCount) {
            this.accessTable[n3] = 1;
        }
        return object3;
    }

    protected Object addOrRemove(long l, Object object, Object object2, boolean bl) {
        int n = (int)l;
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object3 = null;
        while (n3 >= 0 && !(this.isIntKey ? l == (long)this.intKeyTable[n3] : l == this.longKeyTable[n3])) {
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (n3 >= 0) {
            if (bl) {
                if (l == 0L) {
                    this.hasZeroKey = false;
                    this.zeroKeyIndex = -1;
                }
                if (this.isIntKey) {
                    this.intKeyTable[n3] = 0;
                } else {
                    this.longKeyTable[n3] = 0L;
                }
                object3 = this.objectValueTable[n3];
                this.objectValueTable[n3] = null;
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.isTwoObjectValue) {
                    this.objectKeyTable[n3] = null;
                }
                if (this.accessTable != null) {
                    this.accessTable[n3] = 0;
                }
                return object3;
            }
            if (this.isObjectValue) {
                object3 = this.objectValueTable[n3];
                this.objectValueTable[n3] = object;
            }
            if (this.isTwoObjectValue) {
                this.objectKeyTable[n3] = object2;
            }
            if (this.isLastAccessCount) {
                this.accessTable[n3] = ++this.accessCount;
            } else if (this.isAccessCount) {
                int n5 = n3;
                this.accessTable[n5] = this.accessTable[n5] + 1;
            }
            return object3;
        }
        if (bl) {
            return object3;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(l, object, object2, bl);
            }
            return null;
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        if (this.isIntKey) {
            this.intKeyTable[n3] = (int)l;
        } else {
            this.longKeyTable[n3] = l;
        }
        if (l == 0L) {
            this.hasZeroKey = true;
            this.zeroKeyIndex = n3;
        }
        this.objectValueTable[n3] = object;
        if (this.isTwoObjectValue) {
            this.objectKeyTable[n3] = object2;
        }
        if (this.isLastAccessCount) {
            this.accessTable[n3] = ++this.accessCount;
        } else if (this.isAccessCount) {
            this.accessTable[n3] = 1;
        }
        return object3;
    }

    protected Object removeObject(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        int n = object.hashCode();
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object2 = null;
        while (n3 >= 0) {
            if (this.objectKeyTable[n3].equals(object)) {
                object2 = this.objectKeyTable[n3];
                this.objectKeyTable[n3] = null;
                if (this.accessTable != null) {
                    this.accessTable[n3] = 0;
                }
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.isObjectValue) {
                    object2 = this.objectValueTable[n3];
                    this.objectValueTable[n3] = null;
                }
                if (bl) {
                    this.removeRow(n3);
                }
                return object2;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return object2;
    }

    protected Object addOrRemoveObject(Object object, long l, boolean bl) {
        int n = (int)l;
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.getLookup(n);
        int n4 = -1;
        Object object2 = null;
        while (n3 >= 0) {
            if (this.comparator.longKey(this.objectKeyTable[n3]) == l) {
                object2 = this.objectKeyTable[n3];
                break;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (n3 >= 0) {
            if (bl) {
                this.objectKeyTable[n3] = null;
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.accessTable != null) {
                    this.accessTable[n3] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
            } else {
                this.objectKeyTable[n3] = object;
                if (this.isLastAccessCount) {
                    this.accessTable[n3] = ++this.accessCount;
                } else if (this.isAccessCount) {
                    int n5 = n3;
                    this.accessTable[n5] = this.accessTable[n5] + 1;
                }
            }
            return object2;
        }
        if (bl) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemoveObject(object, l, bl);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        this.objectKeyTable[n3] = object;
        if (this.isLastAccessCount) {
            this.accessTable[n3] = ++this.accessCount;
        } else if (this.isAccessCount) {
            this.accessTable[n3] = 1;
        }
        return object2;
    }

    protected boolean reset() {
        if (this.maxCapacity == 0 || this.maxCapacity > this.threshold) {
            this.rehash(this.hashIndex.linkTable.length * 2);
            return true;
        }
        switch (this.purgePolicy) {
            case 1: {
                this.clear();
                return true;
            }
            case 2: {
                this.clearToHalf();
                return true;
            }
        }
        return false;
    }

    protected void rehash(int n) {
        int n2;
        int n3 = this.hashIndex.newNodePointer;
        boolean bl = this.hasZeroKey;
        int n4 = this.zeroKeyIndex;
        if (n < this.hashIndex.elementCount) {
            return;
        }
        this.hashIndex.reset((int)((float)n * this.loadFactor), n);
        if (this.multiValueTable != null) {
            n2 = this.multiValueTable.length;
            while (--n2 >= 0) {
                this.multiValueTable[n2] = false;
            }
        }
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.threshold = n;
        n2 = -1;
        while ((n2 = this.nextLookup(n2, n3, bl, n4)) < n3) {
            long l = 0L;
            long l2 = 0L;
            Object object = null;
            Object object2 = null;
            if (this.isObjectKey) {
                object = this.objectKeyTable[n2];
            } else {
                l = this.isIntKey ? (long)this.intKeyTable[n2] : this.longKeyTable[n2];
            }
            if (this.isObjectValue) {
                object2 = this.objectValueTable[n2];
            } else if (this.isIntValue) {
                l2 = this.intValueTable[n2];
            } else if (this.isLongValue) {
                l2 = this.longValueTable[n2];
            }
            if (this.multiValueTable == null) {
                this.addOrRemove(l, l2, object, object2, false);
            } else {
                this.addOrRemoveMultiVal(l, l2, object, object2, false, false);
            }
            if (this.accessTable == null) continue;
            this.accessTable[this.hashIndex.elementCount - 1] = this.accessTable[n2];
        }
        this.resizeElementArrays(this.hashIndex.newNodePointer, n);
    }

    private void resizeElementArrays(int n, int n2) {
        Object[] objectArray;
        int n3;
        int n4 = n3 = n2 > n ? n : n2;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            this.intKeyTable = new int[n2];
            System.arraycopy(objectArray, 0, this.intKeyTable, 0, n3);
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            this.intValueTable = new int[n2];
            System.arraycopy(objectArray, 0, this.intValueTable, 0, n3);
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            this.longKeyTable = new long[n2];
            System.arraycopy(objectArray, 0, this.longKeyTable, 0, n3);
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            this.longValueTable = new long[n2];
            System.arraycopy(objectArray, 0, this.longValueTable, 0, n3);
        }
        if (this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            this.objectKeyTable = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectKeyTable, 0, n3);
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            this.objectValueTable = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectValueTable, 0, n3);
        }
        if (this.objectValueTable2 != null) {
            objectArray = this.objectValueTable2;
            this.objectValueTable2 = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectValueTable2, 0, n3);
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            this.accessTable = new int[n2];
            System.arraycopy(objectArray, 0, this.accessTable, 0, n3);
        }
        if (this.multiValueTable != null) {
            objectArray = this.multiValueTable;
            this.multiValueTable = new boolean[n2];
            System.arraycopy(objectArray, 0, this.multiValueTable, 0, n3);
        }
    }

    private void clearElementArrays(int n, int n2) {
        int n3;
        if (this.isIntKey) {
            n3 = n2;
            while (--n3 >= n) {
                this.intKeyTable[n3] = 0;
            }
        } else if (this.isLongKey) {
            n3 = n2;
            while (--n3 >= n) {
                this.longKeyTable[n3] = 0L;
            }
        } else if (this.isObjectKey || this.objectKeyTable != null) {
            n3 = n2;
            while (--n3 >= n) {
                this.objectKeyTable[n3] = null;
            }
        }
        if (this.isIntValue) {
            n3 = n2;
            while (--n3 >= n) {
                this.intValueTable[n3] = 0;
            }
        } else if (this.isLongValue) {
            n3 = n2;
            while (--n3 >= n) {
                this.longValueTable[n3] = 0L;
            }
        } else if (this.isObjectValue) {
            n3 = n2;
            while (--n3 >= n) {
                this.objectValueTable[n3] = null;
            }
        }
        if (this.accessTable != null) {
            n3 = n2;
            while (--n3 >= n) {
                this.accessTable[n3] = 0;
            }
        }
        if (this.multiValueTable != null) {
            n3 = n2;
            while (--n3 >= n) {
                this.multiValueTable[n3] = false;
            }
        }
    }

    void removeFromElementArrays(int n) {
        Object[] objectArray;
        int n2 = this.hashIndex.newNodePointer;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            this.intKeyTable[n2] = 0;
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            this.longKeyTable[n2] = 0L;
        }
        if (this.isObjectKey || this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            this.objectKeyTable[n2] = null;
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            this.intValueTable[n2] = 0;
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            this.longValueTable[n2] = 0L;
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            System.arraycopy(objectArray, n + 1, objectArray, n, n2 - n);
            this.objectValueTable[n2] = null;
        }
    }

    int nextLookup(int n, int n2, boolean bl, int n3) {
        ++n;
        while (n < n2) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n] != null) {
                    return n;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n] != 0) {
                    return n;
                }
                if (bl && n == n3) {
                    return n;
                }
            } else {
                if (this.longKeyTable[n] != 0L) {
                    return n;
                }
                if (bl && n == n3) {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    protected int nextLookup(int n) {
        ++n;
        while (n < this.hashIndex.newNodePointer) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n] != null) {
                    return n;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n] != 0) {
                    return n;
                }
                if (this.hasZeroKey && n == this.zeroKeyIndex) {
                    return n;
                }
            } else {
                if (this.longKeyTable[n] != 0L) {
                    return n;
                }
                if (this.hasZeroKey && n == this.zeroKeyIndex) {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    protected void removeRow(int n) {
        this.hashIndex.removeEmptyNode(n);
        this.removeFromElementArrays(n);
    }

    public void clear() {
        if (this.hashIndex.modified) {
            this.accessMin = this.accessCount = 0;
            this.hasZeroKey = false;
            this.zeroKeyIndex = -1;
            this.clearElementArrays(0, this.hashIndex.linkTable.length);
            this.hashIndex.clear();
            if (this.minimizeOnEmpty) {
                this.rehash(this.initialCapacity);
            }
        }
    }

    protected int getAccessCountCeiling(int n, int n2) {
        return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, n, this.accessMin, this.accessCount, n2);
    }

    protected void setAccessCountFloor(int n) {
        this.accessMin = n;
    }

    protected int incrementAccessCount() {
        return ++this.accessCount;
    }

    private void clearToHalf() {
        int n = this.threshold >> 1;
        int n2 = this.threshold >> 8;
        if (n2 < 64) {
            n2 = 64;
        }
        int n3 = this.hashIndex.newNodePointer;
        int n4 = this.getAccessCountCeiling(n, n2);
        for (int i = 0; i < n3; ++i) {
            Object object = this.objectKeyTable[i];
            if (object == null || this.accessTable[i] >= n4) continue;
            this.removeObject(object, false);
        }
        this.accessMin = n4;
        if (this.hashIndex.elementCount > this.threshold - n2) {
            this.clear();
        }
    }

    protected void resetAccessCount() {
        if (this.accessCount < 0x7FEFFFFF) {
            return;
        }
        double d = 0.5;
        for (int i = 0; i < this.accessTable.length; ++i) {
            this.accessTable[i] = this.accessTable[i] < this.accessMin ? 0 : (int)((double)(this.accessTable[i] - this.accessMin) * d);
        }
        this.accessCount = (int)((double)(this.accessCount - this.accessMin) * d);
        this.accessMin = 0;
    }

    protected int capacity() {
        return this.hashIndex.linkTable.length;
    }

    public int size() {
        return this.hashIndex.elementCount;
    }

    public boolean isEmpty() {
        return this.hashIndex.elementCount == 0;
    }

    protected void setComparator(ObjectComparator objectComparator) {
        this.comparator = objectComparator;
    }

    protected boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n = this.getLookup(object, object.hashCode());
        return n != -1;
    }

    protected boolean containsKey(int n) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n2 = this.getLookup(n);
        return n2 != -1;
    }

    protected boolean containsKey(long l) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n = this.getLookup(l);
        return n != -1;
    }

    protected boolean containsValue(Object object) {
        int n;
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        if (object == null) {
            for (n = 0; n < this.hashIndex.newNodePointer; ++n) {
                if (this.objectValueTable[n] != null) continue;
                if (this.isObjectKey) {
                    if (this.objectKeyTable[n] == null) continue;
                    return true;
                }
                if (this.isIntKey) {
                    if (this.intKeyTable[n] != 0) {
                        return true;
                    }
                    if (!this.hasZeroKey || n != this.zeroKeyIndex) continue;
                    return true;
                }
                if (this.longKeyTable[n] != 0L) {
                    return true;
                }
                if (!this.hasZeroKey || n != this.zeroKeyIndex) continue;
                return true;
            }
        } else {
            while (n < this.hashIndex.newNodePointer) {
                if (object.equals(this.objectValueTable[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected class BaseHashIterator
    implements Iterator {
        boolean keys;
        int lookup = -1;
        int counter;
        boolean removed;

        public BaseHashIterator() {
        }

        public BaseHashIterator(boolean bl) {
            this.keys = bl;
        }

        public void reset() {
            this.lookup = -1;
            this.counter = 0;
            this.removed = false;
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseHashMap.this.hashIndex.elementCount;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isObjectKey || !this.keys && !BaseHashMap.this.isObjectValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.objectKeyTable[this.lookup];
                }
                return BaseHashMap.this.objectValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isIntKey || !this.keys && !BaseHashMap.this.isIntValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.intKeyTable[this.lookup];
                }
                return BaseHashMap.this.intValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isLongKey || !this.keys && !BaseHashMap.this.isLongValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                return this.keys ? BaseHashMap.this.longKeyTable[this.lookup] : BaseHashMap.this.longValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            if (this.removed) {
                throw new NoSuchElementException("Hash Iterator");
            }
            --this.counter;
            this.removed = true;
            if (BaseHashMap.this.isObjectKey) {
                if (BaseHashMap.this.multiValueTable == null) {
                    BaseHashMap.this.addOrRemove(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], null, true);
                } else if (this.keys) {
                    BaseHashMap.this.addOrRemoveMultiVal(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], null, true, false);
                } else {
                    BaseHashMap.this.addOrRemoveMultiVal(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], BaseHashMap.this.objectValueTable[this.lookup], false, true);
                }
            } else if (BaseHashMap.this.isIntKey) {
                BaseHashMap.this.addOrRemove(BaseHashMap.this.intKeyTable[this.lookup], 0L, null, null, true);
            } else {
                BaseHashMap.this.addOrRemove(BaseHashMap.this.longKeyTable[this.lookup], 0L, null, null, true);
            }
            if (BaseHashMap.this.isList) {
                BaseHashMap.this.removeRow(this.lookup);
                --this.lookup;
            }
        }

        @Override
        public void setValue(Object object) {
            if (this.keys) {
                throw new NoSuchElementException();
            }
            BaseHashMap.this.objectValueTable[this.lookup] = object;
        }

        public int getAccessCount() {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            return BaseHashMap.this.accessTable[this.lookup];
        }

        public void setAccessCount(int n) {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            BaseHashMap.this.accessTable[this.lookup] = n;
        }

        public int getLookup() {
            return this.lookup;
        }
    }

    protected class MultiValueKeyIterator
    implements Iterator {
        boolean keys;
        int lookup = -1;
        int counter;
        boolean removed;
        Object oldKey;

        public MultiValueKeyIterator() {
            this.toNextLookup();
        }

        private void toNextLookup() {
            do {
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
            } while (this.lookup != -1 && BaseHashMap.this.multiValueTable[this.lookup]);
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            Object object = BaseHashMap.this.objectKeyTable[this.lookup];
            this.toNextLookup();
            this.oldKey = object;
            return object;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            BaseHashMap.this.addOrRemoveMultiVal(0L, 0L, this.oldKey, null, true, false);
        }

        @Override
        public void setValue(Object object) {
            throw new NoSuchElementException("Hash Iterator");
        }
    }

    protected class ValuesIterator
    implements Iterator {
        int lookup = -1;
        Object key;

        protected ValuesIterator() {
        }

        private void reset(Object object, int n) {
            this.key = object;
            this.lookup = n;
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.lookup == -1) {
                return null;
            }
            Object object = BaseHashMap.this.objectValueTable[this.lookup];
            do {
                this.lookup = BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
            } while (this.lookup != -1 && !BaseHashMap.this.objectKeyTable[this.lookup].equals(this.key));
            return object;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void setValue(Object object) {
            throw new NoSuchElementException("Hash Iterator");
        }
    }
}

