/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jitsi.cmd.ParseException;
import org.jitsi.utils.logging.Logger;

public class CmdLine {
    private static final Logger logger = Logger.getLogger(CmdLine.class);
    private Map<String, String> argMap = new HashMap<String, String>();
    private List<String> requiredArgs = new ArrayList<String>();

    public void addRequiredArgument(String reqArg) {
        if (!this.requiredArgs.contains(reqArg = this.cleanHyphens(reqArg))) {
            this.requiredArgs.add(reqArg);
        }
    }

    public void removeRequiredArgument(String reqArg) {
        reqArg = this.cleanHyphens(reqArg);
        this.requiredArgs.remove(reqArg);
    }

    public List<String> getRequiredArguments() {
        return Collections.unmodifiableList(this.requiredArgs);
    }

    private String cleanHyphens(String arg) {
        if (arg.startsWith("--")) {
            return arg.substring(2);
        }
        if (arg.startsWith("-")) {
            return arg.substring(1);
        }
        return arg;
    }

    public void parse(String[] args2) throws ParseException {
        for (String arg : args2) {
            int eqIdx = (arg = this.cleanHyphens(arg)).indexOf("=");
            if (eqIdx <= 0) {
                logger.warn("Skipped invalid cmd line argument: " + arg);
                continue;
            }
            if (eqIdx == arg.length() - 1) {
                logger.warn("Skipped empty cmd line argument: " + arg);
                continue;
            }
            String key = arg.substring(0, eqIdx);
            String val = arg.substring(eqIdx + 1);
            this.argMap.put(key, val);
        }
        ArrayList<String> leftReqArgs = new ArrayList<String>(this.requiredArgs);
        leftReqArgs.removeAll(this.argMap.keySet());
        if (!leftReqArgs.isEmpty()) {
            throw new ParseException("Some of required arguments were not specified: " + ((Object)leftReqArgs).toString());
        }
    }

    public String getOptionValue(String opt) {
        return this.argMap.get(this.cleanHyphens(opt));
    }

    public String getOptionValue(String opt, String defaultValue) {
        String val = this.getOptionValue(opt);
        return val != null ? val : defaultValue;
    }

    public int getIntOptionValue(String opt, int defaultValue) {
        String val = this.getOptionValue(opt);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException fmt) {
            return defaultValue;
        }
    }
}

