/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.util.Loader;

public abstract class AbstractCrypto
extends CryptoBase {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$ws$security$components$crypto$AbstractCrypto == null ? (class$org$apache$ws$security$components$crypto$AbstractCrypto = AbstractCrypto.class$("org.apache.ws.security.components.crypto.AbstractCrypto")) : class$org$apache$ws$security$components$crypto$AbstractCrypto));
    protected static CertificateFactory certFact;
    protected Properties properties = null;
    static /* synthetic */ Class class$org$apache$ws$security$components$crypto$AbstractCrypto;

    public AbstractCrypto(Properties properties) throws CredentialException, IOException {
        this(properties, (class$org$apache$ws$security$components$crypto$AbstractCrypto == null ? (class$org$apache$ws$security$components$crypto$AbstractCrypto = AbstractCrypto.class$("org.apache.ws.security.components.crypto.AbstractCrypto")) : class$org$apache$ws$security$components$crypto$AbstractCrypto).getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCrypto(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        this.properties = properties;
        String location = this.properties.getProperty("org.apache.ws.security.crypto.merlin.file");
        InputStream is = null;
        URL url = Loader.getResource(loader, location);
        is = url != null ? url.openStream() : new FileInputStream(location);
        if (is == null) {
            try {
                is = new FileInputStream(location);
            }
            catch (Exception e) {
                throw new CredentialException(3, "proxyNotFound", new Object[]{location});
            }
        }
        try {
            String provider = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.provider");
            String passwd = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password", "security");
            String type = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type", KeyStore.getDefaultType());
            this.keystore = this.load(is, passwd, provider, type);
        }
        finally {
            is.close();
        }
        String cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
        FileInputStream cacertsIs = new FileInputStream(cacertsPath);
        try {
            String cacertsPasswd = properties.getProperty("org.apache.ws.security.crypto.merlin.cacerts.password", "changeit");
            this.cacerts = this.load(cacertsIs, cacertsPasswd, null, KeyStore.getDefaultType());
        }
        finally {
            ((InputStream)cacertsIs).close();
        }
    }

    public KeyStore load(InputStream input, String storepass, String provider, String type) throws CredentialException {
        if (input == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        KeyStore ks = null;
        try {
            ks = provider == null || provider.length() == 0 ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            ks.load(input, storepass == null || storepass.length() == 0 ? new char[]{} : storepass.toCharArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CredentialException(3, "ioError00", e);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new CredentialException(3, "secError00", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CredentialException(-1, "error00", e);
        }
        return ks;
    }

    protected String getCryptoProvider() {
        return this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
    }

    public String getDefaultX509Alias() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.alias");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

