
#ifndef KSTYLE_EXPORT_H
#define KSTYLE_EXPORT_H

#ifdef KSTYLE_STATIC_DEFINE
#  define KSTYLE_EXPORT
#  define KSTYLE_NO_EXPORT
#else
#  ifndef KSTYLE_EXPORT
#    ifdef KF6Style_EXPORTS
        /* We are building this library */
#      define KSTYLE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KSTYLE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KSTYLE_NO_EXPORT
#    define KSTYLE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KSTYLE_DECL_DEPRECATED
#  define KSTYLE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KSTYLE_DECL_DEPRECATED_EXPORT
#  define KSTYLE_DECL_DEPRECATED_EXPORT KSTYLE_EXPORT KSTYLE_DECL_DEPRECATED
#endif

#ifndef KSTYLE_DECL_DEPRECATED_NO_EXPORT
#  define KSTYLE_DECL_DEPRECATED_NO_EXPORT KSTYLE_NO_EXPORT KSTYLE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KSTYLE_NO_DEPRECATED
#    define KSTYLE_NO_DEPRECATED
#  endif
#endif
#include <frameworkintegration_version.h>

#define KSTYLE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KSTYLE_NO_DEPRECATED) && !defined(KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KSTYLE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KSTYLE_NO_DEPRECATED_WARNINGS) && !defined(KSTYLE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KSTYLE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KSTYLE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KSTYLE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KSTYLE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KSTYLE_NO_DEPRECATED)
#  undef KSTYLE_DEPRECATED
#  define KSTYLE_DEPRECATED_EXPORT KSTYLE_EXPORT
#  define KSTYLE_DEPRECATED_NO_EXPORT KSTYLE_NO_EXPORT
#elif defined(KSTYLE_NO_DEPRECATED_WARNINGS)
#  define KSTYLE_DEPRECATED
#  define KSTYLE_DEPRECATED_EXPORT KSTYLE_EXPORT
#  define KSTYLE_DEPRECATED_NO_EXPORT KSTYLE_NO_EXPORT
#else
#  define KSTYLE_DEPRECATED KSTYLE_DECL_DEPRECATED
#  define KSTYLE_DEPRECATED_EXPORT KSTYLE_DECL_DEPRECATED_EXPORT
#  define KSTYLE_DEPRECATED_NO_EXPORT KSTYLE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KSTYLE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KSTYLE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KSTYLE_NO_DEPRECATED
#  define KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT FRAMEWORKINTEGRATION_VERSION
#endif
#ifdef KSTYLE_NO_DEPRECATED_WARNINGS
#  define KSTYLE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KSTYLE_DEPRECATED_WARNINGS_SINCE
#  ifdef KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KSTYLE_DEPRECATED_WARNINGS_SINCE KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KSTYLE_DEPRECATED_WARNINGS_SINCE FRAMEWORKINTEGRATION_VERSION
#  endif
#endif

#ifndef KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KSTYLE_DEPRECATED
#  define KSTYLE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KSTYLE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KSTYLE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KSTYLE_EXPORT_H */
