/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.RedisCredentials;
import redis.clients.jedis.SslOptions;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.mcf.HealthCheckStrategy;
import redis.clients.jedis.mcf.HealthStatus;
import redis.clients.jedis.mcf.ProbingPolicy;
import redis.clients.jedis.mcf.RedisRestAPI;

public class LagAwareStrategy
implements HealthCheckStrategy {
    private static final Logger log = LoggerFactory.getLogger(LagAwareStrategy.class);
    private final Config config;
    private final RedisRestAPI redisRestAPI;
    private String bdbId;

    public LagAwareStrategy(Config config) {
        this.config = config;
        this.redisRestAPI = new RedisRestAPI(config.getRestEndpoint(), config.getCredentialsSupplier(), config.getTimeout(), config.getSslOptions());
    }

    @Override
    public int getInterval() {
        return this.config.interval;
    }

    @Override
    public int getTimeout() {
        return this.config.timeout;
    }

    @Override
    public int getNumProbes() {
        return this.config.getNumProbes();
    }

    @Override
    public ProbingPolicy getPolicy() {
        return this.config.getPolicy();
    }

    @Override
    public int getDelayInBetweenProbes() {
        return this.config.getDelayInBetweenProbes();
    }

    @Override
    public HealthStatus doHealthCheck(Endpoint endpoint) {
        try {
            String bdb = this.bdbId;
            if (bdb == null) {
                String dbHost = endpoint.getHost();
                List<RedisRestAPI.BdbInfo> bdbs = this.redisRestAPI.getBdbs();
                RedisRestAPI.BdbInfo matchingBdb = RedisRestAPI.BdbInfo.findMatchingBdb(bdbs, dbHost);
                if (matchingBdb == null) {
                    String msg = String.format("No BDB found matching host '%s' for health check", dbHost);
                    log.warn(msg);
                    throw new JedisException(msg);
                }
                bdb = matchingBdb.getUid();
                log.debug("Found matching BDB '{}' for host '{}'", (Object)bdb, (Object)dbHost);
                this.bdbId = bdb;
            }
            if (this.config.isExtendedCheckEnabled() ? this.redisRestAPI.checkBdbAvailability(bdb, true, this.config.getAvailabilityLagTolerance().toMillis()) : this.redisRestAPI.checkBdbAvailability(bdb, false)) {
                return HealthStatus.HEALTHY;
            }
        }
        catch (Exception e) {
            log.error("Error while checking database availability", (Throwable)e);
            this.bdbId = null;
            throw new JedisException("Error while checking availability", e);
        }
        return HealthStatus.UNHEALTHY;
    }

    public static class Config
    extends HealthCheckStrategy.Config {
        public static final boolean EXTENDED_CHECK_DEFAULT = true;
        public static final Duration AVAILABILITY_LAG_TOLERANCE_DEFAULT = Duration.ofMillis(5000L);
        private final Endpoint restEndpoint;
        private final Supplier<RedisCredentials> credentialsSupplier;
        private final SslOptions sslOptions;
        private final Duration availability_lag_tolerance;
        private final boolean extendedCheckEnabled;

        public Config(Endpoint restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            this(Config.builder(restEndpoint, credentialsSupplier).availabilityLagTolerance(AVAILABILITY_LAG_TOLERANCE_DEFAULT).extendedCheckEnabled(true));
        }

        private Config(ConfigBuilder builder) {
            super(builder);
            this.restEndpoint = builder.restEndpoint;
            this.credentialsSupplier = builder.credentialsSupplier;
            this.sslOptions = builder.sslOptions;
            this.availability_lag_tolerance = builder.availabilityLagTolerance;
            this.extendedCheckEnabled = builder.extendedCheckEnabled;
        }

        public Endpoint getRestEndpoint() {
            return this.restEndpoint;
        }

        public Supplier<RedisCredentials> getCredentialsSupplier() {
            return this.credentialsSupplier;
        }

        public SslOptions getSslOptions() {
            return this.sslOptions;
        }

        public Duration getAvailabilityLagTolerance() {
            return this.availability_lag_tolerance;
        }

        public boolean isExtendedCheckEnabled() {
            return this.extendedCheckEnabled;
        }

        public static ConfigBuilder builder(Endpoint restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return new ConfigBuilder(restEndpoint, credentialsSupplier);
        }

        public static ConfigBuilder builder() {
            throw new UnsupportedOperationException("Endpoint and credentials are required to build LagAwareStrategy.Config.");
        }

        public static Config create(Endpoint restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return new ConfigBuilder(restEndpoint, credentialsSupplier).build();
        }

        public static Config databaseAvailability(Endpoint restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return new ConfigBuilder(restEndpoint, credentialsSupplier).extendedCheckEnabled(false).build();
        }

        public static Config lagAware(Endpoint restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
            return new ConfigBuilder(restEndpoint, credentialsSupplier).extendedCheckEnabled(true).build();
        }

        public static Config lagAwareWithTolerance(Endpoint restEndpoint, Supplier<RedisCredentials> credentialsSupplier, Duration availabilityLagTolerance) {
            return new ConfigBuilder(restEndpoint, credentialsSupplier).extendedCheckEnabled(true).availabilityLagTolerance(availabilityLagTolerance).build();
        }

        public static class ConfigBuilder
        extends HealthCheckStrategy.Config.Builder<ConfigBuilder, Config> {
            private final Endpoint restEndpoint;
            private final Supplier<RedisCredentials> credentialsSupplier;
            private SslOptions sslOptions;
            private Duration availabilityLagTolerance = AVAILABILITY_LAG_TOLERANCE_DEFAULT;
            private boolean extendedCheckEnabled = true;

            private ConfigBuilder(Endpoint restEndpoint, Supplier<RedisCredentials> credentialsSupplier) {
                this.restEndpoint = restEndpoint;
                this.credentialsSupplier = credentialsSupplier;
            }

            public ConfigBuilder sslOptions(SslOptions sslOptions) {
                this.sslOptions = sslOptions;
                return this;
            }

            public ConfigBuilder availabilityLagTolerance(Duration availabilityLagTolerance) {
                this.availabilityLagTolerance = availabilityLagTolerance;
                return this;
            }

            public ConfigBuilder extendedCheckEnabled(boolean extendedCheckEnabled) {
                this.extendedCheckEnabled = extendedCheckEnabled;
                return this;
            }

            @Override
            public Config build() {
                return new Config(this);
            }
        }
    }
}

