/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.addressbook.AddressBook;
import net.i2p.addressbook.ConfigParser;
import net.i2p.addressbook.Subscription;
import net.i2p.addressbook.SubscriptionIterator;

class SubscriptionList
implements Iterable<AddressBook> {
    private final List<Subscription> subscriptions;
    private final File etagsFile;
    private final File lastModifiedFile;
    private final File lastFetchedFile;
    private final long delay;
    private final String proxyHost;
    private final int proxyPort;

    public SubscriptionList(File locationsFile, File etagsFile, File lastModifiedFile, File lastFetchedFile, long delay, List<String> defaultSubs, String proxyHost, int proxyPort) {
        Map<String, String> lastFetched;
        Map<String, String> lastModified;
        Map<String, String> etags;
        this.subscriptions = new ArrayList<Subscription>(4);
        this.etagsFile = etagsFile;
        this.lastModifiedFile = lastModifiedFile;
        this.lastFetchedFile = lastFetchedFile;
        this.delay = delay;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        List<String> locations = ConfigParser.parseSubscriptions(locationsFile, defaultSubs);
        try {
            etags = ConfigParser.parse(etagsFile);
        }
        catch (IOException exp) {
            etags = Collections.emptyMap();
        }
        try {
            lastModified = ConfigParser.parse(lastModifiedFile);
        }
        catch (IOException exp) {
            lastModified = Collections.emptyMap();
        }
        try {
            lastFetched = ConfigParser.parse(lastFetchedFile);
        }
        catch (IOException exp) {
            lastFetched = Collections.emptyMap();
        }
        for (String location : locations) {
            this.subscriptions.add(new Subscription(location, etags.get(location), lastModified.get(location), lastFetched.get(location)));
        }
    }

    public SubscriptionList(String hoststxt) {
        File dummy;
        this.etagsFile = dummy = new File("/dev/null");
        this.lastModifiedFile = dummy;
        this.lastFetchedFile = dummy;
        this.delay = 0L;
        this.proxyHost = "127.0.0.1";
        this.proxyPort = 4444;
        Subscription sub = new Subscription("file:" + hoststxt, null, null, null);
        this.subscriptions = Collections.singletonList(sub);
    }

    public SubscriptionIterator iterator() {
        return new SubscriptionIterator(this.subscriptions, this.delay, this.proxyHost, this.proxyPort);
    }

    public void write() {
        int sz = this.subscriptions.size();
        HashMap<String, String> etags = new HashMap<String, String>(sz);
        HashMap<String, String> lastModified = new HashMap<String, String>(sz);
        HashMap<String, String> lastFetched = new HashMap<String, String>(sz);
        for (Subscription sub : this.subscriptions) {
            if (sub.getEtag() != null) {
                etags.put(sub.getLocation(), sub.getEtag());
            }
            if (sub.getLastModified() != null) {
                lastModified.put(sub.getLocation(), sub.getLastModified());
            }
            lastFetched.put(sub.getLocation(), Long.toString(sub.getLastFetched()));
        }
        try {
            ConfigParser.write(etags, this.etagsFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ConfigParser.write(lastModified, this.lastModifiedFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ConfigParser.write(lastFetched, this.lastFetchedFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

