/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import javax.inject.Inject;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.capability.DefaultFeatureCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.dependencies.ModuleDependencyCapabilitiesInternal;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.typeconversion.NotationParser;

public abstract class DefaultMutableModuleDependencyCapabilitiesHandler
implements ModuleDependencyCapabilitiesInternal {
    private final NotationParser<Object, Capability> capabilityNotationParser;

    @Inject
    public DefaultMutableModuleDependencyCapabilitiesHandler(NotationParser<Object, Capability> capabilityNotationParser) {
        this.capabilityNotationParser = capabilityNotationParser;
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    public abstract SetProperty<CapabilitySelector> getCapabilitySelectors();

    public void requireCapability(Object capabilityNotation) {
        if (capabilityNotation instanceof Provider) {
            this.getCapabilitySelectors().add(((Provider)capabilityNotation).map(this::convertExact));
        } else {
            this.getCapabilitySelectors().add((Object)this.convertExact(capabilityNotation));
        }
    }

    private DefaultSpecificCapabilitySelector convertExact(Object notation) {
        Capability capability = (Capability)this.capabilityNotationParser.parseNotation(notation);
        return new DefaultSpecificCapabilitySelector((ImmutableCapability)capability);
    }

    public void requireFeature(String featureName) {
        this.getCapabilitySelectors().add((Object)new DefaultFeatureCapabilitySelector(featureName));
    }

    public void requireFeature(Provider<String> featureName) {
        this.getCapabilitySelectors().add(featureName.map(DefaultFeatureCapabilitySelector::new));
    }

    public void requireCapabilities(Object ... capabilityNotations) {
        for (Object notation : capabilityNotations) {
            this.requireCapability(notation);
        }
    }

    @Override
    public ModuleDependencyCapabilitiesInternal copy() {
        DefaultMutableModuleDependencyCapabilitiesHandler out = (DefaultMutableModuleDependencyCapabilitiesHandler)this.getObjectFactory().newInstance(DefaultMutableModuleDependencyCapabilitiesHandler.class, new Object[]{this.capabilityNotationParser});
        out.getCapabilitySelectors().addAll(this.getCapabilitySelectors());
        return out;
    }
}

