/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.smali.AntlrSmaliUtil;
import com.googlecode.d2j.smali.antlr4.SmaliLexer;
import com.googlecode.d2j.smali.antlr4.SmaliParser;
import com.googlecode.d2j.visitors.DexFileVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class Smali {
    public static void smaliFile(Path path, DexFileVisitor dcv) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            CodePointCharStream is = CharStreams.fromReader((Reader)reader, (String)path.toString());
            Smali.smali0(dcv, (CharStream)is);
        }
    }

    public static void smaliFile(String name, String buff, DexFileVisitor dcv) {
        CodePointCharStream is = CharStreams.fromString((String)buff, (String)name);
        Smali.smali0(dcv, (CharStream)is);
    }

    public static void smaliFile(String name, InputStream in, DexFileVisitor dcv) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            CodePointCharStream is = CharStreams.fromReader((Reader)reader, (String)name);
            Smali.smali0(dcv, (CharStream)is);
        }
    }

    public static DexClassNode smaliFile2Node(String name, InputStream in) throws IOException {
        DexFileNode dfn = new DexFileNode();
        Smali.smaliFile(name, in, (DexFileVisitor)dfn);
        return dfn.clzs.size() > 0 ? (DexClassNode)dfn.clzs.get(0) : null;
    }

    public static DexClassNode smaliFile2Node(String name, String buff) {
        DexFileNode dfn = new DexFileNode();
        Smali.smaliFile(name, buff, (DexFileVisitor)dfn);
        return dfn.clzs.size() > 0 ? (DexClassNode)dfn.clzs.get(0) : null;
    }

    private static void smali0(DexFileVisitor dcv, CharStream is) {
        SmaliLexer lexer = new SmaliLexer(is);
        CommonTokenStream ts = new CommonTokenStream((TokenSource)lexer);
        SmaliParser parser = new SmaliParser((TokenStream)ts);
        for (SmaliParser.SFileContext ctx : parser.sFiles().sFile()) {
            AntlrSmaliUtil.acceptFile(ctx, dcv);
        }
    }

    public static void smaliFile(String fileName, char[] data, DexFileVisitor dcv) {
        CodePointCharStream is = CharStreams.fromString((String)new String(data), (String)fileName);
        Smali.smali0(dcv, (CharStream)is);
    }

    public static void smali(Path base, final DexFileVisitor dfv) throws IOException {
        if (Files.isDirectory(base, new LinkOption[0])) {
            Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path fn = dir.getFileName();
                    if (fn != null && fn.toString().startsWith(".")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Smali.smaliFile(file, dfv);
                    return super.visitFile(file, attrs);
                }
            });
        } else if (Files.isRegularFile(base, new LinkOption[0])) {
            Smali.smaliFile(base, dfv);
        }
    }
}

